/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.order.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.order.bean.BackGoods;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.BackOrderLog;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.BackGoodsService;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.third.goods.service.ThirdGoodsService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdBackOrderController {
    private static final MyLogger LOGGER = new MyLogger(ThirdBackOrderController.class);
    private BackOrderService backOrderService;
    private OrderService orderService;
    @Resource
    private ThirdGoodsService thirdGoodsService;
    private static final String BACKORDERGENERAL = "backOrderGeneral";
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Resource(name="BackOrderLogService")
    private BackOrderLogService backOrderLogService;
    @Resource(name="backGoodsService")
    private BackGoodsService backGoodsService;
    @Autowired
    private DepositInfoService depositInfoService;
    @Autowired
    private TradeInfoService tradeInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryThirdBackOrderList"})
    public ModelAndView queryBackOrderList(String startTime, String endTime, BackOrder bkorder, PageBean pageBean, HttpServletResponse response, HttpServletRequest request, String n, String l, String tabStatus) throws UnsupportedEncodingException {
        if (null != bkorder.getShippingPerson()) {
            String str = new String(bkorder.getShippingPerson().getBytes("ISO8859-1"), "utf-8");
            bkorder.setShippingPerson(str);
        }
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (tabStatus != null && !"5".equals(tabStatus)) {
            bkorder.setBackCheck(tabStatus);
        }
        bkorder.setBusinessId((Long)request.getSession().getAttribute("thirdId"));
        map.put("pb", this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime));
        map.put("bkorder", bkorder);
        map.put("bset", BasicSetUtil.getAddress((String)this.thirdGoodsService.bsetUrl()));
        map.put("tabStatus", tabStatus);
        pageBean.setUrl("queryThirdBackOrderList");
        try {
            ModelAndView modelAndView = new ModelAndView("order/thirdBackorderlists", "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    @RequestMapping(value={"/queryThirdBackOrderList2"})
    public ModelAndView updateBackOrderList(BackOrder bkorder) {
        return new ModelAndView("queryThirdBackOrderList.htm");
    }

    @RequestMapping(value={"/updateBackOrderStatus"})
    public ModelAndView updateThirdBackOrderSta(BackOrder backOrder, HttpServletRequest request, String sign) {
        Customer cust;
        String backInfo = "";
        backOrder.setAuthorName(((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        backOrder.setBusinessId((Long)request.getSession().getAttribute("thirdId"));
        BackOrderLog backOrderLog = new BackOrderLog();
        backOrderLog.setBackLogPerson(backOrder.getAuthorName());
        backOrderLog.setBackLogTime(new Date());
        backOrderLog.setBackOrderId(backOrder.getBackOrderId());
        BackOrder bOrder = this.backOrderService.selectBackOrderByBackOrderId(backOrder.getBackOrderId());
        Order order = this.orderService.getPayOrderByCode(bOrder.getOrderCode());
        if (sign != null && (sign.equals("2") && backOrder.getBackCheck().equals("7") || sign.equals("3") && backOrder.getBackCheck().equals("7"))) {
            backOrderLog.setBackLogStatus("9");
            backInfo = "\u62d2\u7edd\u9000\u6b3e";
        } else if (sign != null && (sign.equals("2") && backOrder.getBackCheck().equals("10") || sign.equals("3") && backOrder.getBackCheck().equals("10") || sign.equals("3") && backOrder.getBackCheck().equals("4"))) {
            backOrderLog.setBackLogStatus("8");
            backInfo = "\u540c\u610f\u9000\u6b3e";
            this.updateDepositInfo(order, bOrder);
        } else if (sign != null && sign.equals("1") && backOrder.getBackCheck().equals("2")) {
            backOrderLog.setBackLogStatus("3");
            backInfo = "\u9000\u8d27\u5ba1\u6838\u4e0d\u901a\u8fc7";
        } else if (sign != null && sign.equals("1") && backOrder.getBackCheck().equals("1")) {
            backOrderLog.setBackLogStatus("2");
            backInfo = "\u9000\u8d27\u5ba1\u6838\u901a\u8fc7";
            this.updateDepositInfo(order, bOrder);
        }
        this.backOrderLogService.insert(backOrderLog);
        BackOrder backOrderPre = this.backOrderService.selectBackOrderByBackOrderId(backOrder.getBackOrderId());
        int count = this.backOrderService.modifyThirdBackBeanCheck(backOrder);
        if ("10".equals(bOrder.getBackCheck())) {
            this.orderCouponService.modifyCouponStatus(bOrder.getOrderId());
            backInfo = "\u9000\u6b3e\u6210\u529f";
        } else if ("4".equals(bOrder.getBackCheck())) {
            String[] ids;
            List orderGoodses = this.orderService.queryOrderGoods(order.getOrderId());
            BigDecimal all = BigDecimal.ZERO;
            for (OrderGoods og : orderGoodses) {
                all = all.add(og.getGoodsBackPrice());
            }
            ArrayList<Long> goodsInfoIds = new ArrayList<Long>();
            for (String goodsInfoId : ids = bOrder.getBackGoodsIdAndSum().split("-")) {
                String id = goodsInfoId.split(",")[0];
                goodsInfoIds.add(Long.parseLong(goodsInfoId.split(",")[0]));
            }
            for (Long goodsInfoId : goodsInfoIds) {
                BackGoods backGoods = this.backOrderService.selectOrdersetBackGodds(goodsInfoId, order.getOrderId());
                if (backOrderPre.getBackPrice() != backOrder.getBackPrice()) {
                    backGoods.setBackGoodsPrice(backGoods.getBackGoodsPrice().subtract(backGoods.getBackGoodsPrice().multiply(backOrderPre.getBackPrice().subtract(backOrder.getBackPrice())).divide(all, 2)));
                }
                backGoods.setBusinessId(order.getBusinessId());
                backGoods.setDelFlag("0");
                backGoods.setBackSturts("0");
                this.backGoodsService.insertSelective(backGoods);
            }
            this.orderCouponService.modifyStock(bOrder.getOrderId());
            backInfo = "\u786e\u8ba4\u6536\u8d27\uff0c\u9000\u8d27\u7ed3\u675f";
        }
        if (count == 1 && bOrder != null && bOrder.getOrderId() != null) {
            this.backOrderService.reducePointOrderBack(bOrder.getOrderId());
        }
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u9000\u8d27\u64cd\u4f5c", "\u9000\u8d27\u64cd\u4f5c\uff0c\u8ba2\u5355\u7f16\u53f7\u3010" + order.getOrderCode() + "\u3011\u72b6\u6001\u6539\u4e3a" + backInfo + "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u9000\u8d27\u64cd\u4f5c");
        }
        return new ModelAndView((View)new RedirectView("queryThirdBackOrderList.htm"));
    }

    @RequestMapping(value={"/toExamBackOrder"})
    public ModelAndView toExamBackOrder(HttpServletRequest request, HttpServletResponse response, Long backOrderId) {
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        BackOrder bOrder = this.backOrderService.detail(backOrderId);
        if (thirdId != null && bOrder.getBusinessId() != null && !thirdId.equals(bOrder.getBusinessId())) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/sellerinfo.html"));
        }
        ArrayList<String> imglist = new ArrayList<String>();
        if (bOrder.getUploadDocuments() != null) {
            String[] imgs = bOrder.getUploadDocuments().split(",");
            for (int i = 0; i < imgs.length; ++i) {
                imglist.add(imgs[i]);
            }
        }
        Long backOrderIdNew = (long)backOrderId;
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(backOrderIdNew);
        List backOrderLogs = this.backOrderLogService.queryByBackId(bOrder.getBackOrderId());
        return new ModelAndView("order/thirdbackorderdetail").addObject("backorder", (Object)bOrder).addObject("imglist", imglist).addObject("backOrderLogs", (Object)backOrderLogs).addObject("order", (Object)this.orderService.payOrder(bOrder.getOrderId())).addObject(BACKORDERGENERAL, (Object)backOrderGeneral);
    }

    @RequestMapping(value={"/checkpriceback"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object checkBackPrice(Long backOrderId) {
        return this.backOrderService.selectBackOrderByBackOrderId(backOrderId);
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public void updateDepositInfo(Order order, BackOrder backOrder) {
        if (order.getPayId().intValue() == 5) {
            Long customerId = order.getCustomerId();
            DepositInfo depositInfo = this.depositInfoService.selectDepositByCustId(customerId);
            BigDecimal preDepositPrice = depositInfo.getPreDeposit();
            preDepositPrice = preDepositPrice == null || preDepositPrice.intValue() == 0 ? order.getOrderPrePrice() : preDepositPrice.add(order.getOrderPrice());
            depositInfo.setPreDeposit(preDepositPrice);
            if (depositInfo.getFreezePreDeposit() != null && depositInfo.getFreezePreDeposit().intValue() != 0) {
                preDepositPrice = preDepositPrice.add(depositInfo.getFreezePreDeposit());
            }
            TradeInfo tradeInfo = this.getTradeInfo(customerId, backOrder, order, preDepositPrice);
            this.tradeInfoService.insertTradeInfo(tradeInfo);
            this.depositInfoService.updateDeposit(depositInfo);
        }
    }

    public TradeInfo getTradeInfo(Long customerId, BackOrder backOrder, Order order, BigDecimal currentPrice) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderCode(backOrder.getOrderCode());
        tradeInfo.setOrderType("1");
        tradeInfo.setOrderStatus("4");
        tradeInfo.setCurrentPrice(currentPrice);
        tradeInfo.setOrderPrice(backOrder.getBackPrice());
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setUpdateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setTradeRemark("\u9000\u6b3e\u8ba2\u5355:" + order.getOrderCode() + ",\u9000\u6b3e\u5355\u53f7:" + backOrder.getBackOrderCode());
        return tradeInfo;
    }
}

