/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.service.impl.ChannelStoreyServiceImpl;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.third.goods.service.ThirdCateService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempStoreyController {
    private static final MyLogger LOGGER = new MyLogger(ThirdTempStoreyController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_VIEW = "showThirdTempStorey.htm?tempId=";
    private static final String LIST_VIEW = "queryThirdTempStoreyByPageBean.htm?tempId=";
    private static final String THIRDID = "thirdId";
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ChannelStoreyService")
    private ChannelStoreyServiceImpl channelStoreyServiceImpl;
    @Resource(name="ThirdCateService1")
    private ThirdCateService goodsCateService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryThirdTempStoreyByPageBean"})
    public ModelAndView queryThirdTempStoreyByPageBean(HttpServletRequest request, PageBean pb, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCates", this.goodsCateService.getThirdCateByParentId(Long.valueOf(0L), Long.valueOf(Long.parseLong(thirdId))));
        map.put("pb", this.channelStoreyServiceImpl.selectchannelStoreyByParam(pb, null, tempId, thirdId));
        map.put("temp", temp);
        map.put(THIRDID, thirdId);
        return new ModelAndView("temp/temp_storey_list", "map", map);
    }

    @RequestMapping(value={"/showThirdTempStorey"})
    public ModelAndView showThirdTempStorey(HttpServletRequest request, Long storeyId, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        map.put("temp", temp);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        List goodsCates = this.goodsCateService.getThirdCateByParentId(Long.valueOf(0L), thirdId);
        map.put("goodsCates", goodsCates);
        map.put(THIRDID, thirdId);
        if (null != storeyId) {
            ChannelStorey channelStorey = this.channelStoreyServiceImpl.getChannelStoreyById(storeyId);
            map.put("channelStorey", channelStorey);
        }
        return new ModelAndView("temp/show_temp_storey", "map", map);
    }

    @RequestMapping(value={"/getChannelStoreyById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStorey getChannelStoreyById(Long storyId) {
        return this.channelStoreyServiceImpl.getChannelStoreyById(storyId);
    }

    @RequestMapping(value={"/createThirdTempStorey"})
    public ModelAndView createThirdTempStorey(MultipartHttpServletRequest request, HttpServletResponse response, ChannelStorey channelStorey, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            MultipartFile file = request.getFile("netLogo");
            if (file.getSize() != 0L) {
                channelStorey.setStoreyImg(UploadUtil.uploadFileOne((MultipartFile)file));
                this.infoImageManageService.saveImage(channelStorey.getStoreyImg());
            }
            channelStorey.setTempId(tempId);
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStorey.setCreateUserId(loginUserId);
            int n = this.channelStoreyServiceImpl.saveChannelStorey(channelStorey);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
        }
        return mav;
    }

    @RequestMapping(value={"/updateThirdTempStorey"})
    public ModelAndView updateThirdTempStorey(MultipartHttpServletRequest request, HttpServletResponse response, ChannelStorey channelStorey, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            MultipartFile file = request.getFile("netLogo");
            if (file.getSize() != 0L) {
                channelStorey.setStoreyImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getStoreyImg());
            }
            channelStorey.setTempId(tempId);
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStorey.setUpdateUserId(loginUserId);
            int n = this.channelStoreyServiceImpl.updateChannelStorey(channelStorey);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(LIST_VIEW + tempId));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteThirdTempStorey"})
    public ModelAndView deleteThirdTempStorey(HttpServletRequest request, Long[] channelStoreyId, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < channelStoreyId.length; ++i) {
            this.channelStoreyServiceImpl.deleteChannelStorey(channelStoreyId[i], loginUserId);
        }
        return new ModelAndView((View)new RedirectView(LIST_VIEW + tempId));
    }
}

