/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.order.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.common.util.alipay.util.AlipayNotify;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.service.CustomerAddressService;
import com.qianjiang.customer.service.CustomerCommissionService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.OrderNoticeService;
import com.qianjiang.freight.service.FreightTemplateService;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsGroupReleProductVo;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.morder.bean.Order;
import com.qianjiang.order.bean.OrderAddress;
import com.qianjiang.order.bean.OrderInfoSession;
import com.qianjiang.order.service.OrderMService;
import com.qianjiang.order.service.OrderPayService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.OrderNotice;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.bean.DeliveryPoint;
import com.qianjiang.system.bean.ExpressConf;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.bean.Receivables;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.system.service.IExpressConfBiz;
import com.qianjiang.system.service.IExpressConfService;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.service.PaymentService;
import com.qianjiang.system.service.ReceivablesService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.alipay.AlipayRequestDatas;
import com.qianjiang.wap.alipay.AlipayUtils;
import com.qianjiang.wap.order.bean.Invoice;
import com.qianjiang.wap.util.LoginUtil;
import com.qianjiang.wap.weixin.util.Configure;
import com.qianjiang.wap.weixin.util.WXPayUtil;
import com.qianjiang.wap.weixin.util.WXSendMSG;
import com.qianjiang.wxpay.dto.ResponseDatas;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class OrderMController {
    private static final MyLogger LOGGER = new MyLogger(OrderMController.class);
    private static final String CH_PAY = "ch_pay";
    private static final String TYPEID = "typeId";
    private static final String ADDRESSID = "addressId";
    private static final String DELIVERYPOINTID = "deliveryPointId";
    private static final String LOGIN_HTML = "../loginm.html";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String ORDER = "order";
    private static final String PAYLIST = "paylist";
    private static final String OUT_TRADE_NO = "out_trade_no";
    private static final String UTF_8 = "UTF-8";
    private static final String SUCCESS = "success";
    private static final String CSUCCESS = "SUCCESS";
    private static final String UNKNOWN = "unknown";
    private static final String GOODSNOEXIT = "/goods/no_exit";
    @Resource(name="ShoppingCartService")
    private ShoppingCartService shoppingCartService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="OrderMService")
    private OrderMService siteOrderService;
    @Resource(name="OrderService")
    private OrderService orderser;
    @Resource(name="customerAddressService")
    private CustomerAddressService addressService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="FreightTemplateService")
    private FreightTemplateService freightTemplateService;
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Resource(name="customerAddressService")
    private CustomerAddressService customerAddressService;
    @Resource(name="OrderPayService1")
    private OrderPayService orderPayService;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="DeliveryPointService")
    private DeliveryPointService deliveryPointService;
    @Resource(name="PaymentService")
    PaymentService paymentService;
    @Autowired
    private IExpressConfBiz iExpressConfBiz;
    @Autowired
    private IExpressConfService iExpressConfService;
    @Resource(name="orderNoticeService")
    private OrderNoticeService orderNoticeService;
    @Resource(name="receivablesService")
    private ReceivablesService receivablesService;
    @Resource(name="depositInfoServiceImpl")
    private DepositInfoService depositInfoService;
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="customerCommissionService")
    private CustomerCommissionService customerCommissionService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Autowired
    private OrderService orderService;

    @RequestMapping(value={"/getMexpressprice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getExpressPrice(Long addressId, HttpServletRequest request, Long distributionId) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        String thirdId = request.getParameter("thirdIds");
        String cartId = request.getParameter("cartIds");
        String[] thirdIds = thirdId.split(",");
        String[] cartIds = cartId.split(",");
        CustomerAddress ca = this.addressService.queryCustomerAddressById(addressId, customerId);
        if (ca == null) {
            return "0";
        }
        BigDecimal price = new BigDecimal(0);
        for (int i = 0; i < thirdIds.length; ++i) {
            if (thirdIds[i] == null || "".equals(thirdIds[i])) continue;
            ArrayList<Long> shopIds = new ArrayList<Long>();
            if ("0".equals(thirdIds[i])) {
                for (int j = 0; j < cartIds.length; ++j) {
                    String s = cartIds[j];
                    String[] ids = s.split("-");
                    if (ids == null || ids.length == 0) continue;
                    for (String id : ids) {
                        shopIds.add(Long.valueOf(id));
                    }
                }
            } else {
                String s = cartIds[i];
                String[] ids = s.split("-");
                if (ids != null && ids.length != 0) {
                    for (String id : ids) {
                        shopIds.add(Long.valueOf(id));
                    }
                }
            }
            Long[] box = new Long[shopIds.size()];
            for (int j = 0; j < shopIds.size(); ++j) {
                box[j] = (Long)shopIds.get(j);
            }
            List shlist = this.shoppingCartService.searchByProduct(box);
            BigDecimal weight = new BigDecimal(0);
            Integer nums = 0;
            if (shlist != null && !shlist.isEmpty()) {
                for (ShoppingCart sc : shlist) {
                    if (sc.getFitId() == null) {
                        GoodsProductVo goodsProduct = this.goodsProductService.queryByPrimaryId(sc.getGoodsInfoId());
                        if (goodsProduct == null || !"0".equals(goodsProduct.getIsMailBay())) continue;
                        weight = weight.add(goodsProduct.getGoodsInfoWeight().multiply(new BigDecimal(sc.getGoodsNum())));
                        nums = nums + Integer.parseInt(sc.getGoodsNum().toString());
                        continue;
                    }
                    GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(sc.getFitId());
                    for (int j = 0; j < goodsGroupVo.getProductList().size(); ++j) {
                        weight = weight.add(((GoodsGroupReleProductVo)goodsGroupVo.getProductList().get(j)).getProductDetail().getGoodsInfoWeight().multiply(new BigDecimal(sc.getGoodsNum())));
                        nums = nums + Integer.parseInt(sc.getGoodsNum().toString());
                    }
                }
            }
            price = price.add(this.freightTemplateService.getExpressPrice(distributionId, ca.getCity().getCityId(), Long.valueOf(thirdIds[i]), nums, weight));
        }
        return price.toString();
    }

    @RequestMapping(value={"/getnewMexpressprice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getnewexpressprice(Long addressId, HttpServletRequest request) {
        CustomerAddress ca;
        String[] shopCartIds = request.getParameterValues("shopIds[]");
        ArrayList<Long> cartList = new ArrayList<Long>();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (shopCartIds != null && shopCartIds.length != 0) {
            for (String str : shopCartIds) {
                cartList.add(Long.parseLong(str));
            }
        }
        if ((ca = this.customerAddressService.queryCustomerAddressById(addressId, customerId)) == null) {
            return null;
        }
        Map freightMap = null;
        if (CollectionUtils.isNotEmpty(cartList) && addressId != null) {
            freightMap = this.shoppingCartService.getNewExpressPrice(ca.getCity().getCityId(), cartList, Long.valueOf(Long.parseLong(ca.getInfoCity())));
        }
        return freightMap;
    }

    @RequestMapping(value={"tochangeInvoice"})
    public ModelAndView tochangeInvoice(HttpServletRequest request, com.qianjiang.wap.order.bean.OrderInfoSession orderInfoSession) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId == null) {
                mav.setViewName("redirect:/loginm.html");
                return mav;
            }
            request.getSession().setAttribute("orderInfo", (Object)orderInfoSession);
            Invoice invoice = orderInfoSession.getInvoice();
            if (invoice != null) {
                if (StringUtils.isNotEmpty((String)invoice.getInvoiceType())) {
                    mav.addObject("invoiceType", (Object)invoice.getInvoiceType());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoiceTitle())) {
                    mav.addObject("invoiceTitle", (Object)invoice.getInvoiceTitle());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicEmailbox())) {
                    mav.addObject("invoicEmailbox", (Object)invoice.getInvoicEmailbox());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicCorporateName())) {
                    mav.addObject("invoicCorporateName", (Object)invoice.getInvoicCorporateName());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicDutyParagraph())) {
                    mav.addObject("invoicDutyParagraph", (Object)invoice.getInvoicDutyParagraph());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicCompanyAddress())) {
                    mav.addObject("invoicCompanyAddress", (Object)invoice.getInvoicCompanyAddress());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicCompanyPhone())) {
                    mav.addObject("invoicCompanyPhone", (Object)invoice.getInvoicCompanyPhone());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicOpeningBank())) {
                    mav.addObject("invoicOpeningBank", (Object)invoice.getInvoicOpeningBank());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicAccountNumber())) {
                    mav.addObject("invoicAccountNumber", (Object)invoice.getInvoicAccountNumber());
                }
                if (StringUtils.isNotEmpty((String)invoice.getInvoicCompanyEmail())) {
                    mav.addObject("invoicCompanyEmail", (Object)invoice.getInvoicCompanyEmail());
                }
            }
            mav.setViewName("mobileNew/invoice_ctNew");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8ba2\u5355\u786e\u8ba4\u9875\u70b9\u51fb\u53d1\u7968\u8df3\u8f6c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/suborder"})
    public ModelAndView subOrder(HttpServletRequest request, HttpServletResponse response, Long[] box, OrderAddress orderAddress, String codeNo, String[] boxgift, Long deliveryPointId, Invoice invoice) {
        ModelAndView mav = new ModelAndView();
        request.getSession().setAttribute("tok", (Object)UUID.randomUUID().toString());
        HttpSession session = request.getSession();
        Long customerId = (Long)session.getAttribute("customerId");
        try {
            String preUrl;
            OrderAddress orderAddressNew = orderAddress;
            Long[] boxNew = box;
            Long typeIdNew = null;
            if (boxNew != null) {
                session.setAttribute("box", (Object)box);
                session.removeAttribute("orderInfo");
            } else {
                boxNew = (Long[])session.getAttribute("box");
            }
            if (ArrayUtils.isEmpty((Object[])boxgift)) {
                if (session.getAttribute("boxgift") != null) {
                    boxgift = (String[])session.getAttribute("boxgift");
                } else {
                    session.setAttribute("boxgift", null);
                }
            } else {
                session.setAttribute("boxgift", (Object)boxgift);
            }
            com.qianjiang.wap.order.bean.OrderInfoSession orderInfoSession = (com.qianjiang.wap.order.bean.OrderInfoSession)session.getAttribute("orderInfo");
            if (invoice != null && invoice.getInvoiceType() != null) {
                if (orderInfoSession == null) {
                    orderInfoSession = new com.qianjiang.wap.order.bean.OrderInfoSession();
                }
                orderInfoSession.setInvoice(invoice);
            }
            if (codeNo != null) {
                if (orderInfoSession == null) {
                    orderInfoSession = new com.qianjiang.wap.order.bean.OrderInfoSession();
                }
                orderInfoSession.setCodeNo(codeNo);
            }
            if (deliveryPointId != null) {
                if (orderInfoSession == null) {
                    orderInfoSession = new com.qianjiang.wap.order.bean.OrderInfoSession();
                }
                orderInfoSession.setDeliveryPointId(deliveryPointId);
            }
            if (orderInfoSession != null) {
                session.setAttribute("orderInfo", (Object)orderInfoSession);
            }
            if ((orderInfoSession = (com.qianjiang.wap.order.bean.OrderInfoSession)session.getAttribute("orderInfo")) != null) {
                invoice = orderInfoSession.getInvoice();
                codeNo = orderInfoSession.getCodeNo();
                deliveryPointId = orderInfoSession.getDeliveryPointId();
                typeIdNew = orderInfoSession.getTypeId();
            }
            if ((preUrl = request.getHeader("Referer")) != null) {
                preUrl = URLDecoder.decode(preUrl, "utf-8");
            }
            if (customerId == null) {
                mav.setView((View)new RedirectView(LOGIN_HTML));
                return this.seoService.getCurrSeo(mav);
            }
            boolean isNormal = this.shoppingCartService.checkHasErrorProduct(boxNew);
            if (!isNormal) {
                mav.setViewName(GOODSNOEXIT);
                return this.seoService.getCurrSeo(mav);
            }
            CustomerAddress customerAddress = this.addressService.queryDefaultAddr(customerId);
            if (null == customerAddress) {
                customerAddress = this.addressService.selectByCIdFirst(customerId);
            } else if (orderAddressNew.getAddressName() == null || orderAddressNew.getAddressPhone() == null || orderAddressNew.getAddressDetail() == null || orderAddressNew.getAddressDetailInfo() == null) {
                orderAddressNew = new OrderAddress();
                orderAddressNew.setAddressId(customerAddress.getAddressId());
                orderAddressNew.setAddressDetailInfo(customerAddress.getAddressDetail());
                orderAddressNew.setAddressName(customerAddress.getAddressName());
                orderAddressNew.setAddressPhone(customerAddress.getAddressMoblie());
                orderAddressNew.setAddressDetail(customerAddress.getProvince().getProvinceName() + customerAddress.getCity().getCityName() + customerAddress.getDistrict().getDistrictName());
                if (typeIdNew == null || typeIdNew == 0L) {
                    typeIdNew = 0L;
                }
            } else {
                orderAddressNew.setAddressCitySecondStageName(new String(orderAddressNew.getAddressCitySecondStageName().getBytes(ISO_8859_1), "utf-8"));
                orderAddressNew.setAddressCountiesThirdStageName(new String(orderAddressNew.getAddressCountiesThirdStageName().getBytes(ISO_8859_1), "utf-8"));
                orderAddressNew.setAddressDetail(new String(orderAddressNew.getAddressDetail().getBytes(ISO_8859_1), "utf-8"));
                orderAddressNew.setAddressDetailInfo(new String(orderAddressNew.getAddressDetailInfo().getBytes(ISO_8859_1), "utf-8"));
                orderAddressNew.setAddressName(new String(orderAddressNew.getAddressName().getBytes(ISO_8859_1), "utf-8"));
                orderAddressNew.setAddressPhone(new String(orderAddressNew.getAddressPhone().getBytes(ISO_8859_1), "utf-8"));
                orderAddressNew.setProviceFirstStageName(new String(orderAddressNew.getProviceFirstStageName().getBytes(ISO_8859_1), "utf-8"));
            }
            Map map = this.shoppingCartService.newsubOrder(request, boxNew, customerAddress, boxgift);
            List shoplist = (List)map.get("shoplist");
            if (shoplist == null || shoplist.isEmpty() || "0".equals(map.get("stock"))) {
                ModelMap modelMap = new ModelMap();
                String stocks = JSON.toJSONString(map.get("stockInfo"));
                modelMap.addAttribute("stockinfos", (Object)stocks);
                modelMap.addAttribute("buyingLimitError", map.get("buyingLimitError"));
                mav.addAllObjects((Map)modelMap);
                mav.setView((View)new RedirectView(request.getContextPath() + "/myshoppingmcart.html"));
                return this.seoService.getCurrSeo(mav);
            }
            ExpressConf exp = this.iExpressConfBiz.getExpressConfByUsedField();
            if (null != exp && "1".equals(exp.getUsedStatus())) {
                HashMap<String, Object> deliveryMap = new HashMap<String, Object>();
                if (deliveryPointId != null) {
                    // empty if block
                }
                List deliveries = new ArrayList();
                if (deliveryPointId != null) {
                    DeliveryPoint deliveryPoint = this.deliveryPointService.getDeliveryPoint(deliveryPointId);
                    deliveryMap.put("choseDeliveryPoint", deliveryPoint);
                } else {
                    if (customerAddress != null && customerAddress.getCity() != null) {
                        deliveries = this.deliveryPointService.selectByCityId(customerAddress.getCity().getCityId());
                    }
                    deliveryMap.put("deliveries", deliveries);
                }
                mav.addObject("deliveryMap", deliveryMap);
            }
            if (StringUtils.isNotEmpty((String)codeNo)) {
                Coupon coupon = this.couponService.selectCouponByCodeNo(codeNo);
                mav.addObject("coupon", (Object)coupon);
            }
            List payList = this.paymentService.selectAllForSite();
            List pays = this.payService.queryAllPaySet();
            mav.addObject("invoice", (Object)invoice);
            response.setHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Pragma", "no-cache");
            mav.addObject(DELIVERYPOINTID, (Object)deliveryPointId);
            mav.addObject("map", (Object)map);
            mav.addObject("customer", (Object)customerAddress);
            mav.addObject(TYPEID, (Object)typeIdNew);
            mav.addObject("orderAddress", (Object)orderAddressNew);
            mav.addObject(PAYLIST, (Object)payList);
            mav.addObject("pays", (Object)pays);
            mav.addObject("url", (Object)preUrl);
            mav.addObject("sx", (Object)request.getSession().getAttribute("tok").toString());
            mav.setViewName("order/newsuborder");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u8df3\u8f6c\u5230\u8ba2\u5355\u786e\u8ba4\u9875\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"toFreightAndPay"})
    public ModelAndView toFreightAndPay(HttpServletRequest request, Long typeId, Long addressId, Long chPay, Long deliveryPointId) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Long typeIdNew = typeId;
        if (typeIdNew == null) {
            typeIdNew = 0L;
        }
        try {
            if (customerId == null) {
                mav.setView((View)new RedirectView(LOGIN_HTML));
                return mav;
            }
            CustomerAddress customerAddress = this.addressService.queryDefaultAddr(customerId);
            if (null == customerAddress) {
                customerAddress = this.addressService.selectByCIdFirst(customerId);
            }
            Long[] box = (Long[])request.getSession().getAttribute("box");
            Map map = this.shoppingCartService.newsubOrder(request, box, customerAddress, null);
            CustomerAddress address = null;
            address = addressId != null ? this.addressService.queryCustomerAddressById(addressId, customerId) : this.addressService.selectByCIdFirst(customerId);
            List dps = null;
            if (address != null) {
                dps = this.deliveryPointService.selectDeliveryPointBycityId(Long.valueOf(address.getInfoCity()));
            }
            mav.addObject("ch_pay2", request.getSession().getAttribute(CH_PAY));
            mav.addObject(PAYLIST, (Object)this.paymentService.selectAllForSite());
            mav.addObject(ADDRESSID, (Object)addressId);
            mav.addObject(CH_PAY, (Object)chPay);
            mav.addObject(DELIVERYPOINTID, (Object)deliveryPointId);
            mav.addObject("expressConf", (Object)this.iExpressConfService.getExpressConfByUsedField());
            mav.addObject("map", (Object)map);
            mav.addObject(TYPEID, (Object)typeIdNew);
            mav.addObject("dps", (Object)dps);
            mav.setViewName("order/payType");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8bbe\u7f6e\u914d\u9001\u65b9\u5f0f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"tocouponlist"})
    public ModelAndView tocouponlist(HttpServletRequest request, String codeNo, com.qianjiang.wap.order.bean.OrderInfoSession orderInfoSession) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId == null) {
                mav.setView((View)new RedirectView(LOGIN_HTML));
                return this.seoService.getCurrSeo(mav);
            }
            if (orderInfoSession != null && orderInfoSession.getSubTag() != null) {
                request.getSession().setAttribute("orderInfo", (Object)orderInfoSession);
            }
            Long[] box = (Long[])request.getSession().getAttribute("box");
            mav.addObject("codeNo", (Object)codeNo);
            List couponlist = this.shoppingCartService.getUsedCouponlist(request, box);
            mav.addObject("couponlist", (Object)couponlist);
            List coupons = this.couponService.selectCouponListByCustomerId(customerId);
            if (couponlist != null && !couponlist.isEmpty()) {
                for (int i = 0; i < couponlist.size(); ++i) {
                    for (int j = 0; j < coupons.size(); ++j) {
                        if (!((Coupon)couponlist.get(i)).getCodeNo().equals(((Coupon)coupons.get(j)).getCodeNo())) continue;
                        coupons.remove(coupons.get(j));
                        --j;
                    }
                }
            }
            mav.addObject("coupons", (Object)coupons);
            mav.setViewName("order/couponlist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u67e5\u770b\u4e2a\u4eba\u6240\u6709\u7684\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"queryStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryStatus(HttpServletRequest request, String couponNo) {
        int flag = 1;
        Long[] box = (Long[])request.getSession().getAttribute("box");
        List couponlist = this.shoppingCartService.getUsedCouponlist(request, box);
        if (StringUtils.isEmpty((String)couponNo)) {
            flag = -1;
        } else if (null != couponlist && couponlist.size() > 0) {
            for (int i = 0; i < couponlist.size(); ++i) {
                if (!couponNo.equals(((Coupon)couponlist.get(i)).getCodeNo())) continue;
                flag = 0;
                break;
            }
        }
        return flag;
    }

    @RequestMapping(value={"toproductsList"})
    public ModelAndView toproductsList(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId == null) {
                mav.setView((View)new RedirectView(LOGIN_HTML));
                return mav;
            }
            CustomerAddress customerAddress = this.addressService.queryDefaultAddr(customerId);
            if (null == customerAddress) {
                customerAddress = this.addressService.selectByCIdFirst(customerId);
            }
            Long[] box = (Long[])request.getSession().getAttribute("box");
            Map map = this.shoppingCartService.newsubOrder(request, box, customerAddress, null);
            mav.addObject("map", (Object)map);
            mav.setViewName("order/productsList");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u770b\u8d27\u54c1\u8be6\u60c5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/selectordermarketingbygoodsids"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Promotion> selectordermarketingbygoodsids(Long[] goodsIds) {
        return new ArrayList<Promotion>();
    }

    @RequestMapping(value={"/changeshoppingcartordermarkets"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int changeshoppingcartordermarkets(Long shoppingCartId, Long orderMarketId) {
        return 0;
    }

    @RequestMapping(value={"/submitorder"})
    public ModelAndView submitOrder(HttpServletRequest request, Long point, String invoiceType, String invoiceTitle, String invoicEmailbox, String invoicCorporateName, String invoicDutyParagraph, String invoicCompanyAddress, String invoicOpeningBank, String invoicAccountNumber, String invoicCompanyEmail, String invoicCompanyPhone, Long deliveryPointId, Long[] shoppingCartId, HttpServletResponse response, Long typeId, OrderAddress orderAddress, String[] presentScopeId) throws UnsupportedEncodingException {
        if (point != null && point < 0L) {
            throw new RuntimeException("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView(LOGIN_HTML));
        }
        List orders = null;
        if (orders == null || orders.size() == 0) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/myshoppingmcart.htm"));
        }
        com.qianjiang.order.bean.Order order = (com.qianjiang.order.bean.Order)orders.get(0);
        this.orderPayService.sendOrderRe(order);
        for (int i = 0; i < orders.size(); ++i) {
            com.qianjiang.order.bean.Order or = this.orderPayService.queryGoodsProducts(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderId());
            orders.set(i, or);
        }
        OrderNotice record = new OrderNotice();
        com.qianjiang.order.bean.Order orderT = new com.qianjiang.order.bean.Order();
        for (int i = 0; i < orders.size(); ++i) {
            orderT = (com.qianjiang.order.bean.Order)orders.get(i);
            record.setCustomerId(customerId);
            record.setOrderId(orderT.getOrderId());
            record.setNoticeTitle("\u8ba2\u5355\u901a\u77e5");
            record.setNoticeContent("\u60a8\u7684\u8ba2\u5355 " + orderT.getOrderCode() + " \u5df2\u7ecf\u63d0\u4ea4\u6210\u529f\uff0c\u6211\u4eec\u5c06\u53ca\u65f6\u4e3a\u60a8\u5904\u7406\u3002");
            record.setIsRead("0");
            this.orderNoticeService.addNotice(record);
        }
        ModelAndView mav = null;
        Long chPay = 1L;
        if (StringUtils.isNotEmpty((String)request.getParameter(CH_PAY))) {
            chPay = Long.valueOf(request.getParameter(CH_PAY));
        }
        if (chPay.equals(2L)) {
            mav = new ModelAndView((View)new RedirectView("customer/detail-" + ((com.qianjiang.order.bean.Order)orders.get(0)).getOrderId() + ".html"));
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"gopayorder"})
    public ModelAndView gopayorder(Long orderId) {
        ModelAndView mav = new ModelAndView("order/orderdetail").addObject(ORDER, (Object)this.siteOrderService.getPayOrder(orderId)).addObject(PAYLIST, (Object)this.payService.queryAllPaySet());
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/paybarterorder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> paybarterorder(HttpServletRequest request, Long point, OrderInfoSession orderInfoSession, Long[] shoppingCartId, HttpServletResponse response, OrderAddress orderAddress, String[] presentScopeId, String subtractPrice, Long[] orderBarterGoodIndex) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String flag = "0";
        try {
            ArrayList orderIdList = new ArrayList();
            if (point != null && point < 0L) {
                flag = "2";
                map.put("flag", flag);
                return map;
            }
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            if (customerId == null) {
                flag = "3";
                map.put("flag", flag);
                return map;
            }
            Long[] l = new Long[]{1L};
            CustomerAddress customerAddress = this.customerAddressService.queryCustomerAddressById(orderAddress.getAddressId(), customerId);
            int result = this.orderService.saveAddOrderInterface(new BigDecimal(subtractPrice), new BigDecimal("10"), "25_EMS", "", orderBarterGoodIndex, l, Long.valueOf(1690L), Long.valueOf(1L), "", "1", "\u660e\u7ec6", customerAddress, "", "");
            if (result > 0) {
                map.put("orderId", this.orderService.selectLastId());
                flag = "1";
                map.put("flag", flag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @RequestMapping(value={"/payorder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> payOrder(HttpServletRequest request, Long point, OrderInfoSession orderInfoSession, Long[] shoppingCartId, HttpServletResponse response, OrderAddress orderAddress, String[] presentScopeId) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String flag = "0";
        try {
            ArrayList<Long> orderIdList = new ArrayList<Long>();
            if (point != null && point < 0L) {
                flag = "2";
                map.put("flag", flag);
                return map;
            }
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            if (customerId == null) {
                flag = "3";
                map.put("flag", flag);
                return map;
            }
            List orders = this.siteOrderService.newsubmitOrder(point, orderInfoSession, request, shoppingCartId, orderAddress, presentScopeId);
            BigDecimal sumPrice = BigDecimal.ZERO;
            if (orders == null || orders.size() == 0) {
                flag = "4";
                map.put("flag", flag);
                return map;
            }
            com.qianjiang.order.bean.Order order = (com.qianjiang.order.bean.Order)orders.get(0);
            this.orderPayService.sendOrderRe(order);
            for (int i = 0; i < orders.size(); ++i) {
                com.qianjiang.order.bean.Order or = this.orderPayService.newQueryGoodsProducts(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderId());
                orders.set(i, or);
                sumPrice = sumPrice.add(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderPrice());
            }
            OrderNotice record = new OrderNotice();
            com.qianjiang.order.bean.Order orderT = new com.qianjiang.order.bean.Order();
            for (int i = 0; i < orders.size(); ++i) {
                orderT = (com.qianjiang.order.bean.Order)orders.get(i);
                record.setCustomerId(customerId);
                record.setOrderId(orderT.getOrderId());
                record.setNoticeTitle("\u8ba2\u5355\u901a\u77e5");
                record.setNoticeContent("\u60a8\u7684\u8ba2\u5355 " + orderT.getOrderCode() + " \u5df2\u7ecf\u63d0\u4ea4\u6210\u529f\uff0c\u6211\u4eec\u5c06\u53ca\u65f6\u4e3a\u60a8\u5904\u7406\u3002");
                record.setIsRead("0");
                this.orderNoticeService.addNotice(record);
                orderIdList.add(orderT.getOrderId());
            }
            map.put("flag", "1");
            map.put("orderIdList", orderIdList);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("flag", "99");
        }
        return map;
    }

    @RequestMapping(value={"/orderlistpay"})
    public ModelAndView orderlistpay(HttpServletRequest request, Long orderId) throws UnsupportedEncodingException {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView(LOGIN_HTML));
        }
        String orderType = request.getParameter("orderType");
        com.qianjiang.order.bean.Order order = this.orderser.getPayOrder(orderId);
        if ("all".equals(orderType)) {
            if (null != order) {
                BigDecimal total = new BigDecimal(0);
                String orderOldCode = order.getOrderOldCode();
                List orderList = this.orderser.getPayOrderByOldCode(orderOldCode);
                for (com.qianjiang.order.bean.Order or : orderList) {
                    if (or == null) continue;
                    total = total.add(or.getOrderPrice());
                    this.orderser.updateOrderPayType(or.getOrderId(), 1);
                }
                order.setOrderPrice(total);
            }
        } else {
            this.orderser.updateOrderPayType(orderId, 1);
        }
        Map map = this.orderser.queryGoodsInfoName1(order.getOrderId());
        String goodsName = (String)map.get("goodsName");
        ModelAndView mav = new ModelAndView();
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        if (p != null) {
            this.getReceivables(p, request, order);
            if ("1".equals(p.getPayType())) {
                String notifyUrl = p.getNoticeUrl();
                String returnUrl = p.getBackUrl();
                String outTradeNo = order.getOrderOldCode();
                String subject = goodsName;
                String totalFee = order.getOrderPrice().toString();
                try {
                    AlipayRequestDatas requestDatas = new AlipayRequestDatas();
                    requestDatas.setOut_trade_no(outTradeNo);
                    requestDatas.setSubject(subject);
                    requestDatas.setTotal_amount(new BigDecimal(totalFee));
                    requestDatas.setReturnUrl(returnUrl);
                    requestDatas.setNotifyUrl(notifyUrl);
                    Pay pay = this.payService.selectPayByType("1");
                    String form = AlipayUtils.aliPayPostExecute(requestDatas);
                    mav.addObject("sHtmlText", (Object)form);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                mav.setViewName("order/netbank");
            }
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"getwxparam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getWXParam(HttpServletRequest request, Long point, String invoiceType, String invoiceTitle, String invoicEmailbox, String invoicCorporateName, String invoicDutyParagraph, String invoicCompanyAddress, String invoicCompanyPhone, String invoicOpeningBank, String invoicAccountNumber, String invoicCompanyEmail, Long deliveryPointId, Long[] shoppingCartId, HttpServletResponse response, Long typeId, OrderAddress orderAddress, String[] presentScopeId) throws UnsupportedEncodingException {
        if (point != null && point < 0L) {
            throw new RuntimeException("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return null;
        }
        List orders = null;
        BigDecimal sumPrice = BigDecimal.ZERO;
        if (orders == null || orders.size() == 0) {
            return null;
        }
        com.qianjiang.order.bean.Order order = (com.qianjiang.order.bean.Order)orders.get(0);
        this.orderPayService.sendOrderRe(order);
        for (int i = 0; i < orders.size(); ++i) {
            com.qianjiang.order.bean.Order or = this.orderPayService.queryGoodsProducts(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderId());
            orders.set(i, or);
            sumPrice = sumPrice.add(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderPrice());
        }
        OrderNotice record = new OrderNotice();
        com.qianjiang.order.bean.Order orderT = new com.qianjiang.order.bean.Order();
        for (int i = 0; i < orders.size(); ++i) {
            orderT = (com.qianjiang.order.bean.Order)orders.get(i);
            record.setCustomerId(customerId);
            record.setOrderId(orderT.getOrderId());
            record.setNoticeTitle("\u8ba2\u5355\u901a\u77e5");
            record.setNoticeContent("\u60a8\u7684\u8ba2\u5355 " + orderT.getOrderCode() + " \u5df2\u7ecf\u63d0\u4ea4\u6210\u529f\uff0c\u6211\u4eec\u5c06\u53ca\u65f6\u4e3a\u60a8\u5904\u7406\u3002");
            record.setIsRead("0");
            this.orderNoticeService.addNotice(record);
        }
        Pay pay = this.payService.findByPayId(Long.valueOf(37L));
        if (orders.size() > 1) {
            order.setOrderCode(((com.qianjiang.order.bean.Order)orders.get(0)).getOrderOldCode());
            order.setOrderPrice(sumPrice);
        }
        if (orders.size() > 1) {
            for (int i = 0; i < orders.size(); ++i) {
                com.qianjiang.order.bean.Order childOrder = (com.qianjiang.order.bean.Order)orders.get(i);
                if (!"1".equals(childOrder.getOrderLinePay())) continue;
                this.getReceivables(pay, request, childOrder);
            }
        } else {
            this.getReceivables(pay, request, order);
        }
        return null;
    }

    @RequestMapping(value={"/paysucccess"})
    public ModelAndView paySuccess(HttpServletRequest request, HttpServletResponse agr1, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView("order/payFail_ct");
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            StringBuilder valueStr = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    valueStr.append(values[i]);
                    continue;
                }
                valueStr.append(values[i]);
                valueStr.append(",");
            }
            params.put(name, valueStr.toString());
        }
        String orderCode = null;
        try {
            orderCode = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u4ea4\u6613\u53f7\u9519\u8bef\uff1a" + e);
        }
        boolean verifyResult = AlipayUtils.rsaCheckV1(params);
        System.out.println("-----------------------------[" + verifyResult + "]-----------------------");
        List orderList = this.orderser.getPayOrderByOldCode(orderCode);
        if (orderList != null && orderList.size() > 0) {
            LOGGER.debug("\u652f\u4ed8\u7ed3\u675f\u540e\u6821\u9a8c\u7b7e\u540d\u662f\u5426\u6b63\u786e");
            ArrayList result = new ArrayList();
            HashMap<String, Object> resultMap = null;
            BigDecimal orderPrice = new BigDecimal(0);
            for (com.qianjiang.order.bean.Order or : orderList) {
                orderPrice = orderPrice.add(or.getOrderPrice());
                if (verifyResult) {
                    if ("0".equals(or.getOrderStatus())) {
                        this.siteOrderService.payOrder(or.getOrderId());
                    }
                    if ("2".equals(or.getOrderMType())) {
                        CustomerAllInfo customer = this.customerServiceMapper.queryCustomerInfo(or.getCustomerId());
                        Map map = this.orderser.queryGoodsInfoName1(or.getOrderId());
                        String goodsName = (String)map.get("goodsName");
                        HashMap<String, Object> paraMap = new HashMap<String, Object>();
                        paraMap.put("openid", customer.getCustomerUsername());
                        paraMap.put("orderNo", or.getOrderCode());
                        paraMap.put("orderPrice", or.getOrderPrice());
                        paraMap.put("goodsName", goodsName);
                        paraMap.put("orderId", or.getOrderId());
                        WXSendMSG.sendWxMsgForOrderPaySucc(paraMap, request, response);
                    }
                    if ("4".equals(or.getOrderCargoStatus())) {
                        this.orderser.modifyOrderByKey(or.getOrderId(), "2");
                    }
                    this.customerCommissionService.getCustomerCommission(or.getCustomerId(), or.getPayTime(), or.getOrderCode());
                    this.upgradeCustomerLevel(or.getCustomerId());
                }
                mav.setViewName("order/paySuccess_ct");
                resultMap = new HashMap<String, Object>();
                resultMap.put("orderId", or.getOrderId());
                resultMap.put("orderPrice", or.getOrderPrice());
                resultMap.put("orderDistributedType", or.getOrderDistributedType());
                resultMap.put("shippingPerson", or.getShippingPerson());
                resultMap.put("shippingMobile", or.getShippingMobile());
                resultMap.put("addr", or.getShippingProvince() + or.getShippingCity() + or.getShippingCounty() + or.getShippingAddress());
                String storeAddress = "";
                Long id = or.getShippingCountyId();
                resultMap.put("toAddr", storeAddress);
                result.add(resultMap);
            }
            mav.addObject("list", result);
            mav.addObject("orderPrice", (Object)orderPrice);
        }
        return this.seoService.getCurrSeo(mav);
    }

    private void upgradeCustomerLevel(Long customerId) {
        List levelList = this.customerPointServiceMapper.getAllCustomerPointLevelSortDesc();
        BigDecimal totalMoney = this.orderser.countTotalPriceByCustomerId(customerId);
        BigDecimal maxMoney = this.orderser.selectMaxPriceByCustomerId(customerId);
        CustomerAllInfo customerInfo = this.customerServiceMapper.queryCustomerInfo(customerId);
        Long currentCustomerLevelId = customerInfo.getPointLevelId();
        for (CustomerPointLevel customer : levelList) {
            if ((customer.getMinPoint() < totalMoney.longValue() || customer.getMaxPoint() > totalMoney.longValue()) && (long)customer.getPointNeedOnce() > maxMoney.longValue() || customer.getPointLevelId() <= customerInfo.getPointLevelId()) continue;
            currentCustomerLevelId = customer.getPointLevelId();
            HashMap<String, Object> paramp = new HashMap<String, Object>();
            paramp.put("pointLevelId", currentCustomerLevelId);
            paramp.put("pointLevelName", customer.getPointLevelName());
            paramp.put("customerId", customerId);
            this.customerServiceMapper.upCusLevel(paramp);
            break;
        }
    }

    @RequestMapping(value={"/wxpaysuc"})
    public void wxpaySuc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        try {
            Document document = DocumentHelper.parseText((String)sb.toString());
            Element root = document.getRootElement();
            String appId = "";
            String outTradeNo = "";
            String resultCode = "";
            String mId = "";
            List elements = root.elements();
            for (Element element : elements) {
                if ("appid".equals(element.getName())) {
                    appId = element.getText();
                    continue;
                }
                if ("bank_type".equals(element.getName())) {
                    element.getText();
                    continue;
                }
                if ("mch_id".equals(element.getName())) {
                    mId = element.getText();
                    continue;
                }
                if ("result_code".equals(element.getName())) {
                    resultCode = element.getText();
                    continue;
                }
                if (!OUT_TRADE_NO.equals(element.getName())) continue;
                outTradeNo = element.getText();
            }
            com.qianjiang.order.bean.Order or = this.siteOrderService.getPayOrderByCode(outTradeNo);
            Pay pay = this.payService.findByPayId(Long.valueOf(37L));
            if (or == null) {
                List orders = this.siteOrderService.queryOrderByOrderOldCode(outTradeNo);
                if (!orders.isEmpty() && orders.size() != 0) {
                    for (int i = 0; i < orders.size(); ++i) {
                        if (!CSUCCESS.equals(resultCode) || !appId.equals(pay.getApiKey()) || !mId.equals(pay.getPartner()) || !"0".equals(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderStatus())) continue;
                        this.siteOrderService.payOrder(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderId());
                        Receivables receivables = this.receivablesService.queryByOrderCode(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderCode());
                        if (null == receivables) continue;
                        receivables.setReceivablesTime(new Date());
                        this.receivablesService.updatePayStatus(receivables);
                    }
                    this.sendSucess(response, CSUCCESS);
                    this.customerCommissionService.getCustomerCommission(or.getCustomerId(), or.getPayTime(), or.getOrderCode());
                }
            } else if (CSUCCESS.equals(resultCode) && appId.equals(pay.getApiKey()) && mId.equals(pay.getPartner()) && "0".equals(or.getOrderStatus())) {
                this.siteOrderService.payOrder(or.getOrderId());
                Receivables receivables = this.receivablesService.queryByOrderCode(or.getOrderCode());
                if (null != receivables) {
                    receivables.setReceivablesTime(new Date());
                    this.receivablesService.updatePayStatus(receivables);
                }
                this.sendSucess(response, CSUCCESS);
                this.customerCommissionService.getCustomerCommission(or.getCustomerId(), or.getPayTime(), or.getOrderCode());
            }
        }
        catch (DocumentException e1) {
            LOGGER.error("\u5fae\u4fe1\u652f\u4ed8\u9519\u8bef\uff1a" + (Object)((Object)e1));
            this.sendSucess(response, "FAIL");
        }
    }

    public void sendSucess(HttpServletResponse response, String msg) throws IOException {
        PrintWriter out = response.getWriter();
        out.println(msg);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/paysucccesswx"})
    public ModelAndView paySuccessWx(HttpServletRequest request, HttpServletResponse agr1, Long orderId) {
        ModelAndView mav = new ModelAndView("order/pay_success_new");
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/addcartsuc"})
    public ModelAndView addCartSuc(Long goodsInfoId) {
        List goodsProductVos = this.orderser.queryGoodsProductVoByOrderGoods(goodsInfoId);
        return this.seoService.getCurrSeo(new ModelAndView("shoppingcart/add_cart").addObject("list", (Object)goodsProductVos));
    }

    @RequestMapping(value={"/orderdetailpay"})
    public ModelAndView orderDetailPay(Long orderId) {
        com.qianjiang.order.bean.Order order = this.orderPayService.queryGoodsProducts(orderId);
        ModelAndView mav = new ModelAndView("order/check_out_de2");
        mav.addObject(ORDER, (Object)order);
        mav.addObject(PAYLIST, (Object)this.payService.queryAllPaySet());
        mav.addObject("coupon", (Object)this.couponService.selectCouponByCodeNo(order.getCouponNo()));
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/paysucccessybm"})
    public void paySuccessyb(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int i;
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            StringBuilder valueStr = new StringBuilder();
            for (i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    valueStr.append(values[i]);
                    continue;
                }
                valueStr.append(values[i]);
                valueStr.append(",");
            }
            params.put(name, valueStr.toString());
        }
        String outTradeNo = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
        String tradeStatus = new String(request.getParameter("trade_status").getBytes(ISO_8859_1), UTF_8);
        if (AlipayNotify.verify(params)) {
            Receivables receivables;
            List orders;
            com.qianjiang.order.bean.Order or;
            if ("TRADE_FINISHED".equals(tradeStatus)) {
                or = this.siteOrderService.getPayOrderByCode(outTradeNo);
                if (or == null) {
                    orders = this.siteOrderService.queryOrderByOrderOldCode(outTradeNo);
                    for (i = 0; i < orders.size(); ++i) {
                        Receivables receivables2 = this.receivablesService.queryByOrderCode(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderCode());
                        if (!"0".equals(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderStatus())) continue;
                        this.siteOrderService.payOrder(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderId());
                        if (null == receivables2) continue;
                        receivables2.setReceivablesTime(new Date());
                        this.receivablesService.updatePayStatus(receivables2);
                        this.siteOrderService.paySuccessSendSms((com.qianjiang.order.bean.Order)orders.get(i));
                    }
                } else {
                    receivables = this.receivablesService.queryByOrderCode(or.getOrderCode());
                    if ("0".equals(or.getOrderStatus())) {
                        this.siteOrderService.payOrder(or.getOrderId());
                        if (null != receivables) {
                            receivables.setReceivablesTime(new Date());
                            this.receivablesService.updatePayStatus(receivables);
                            this.siteOrderService.paySuccessSendSms(or);
                        }
                    }
                }
            } else if ("TRADE_SUCCESS".equals(tradeStatus)) {
                or = this.siteOrderService.getPayOrderByCode(outTradeNo);
                if (or == null) {
                    orders = this.siteOrderService.queryOrderByOrderOldCode(outTradeNo);
                    for (i = 0; i < orders.size(); ++i) {
                        Receivables receivables3 = this.receivablesService.queryByOrderCode(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderCode());
                        if (!"0".equals(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderStatus())) continue;
                        this.siteOrderService.payOrder(((com.qianjiang.order.bean.Order)orders.get(i)).getOrderId());
                        if (null == receivables3) continue;
                        receivables3.setReceivablesTime(new Date());
                        this.receivablesService.updatePayStatus(receivables3);
                        this.siteOrderService.paySuccessSendSms((com.qianjiang.order.bean.Order)orders.get(i));
                    }
                } else {
                    receivables = this.receivablesService.queryByOrderCode(or.getOrderCode());
                    if ("0".equals(or.getOrderStatus())) {
                        this.siteOrderService.payOrder(or.getOrderId());
                        if (null != receivables) {
                            receivables.setReceivablesTime(new Date());
                            this.receivablesService.updatePayStatus(receivables);
                            this.siteOrderService.paySuccessSendSms(or);
                        }
                    }
                }
                this.sendSucess(response, SUCCESS);
            }
        } else {
            System.out.println("fail");
        }
    }

    @RequestMapping(value={"/queryAllPaySet"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryAllPaySet() {
        return this.payService.queryAllPaySet();
    }

    public PayService getPayService() {
        return this.payService;
    }

    @RequestMapping(value={"getmwxparamH5"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, String> getWXParamH5(Long orderId, HttpServletRequest request, HttpServletResponse response) {
        String orderType = request.getParameter("orderType");
        com.qianjiang.order.bean.Order order = this.orderser.getPayOrder(orderId);
        if ("all".equals(orderType)) {
            if (null != order) {
                BigDecimal total = new BigDecimal(0);
                String orderOldCode = order.getOrderOldCode();
                List orderList = this.orderser.getPayOrderByOldCode(orderOldCode);
                for (com.qianjiang.order.bean.Order or : orderList) {
                    if (or == null) continue;
                    total = total.add(or.getOrderPrice());
                    this.orderser.updateOrderPayType(or.getOrderId(), 3);
                }
                order.setOrderPrice(total);
            }
        } else {
            this.orderser.updateOrderPayType(orderId, 3);
        }
        Pay pay = this.payService.findByPayId(Long.valueOf(37L));
        this.getReceivables(pay, request, order);
        Map map = this.orderser.queryGoodsInfoName1(orderId);
        String goodsName = (String)map.get("goodsName");
        return this.siteOrderService.getWXUrlH5(request, response, order, pay, goodsName);
    }

    @RequestMapping(value={"/getmwxparam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getWXParam(Long orderId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String orderType = request.getParameter("orderType");
            com.qianjiang.order.bean.Order order = this.orderser.getPayOrder(orderId);
            if ("all".equals(orderType)) {
                if (null != order) {
                    BigDecimal total = new BigDecimal(0);
                    String orderOldCode = order.getOrderOldCode();
                    List orderList = this.orderser.getPayOrderByOldCode(orderOldCode);
                    for (com.qianjiang.order.bean.Order or : orderList) {
                        if (or == null) continue;
                        total = total.add(or.getOrderPrice());
                        this.orderser.updateOrderPayType(or.getOrderId(), 3);
                    }
                    order.setOrderPrice(total);
                }
            } else {
                this.orderser.updateOrderPayType(orderId, 3);
            }
            Pay pay = this.payService.findByPayId(Long.valueOf(37L));
            this.getReceivables(pay, request, order);
            Map map = this.orderser.queryGoodsInfoName1(orderId);
            String goodsName = (String)map.get("goodsName");
            ResponseDatas responseDatas = this.siteOrderService.getWXUrl(request, response, order, pay, goodsName);
            if (responseDatas != null && responseDatas.isSuccess()) {
                result.put("appid", responseDatas.getAppId());
                result.put("partnerid", responseDatas.getMchId());
                result.put("prepayid", responseDatas.getPrepayId());
                result.put("package", "Sign=WXPay");
                result.put("noncestr", responseDatas.getNonceStr());
                result.put("timestamp", WXPayUtil.getCurrentTimestamp() + "");
                String sign = WXPayUtil.generateSignature(result, Configure.getKey());
                result.put("sign", sign);
                result.put("status", CSUCCESS);
            } else {
                result.put("status", "FAIL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("status", "FAIL");
        }
        String resultData = JSONObject.fromObject(result).toString();
        LOGGER.debug("\u751f\u6210\u9884\u4ed8\u5355\u8fd4\u56de\u53c2\u6570[" + resultData + "]");
        return resultData;
    }

    public void getReceivables(Pay p, HttpServletRequest request, com.qianjiang.order.bean.Order order) {
        boolean isNotExist;
        Receivables receivables = this.receivablesService.queryByOrderCode(order.getOrderCode());
        boolean bl = isNotExist = null == receivables;
        if (isNotExist) {
            receivables = new Receivables();
            Random random = new Random();
            int code = random.nextInt(10001);
            String codes = "2015" + code;
            receivables.setCashRegisterCode(codes);
        }
        receivables.setPayIp(this.getIpAddr(request));
        receivables.setCustomerId(order.getCustomerUsername());
        receivables.setPayAccount(p.getPayAccount());
        receivables.setPayTime(new Date());
        receivables.setReceivablesTime(new Date());
        receivables.setPayMode(p.getPayName());
        receivables.setPayType("\u5728\u7ebf\u652f\u4ed8");
        receivables.setPayMoney(order.getOrderPrice());
        receivables.setOrderCode(order.getOrderCode());
        receivables.setPayStatus("1");
        if (isNotExist) {
            this.receivablesService.addReceivables(receivables);
        } else {
            this.receivablesService.upDateReceivables(receivables);
        }
    }

    public String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    @RequestMapping(value={"/deliverylist"})
    public ModelAndView deliveryList(HttpServletRequest request, String dpId, com.qianjiang.wap.order.bean.OrderInfoSession orderInfoSession) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (orderInfoSession != null && orderInfoSession.getSubTag() != null) {
                request.getSession().setAttribute("orderInfo", (Object)orderInfoSession);
            }
            CustomerAddress customerAddress = null;
            if (customerId != null) {
                customerAddress = this.addressService.queryDefaultAddr(customerId);
            }
            if (null == customerAddress) {
                customerAddress = this.addressService.selectByCIdFirst(customerId);
            }
            HashMap<String, List> deliveryMap = new HashMap<String, List>();
            if (customerAddress != null && customerAddress.getCity() != null) {
                List deliveries = this.deliveryPointService.selectByCityId(customerAddress.getCity().getCityId());
                deliveryMap.put("deliveries", deliveries);
            }
            mav.addObject("deliveryMap", deliveryMap);
            mav.addObject("dpId", (Object)dpId);
            mav.setViewName("order/deliverylist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8ba2\u5355\u786e\u8ba4\u9875\u8df3\u8f6c\u81ea\u63d0\u70b9\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/depositpayorder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public com.alibaba.fastjson.JSONObject depositPayOrder(HttpServletRequest request, String payPassword, Long orderId) {
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            com.qianjiang.order.bean.Order order = this.orderser.queryOrderByCustomerIdAndOrderId(customerId, orderId);
            order.setPayId(Long.valueOf(5L));
            JSONObject json = JSONObject.fromObject((Object)order);
            Object orderm = JSONObject.toBean((JSONObject)json, Order.class);
            return (com.alibaba.fastjson.JSONObject)this.depositInfoService.depositPay((Order)orderm, customerId, payPassword);
        }
        return null;
    }

    @RequestMapping(value={"/querypayments"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryPayments(HttpServletRequest request) {
        if (LoginUtil.checkLoginStatus(request)) {
            return this.payService.queryAllPaySet();
        }
        return null;
    }
}

