/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.order.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.CustomerAddressService;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.system.service.IExpressConfBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.order.bean.OrderInfoSession;
import com.qianjiang.wap.util.LoginUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class OrderAddressController {
    public static final MyLogger LOGGER = new MyLogger(OrderAddressController.class);
    private static final String ADDRESSID = "addressId";
    private static final String FLAG = "flag";
    private static final String ADDRESSLIST_HTML = "redirect:/order/addresslist.html";
    @Resource(name="expressConfBizImpl")
    private IExpressConfBiz iExpressConfBiz;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="customerAddressService")
    private CustomerAddressService addressService;
    @Resource(name="DeliveryPointService")
    private DeliveryPointService deliveryPointService;

    @RequestMapping(value={"/addresslist"})
    public ModelAndView queryOrderAddressList(HttpServletRequest request, String flag, OrderInfoSession orderInfoSession) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if (orderInfoSession != null && orderInfoSession.getSubTag() != null) {
                    request.getSession().setAttribute("orderInfo", (Object)orderInfoSession);
                }
                List addresses = this.addressService.queryCustomerAddress(customerId);
                if (flag != null && "1".equals(flag)) {
                    mav.addObject("addresses", (Object)addresses);
                    mav.setViewName("order/address_list");
                } else {
                    mav.addObject("addresses", (Object)addresses);
                    mav.setViewName("mobileNew/my_account_address_listNew");
                }
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6536\u83b7\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/showAddressPage"})
    public ModelAndView showAddressPage(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        try {
            if (LoginUtil.checkLoginStatus(req)) {
                mav.setViewName("/order/my_account_address_add");
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6536\u83b7\u5730\u5740\u70b9\u51fb\u65b0\u589e\uff0c\u8df3\u8f6c\u65b0\u589e\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/updateAddressPage"})
    public ModelAndView updateAddressPage(HttpServletRequest request, Long addressId) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                CustomerAddress orderaddress = this.addressService.queryCustomerAddressById(addressId, customerId);
                mav.addObject("orderaddress", (Object)orderaddress);
                mav.setViewName("/order/my_account_address_edit");
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6536\u83b7\u5730\u5740\uff0c\u70b9\u51fb\u7f16\u8f91\uff0c\u8df3\u8f6c\u7f16\u8f91\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/changeAddress"})
    public ModelAndView changeAddress(HttpServletRequest request, Long addressId) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId != null) {
                CustomerAddress address = new CustomerAddress();
                address.setAddressId(addressId);
                address.setCustomerId(customerId);
                address.setIsDefault("1");
                this.addressService.updateAddressDef(customerId);
                this.addressService.updateAddress(address, customerId);
                if (request.getSession().getAttribute("box") == null) {
                    mav.setView((View)new RedirectView("customercenter.html"));
                } else {
                    mav.setView((View)new RedirectView("suborder.htm?addressId=" + addressId));
                }
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u66f4\u6539\u8ba2\u5355\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/querydelivery"})
    public ModelAndView queryDelivery(HttpServletRequest request, Long districtId, Long cityId, Long provinceId, Long[] box) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.addObject("delivery", (Object)this.deliveryPointService.selectDeliveryPointByDistrictIdForSite(districtId));
            mav.addObject("districtId", (Object)districtId);
            mav.addObject("cityId", (Object)cityId);
            mav.addObject("Province", (Object)provinceId);
            mav.addObject("box", (Object)box);
            mav.setViewName("/order/instead_address");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5730\u533aid\u67e5\u8be2\u81ea\u63d0\u70b9\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"toAddAddress"})
    public ModelAndView toAddAddress(HttpServletRequest request, String flag) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.addObject(FLAG, (Object)flag);
            mav.setViewName("order/my_account_address_add");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8fd4\u56de\u65b0\u589e\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/queryAllExpress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryAllExpress() {
        HashMap<String, Object> resultMap = new HashMap();
        try {
            resultMap = this.iExpressConfBiz.queryAllExpress();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(" \u67e5\u8be2\u6240\u6709\u7684\u914d\u9001\u65b9\u5f0f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/orderfilladdress"})
    public ModelAndView orderFillAddress(HttpServletRequest request, Long addressId, Long[] box) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if (addressId == null) {
                    mav.addObject("box", (Object)box);
                    mav.addObject(ADDRESSID, (Object)0);
                    mav.setViewName("order/filladdress");
                } else {
                    mav.addObject("box", (Object)box);
                    mav.addObject(ADDRESSID, (Object)addressId);
                    mav.addObject("addr", (Object)this.addressService.queryCustomerAddressById(addressId, customerId));
                    mav.setViewName("order/filladdress");
                }
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(" \u6839\u636e\u5730\u5740\u7f16\u53f7\u67e5\u627e\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/orderupdateaddress"})
    public ModelAndView orderUpdateAddress(HttpServletRequest request, CustomerAddress address, String flag) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Long addressId = address.getAddressId();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if ("1".equals(address.getIsDefault())) {
                    CustomerAddress customerAddress = this.addressService.queryCustomerAddressById(addressId, customerId);
                    if ("0".equals(customerAddress.getIsDefault())) {
                        this.addressService.updateAddressDef(customerId);
                        this.addressService.updateAddress(address, customerId);
                        mav.addObject(FLAG, (Object)flag);
                        mav.addObject(ADDRESSID, (Object)address.getAddressId());
                        mav.setViewName(ADDRESSLIST_HTML);
                        return this.seoService.getCurrSeo(mav);
                    }
                    this.addressService.updateAddress(address, customerId);
                    mav.addObject(FLAG, (Object)flag);
                    mav.addObject(ADDRESSID, (Object)address.getAddressId());
                    mav.setViewName(ADDRESSLIST_HTML);
                    return this.seoService.getCurrSeo(mav);
                }
                this.addressService.updateAddress(address, customerId);
                mav.addObject(FLAG, (Object)flag);
                mav.addObject(ADDRESSID, (Object)address.getAddressId());
                mav.setViewName(ADDRESSLIST_HTML);
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(" \u4fee\u6539\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"toupdateAddress"})
    public ModelAndView toupdateAddress(HttpServletRequest request, Long addressId, String flag) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId != null) {
                CustomerAddress address = this.addressService.queryCustomerAddressById(addressId, customerId);
                mav.addObject("orderaddress", (Object)address);
                mav.addObject(FLAG, (Object)flag);
                mav.setViewName("order/my_account_address_edit");
            } else {
                mav.addObject("url", (Object)"/customercenter.html");
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53bb\u4fee\u6539\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/delAddress"})
    public ModelAndView delAddress(HttpServletRequest request, Long addressId, String flag) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId != null) {
                this.addressService.deleteAddressById(addressId);
                return new ModelAndView(ADDRESSLIST_HTML).addObject(FLAG, (Object)flag);
            }
            return this.seoService.getCurrSeo(new ModelAndView("redirect:/loginm.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u6536\u83b7\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return this.seoService.getCurrSeo(mav);
        }
    }

    @RequestMapping(value={"/orderaddaddress"})
    public ModelAndView orderAddAddress(HttpServletRequest request, CustomerAddress address, Long[] box, Long addressId, String flag) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if ("1".equals(address.getIsDefault())) {
                    List addresses = this.addressService.queryCustomerAddress(customerId);
                    for (Object object : addresses) {
                        CustomerAddress addr = new CustomerAddress();
                        addr = (CustomerAddress)JSON.parseObject((String)JSON.toJSONString(object), CustomerAddress.class);
                        addr.setIsDefault("0");
                        this.addressService.updateAddress(addr, customerId);
                    }
                }
                this.addressService.addAddress(address, customerId);
                mav.addObject(FLAG, (Object)flag);
                mav.addObject(ADDRESSID, (Object)addressId);
                mav.addObject("box", (Object)box);
                mav.setViewName(ADDRESSLIST_HTML);
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/bdmap"})
    public ModelAndView bdMap(HttpServletRequest request, String address) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.addObject("ad", (Object)address);
            mav.setViewName("/order/map");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/updateDefaultAddress"})
    public ModelAndView updateDefaultAddress(HttpServletRequest request, Long addressId, String flag) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                this.addressService.updateAddressDef(customerId);
                this.addressService.updateAddressById(addressId);
                mav.addObject(ADDRESSID, (Object)addressId);
                mav.addObject(FLAG, (Object)flag);
                mav.setViewName(ADDRESSLIST_HTML);
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6536\u83b7\u5730\u5740\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740\u5931\u8d25");
        }
        return this.seoService.getCurrSeo(mav);
    }
}

