/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.alipay;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.PayService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.alipay.AlipayRequestDatas;
import com.qianjiang.wap.alipay.PubllicRequestParamter;
import com.qianjiang.wap.alipay.RequestDatas;
import com.qianjiang.wap.alipay.ResponseDatas;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlipayUtils {
    private static final MyLogger logger = new MyLogger(AlipayUtils.class);
    private static AlipayClient alipayClients = null;
    @Autowired
    private PayService payService;
    private static AlipayUtils alipayUtils;

    @PostConstruct
    public void init() {
        alipayUtils = this;
        AlipayUtils.alipayUtils.payService = this.payService;
        try {
            this.initAlipayClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initAlipayClient() throws Exception {
        logger.info((Object)"\u5f00\u59cb\u521d\u59cb\u5316\u652f\u4ed8\u5b9dAlipayClient");
        Pay pay = AlipayUtils.alipayUtils.payService.selectPayByType("1");
        if (pay == null) {
            throw new Exception("\u652f\u4ed8\u5b9d\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PubllicRequestParamter.setAPPID(pay.getApiKey());
        PubllicRequestParamter.setPUBLIC_KEY(pay.getSecretKey());
        PubllicRequestParamter.setSELLER_ID(pay.getPartner());
        alipayClients = new DefaultAlipayClient("https://openapi.alipaydev.com/gateway.do", PubllicRequestParamter.getAPPID(), PubllicRequestParamter.PRIVATE_KEY, "JSON", "utf-8", PubllicRequestParamter.getPUBLIC_KEY(), "RSA2");
        logger.info((Object)"\u7ed3\u675f\u521d\u59cb\u5316\u652f\u4ed8\u5b9dAlipayClient");
    }

    public static AlipayClient getAlipayClient() throws Exception {
        if (alipayClients == null) {
            alipayUtils.initAlipayClient();
        }
        return alipayClients;
    }

    public static ResponseDatas AlipayExecute(RequestDatas requestData) {
        ResponseDatas result = new ResponseDatas();
        try {
            AlipayClient alipayClient = AlipayUtils.getAlipayClient();
            AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
            request.setBizContent(requestData.getzContent());
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                result.setSuccess(true);
            }
            result.setCode(response.getCode());
            result.setMessage(response.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u652f\u4ed8\u5b9d\u9000\u6b3e\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        return result;
    }

    public static String aliPayPostExecute(AlipayRequestDatas requestDatas) throws Exception {
        AlipayClient alipayClient = AlipayUtils.getAlipayClient();
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setReturnUrl(requestDatas.getReturnUrl());
        alipayRequest.setNotifyUrl(requestDatas.getNotifyUrl());
        alipayRequest.setBizContent(requestDatas.getBizContent());
        String form = ((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody();
        return form;
    }

    public static boolean rsaCheckV1(Map<String, String> paramsMap) {
        boolean signVerified = false;
        try {
            if (alipayClients == null) {
                alipayUtils.initAlipayClient();
            }
            signVerified = AlipaySignature.rsaCheckV1(paramsMap, (String)PubllicRequestParamter.getPUBLIC_KEY(), (String)"utf-8", (String)"RSA2");
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        return signVerified;
    }
}

