/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.customer.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.service.BrowserecordService;
import com.qianjiang.customer.service.CustomerFollowService;
import com.qianjiang.customer.service.CustomerOrderService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.GuessLikeGoodsService;
import com.qianjiang.customer.service.InsideLetterServiceMapper;
import com.qianjiang.customer.service.OrderNoticeService;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.orderrepaircost.service.RepairCostService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.wap.customer.vo.CustomerFollowVo;
import com.qianjiang.wap.util.LoginUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CustomerControllerM {
    private static final MyLogger LOGGER = new MyLogger(CustomerControllerM.class);
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="customerFollowService")
    private CustomerFollowService customerFollowService;
    @Resource(name="repairCostService")
    private RepairCostService repairCostService;
    @Resource(name="browserecordService")
    private BrowserecordService browserecordService;
    @Resource(name="insideLetterServiceMapper")
    private InsideLetterServiceMapper insideLetterServiceMapper;
    @Resource(name="orderNoticeService")
    private OrderNoticeService orderNoticeService;
    @Resource(name="guessLikeGoodsService")
    private GuessLikeGoodsService guessLikeGoodsService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductMapper;
    @Resource(name="customerOrderService")
    private CustomerOrderService customerOrderService;
    @Resource(name="ReturnGoodsService")
    private ReturnGoodsService returnGoodsService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Autowired
    private GoodsProductService goodsProductService;
    private static final String URLREDIRECT = "redirect:/loginm.html?url=/myaccount.html";
    private static final String RULMYACCOUNT = "redirect:/myaccount.html";
    private static final String CUSTOMER = "customer";

    @RequestMapping(value={"/customercenter"})
    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                request.getSession().setAttribute("cust", (Object)this.customerService.selectByPrimaryKey(customerId));
                Long myCollectionCount = this.customerFollowService.myCollectionsCount(customerId);
                Long browereCount = this.browserecordService.browereCount(customerId);
                Long insideLetterCount = this.insideLetterServiceMapper.getIsNotReadCount(customerId);
                Long orderNoticeCount = this.orderNoticeService.getIsNotReadCount(customerId);
                List guessLikes = (List)JSON.parseObject((String)JSON.toJSONString((Object)this.guessLikeGoodsService.guessLikeGoodsList(customerId)), List.class);
                int noMoneyCount = this.customerOrderService.queryNoMoneyOrderCount("", "1", customerId);
                int noFaHuoCount = this.customerOrderService.queryNoShowHuoOrderCount("", "3", customerId);
                int noCommentCount = this.customerOrderService.queryNoCommentOrderCount("", "4", customerId);
                int cancelCount = this.returnGoodsService.queryCancleOrderCount(customerId);
                int countFans = this.customerService.countFans(customerId);
                response.setHeader("Cache-Control", "no-store");
                response.setDateHeader("Expires", 0L);
                response.setHeader("Pragma", "no-cache");
                if (!guessLikes.isEmpty()) {
                    resultMap.put("guessLikes", guessLikes);
                } else {
                    resultMap.put("guessLikes", this.goodsProductMapper.queryInfosOrderBySales(Long.valueOf(10L)));
                }
                resultMap.put("mycollectcount", myCollectionCount);
                resultMap.put("browereCount", browereCount);
                resultMap.put("xiaoxiCount", insideLetterCount + orderNoticeCount);
                resultMap.put("noMoneyCount", noMoneyCount);
                resultMap.put("noFaHuoCount", noFaHuoCount);
                resultMap.put("noCommentCount", noCommentCount);
                resultMap.put("cancelCount", cancelCount);
                resultMap.put("countFans", countFans);
                mav.addAllObjects(resultMap);
                mav.setViewName("member/main");
            } else {
                mav.setViewName("redirect:/loginm.html?url=/customercenter.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u8df3\u8f6c\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/sendcode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendcode(HttpServletRequest request, String mobile, String checkCode) throws IOException {
        String patchca = (String)request.getSession().getAttribute("PATCHCA");
        if (checkCode != null && checkCode.equals(patchca)) {
            request.getSession().removeAttribute("PATCHCA");
            Map reslutMap = this.customerService.sendPost(mobile, null, null);
            HttpSession session = request.getSession();
            session.setAttribute("userMobile", reslutMap.get("userMobile"));
            session.setAttribute("mcCode", reslutMap.get("mcCode"));
            return 1;
        }
        return 2;
    }

    @RequestMapping(value={"validate/getMCode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int getMCode(HttpServletRequest request, String code) throws IOException {
        String mcCode = (String)request.getSession().getAttribute("mcCode");
        return this.customerService.getMCode(mcCode, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/myaccount"})
    public ModelAndView myaccount(HttpServletRequest request) {
        ModelAndView mav = null;
        HashMap resultMap = new HashMap();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                request.getSession().setAttribute("cust", (Object)this.customerService.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
                mav = new ModelAndView("member/myaccountNew");
                mav.addAllObjects(resultMap);
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/editCustomerId"})
    public ModelAndView editCustomerId(HttpServletRequest request, CustomerAllInfo customers) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        try {
            mav = new ModelAndView(RULMYACCOUNT);
            if (LoginUtil.checkLoginStatus(request)) {
                Customer customer = new Customer();
                customer.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                if (StringUtils.isNotEmpty((String)customers.getCustomerNickname())) {
                    String customerNickName = new String(customers.getCustomerNickname().getBytes("utf-8"), "utf-8");
                    customer.setCustomerNickname(customerNickName);
                }
                customer.setCustomerImg(customers.getCustomerImg());
                this.customerService.updateCustomer(customer);
                CustomerAllInfo custInfo = new CustomerAllInfo();
                if (StringUtils.isNotEmpty((String)customers.getInfoGender())) {
                    custInfo.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                    custInfo.setInfoGender(customers.getInfoGender());
                    this.customerService.updateCustomerInfo(custInfo);
                }
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = new ModelAndView(RULMYACCOUNT);
        }
    }

    @RequestMapping(value={"aboutUs"})
    public ModelAndView aboutUs(HttpServletRequest request) throws IOException {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("mobileNew/aboutUs");
        return mav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/changenickname"})
    public ModelAndView toChangeNickName(HttpServletRequest request) {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                mav = new ModelAndView("member/changename");
                mav.addObject(CUSTOMER, (Object)this.customerService.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/savenickname"})
    public ModelAndView saveNickName(HttpServletRequest request, Customer customers) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                Customer customer = new Customer();
                customer.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                customer.setCustomerNickname(customers.getCustomerNickname());
                this.customerService.updateCustomer(customer);
                mav = new ModelAndView(RULMYACCOUNT);
                customer = null;
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/changename"})
    public ModelAndView toChangeName(HttpServletRequest request) {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                mav = new ModelAndView("member/changename2");
                mav.addObject(CUSTOMER, (Object)this.customerService.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/savename"})
    public ModelAndView saveName(HttpServletRequest request, CustomerAllInfo customers) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                CustomerAllInfo customer = new CustomerAllInfo();
                customer.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                customer.setInfoRealname(customers.getInfoRealname());
                this.customerService.updateCustomerInfo(customer);
                mav = new ModelAndView(RULMYACCOUNT);
                customer = null;
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/myintegral"})
    public ModelAndView queryCustomerPoint(HttpServletRequest request, PageBean pb, Long date, String type) {
        pb.setUrl("1".equals(date.toString()) ? "customer/myintegral" : "customer/myintegral-" + date);
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            CustomerAllInfo customerAllInfo = (CustomerAllInfo)request.getSession().getAttribute("cust");
            customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "")));
            int pointNumber = 0;
            for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
                String[] points = level.getPointNeed().split("~");
                if (Integer.valueOf(points[0]) > customerAllInfo.getInfoPointSum() || customerAllInfo.getInfoPointSum() > Integer.valueOf(points[1])) continue;
                customerAllInfo.setPointLevelName(level.getPointLevelName());
                customerAllInfo.setPointLevelId(level.getPointLevelId());
                pointNumber = Integer.valueOf(points[1]) - customerAllInfo.getInfoPointSum() + 1;
            }
            return new ModelAndView("customer/integral").addObject("pb", (Object)this.customerService.selectAllCustomerPoint(customerId, pb, date, type)).addObject(CUSTOMER, (Object)customerAllInfo).addObject("date", (Object)date).addObject("pointNumber", (Object)pointNumber).addObject("type", (Object)type).addObject("pointLevels", (Object)this.customerPointServiceMapper.getAllCustomerPointLevelSort());
        }
        return new ModelAndView("redirect:/loginm.html");
    }

    @RequestMapping(value={"/myintegralDetailNew"})
    public ModelAndView myintegralDetailNew(HttpServletRequest request, PageBean pb, Long date, String type) {
        Long customerId = null;
        if (LoginUtil.checkLoginStatus(request)) {
            customerId = (Long)request.getSession().getAttribute("customerId");
        }
        return new ModelAndView("/mobileNew/integrationDetailsNew").addObject("pb", (Object)this.customerService.selectAllCustomerPoint(customerId, pb, date, type));
    }

    @RequestMapping(value={"/integralRuleNew"})
    public String integralRuleNew() {
        return "/mobileNew/integralRuleNew";
    }

    @RequestMapping(value={"/allmyintegral"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean allMyIntegral(HttpServletRequest request, PageBean pb, String type) {
        PageBean pbNew = pb;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            pbNew = this.customerService.selectAllCustomerPoint(customerId, pbNew, Long.valueOf(1L), type);
        }
        return pbNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/changegender"})
    public ModelAndView changeGender(HttpServletRequest request, String gender) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                CustomerAllInfo customer = new CustomerAllInfo();
                customer.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                customer.setInfoGender(gender);
                this.customerService.updateCustomerInfo(customer);
                mav = new ModelAndView(RULMYACCOUNT);
                customer = null;
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/phonevalidate1"})
    public ModelAndView phonevalidate1(HttpServletRequest request) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                mav = new ModelAndView("member/phonevalidate1");
                mav.addObject("custInfo", (Object)this.customerService.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/phonevalidate3"})
    public ModelAndView phonevalidate3(HttpServletRequest request) {
        ModelAndView mav = null;
        try {
            mav = LoginUtil.checkLoginStatus(request) ? new ModelAndView("member/phonevalidate3") : new ModelAndView(URLREDIRECT);
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/modifyMobile"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object modifyMobile(HttpServletRequest request, String mobile, String code) throws IOException {
        Object flag = 0;
        if (LoginUtil.checkLoginStatus(request)) {
            String mcCode = (String)request.getSession().getAttribute("mcCode");
            int isCode = this.customerService.getMCode(mcCode, code);
            if (isCode == 1) {
                CustomerAllInfo customer = new CustomerAllInfo();
                customer.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                customer.setInfoMobile((String)request.getSession().getAttribute("userMobile"));
                customer.setIsMobile("1");
                this.customerService.updateCustomerInfo(customer);
                customer = null;
                Customer customer2 = new Customer();
                customer2.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                customer2.setIsMobile("1");
                this.customerService.updateCustomer(customer2);
                customer2 = null;
                flag = "/myaccount.html";
            } else {
                flag = 2;
            }
        } else {
            flag = "/loginm.html?url=/myaccount.html";
        }
        return flag;
    }

    @RequestMapping(value={"/mycollections"})
    public ModelAndView myCollections(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            pb = this.customerFollowService.selectCustomerFollow(customerId, pb);
            List list = pb.getList();
            ArrayList<CustomerFollowVo> followList = new ArrayList<CustomerFollowVo>();
            for (int i = 0; i < list.size(); ++i) {
                CustomerFollowVo childCustomerFollow = (CustomerFollowVo)JSON.parseObject((String)JSON.toJSONString(list.get(i)), CustomerFollowVo.class);
                Long cateId = childCustomerFollow.getProduct().getGoods().getCatId();
                Long brandId = childCustomerFollow.getProduct().getGoods().getBrandId();
                Long goodsInfoId = childCustomerFollow.getGoodsId();
                List marketingList = this.marketingService.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
                if (marketingList.isEmpty()) {
                    childCustomerFollow.setCuxiaoFlag("0");
                } else {
                    childCustomerFollow.setCuxiaoFlag("1");
                }
                GoodsProduct goodsProduct = this.goodsProductService.selectHotGoodsById(goodsInfoId);
                if (goodsProduct.getHotFlag() == null) {
                    childCustomerFollow.setRexiaoFlag("0");
                } else if (goodsProduct.getHotFlag().equals("1")) {
                    childCustomerFollow.setRexiaoFlag("1");
                } else if (goodsProduct.getHotFlag().equals("0")) {
                    childCustomerFollow.setRexiaoFlag("0");
                }
                followList.add(childCustomerFollow);
            }
            pb.setList(followList);
            mav = new ModelAndView("customer/collections").addObject("pb", (Object)pb);
        } else {
            mav = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/ajaxcollection"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int ajaxcollection(HttpServletRequest request, Long productId) {
        int resultData = -1;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            resultData = this.customerFollowService.selectCUstFollowByCustIdAndProId(customerId, productId);
        }
        return resultData;
    }

    @RequestMapping(value={"/allmycollection"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean allMyCollections(HttpServletRequest request, PageBean pb) {
        PageBean pbNew = pb;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            pbNew = this.customerFollowService.selectCustomerFollow(customerId, pb);
        }
        return pbNew;
    }

    @RequestMapping(value={"/cancelcollection"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> cancelMyCollections(HttpServletRequest request, Long followId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int flag = 0;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            flag = this.customerFollowService.deleteFollow(followId, customerId);
            Long myCollectionCount = this.customerFollowService.myCollectionsCount((Long)request.getSession().getAttribute("customerId"));
            resultMap.put("flag", flag);
            resultMap.put("myCollectionCount", myCollectionCount);
        }
        return resultMap;
    }

    @RequestMapping(value={"/mybrowerecord"})
    public ModelAndView myBrowserecord(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            mav = new ModelAndView("customer/browserecord").addObject("pb", (Object)this.browserecordService.selectBrowserecord(customerId, pb));
        } else {
            mav = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/myFans"})
    public ModelAndView myFans(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            mav = new ModelAndView("customer/myfans").addObject("pageBean", (Object)this.customerService.listMyFans(customerId, pb));
        } else {
            mav = new ModelAndView("redirect:/loginm.html");
        }
        return mav;
    }

    @RequestMapping(value={"/allbrowerecord"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean allMyBrowerecord(HttpServletRequest request, PageBean pb) {
        PageBean pbNew = pb;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            pbNew = this.browserecordService.selectBrowserecord(customerId, pbNew);
        }
        return pbNew;
    }

    @RequestMapping(value={"/accountsafe"})
    public ModelAndView safe(HttpServletRequest request) {
        ModelAndView mav = null;
        mav = LoginUtil.checkLoginStatus(request) ? new ModelAndView("member/my_account_safe") : new ModelAndView(URLREDIRECT);
        return mav;
    }

    @RequestMapping(value={"/tochangepassword"})
    public ModelAndView tochangepassword(HttpServletRequest request) {
        ModelAndView mav = null;
        mav = LoginUtil.checkLoginStatus(request) ? new ModelAndView("mobileNew/my_account_change_password") : new ModelAndView(URLREDIRECT);
        return mav;
    }

    @RequestMapping(value={"/modifypassword"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object modifypassword(HttpServletRequest request, HttpServletResponse response, String password, String newPassword, String code) {
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            return this.customerService.modifyPassword(response, customerId.longValue(), password, newPassword);
        }
        return "/loginm.html?url=/myaccount.html";
    }

    @RequestMapping(value={"/tosafetips"})
    public ModelAndView tosafetips(HttpServletRequest request) {
        if (LoginUtil.checkLoginStatus(request)) {
            return new ModelAndView("member/my_account_safe_tips");
        }
        return new ModelAndView(URLREDIRECT);
    }

    @RequestMapping(value={"/phonevalidate4"})
    public ModelAndView phonevalidate4(HttpServletRequest request) {
        if (LoginUtil.checkLoginStatus(request)) {
            return new ModelAndView("member/phonevalidate4");
        }
        return new ModelAndView(URLREDIRECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/changeqq"})
    public ModelAndView toChangeQq(HttpServletRequest request) {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                mav = new ModelAndView("member/changeqq");
                mav.addObject(CUSTOMER, (Object)this.customerService.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/saveqq"})
    public ModelAndView saveQq(HttpServletRequest request, String changeQq) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                CustomerAllInfo customer = new CustomerAllInfo();
                customer.setCustomerId((Long)request.getSession().getAttribute("customerId"));
                customer.setInfoQq(changeQq);
                this.customerService.updateCustomerInfo(customer);
                mav = new ModelAndView(RULMYACCOUNT);
                customer = null;
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"validate/checkidentity"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkidentity(HttpServletRequest request, String valiCode, String password) throws IOException {
        if (LoginUtil.checkLoginStatus(request)) {
            String patchca = (String)request.getSession().getAttribute("PATCHCA");
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            return this.customerService.checkIdentity(patchca, customerId, valiCode, password);
        }
        return 0;
    }

    @RequestMapping(value={"delBrowserrcordByLikeId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONObject delBrowserrcordByLikeId(HttpServletRequest request, Long likeId) {
        JSONObject json = new JSONObject();
        Long custId = (Long)request.getSession().getAttribute("customerId");
        int status = this.browserecordService.deleteByPrimaryKey(likeId, custId);
        json.put("status", (Object)status);
        return json;
    }

    @RequestMapping(value={"/myShare"})
    public ModelAndView myShare(HttpServletRequest request) {
        ModelAndView mav = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            mav = new ModelAndView("customer/sharepage");
        } else {
            mav = new ModelAndView("redirect:/loginm.html");
        }
        return mav;
    }
}

