/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.customer.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.wap.util.LoginUtil;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CouponCustomerM {
    private static final MyLogger LOGGER = new MyLogger(CouponCustomerM.class);
    private static final String CUSTOMERID = "customerId";
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;

    @RequestMapping(value={"/customer/coupons"})
    public ModelAndView queryMyConpons(HttpServletRequest request, PageBean pageBean, String type) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        String typeNew = type;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if (typeNew == null || "".equals(typeNew)) {
                    typeNew = "1";
                }
                resultMap.put("pb", this.couponService.myCouponListM(customerId, typeNew));
                resultMap.put("status1", this.couponService.countByCodeStatus(customerId, "1"));
                resultMap.put("status2", this.couponService.countByCodeStatus(customerId, "2"));
                resultMap.put("status3", this.couponService.countByCodeStatus(customerId, "3"));
                resultMap.put("type", typeNew);
                mav.addAllObjects(resultMap);
                mav.setViewName("member/my_couponsNew");
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\uff1a\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u6211\u7684\u4f18\u60e0\u5238\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/getOffCouponMobile"})
    @ResponseBody
    public int getOffCoupon(HttpServletRequest request, Long couponId) {
        int couponResult = 0;
        Long cId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            Coupon coupon = this.couponService.searchCouponById(couponId);
            if (cId == null) {
                couponResult = 3;
            } else {
                int counts = this.couponNoService.selectReadyGet(couponId, cId);
                int countAll = this.couponNoService.selectCountAllByCouponId(couponId);
                if (counts < coupon.getCouponGetNo().intValue()) {
                    if (countAll - this.couponNoService.queryUsedCountByCouponId(couponId).intValue() > 0) {
                        int count;
                        CouponNo couponNo;
                        Date d = new Date();
                        couponResult = coupon.getCouponStartTime().before(d) && coupon.getCouponEndTime().after(d) ? ((couponNo = this.couponNoService.selectNoByCouponIdByStatus(couponId)) != null ? ((count = this.couponNoService.updateCouponCustomer(couponNo.getCodeId(), cId)) > 0 ? 1 : 2) : 3) : 2;
                    } else {
                        couponResult = 2;
                    }
                } else {
                    couponResult = 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u5546\u54c1\u8be6\u60c5\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return couponResult;
    }

    @RequestMapping(value={"/toaddcoupons"})
    public ModelAndView toaddcoupons(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                resultMap.put("flag", request.getParameter("flag"));
                resultMap.put("invoiceType", request.getParameter("invoiceType"));
                resultMap.put("invoiceTitle", request.getParameter("invoiceTitle"));
                resultMap.put("codeNo", request.getParameter("codeNo"));
                resultMap.put("customercon", (String)this.customerService.selectByPrimaryKey(customerId));
                mav.addAllObjects(resultMap);
                mav.setViewName("member/my_coupons_add");
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u4f1a\u5458\u4e2d\u5fc3\u8df3\u8f6c\u6dfb\u52a0\u4f18\u60e0\u5238\u5931\u8d25");
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/addcoupons"})
    @ResponseBody
    public Object addCoupons(HttpServletRequest request, String couponCode) {
        Object flag = LoginUtil.checkLoginStatus(request) ? Integer.valueOf(this.couponNoService.selectCouponByCode(couponCode, (Long)request.getSession().getAttribute(CUSTOMERID))) : "loginm.html?url=/customercenter.html";
        return flag;
    }
}

