/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.jewelry.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class JewelryBoxController {
    @Autowired
    private CustomerServiceMapper customerServiceMapper;
    @Autowired
    private BackOrderService backOrderService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private GoodsProductService goodsProductService;

    @RequestMapping(value={"/selectAllJewelry"})
    public ModelAndView selectAllJewelry(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mv = new ModelAndView();
        try {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            if (customerId == null) {
                mv.setViewName("mobileNew/JewelryBox");
            } else {
                CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey(customerId);
                BigDecimal orderPrice = this.orderService.countOrderPrice(customerId);
                List goodsProduct = this.goodsProductService.selectAllByCustomerId(customerId);
                mv.addObject("customerAllInfo", (Object)customerAllInfo);
                mv.addObject("orderPriceSum", (Object)orderPrice);
                mv.addObject("goodsProduct", (Object)goodsProduct);
                mv.setViewName("mobileNew/JewelryBox");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mv;
    }
}

