/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.login.controller;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.license.service.LicenseImportService;
import com.qianjiang.login.service.LoginService;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="loginControllerM")
public class LoginController {
    private static final MyLogger LOGGER = new MyLogger(LoginController.class);
    private static final String INDEX_HTML = "/customercenter.html";
    @Resource(name="loginServiceM")
    private LoginService loginService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="authService")
    private AuthService authService;
    @Resource(name="licenseImportService")
    public LicenseImportService licenseImportService;

    @RequestMapping(value={"/customerm/login"})
    public ModelAndView login(HttpServletRequest request, HttpServletResponse response, String url) {
        ModelAndView mav = new ModelAndView();
        String urlEmp = url;
        try {
            String preUrl = request.getHeader("Referer");
            if (urlEmp != null && (urlEmp.indexOf("customercenter") != -1 || urlEmp.indexOf("myorder") != -1)) {
                preUrl = null;
            }
            if (preUrl != null) {
                String strRegex = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([0-9a-z][0-9a-z-]{0,61}))(:[0-9]{1,5})?" + request.getContextPath() + "/";
                urlEmp = preUrl.replaceFirst(strRegex, "");
            } else {
                preUrl = (String)request.getSession().getAttribute("preferUrl");
                if (urlEmp != null && urlEmp.indexOf("customercenter") != -1) {
                    preUrl = null;
                    urlEmp = request.getContextPath() + urlEmp;
                }
                preUrl = preUrl == null ? urlEmp : preUrl;
                urlEmp = preUrl != null ? preUrl : request.getContextPath() + INDEX_HTML;
            }
            if (urlEmp.indexOf("register") != -1 || urlEmp.indexOf("success") != -1 || urlEmp.length() == 0 || urlEmp.indexOf("updatesucess") != -1) {
                urlEmp = request.getContextPath() + INDEX_HTML;
            }
            if (urlEmp.indexOf("validateidentity") != -1 || urlEmp.indexOf("reirectpem") != -1) {
                urlEmp = "customer/securitycenter.html";
            }
            if (urlEmp.indexOf(".html") == -1 && urlEmp.indexOf(".htm") == -1) {
                urlEmp = urlEmp + ".html";
            }
            if (urlEmp.indexOf("valididentity") != -1) {
                urlEmp = request.getContextPath() + INDEX_HTML;
            }
            if (urlEmp.indexOf("myorder") != -1) {
                urlEmp = request.getContextPath() + urlEmp;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            List findByShow = this.authService.findByShow();
            resultMap.put("t", findByShow);
            this.setResultMap(request, resultMap, urlEmp);
            mav.addAllObjects(resultMap);
            request.getSession().setAttribute("urlEmp", (Object)urlEmp);
            mav = this.loginService.checkCookie(request, response, urlEmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("mobile\u7aef\u8df3\u8f6c\u767b\u5f55\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"customer/logout"})
    public ModelAndView loginOut(HttpServletRequest request, HttpServletResponse response, String url) {
        ModelAndView mav = new ModelAndView();
        String urlNew = url;
        try {
            if (urlNew == null) {
                urlNew = INDEX_HTML;
            }
            request.getSession().removeAttribute("cust");
            request.getSession().removeAttribute("url");
            request.getSession().removeAttribute("customerId");
            request.getSession().removeAttribute("isThirdLogin");
            Cookie cookieName = new Cookie("_mall_newMobile_username", null);
            Cookie cookiePassword = new Cookie("_mall_newMobile_password", null);
            cookieName.setMaxAge(-1);
            cookieName.setPath("/");
            cookiePassword.setMaxAge(-1);
            cookiePassword.setPath("/");
            response.addCookie(cookieName);
            response.addCookie(cookiePassword);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            List findByShow = this.authService.findByShow();
            resultMap.put("t", findByShow);
            this.setResultMap(request, resultMap, urlNew);
            mav.addAllObjects(resultMap);
            mav.setView((View)new RedirectView(request.getContextPath() + "/loginm.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u9000\u51fa\u8df3\u8f6c\u767b\u5f55\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/checklogin"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONObject checkLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, String url, String code) {
        Object result = null;
        JSONObject json = new JSONObject();
        try {
            if (request.getSession().getAttribute("urlEmp") != null) {
                url = (String)request.getSession().getAttribute("urlEmp");
            }
            if (username == null || password == null) {
                result = -10024;
                json.put("result", (Object)-10024);
                return json;
            }
            String flag = this.licenseImportService.isQualified("user");
            int status = this.loginService.checkCustomerExists(request, response, username, password, code);
            if (status == 1) {
                result = url;
                json.put("result", (Object)url);
                return json;
            }
            result = status;
            json.put("result", (Object)status);
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return json;
        }
    }

    @RequestMapping(value={"/getXieYi"})
    public ModelAndView getXieYi() {
        HashMap<String, BasicSet> topmap = new HashMap<String, BasicSet>();
        topmap.put("systembase", this.basicSetService.findBasicSet());
        return new ModelAndView("/login/xieyi").addObject("topmap", topmap);
    }

    public void setResultMap(HttpServletRequest request, Map<String, Object> resultMap, String url) {
        String username = "";
        Cookie[] cookies = request.getCookies();
        try {
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (cookie == null || !"_mall_username".equals(cookie.getName())) continue;
                    username = URLDecoder.decode(cookie.getValue(), "utf-8");
                    break;
                }
            }
            resultMap.put("username", username);
            resultMap.put("url", url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

