/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.util;

import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.goods.vo.GoodsSiteSearchBean;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="CateCacheUtil")
public class CateCacheUtil {
    private static List<GoodsCate> rootCates = null;
    private static Map<Long, List<GoodsCate>> childSecendCate = new HashMap<Long, List<GoodsCate>>();
    private static Map<String, PageBean> goodsMap = new HashMap<String, PageBean>();
    private static Map<String, Date> lastUpdate = new HashMap<String, Date>();
    private static long INTERVAR_TIME = 900000L;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;

    public List<GoodsCate> getRootCate() {
        List<GoodsCate> cates = rootCates;
        if (cates == null || lastUpdate.get("rootCates") != null && new Date().getTime() - lastUpdate.get("rootCates").getTime() > INTERVAR_TIME) {
            rootCates = this.goodsCateService.querySonCateByParentId(new Long(0L));
            cates = rootCates;
            lastUpdate.put("rootCates", new Date());
        }
        return cates;
    }

    public List<GoodsCate> getSecendChildCates(Long cateId) {
        List secondLists = childSecendCate.get(cateId);
        if (secondLists == null || lastUpdate.get("childSecendCate_" + cateId) != null && new Date().getTime() - lastUpdate.get("childSecendCate_" + cateId).getTime() > INTERVAR_TIME) {
            secondLists = this.goodsCateService.querySonCateByParentId(cateId);
            childSecendCate.put(cateId, secondLists);
            lastUpdate.put("childSecendCate_" + cateId, new Date());
        }
        return secondLists;
    }

    public Map<String, Object> queryCateGoods(SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, Long catId, Long distinctId) {
        return this.goodsService.searchGoods2(pb, searchBean, catId, distinctId);
    }

    public Map<String, Object> queryCateGoods(SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, Long cateId, Long distinctId, String sort) {
        return this.goodsService.searchGoodsForSort(pb, searchBean, cateId, distinctId, sort);
    }

    public Map<String, Object> queryCateGoods(SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, Long cateId, Long distinctId, String sort, Long caizhiMix, Long categoryMix, Long colorMix, String minPrice, String maxPrice) {
        return this.goodsService.searchGoodsForSortAndScreen(pb, searchBean, cateId, distinctId, sort, caizhiMix, categoryMix, colorMix, minPrice, maxPrice);
    }
}

