/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.deposit.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.util.PageBean;
import com.qianjiang.wap.util.LoginUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DepositTradeController {
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="tradeInfoServiceImpl")
    private TradeInfoService tradeInfoService;

    @RequestMapping(value={"/customerTradeInfo"})
    public ModelAndView customerTradeInfo(HttpServletRequest request, HttpServletResponse response, PageBean pageBean, String type) {
        ModelAndView mav = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            map.put("customerId", customerId);
            mav = new ModelAndView("customer/tradeinfo").addObject("pb", (Object)this.tradeInfoService.queryTradeInfo(pageBean, map));
        } else {
            mav = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/getCustomerTradeInfo"})
    @ResponseBody
    public Map<String, Object> getCustomerTradeInfo(HttpServletRequest request, HttpServletResponse response, PageBean pageBean, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            map.put("customerId", customerId);
            map.put("pb", this.tradeInfoService.queryTradeInfo(pageBean, map));
        }
        return map;
    }

    @RequestMapping(value={"/towithdrawrecords"})
    public ModelAndView customerWithdrawTradeInfo(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = null;
        mav = LoginUtil.checkLoginStatus(request) ? new ModelAndView("member/cashrecords") : new ModelAndView("redirect:/loginm.html");
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/getwithdrawrecords"})
    @ResponseBody
    public Map<String, Object> getCustomerWithdrawTradeInfo(HttpServletRequest request, HttpServletResponse response, PageBean pageBean, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            map.put("customerId", customerId);
            map.put("pb", this.tradeInfoService.queryWithdraw(pageBean, map));
        }
        return map;
    }

    @RequestMapping(value={"/towtradeinfodetail"})
    public ModelAndView withdrawTradeInfoDetail(HttpServletRequest request, HttpServletResponse response, Long tradeId) {
        ModelAndView mav = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            mav = new ModelAndView("member/cashrecords_detail").addObject("tradeDetail", (Object)this.tradeInfoService.queryByIdAndCusId(tradeId, customerId));
        } else {
            mav = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/updatetradeinfostatus"})
    @ResponseBody
    public boolean updateTradeInfoStatus(HttpServletRequest request, Long tradeInfoId, String type) {
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            return this.tradeInfoService.updateTradeInfoStatus(customerId, tradeInfoId, type);
        }
        return false;
    }
}

