/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.catelist.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.goods.vo.GoodsSiteSearchBean;
import com.qianjiang.mobile.bean.MobCateBar;
import com.qianjiang.mobile.service.MobCateBarService;
import com.qianjiang.mobile.vo.MobCateBarVo;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.address.service.ShoppingCartAddressService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.util.CateCacheUtil;
import com.qianjiang.wap.util.CateCashUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CateListController {
    private static final MyLogger LOGGER = new MyLogger(CateListController.class);
    @Resource(name="MobCateBarService")
    private MobCateBarService mobCateBarService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="CateCashUtil")
    private CateCashUtil cateCashUtil;
    @Resource(name="CateCacheUtil")
    private CateCacheUtil cateCacheUtil;
    @Autowired
    private ShoppingCartAddressService shoppingCartAddressService;

    @RequestMapping(value={"/queryMobCateBar"})
    public ModelAndView queryMobCateBar(HttpServletRequest request, SearchPageBean<SolrGoodsInfo> pb, Long cateBarId, Long secondCateBarId) {
        ModelAndView mav = new ModelAndView();
        String px = request.getParameter("px");
        if (StringUtils.isEmpty((String)px)) {
            px = "0";
        }
        pb.setPageSize(20);
        try {
            List<MobCateBar> cates = this.cateCashUtil.queryRootCates();
            if (cateBarId == null) {
                cateBarId = cates.get(0).getCateBarId();
            }
            List<MobCateBarVo> secondLists = this.cateCashUtil.querySecondMobCateBar(cateBarId);
            if (secondCateBarId == null && secondLists != null && secondLists.size() > 0) {
                secondCateBarId = secondLists.get(0).getCateBarId();
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            GoodsSiteSearchBean searchBean = new GoodsSiteSearchBean();
            Long catId = null;
            Map<String, Object> resultMap = null;
            if (secondCateBarId == null) {
                MobCateBar oneCateBar = this.mobCateBarService.selectMobcateBarById(cateBarId);
                if (oneCateBar != null) {
                    catId = oneCateBar.getCateId();
                    resultMap = this.cateCacheUtil.queryCateGoods(pb, searchBean, catId, distinctId);
                }
            } else {
                MobCateBar twoCateBar = this.mobCateBarService.selectMobcateBarById(secondCateBarId);
                if (twoCateBar != null) {
                    catId = twoCateBar.getCateId();
                    resultMap = this.cateCacheUtil.queryCateGoods(pb, searchBean, catId, distinctId);
                }
            }
            mav.addObject("cates", cates);
            mav.addObject("secondLists", secondLists);
            mav.addObject("cateBarId", (Object)cateBarId);
            mav.addObject("secondCateBarId", (Object)secondCateBarId);
            mav.addObject("resultMap", resultMap);
            if (resultMap != null && resultMap.get("pb") != null && (Integer)resultMap.get("dataNum") > 0) {
                mav.addObject("dataNum", (Object)((Integer)resultMap.get("dataNum")));
            } else {
                mav.addObject("dataNum", (Object)0);
            }
            mav.addObject("px", (Object)px);
            mav.setViewName("mobileNew/cates");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }
}

