/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.customer.controller;

import com.qianjiang.customer.service.InsideLetterServiceMapper;
import com.qianjiang.customer.service.OrderNoticeService;
import com.qianjiang.customer.vo.InsideLetterVo;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsideLettersController {
    private InsideLetterServiceMapper insideLetterService;
    @Resource(name="orderNoticeService")
    private OrderNoticeService orderNoticeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/adminnotice"})
    public ModelAndView showInsideLetter(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = null;
        pb.setUrl("/adminnotice");
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        try {
            if (this.checkLoginStatus(request)) {
                resultMap.put("receiveCustomerId", (Long)request.getSession().getAttribute("customerId"));
                mav = new ModelAndView("member/notice1").addObject("pb", (Object)this.insideLetterService.queryInsideLetters(resultMap));
            } else {
                mav = new ModelAndView("redirect:/loginm.html").addObject("url", (Object)"/adminnotice.html");
            }
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/readletterm"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int readedLetter(HttpServletRequest request, @Valid InsideLetterVo inside) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId != null) {
            HashMap<String, Long> resultMap = new HashMap<String, Long>();
            resultMap.put("customerId", customerId);
            resultMap.put("letterId", inside.getLetterId());
            int isRead = Integer.parseInt(this.insideLetterService.letterIsRead(resultMap) + "");
            if (isRead == 0) {
                inside.setCustomerId(customerId);
                return this.insideLetterService.readedLetter(inside);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/ordernotice"})
    public ModelAndView ordernotice(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = null;
        pb.setUrl("/ordernotice");
        try {
            mav = this.checkLoginStatus(request) ? new ModelAndView("member/notice2").addObject("pb", (Object)this.orderNoticeService.selectOrderNotices((Long)request.getSession().getAttribute("customerId"))) : new ModelAndView("redirect:/loginm.html").addObject("url", (Object)"/ordernotice.htm");
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/readnotice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object readnotice(HttpServletRequest request, Long noticeId) {
        if (this.checkLoginStatus(request)) {
            return this.orderNoticeService.readNotice(noticeId);
        }
        return "/loginm.html?url=/ordernotice.htm";
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute("cust") != null;
    }

    public InsideLetterServiceMapper getInsideLetterService() {
        return this.insideLetterService;
    }

    @Resource(name="insideLetterServiceMapper")
    public void setInsideLetterService(InsideLetterServiceMapper insideLetterService) {
        this.insideLetterService = insideLetterService;
    }
}

