/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.common.util;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.util.MyLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class GenerateLinkUtils {
    public static final MyLogger LOGGER = new MyLogger(GenerateLinkUtils.class);
    private static final String CHECK_CODE = "checkCode";

    private GenerateLinkUtils() {
    }

    public static String generateActivateLink(HttpServletRequest request, Customer user) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.lastIndexOf("/")) + "/validbindemail.html?" + CHECK_CODE + "=" + GenerateLinkUtils.generateCheckcode(user) + "&d=" + user.getCustomerId();
    }

    public static String generateFindPwdLink(HttpServletRequest request, Customer user) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.lastIndexOf("/")) + "/validpwdemail.html?" + CHECK_CODE + "=" + GenerateLinkUtils.generatePwdCheckcode(user) + "&d=" + user.getCustomerId();
    }

    public static String generateCheckEmailLink(HttpServletRequest request, Customer user) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.lastIndexOf("/")) + "/valididemail.html?" + CHECK_CODE + "=" + GenerateLinkUtils.generatePwdCheckcode(user) + "&type=" + request.getSession().getAttribute("utype") + "&d=" + user.getCustomerId();
    }

    public static String generateCheckcode(Customer user) {
        return GenerateLinkUtils.md5(String.valueOf(new Date().getTime()));
    }

    public static String generatePwdCheckcode(Customer user) {
        Date d = new Date();
        user.setPwdAeadTime(d);
        user.setPwdCaptcha(GenerateLinkUtils.md5(String.valueOf(d.getTime())));
        return user.getPwdCaptcha();
    }

    public static int verifyCheckcode(Customer user, ServletRequest request) {
        String checkCode = request.getParameter(CHECK_CODE);
        if (GenerateLinkUtils.generateCheckcode(user).equals(checkCode)) {
            return 1;
        }
        return 0;
    }

    public static String md5(String string) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("md5");
            md.update(string.getBytes());
            byte[] md5Bytes = md.digest();
            return GenerateLinkUtils.bytes2Hex(md5Bytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    private static String bytes2Hex(byte[] byteArray) {
        StringBuilder strBuf = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] >= 0 && byteArray[i] < 16) {
                strBuf.append("0");
            }
            strBuf.append(Integer.toHexString(byteArray[i] & 0xFF));
        }
        return strBuf.toString();
    }
}

