/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.push.controller;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.push.util.JPushUtil;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class JPushController {
    private static final MyLogger LOGGER = new MyLogger(JPushController.class);
    private static final String appKey = "83e6242fd1658bfb0d938a7f";
    private static final String masterSecret = "ba4fa1699ec9b7e2c24f598c";
    private static long timeToLive = 86400L;
    private static JPushClient jPushClient = null;

    @RequestMapping(value={"/sendPushAll"})
    public String sendPushAll(String msg) {
        jPushClient = new JPushClient(masterSecret, appKey);
        try {
            PushPayload payload = JPushUtil.buildPushObject_all_alias_alert("alias", msg);
            PushResult result = jPushClient.sendPush(payload);
            LOGGER.info((Object)("\u8fd4\u56de\u6570\u636e\uff1a" + result));
        }
        catch (APIConnectionException e) {
            LOGGER.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOGGER.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOGGER.info((Object)("HTTP Status: " + e.getStatus()));
            LOGGER.info((Object)("Error Code: " + e.getErrorCode()));
            LOGGER.info((Object)("Error Message: " + e.getErrorMessage()));
            LOGGER.info((Object)("Msg ID: " + e.getMsgId()));
        }
        return "success";
    }

    public boolean senPushByIosRegesterId(List<String> regeSterIds, String msgContent) {
        jPushClient = new JPushClient(masterSecret, appKey);
        boolean flag = false;
        try {
            PushPayload payload = JPushUtil.buildPushObject_all_ios_regesterIds(regeSterIds, msgContent);
            System.out.println("\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\uff1a" + payload.toString());
            PushResult result = jPushClient.sendPush(payload);
            if (null != result) {
                LOGGER.info((Object)("Get result ----" + result));
                flag = true;
            }
        }
        catch (APIConnectionException e) {
            LOGGER.error("Connection error. Should retry later. ", (Throwable)e);
            flag = false;
        }
        catch (APIRequestException e) {
            LOGGER.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOGGER.info((Object)("HTTP Status: " + e.getStatus()));
            LOGGER.info((Object)("Error Code: " + e.getErrorCode()));
            LOGGER.info((Object)("Error Message: " + e.getErrorMessage()));
            LOGGER.info((Object)("Msg ID: " + e.getMsgId()));
            flag = false;
        }
        return flag;
    }

    public int sendToAllIos(String notification_title, String msg_title, String msg_content, String extrasparam) {
        int result = 0;
        try {
            PushPayload pushPayload = JPushUtil.buildPushObject_ios_all_alertWithTitle(notification_title, msg_title, msg_content, extrasparam);
            System.out.println(pushPayload);
            PushResult pushResult = jPushClient.sendPush(pushPayload);
            System.out.println(pushResult);
            if (pushResult.getResponseCode() == 200) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int sendToRegistrationId(String registrationId, String notification_title, String msg_title, String msg_content, String extrasparam) {
        int result = 0;
        try {
            PushPayload pushPayload = JPushUtil.buildPushObject_all_registrationId_alertWithTitle(registrationId, notification_title, msg_title, msg_content, extrasparam);
            System.out.println(pushPayload);
            PushResult pushResult = jPushClient.sendPush(pushPayload);
            if (pushResult.getResponseCode() == 200) {
                result = 1;
            }
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        JPushController c = new JPushController();
        int result = JPushController.sendToRegistrationId("161a3797c8560196ced", "ios\u81ea\u5b9a\u4e49\u63a8\u9001\u901a\u77e5", "\u5085\u751f\u73e0\u5b9d", "\u60a8\u7684\u8ba2\u5355\u5df2\u7ecf\u4e0b\u5355\uff01", "");
        System.out.println(result);
    }
}

