/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.index.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.mobile.bean.MobCateBar;
import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.bean.MobStorey;
import com.qianjiang.mobile.service.MobAdverService;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.mobile.service.MobStoreyService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.bean.SeoConf;
import com.qianjiang.system.mobile.bean.MobSiteBasic;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.ISeoConfBiz;
import com.qianjiang.system.service.IStatisticsCodeBiz;
import com.qianjiang.temp.bean.TempToken;
import com.qianjiang.temp.service.TempTokenService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PropertieUtil;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import com.qianjiang.wap.index.vo.MainInfo;
import com.qianjiang.wap.index.vo.MobStoreyInfo;
import com.qianjiang.wap.util.CateCashUtil;
import com.qianjiang.wap.util.IndexStaticizeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Document;

@Controller
public class IndexSiteController {
    private static final MyLogger LOGGER = new MyLogger(IndexSiteController.class);
    private static final String TEMPLATE_PATH = PropertieUtil.readPropertiesFile((InputStream)IndexStaticizeUtil.class.getClassLoader().getResourceAsStream("config/config.properties")).getProperty("REAL_PATH");
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final Long STOREID = -1L;
    static final String xmlFilePath = "templete/xml/9gdemo.xml";
    static final String xslFilePath = "templete/xsl/9gdemo_save.xsl";
    static final String htmlFilePath = "view/main/9gdemo.html";
    private static final String MOBSITEBASIC = "mobSiteBasic";
    private static final String SITEPROJECTURL = "siteProjectUrl";
    private static final String SCODELIST = "sCodeList";
    private static final String MAIN_STORE = "/main/store";
    private static final String HOMEPAGETOKEN = "homePageToken";
    private static final String TOKEN = "token";
    private static final String VIEW_MAIN_STORE = "view/main/store";
    @Resource(name="MobAdverService")
    private MobAdverService mobAdverService;
    @Resource(name="MobStoreyService")
    private MobStoreyService mobStoreyService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="TempTokenService")
    private TempTokenService tokenService;
    @Resource(name="seoConfBizImpl")
    private ISeoConfBiz seoconfbiz;
    @Resource(name="statisticsCodeBizImpl")
    private IStatisticsCodeBiz statisticsCodeBizImpl;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;
    @Resource(name="CateCashUtil")
    private CateCashUtil cateCashUtil;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Autowired
    private BackOrderService BackOrderService;
    @Resource(name="customerService")
    private CustomerService customerService;

    @RequestMapping(value={"/thirdStoreIndex"})
    public ModelAndView thirdStoreIndex(HttpServletRequest request, Long storeId) {
        ModelAndView mav = new ModelAndView();
        try {
            String path = request.getContextPath();
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
            MobSiteBasic msb = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
            if ("1".equals(msb.getTemp2())) {
                String siteProjectUrl = this.basicSetService.findBasicSet().getBsetAddress();
                BasicSet basicSet = this.basicSetService.findBasicSet();
                this.checkFileExistsAndMkdirs(request, "store_main");
                int flag = this.showNewHomePage(request, storeId, null);
                mav.addObject(MOBSITEBASIC, (Object)msb);
                mav.addObject(SITEPROJECTURL, (Object)siteProjectUrl);
                mav.addObject("sys", (Object)basicSet);
                mav.addObject("flag", (Object)flag);
                mav.addObject("seo", (Object)this.getSeo());
                mav.setViewName(MAIN_STORE + STOREID + "/store_main");
            } else {
                this.checkChangeTemp();
                mav.setViewName("main/main");
            }
            List currStatisticsCode = this.statisticsCodeBizImpl.getCurrStatisticsCode();
            mav.addObject(SCODELIST, (Object)currStatisticsCode);
            mav.addObject("storeId", (Object)storeId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7b2c\u4e09\u65b9\u5e97\u94fa\u9996\u9875\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/initMain"})
    public ModelAndView initMain(HttpServletRequest request, HttpServletResponse resp) {
        Object customerId = request.getSession().getAttribute("customerId");
        List backOrderList = null;
        if (customerId != null && customerId != "") {
            backOrderList = this.BackOrderService.selectAllByCustomerId(Long.valueOf(Long.parseLong(customerId.toString())));
        }
        Long beginTime = System.currentTimeMillis();
        LOGGER.info((Object)("------initMain---begin--" + beginTime));
        ModelAndView mav = new ModelAndView();
        try {
            String px = request.getParameter("px");
            if (StringUtils.isEmpty((String)px)) {
                px = "0";
            }
            String path = request.getContextPath();
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
            MobSiteBasic msb = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
            if ("1".equals(msb.getTemp2())) {
                String siteProjectUrl = this.basicSetService.findBasicSet().getBsetAddress();
                BasicSet findBasicSet = this.basicSetService.findBasicSet();
                this.checkFileExistsAndMkdirs(request, "new_main");
                int flag = this.showNewHomePage(request, null, null);
                mav.addObject(MOBSITEBASIC, (Object)msb);
                mav.addObject(SITEPROJECTURL, (Object)siteProjectUrl);
                mav.addObject("sys", (Object)findBasicSet);
                mav.addObject("flag", (Object)flag);
                mav.addObject("seo", (Object)this.getSeo());
                mav.setViewName("main/new_main");
            } else {
                this.checkChangeTemp();
                mav.setViewName("main/main");
            }
            List<MobCateBar> cates = this.cateCashUtil.queryRootCates();
            LOGGER.info((Object)("------initMain---getRootCate--" + (System.currentTimeMillis() - beginTime)));
            List currStatisticsCode = this.statisticsCodeBizImpl.getCurrStatisticsCode();
            mav.addObject("lists", cates);
            mav.addObject(SCODELIST, (Object)currStatisticsCode);
            mav.addObject("px", (Object)px);
            mav.addObject("backOrderList", (Object)backOrderList);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("H5\u7aef\u9996\u9875\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/saveIosRegistrationId"})
    @ResponseBody
    public int saveIosRegistrationId(String iosRegistrationId, HttpServletRequest request) {
        LOGGER.info((Object)("ios\u8bbe\u5907id\u4e3a\uff1a" + iosRegistrationId));
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        int status = this.customerService.updateCustomerIosRegistrationId(customerId, iosRegistrationId);
        return 1;
    }

    @RequestMapping(value={"saveaddress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveAddress(String province, String city, String district, String street, String business, HttpServletRequest request, String streetNumber) {
        request.getSession().setAttribute("address", (Object)(province + "-" + city + "-" + district + "-" + street + "-" + business + "-" + streetNumber));
        return 0;
    }

    @RequestMapping(value={"/showHomePage"})
    public ModelAndView showHomePage(Long homePageId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            String path = request.getContextPath();
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
            MobSiteBasic msb = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
            String siteProjectUrl = this.basicSetService.findBasicSet().getBsetAddress();
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            List currStatisticsCode = this.statisticsCodeBizImpl.getCurrStatisticsCode();
            this.checkFileExistsAndMkdirs(request, "new_main");
            this.showNewHomePage(homePageId, request);
            mav.addObject(MOBSITEBASIC, (Object)msb);
            mav.addObject(SITEPROJECTURL, (Object)siteProjectUrl);
            mav.addObject("sys", (Object)findBasicSet);
            mav.addObject(SCODELIST, (Object)currStatisticsCode);
            mav.addObject("seo", (Object)this.getSeo());
            mav.setViewName("main/store" + STOREID + "/new_main");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u79fb\u52a8\u7aef\u9996\u9875\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    private void showNewHomePage(Long homePageId, HttpServletRequest request) {
        try {
            MobHomePage homePage = this.mobHomePageService.getHomePageById(homePageId);
            Document document = this.xmlUtil.str2Document(homePage.getDoc());
            String filePath = request.getSession().getServletContext().getRealPath("/");
            String htmlFileName = filePath + htmlFilePath;
            htmlFileName = htmlFileName.replace("/main", MAIN_STORE + STOREID);
            File file = new File(htmlFileName);
            if (file.exists()) {
                if (!this.checkHomePageToken(request, homePage)) {
                    String xmlFileName = xmlFilePath.replace(".xml", "_" + STOREID + ".xml");
                    String fileName = filePath + xmlFileName;
                    this.xmlUtil.createXml(fileName, document);
                    String xslFileName = filePath + xslFilePath;
                    this.xmlUtil.Transform(fileName, xslFileName, htmlFileName);
                }
            } else {
                String xmlFileName = xmlFilePath.replace(".xml", "_" + STOREID + ".xml");
                String fileName = filePath + xmlFileName;
                this.xmlUtil.createXml(fileName, document);
                String xslFileName = filePath + xslFilePath;
                this.xmlUtil.Transform(fileName, xslFileName, htmlFileName);
                ServletContext application = request.getSession().getServletContext();
                application.setAttribute(HOMEPAGETOKEN, (Object)homePage.getTemp1());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int showNewHomePage(HttpServletRequest request, Long storeId, Long pageId) {
        int result = 0;
        try {
            File file;
            MobHomePage homePage = null;
            if (storeId != null) {
                homePage = this.mobHomePageService.getCurrHomePageByStoreId(storeId);
                if (homePage == null) {
                    result = 1;
                    return result;
                }
            } else if (pageId != null) {
                homePage = this.mobHomePageService.getHomePageById(pageId);
                if (homePage == null) {
                    result = 1;
                    return result;
                }
            } else {
                homePage = this.mobHomePageService.getCurrHomePageByMerchantId(STOREID);
                if (homePage == null) {
                    result = 2;
                    return result;
                }
            }
            Document document = this.xmlUtil.str2Document(homePage.getDoc());
            String filePath = request.getSession().getServletContext().getRealPath("/");
            if (filePath == null) {
                filePath = TEMPLATE_PATH;
            }
            String htmlFileName = filePath + htmlFilePath;
            if (storeId != null) {
                htmlFileName = htmlFileName.replace("9gdemo", storeId + "_store");
            }
            if (pageId != null) {
                htmlFileName = htmlFileName.replace("9gdemo", pageId + "_page");
            }
            if ((file = new File(htmlFileName = htmlFileName.replace("/main", MAIN_STORE + STOREID))).exists()) {
                if (!this.checkHomePageToken(request, homePage)) {
                    String xmlFileName = xmlFilePath.replace(".xml", "_" + STOREID + ".xml");
                    String fileName = filePath + xmlFileName;
                    this.xmlUtil.createXml(fileName, document);
                    String xslFileName = filePath + xslFilePath;
                    this.xmlUtil.Transform(fileName, xslFileName, htmlFileName);
                    IndexStaticizeUtil.saveFileToContext("mobIndexHtml", htmlFileName);
                }
            } else {
                String xmlFileName = xmlFilePath.replace(".xml", "_" + STOREID + ".xml");
                String fileName = filePath + xmlFileName;
                this.xmlUtil.createXml(fileName, document);
                String xslFileName = filePath + xslFilePath;
                this.xmlUtil.Transform(fileName, xslFileName, htmlFileName);
                ServletContext application = request.getSession().getServletContext();
                application.setAttribute(HOMEPAGETOKEN, (Object)homePage.getTemp1());
                IndexStaticizeUtil.saveFileToContext("mobIndexHtml", htmlFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u663e\u793a\u65b0\u9996\u9875\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/toStaticizeIndex"})
    public ModelAndView toStaticizeIndex(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            this.staticizeIndex(request);
            mav.setView((View)new RedirectView("initMain.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    private List<MobStoreyInfo> initStorey() {
        ArrayList<MobStoreyInfo> storeyInfos = new ArrayList<MobStoreyInfo>();
        List storeys = this.mobStoreyService.selectMobStoreyForSite();
        for (MobStorey mobStorey : storeys) {
            MobStoreyInfo storeyInfo = new MobStoreyInfo();
            storeyInfo.setMobStorey(mobStorey);
            storeyInfo.setStoreyAdvers(this.mobAdverService.selectByStoreyIdForSite(mobStorey.getMobStoreyId()));
            storeyInfos.add(storeyInfo);
        }
        return storeyInfos;
    }

    private void checkChangeTemp() {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (this.checkToken(request)) {
                String indexHtmlPath = request.getRealPath("/") + "view/main/main.html";
                File indexHtml = new File(indexHtmlPath);
                if (!indexHtml.exists()) {
                    this.staticizeIndex(request);
                }
            } else {
                this.staticizeIndex(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u9759\u6001\u5316\u9996\u9875\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean checkToken(HttpServletRequest request) {
        boolean flag = true;
        ServletContext application = request.getSession().getServletContext();
        try {
            String token = (String)application.getAttribute(TOKEN);
            if (null == token || "".equals(token)) {
                TempToken tk = this.tokenService.selectTokenByType("2");
                if (null != tk) {
                    application.setAttribute(TOKEN, (Object)tk.getToken());
                } else {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update(new Date().toString().getBytes());
                    String tokenValue = new BigInteger(1, md.digest()).toString(16);
                    tk = new TempToken();
                    tk.setTemp1("2");
                    tk.setToken(tokenValue);
                    this.tokenService.createToken(tk);
                    application.setAttribute(TOKEN, (Object)tokenValue);
                    request.getSession().setAttribute("indexcount", (Object)0);
                }
                flag = false;
            } else {
                String tokenDatabase = this.tokenService.selectTokenByType("2").getToken();
                if (!token.equals(tokenDatabase)) {
                    flag = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u9a8c\u8bc1token\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    private Map<String, Object> getIndex() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            MainInfo mainInfo = new MainInfo();
            mainInfo.setBigMobAdvers(this.mobAdverService.selectByStoreyIdForSite(Long.valueOf(-1L)));
            List<MobStoreyInfo> storeyInfos = this.initStorey();
            mainInfo.setMobStoreyInfos(storeyInfos);
            map.put("mainInfo", mainInfo);
            String siteProjectUrl = this.basicSetService.findBasicSet().getBsetAddress();
            map.put(SITEPROJECTURL, siteProjectUrl);
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            map.put("request", request);
            map.put("seo", this.getSeo());
            map.put("sys", this.basicSetService.findBasicSet());
            String path = request.getContextPath();
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
            map.put(MOBSITEBASIC, this.mobSiteBasicService.selectCurrMobSiteBasic(basePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void staticizeIndex(HttpServletRequest request) {
        try {
            String templatePath = request.getRealPath("/") + "view/main";
            String templateName = "/main_ftl.ftl";
            String fileName = templatePath + "/main.html";
            Map<String, Object> indexmap = this.getIndex();
            IndexStaticizeUtil.analysisTemplate(templatePath, templateName, fileName, indexmap);
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u9759\u6001\u5934\u90e8\u9519\u8bef\uff1a=>", (Throwable)e);
        }
    }

    private SeoConf getSeo() {
        SeoConf seo = null;
        try {
            seo = this.seoconfbiz.querySeoByUsedStatus();
            if (null == seo) {
                seo = new SeoConf();
                String bsetName = this.basicSetService.findBasicSet().getBsetName();
                if (null != bsetName && !"".equals(bsetName)) {
                    seo.setMete(bsetName);
                } else {
                    seo.setMete("");
                }
                seo.setMeteKey("");
                seo.setMeteDes("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seo;
    }

    private void checkFileExistsAndMkdirs(HttpServletRequest request, String url) {
        try {
            String rootPath = request.getSession().getServletContext().getRealPath("/");
            if (rootPath == null) {
                rootPath = TEMPLATE_PATH;
            }
            File storeFilePath = new File(rootPath + VIEW_MAIN_STORE + STOREID);
            File storeFile = new File(rootPath + VIEW_MAIN_STORE + STOREID + "/" + url + ".ftl");
            if (!storeFile.exists()) {
                storeFilePath.mkdirs();
                String oldPath = rootPath + "view/main/" + url + ".ftl";
                String newPath = rootPath + VIEW_MAIN_STORE + STOREID + "/" + url + ".ftl";
                File oldfile = new File(rootPath + "view/main/" + url + ".ftl");
                if (oldfile.exists()) {
                    FileInputStream inStream = new FileInputStream(oldPath);
                    FileOutputStream fs = new FileOutputStream(newPath);
                    int bytesum = 0;
                    int byteread = 0;
                    byte[] buffer = new byte[2048];
                    while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                        bytesum += byteread;
                        fs.write(buffer, 0, byteread);
                    }
                    LOGGER.info((Object)(url + ".ftl\u6587\u4ef6\u5927\u5c0f=" + bytesum));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521b\u5efa\u7528\u6237\u9996\u9875\u6587\u4ef6\u5939\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean checkHomePageToken(HttpServletRequest request, MobHomePage homePage) {
        boolean flag = true;
        try {
            ServletContext application = request.getSession().getServletContext();
            String token = (String)application.getAttribute(HOMEPAGETOKEN);
            if (null == token || "".equals(token)) {
                String tk = homePage.getTemp1();
                if (null != tk) {
                    application.setAttribute(HOMEPAGETOKEN, (Object)tk);
                } else {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update(new Date().toString().getBytes());
                    String tokenValue = new BigInteger(1, md.digest()).toString(16);
                    application.setAttribute(HOMEPAGETOKEN, (Object)tokenValue);
                    homePage.setTemp1(tokenValue);
                    this.mobHomePageService.updateHomePage(homePage, (Long)request.getSession().getAttribute("loginUserId"));
                    request.getSession().setAttribute("indexcount", (Object)0);
                }
                flag = false;
            } else if (!token.equals(homePage.getTemp1())) {
                application.setAttribute(HOMEPAGETOKEN, (Object)homePage.getTemp1());
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u68c0\u67e5\u9996\u9875token\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    @RequestMapping(value={"locationSet"})
    public ModelAndView locationSet() {
        return new ModelAndView("main/location_set");
    }

    @RequestMapping(value={"/page"})
    public ModelAndView page(HttpServletRequest request, Long pageId) {
        ModelAndView mav = new ModelAndView();
        try {
            String path = request.getContextPath();
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
            MobSiteBasic msb = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
            String siteProjectUrl = this.basicSetService.findBasicSet().getBsetAddress();
            BasicSet basicSet = this.basicSetService.findBasicSet();
            List currStatisticsCode = this.statisticsCodeBizImpl.getCurrStatisticsCode();
            this.checkFileExistsAndMkdirs(request, "page_main");
            int flag = this.showNewHomePage(request, null, pageId);
            mav.addObject(MOBSITEBASIC, (Object)msb);
            mav.addObject(SITEPROJECTURL, (Object)siteProjectUrl);
            mav.addObject("sys", (Object)basicSet);
            mav.addObject(SCODELIST, (Object)currStatisticsCode);
            mav.addObject("flag", (Object)flag);
            mav.addObject("seo", (Object)this.getSeo());
            mav.addObject("pageId", (Object)pageId);
            mav.setViewName(MAIN_STORE + STOREID + "/page_main");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }
}

