/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.util;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class IndexStaticizeUtil {
    private static final Logger LOGGER = Logger.getLogger(IndexStaticizeUtil.class);

    private IndexStaticizeUtil() {
    }

    public static void analysisTemplate(String templatePath, String templateName, String fileName, Map<?, ?> root) {
        try {
            Configuration config = new Configuration();
            config.setDirectoryForTemplateLoading(new File(templatePath));
            config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template template = config.getTemplate(templateName, "utf-8");
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "utf-8");
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TemplateException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFileToContext(String key, String fileName) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        InputStream is = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            is = new BufferedInputStream(fis);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            ServletContext application = request.getSession().getServletContext();
            application.setAttribute(key, (Object)new String(buffer, "UTF-8"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"IO\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"IO\u9519\u8bef", (Throwable)e);
            }
        }
    }
}

