/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.customer.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.CustomerAddressService;
import com.qianjiang.wap.util.LoginUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CustomerAddressControllerM {
    @Resource(name="customerAddressService")
    private CustomerAddressService customerAddressService;
    @Resource(name="SeoService")
    private SeoService seoService;

    @RequestMapping(value={"/customer/address"})
    public ModelAndView queryCustomerAddress(HttpServletRequest request) {
        if (LoginUtil.checkLoginStatus(request)) {
            return this.seoService.getCurrSeo(new ModelAndView("customer/address").addObject("addresses", (Object)this.customerAddressService.queryCustomerAddress((Long)request.getSession().getAttribute("customerId"))));
        }
        return new ModelAndView("redirect:/loginm.html");
    }

    @RequestMapping(value={"/customer/filladdress"})
    public ModelAndView fillAddress(HttpServletRequest request, Long addressId) {
        if (LoginUtil.checkLoginStatus(request)) {
            if (addressId == null) {
                return this.seoService.getCurrSeo(new ModelAndView("customer/filladdress"));
            }
            return this.seoService.getCurrSeo(new ModelAndView("customer/filladdress").addObject("addr", (Object)this.customerAddressService.queryCustomerAddressById(addressId, (Long)request.getSession().getAttribute("customerId"))));
        }
        return new ModelAndView("redirect:/loginm.html");
    }

    @RequestMapping(value={"/customer/updateaddress"})
    public ModelAndView updateAddress(HttpServletRequest request, CustomerAddress address) {
        if (LoginUtil.checkLoginStatus(request)) {
            this.customerAddressService.updateAddress(address, (Long)request.getSession().getAttribute("customerId"));
            return new ModelAndView("redirect:/customer/address.html");
        }
        return new ModelAndView("redirect:/loginm.html");
    }

    @RequestMapping(value={"/customer/addaddress"})
    public ModelAndView addAddress(HttpServletRequest request, CustomerAddress address) {
        if (LoginUtil.checkLoginStatus(request)) {
            this.customerAddressService.addAddress(address, (Long)request.getSession().getAttribute("customerId"));
            return new ModelAndView("redirect:/customer/address.html");
        }
        return new ModelAndView("redirect:/loginm.html");
    }
}

