/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.customer.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.CustomerAddressService;
import com.qianjiang.customer.service.CustomerOrderService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderMService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.system.bean.DeliveryPoint;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.system.service.IsBackOrderService;
import com.qianjiang.util.DateUtils;
import com.qianjiang.util.IPAddress;
import com.qianjiang.util.IdWorker;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import com.qianjiang.wap.customer.controller.CustomerControllerM;
import com.qianjiang.wap.customer.vo.OrderInfoBean;
import com.qianjiang.wap.util.LoginUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;
import sun.misc.BASE64Decoder;

@Controller
public class CustomerOrderControllerM {
    private static final MyLogger LOGGER = new MyLogger(CustomerOrderControllerM.class);
    private static final String PARAMSTRING = "paramString";
    @Resource(name="customerOrderService")
    private CustomerOrderService customerOrderService;
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper commentServiceMapper;
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Resource(name="ReturnGoodsService")
    private ReturnGoodsService returnGoodsService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="IsBackOrderService")
    private IsBackOrderService isbackOrderService;
    @Resource(name="OrderMService")
    private OrderMService orderMService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="customerAddressService")
    private CustomerAddressService addressService;
    @Resource(name="DeliveryPointService")
    private DeliveryPointService deliveryPointService;
    static BASE64Decoder decoder = new BASE64Decoder();

    @RequestMapping(value={"/myorder"})
    public ModelAndView queryAllOrders(HttpServletRequest request, PageBean pb, String date, String type) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        pb.setUrl(request.getContextPath() + "/customer/myorder");
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                Long customerId = (Long)request.getSession().getAttribute("customerId");
                paramMap.put("customerId", customerId);
                paramMap.put("type", type);
                paramMap.put("date", date);
                SystemsSet systemsSet = this.isbackOrderService.getIsBackOrder();
                if (type != null && ("6".equals(type) || "5".equals(type) || "7".equals(type) || "8".equals(type))) {
                    resultMap.put("pb", this.returnGoodsService.queryAllBackOrders(paramMap, pb));
                    mav.setViewName("customer/back_order_list");
                } else {
                    resultMap.put("pb", this.customerOrderService.queryAllMyOrders(paramMap, pb));
                    mav.setViewName("customer/order_list");
                }
                resultMap.put("isBackOrder", systemsSet.getIsBackOrder());
                if (type == null || "".equals(type)) {
                    type = "0";
                }
                resultMap.put("type", type);
                resultMap.put("date", date);
                mav.addAllObjects(resultMap);
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6211\u7684\u8ba2\u5355\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/allmyorder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryAllMyOrders(HttpServletRequest request, PageBean pb, String date, String type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                Long customerId = (Long)request.getSession().getAttribute("customerId");
                paramMap.put("customerId", customerId);
                paramMap.put("type", type);
                paramMap.put("date", date);
                SystemsSet systemsSet = this.isbackOrderService.getIsBackOrder();
                if (type != null && ("6".equals(type) || "5".equals(type) || "7".equals(type))) {
                    resultMap.put("pb", this.returnGoodsService.queryAllBackOrders(paramMap, pb));
                } else {
                    resultMap.put("pb", this.customerOrderService.queryAllMyOrders(paramMap, pb));
                }
                resultMap.put("isBackOrder", systemsSet.getIsBackOrder());
                resultMap.put("type", type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6211\u7684\u8ba2\u5355\u5206\u9875\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/orderdetails"})
    public ModelAndView queryOrderByOrderId(HttpServletRequest request, Long orderId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ModelAndView mav = new ModelAndView();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                SimpleDateFormat fomt;
                String orderTime;
                Long limitDay;
                SystemsSet systemsSet;
                Long customerId = (Long)request.getSession().getAttribute("customerId");
                OrderInfoBean orderInfoBean = (OrderInfoBean)JSON.parseObject((String)JSON.toJSONString((Object)this.customerOrderService.queryOrderByCustIdAndOrderId(orderId, customerId)), OrderInfoBean.class);
                resultMap.put("order", orderInfoBean);
                Long expressType = orderInfoBean.getOrderExpressType();
                if (1L == expressType) {
                    DeliveryPoint deliveryPoint = this.deliveryPointService.getDeliveryPoint(orderInfoBean.getAddressId());
                    resultMap.put("deliveryPoint", deliveryPoint);
                    CustomerAddress customerAddress = null;
                    if (customerId != null) {
                        customerAddress = this.addressService.queryDefaultAddr(customerId);
                    }
                    if (null == customerAddress) {
                        customerAddress = this.addressService.selectByCIdFirst(customerId);
                    }
                    resultMap.put("shippingAddress", customerAddress);
                }
                String isReturn = "0";
                if (null != orderInfoBean && null != (systemsSet = this.isbackOrderService.getIsBackOrder()) && null != (limitDay = systemsSet.getLimitOrderTime()) && !StringUtils.isEmpty((String)(orderTime = DateUtils.getBeforeTodayAfter((SimpleDateFormat)(fomt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")), (int)(-limitDay.intValue()))))) {
                    Date getGoodsTime;
                    Date orderTimes = fomt.parse(orderTime);
                    Order order = this.orderService.orderDetail(orderId);
                    if (null != order && null != order.getGetGoodsTime() && (getGoodsTime = order.getGetGoodsTime()).getTime() < orderTimes.getTime()) {
                        isReturn = "1";
                    }
                }
                mav.addObject("isReturn", (Object)isReturn);
                systemsSet = this.isbackOrderService.getIsBackOrder();
                resultMap.put("isBackOrder", systemsSet.getIsBackOrder());
                resultMap.put("order", orderInfoBean);
                mav.addAllObjects(resultMap);
                mav.setViewName("customer/order_detail");
            } else {
                mav.setViewName("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7528\u6237id\u548c\u8ba2\u5355id\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25");
        }
        return this.seoService.getCurrSeo(mav);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/tocomment"})
    public ModelAndView toShare(HttpServletRequest request, Long orderId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ModelAndView mav = null;
        Long customerId = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                customerId = (Long)request.getSession().getAttribute("customerId");
                resultMap.put("order", this.customerOrderService.queryOrderByCustIdAndOrderId(orderId, customerId));
                mav = new ModelAndView("/customer/order_comment_list").addAllObjects(resultMap);
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
            ModelAndView modelAndView = this.seoService.getCurrSeo(mav);
            return modelAndView;
        }
        finally {
            mav = null;
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/commentgoods"})
    public ModelAndView commentGoods(HttpServletRequest request, Long goodsId, Long orderId, Long commentId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ModelAndView mav = null;
        Long customerId = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                customerId = (Long)request.getSession().getAttribute("customerId");
                resultMap.put("good", this.customerOrderService.selectByOrderIdAndGoodsId(customerId, goodsId, orderId, commentId));
                resultMap.put("cusId", customerId);
                mav = new ModelAndView("/customer/order_comment").addAllObjects(resultMap);
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
            ModelAndView modelAndView = this.seoService.getCurrSeo(mav);
            return modelAndView;
        }
        finally {
            mav = null;
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/comment"})
    public ModelAndView toViewComment(HttpServletRequest request, PageBean pageBean) {
        pageBean.setUrl("customer/comment");
        ModelAndView mav = null;
        HashMap<String, PageBean> resultMap = new HashMap<String, PageBean>();
        try {
            resultMap.put("pb", this.commentServiceMapper.queryCustComment((Long)request.getSession().getAttribute("customerId"), pageBean));
            if (LoginUtil.checkLoginStatus(request)) {
                mav = new ModelAndView("customer/comment");
                mav.addAllObjects(resultMap);
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
            ModelAndView modelAndView = this.seoService.getCurrSeo(mav);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/addgoodscomment"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addGoodsComment(HttpServletRequest request, @Valid Comment comment, Long orderId) {
        int f = 0;
        if (LoginUtil.checkLoginStatus(request)) {
            String ip = IPAddress.getIpAddr((HttpServletRequest)request);
            f = this.customerOrderService.addGoodsComment(ip, comment, orderId);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cancelorder"})
    public ModelAndView cancelOrder(HttpServletRequest request, PageBean pb, Long orderId, String reason) {
        ModelAndView mav = null;
        if (reason != null && !"".equals(reason) && !Pattern.compile("[^\\<\\>]+$").matcher(reason).find()) {
            throw new IllegalArgumentException();
        }
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                this.customerOrderService.cancelOrder(orderId, reason);
                this.orderCouponService.modifyCouponStatusNew(orderId);
                this.orderService.updateRushcustomerByOrderId(orderId);
                mav = new ModelAndView("redirect:/customer/myorder.html");
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
            ModelAndView modelAndView = this.seoService.getCurrSeo(mav);
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/comfirmofgooods"})
    public ModelAndView comfirmofGoods(HttpServletRequest request, PageBean pb, Long orderId) {
        ModelAndView mav = null;
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                Order order = this.orderMService.getPayOrder(orderId);
                if (order != null && order.getPayTime() == null) {
                    order.setPayTime(new Date());
                }
                order.setGetGoodsTime(new Date());
                order.setOrderStatus("3");
                order.setFinishSturts("1");
                this.orderMService.comfirmOrder(order, (Long)request.getSession().getAttribute("customerId"));
                mav = new ModelAndView("redirect:/customer/myorder.html");
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
            ModelAndView modelAndView = this.seoService.getCurrSeo(mav);
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upCommentPic"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object upCommentPic(String base64, HttpServletRequest request) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        IdWorker idWorker = new IdWorker(2L);
        try {
            if (base64 != null && base64.split(",").length > 1) {
                base64 = base64.split(",")[1].toString();
            }
            byte[] bt = decoder.decodeBuffer(base64);
            String imgFilePath = CustomerControllerM.class.getResource("/").getPath() + idWorker.nextId() + ".jpeg";
            boolean flag = CustomerOrderControllerM.generateImage(bt, imgFilePath);
            File file = new File(imgFilePath);
            DiskFileItem fileItem = new DiskFileItem(idWorker.nextId() + ".jpeg", Files.probeContentType(file.toPath()), false, file.getName(), (int)file.length(), file.getParentFile());
            try {
                FileInputStream input = new FileInputStream(file);
                OutputStream os = fileItem.getOutputStream();
                IOUtils.copy((InputStream)input, (OutputStream)os);
            }
            catch (IOException ex) {
                // empty catch block
            }
            CommonsMultipartFile mr = new CommonsMultipartFile((FileItem)fileItem);
            String image = UploadUtil.uploadFileOne((MultipartFile)mr);
            resultMap.put("image", image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSON.toJSON(resultMap);
    }

    public static boolean generateImage(byte[] bytes, String imgFilePath) {
        try {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(bytes);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

