/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.order.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderOtherPay;
import com.qianjiang.order.bean.OrderOtherPaySchedule;
import com.qianjiang.order.service.OrderOtherMPayService;
import com.qianjiang.order.service.OrderOtherPayScheduleService;
import com.qianjiang.order.service.OrderOtherPayService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.service.OrderPayService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.other.bean.RequestHandler;
import com.qianjiang.wap.other.bean.TenpayUtil;
import com.qianjiang.wap.weixin.bean.ResponseHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class OrderOtherController {
    private static final MyLogger LOGGER = new MyLogger(OrderOtherController.class);
    private static final String LOGGERINFO1 = "\u8ba2\u5355\u5df2\u652f\u4ed8";
    private static final String MESSAGE = "message";
    private static final String ORDER = "order";
    private static final String ISO_8859_1 = "ISO-8859-1";
    @Resource(name="OrderOtherPayService")
    private OrderOtherPayService orderOtherPayService;
    @Resource(name="OrderOtherPayScheduleService")
    private OrderOtherPayScheduleService orderOtherPayScheduleService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="OrderPayService")
    OrderPayService payService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="OrderOtherMPayService")
    private OrderOtherMPayService orderOtherMPayService;

    @RequestMapping(value={"/queryother"})
    public ModelAndView queryOther(OrderOtherPay otherPay, Long orderId, HttpServletRequest request) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        Order order = this.orderService.orderDetail(orderId);
        if (!"0".equals(order.getOrderStatus())) {
            return new ModelAndView((View)new RedirectView("errorpage.html")).addObject(MESSAGE, (Object)LOGGERINFO1);
        }
        if (!order.getCustomerId().equals((Long)request.getSession().getAttribute("customerId"))) {
            return new ModelAndView("errorpage.html").addObject(MESSAGE, (Object)"\u7528\u6237\u4e0d\u5339\u914d");
        }
        ModelAndView mav = new ModelAndView("otherpay/pay").addObject(ORDER, (Object)order).addObject("customer", (Object)this.customerServiceMapper.selectByPrimaryKey(order.getCustomerId()));
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/otherPay"})
    public ModelAndView otherPay(OrderOtherPay otherPay, Long orderId, HttpServletRequest request, String status) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        Long custId = (Long)request.getSession().getAttribute("customerId");
        if (custId == null) {
            request.getSession().setAttribute("otherPayUrl", (Object)("otherpay-" + orderId + ".html"));
            return new ModelAndView("redirect:/getwxcode2.htm");
        }
        Order order = this.orderService.getPayOrder(orderId);
        if (!"0".equals(order.getOrderStatus())) {
            return new ModelAndView((View)new RedirectView("errorpage.html")).addObject(MESSAGE, (Object)LOGGERINFO1);
        }
        if (otherPay.getOrderCode() != null) {
            this.orderOtherMPayService.updateOrderOtherSingle(otherPay, custId, request);
        }
        ModelAndView mav = null;
        mav = status != null && "1".equals(status) ? new ModelAndView("otherpay/single_pay_step1") : new ModelAndView("otherpay/information2");
        mav.addObject("map", (Object)this.orderOtherMPayService.selectOtherPaySingle(orderId));
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/otherpaypromptly"})
    public ModelAndView otherPayPromptly(OrderOtherPaySchedule otherPay, Long orderId, HttpServletRequest request, String status) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        Order order = this.orderService.getPayOrder(orderId);
        if (!"0".equals(order.getOrderStatus())) {
            return new ModelAndView((View)new RedirectView("errorpage.html")).addObject(MESSAGE, (Object)LOGGERINFO1);
        }
        Long custId = (Long)request.getSession().getAttribute("customerId");
        if (custId == null) {
            request.getSession().setAttribute("otherPayUrl", (Object)("otherpay-" + orderId + ".html"));
            return new ModelAndView("redirect:/getwxcode2.htm");
        }
        if (otherPay.getOrderCode() != null) {
            this.orderOtherMPayService.updateOrderOtherPay(otherPay, request);
        }
        ModelAndView mav = null;
        mav = status != null && "1".equals(status) ? new ModelAndView("otherpay/multi_pay_step") : new ModelAndView("otherpay/multi_pay_step2");
        mav.addObject("map", (Object)this.orderOtherMPayService.selectOtherPay(orderId));
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/gomultipay"})
    public ModelAndView goMultiPay(Long orderId) {
        ModelAndView mav = null;
        mav = new ModelAndView("otherpay/information");
        mav.addObject("map", (Object)this.orderOtherMPayService.selectOtherPay(orderId));
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"inertotherpaysingle"})
    public ModelAndView payOrderSingle(OrderOtherPay orderOtherPay, Long payId, HttpServletRequest request) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        try {
            orderOtherPay.setOrderPayCustid((Long)request.getSession().getAttribute("customerId"));
            orderOtherPay.setOrderPayName(new String(orderOtherPay.getOrderPayName().getBytes(ISO_8859_1), "utf-8"));
            orderOtherPay.setOrderPayRemark(new String(orderOtherPay.getOrderPayRemark().getBytes(ISO_8859_1), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            OperaLogUtil.addOperaException((String)cust.getCustomerUsername(), (Exception)e, (HttpServletRequest)request);
        }
        String currTime = TenpayUtil.getCurrTime();
        String strTime = currTime.substring(8, currTime.length());
        String strRandom = TenpayUtil.buildRandom(4) + "";
        String strReq = strTime + strRandom;
        String s = orderOtherPay.getOrderCode() + strReq;
        orderOtherPay.setOrderPayCode(s);
        orderOtherPay.setOrderCreateTime(new Date());
        orderOtherPay.setOrderPayStatus("1");
        ModelAndView mav = new ModelAndView();
        Order order = this.orderService.getPayOrderByCode(orderOtherPay.getOrderCode());
        orderOtherPay.setOrderPayCode(order.getOrderCode());
        OrderOtherPaySchedule orderOtherPaySchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(orderOtherPay.getOrderCode());
        if (orderOtherPaySchedule != null) {
            order.setOrderPrice(orderOtherPaySchedule.getOrderResiduePrice());
        }
        if (!"0".equals(order.getOrderStatus())) {
            return new ModelAndView((View)new RedirectView("errorpage.html")).addObject(MESSAGE, (Object)LOGGERINFO1);
        }
        String ip = request.getRemoteAddr();
        mav.addObject(ORDER, (Object)order);
        mav.addObject("ip", (Object)ip);
        mav.addObject("orderId", (Object)order.getOrderId());
        mav.addObject("goodsInfoName", (Object)"\u6d4b\u8bd5");
        mav.addObject("payPrice", (Object)order.getOrderPrice().toString().replace(".", ""));
        mav.addObject("callBackUrl", (Object)"http://shop.qianjiang.com/mobile/wxpaysuc.htm");
        mav.setViewName("pay/pay2");
        this.orderOtherPayService.updateOtherPay(orderOtherPay);
        return mav;
    }

    @RequestMapping(value={"inertotherpay"})
    public ModelAndView payOrder(OrderOtherPay orderOtherPay, Long payId, HttpServletRequest request) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        try {
            orderOtherPay.setOrderPayCustid((Long)request.getSession().getAttribute("customerId"));
            orderOtherPay.setOrderPayName(new String(orderOtherPay.getOrderPayName().getBytes(ISO_8859_1), "utf-8"));
            orderOtherPay.setOrderPayRemark(new String(orderOtherPay.getOrderPayRemark().getBytes(ISO_8859_1), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            OperaLogUtil.addOperaException((String)cust.getCustomerUsername(), (Exception)e, (HttpServletRequest)request);
        }
        Boolean bool = this.orderOtherPayService.isNoPay(orderOtherPay);
        if (bool.booleanValue()) {
            return new ModelAndView((View)new RedirectView("errorpage.html")).addObject(MESSAGE, (Object)"\u5f53\u524d\u6b63\u5728\u652f\u4ed8\u8fc7\u591a\uff0c\u8bf7\u7a0d\u7b49");
        }
        String currTime = TenpayUtil.getCurrTime();
        String strTime = currTime.substring(8, currTime.length());
        String strRandom = TenpayUtil.buildRandom(4) + "";
        String strReq = strTime + strRandom;
        String s = orderOtherPay.getOrderCode() + strReq;
        orderOtherPay.setOrderPayCode(s);
        orderOtherPay.setOrderCreateTime(new Date());
        orderOtherPay.setOrderPayStatus("1");
        ModelAndView mav = new ModelAndView();
        Order order = this.orderService.getPayOrderByCode(orderOtherPay.getOrderCode());
        String ip = request.getRemoteAddr();
        mav.addObject(ORDER, (Object)order);
        mav.addObject("ip", (Object)ip);
        mav.addObject("orderPayCode", (Object)orderOtherPay.getOrderPayCode());
        mav.addObject("orderId", (Object)order.getOrderId());
        mav.addObject("goodsInfoName", (Object)"\u6d4b\u8bd5");
        mav.addObject("payPrice", (Object)orderOtherPay.getOrderPayPrice().toString().replace(".", ""));
        mav.addObject("callBackUrl", (Object)"http://shop.qianjiang.com/mobile/otherpaywxsucess.htm");
        mav.setViewName("pay/pay3");
        this.orderOtherPayService.insertOtherPay(orderOtherPay);
        return mav;
    }

    @RequestMapping(value={"/otherpaywxsucess"})
    public void otherPayWxSucess(HttpServletRequest request, HttpServletResponse response) {
        ResponseHandler resHandler = new ResponseHandler(request, response);
        resHandler.setKey("9b65423e573b0baa90e882e7158270ce");
        resHandler.setKey("LTD5WYXxE8xbFAghepFKezy04NaqXDojDEeFFV5ZgFfhVXX8zNF98yS4kvsTGhlTx2wGRU3JJsEIdnawrAX0AG06dRQ5VaFMyfndnO6ZcremCphgFlJhKwg0dvCWru2e");
        RequestHandler queryReq = new RequestHandler(null, null);
        queryReq.init();
        if (resHandler.isValidSign()) {
            String outTradeNo = resHandler.getParameter("out_trade_no");
            OrderOtherPay otherPay = this.orderOtherPayService.selectOthertByOrderPayCode(outTradeNo);
            otherPay.setOrderPayTime(new Date());
            otherPay.setOrderPayStatus("2");
            this.orderOtherPayService.updateOtherPay(otherPay);
            OrderOtherPaySchedule otherPaySchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(otherPay.getOrderCode());
            otherPaySchedule.setOrderPayStatus("1");
            this.orderOtherMPayService.updateOrderOtherPay(otherPaySchedule, request);
            this.orderOtherPayScheduleService.payOther(otherPaySchedule, otherPay);
            try {
                resHandler.sendToCFT("success");
            }
            catch (IOException e) {
                Customer cust = (Customer)request.getSession().getAttribute("cust");
                OperaLogUtil.addOperaException((String)cust.getCustomerUsername(), (Exception)e, (HttpServletRequest)request);
            }
        } else {
            try {
                resHandler.sendToCFT("fail");
            }
            catch (IOException e) {
                Customer cust = (Customer)request.getSession().getAttribute("cust");
                OperaLogUtil.addOperaException((String)cust.getCustomerUsername(), (Exception)e, (HttpServletRequest)request);
            }
        }
    }

    @RequestMapping(value={"/otherpaysuccess"})
    public ModelAndView otherPaySuccess(HttpServletRequest request, HttpServletResponse agr1, HttpServletResponse response) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (Map.Entry entrySet : requestParams.entrySet()) {
            String[] values = (String[])entrySet.getValue();
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr.concat(values[i]) : valueStr.concat(values[i]).concat(",");
            }
            try {
                valueStr = new String(valueStr.getBytes(ISO_8859_1), "utf-8");
                params.put(entrySet.getKey().toString(), valueStr);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef" + e);
            }
        }
        String orderCode = request.getParameter("out_trade_no");
        OrderOtherPay otherPay = this.orderOtherPayService.selectOthertByOrderPayCode(orderCode);
        otherPay.setOrderPayTime(new Date());
        otherPay.setOrderPayStatus("2");
        this.orderOtherPayService.updateOtherPay(otherPay);
        OrderOtherPaySchedule otherPaySchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(otherPay.getOrderCode());
        this.orderOtherPayScheduleService.payOther(otherPaySchedule, otherPay);
        return new ModelAndView((View)new RedirectView("otherpaypromptly.htm")).addObject("orderId", (Object)2387);
    }

    @RequestMapping(value={"/test"})
    public void test(String orderCode) {
        OrderOtherPay otherPay = this.orderOtherPayService.selectOthertByOrderPayCode(orderCode);
        otherPay.setOrderPayTime(new Date());
        otherPay.setOrderPayStatus("2");
        this.orderOtherPayService.updateOtherPay(otherPay);
        OrderOtherPaySchedule otherPaySchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(otherPay.getOrderCode());
        this.orderOtherPayScheduleService.payOther(otherPaySchedule, otherPay);
    }

    @RequestMapping(value={"/otherpaysinglesuccess"})
    public ModelAndView otherPaySingleSuccess(Long orderId) {
        ModelAndView mav = new ModelAndView("otherpay/single_pay_success").addObject("map", (Object)this.orderOtherMPayService.selectOtherPaySingle(orderId));
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/orderpaysuccess"})
    public ModelAndView orderPaySuccess(Long orderId) {
        ModelAndView mav = new ModelAndView("otherpay/multi_pay_success").addObject("map", (Object)this.orderOtherMPayService.selectOtherPay(orderId));
        return this.seoService.getCurrSeo(mav);
    }
}

