/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.push.controller;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.push.util.JPushUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;

@Controller
public class JPushController {
    private static final MyLogger LOGGER = new MyLogger(JPushController.class);
    private static final String appKey = "83e6242fd1658bfb0d938a7f";
    private static final String masterSecret = "ba4fa1699ec9b7e2c24f598c";
    private static long timeToLive = 86400L;
    private static JPushClient jPushClient = null;
    @Resource(name="customerService")
    private CustomerService customerService;

    public String sendPushAll(String msg) {
        jPushClient = new JPushClient(masterSecret, appKey);
        try {
            PushPayload payload = JPushUtil.buildPushObject_all_alias_alert("alias", msg);
            PushResult result = jPushClient.sendPush(payload);
            LOGGER.info((Object)("\u8fd4\u56de\u6570\u636e\uff1a" + result));
        }
        catch (APIConnectionException e) {
            LOGGER.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOGGER.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOGGER.info((Object)("HTTP Status: " + e.getStatus()));
            LOGGER.info((Object)("Error Code: " + e.getErrorCode()));
            LOGGER.info((Object)("Error Message: " + e.getErrorMessage()));
            LOGGER.info((Object)("Msg ID: " + e.getMsgId()));
        }
        return "success";
    }

    public int sendToRegistrationId(String registrationId, String title, String url) {
        int result = 0;
        jPushClient = new JPushClient(masterSecret, appKey);
        try {
            PushPayload pushPayload = JPushUtil.buildPushObject_all_ios_notification(registrationId, title, url);
            System.out.println(pushPayload);
            PushResult pushResult = jPushClient.sendPush(pushPayload);
            System.out.println(pushResult);
            if (pushResult.getResponseCode() == 200) {
                result = 1;
            }
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        JPushController c = new JPushController();
        int result = c.sendToRegistrationId("161a3797c857abb748d", "\u6536\u5230\u4e00\u6761\u4fe1\u606f", "http://dev_exwap.qjclouds.com/qjsoft-app-exchange-wap/customer/myorder-3-1.html");
        System.out.println(result);
    }
}

