/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.deposit.controller;

import com.alibaba.fastjson.JSONObject;
import com.ningpai.wxpay.utils.RequestHandlerUtil;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.common.util.alipay.util.AlipayNotify;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.OrderPayService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.util.LoginUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DepositController {
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String UTF_8 = "UTF-8";
    private static final String SUCCESS = "SUCCESS";
    @Resource(name="depositInfoServiceImpl")
    private DepositInfoService depositInfoService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="OrderPayService")
    private OrderPayService payService;
    private static final String OUT_TRADE_NO = "out_trade_no";
    private static final MyLogger LOGGER = new MyLogger(DepositController.class);

    @RequestMapping(value={"/mobilevalidation"})
    @ResponseBody
    public boolean getMobileValidationResult(HttpServletRequest request) {
        boolean result = false;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            result = this.depositInfoService.checkMobileValidation(customerId);
        }
        return result;
    }

    @RequestMapping(value={"/topaypassword"})
    public ModelAndView toPayPassword(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = null;
        boolean result = false;
        if (LoginUtil.checkLoginStatus(request)) {
            modelAndView = new ModelAndView("redirect:/loginm.html");
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            result = this.depositInfoService.checkMobileValidation(customerId);
            if (result) {
                modelAndView = new ModelAndView("member/modifypaypassword");
                modelAndView.addObject("custInfo", (Object)this.customerService.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            }
        }
        return this.seoService.getCurrSeo(modelAndView);
    }

    @RequestMapping(value={"/sendpaycode"})
    @ResponseBody
    public int sendPayCode(HttpServletRequest request) throws IOException {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Map result = this.customerService.sendPayCode(customerId);
        request.getSession().setAttribute("payCode", result.get("payCode"));
        request.getSession().setAttribute("userMobile", result.get("userMobile"));
        return 1;
    }

    @RequestMapping(value={"/validatepaycode"})
    @ResponseBody
    public int validatePayCode(HttpServletRequest request, String code) throws IOException {
        String payCode = (String)request.getSession().getAttribute("payCode");
        return this.depositInfoService.validatePayCode(payCode, code);
    }

    @RequestMapping(value={"/submitpayset"})
    @ResponseBody
    public int submitPaySet(HttpServletRequest request, String password) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        return this.depositInfoService.setPayPassword(customerId, password);
    }

    @RequestMapping(value={"/showmypredeposits"})
    public ModelAndView showMyPredeposits(HttpServletRequest request) {
        ModelAndView modelAndView = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            modelAndView = new ModelAndView("member/mypredeposits").addObject("deposit", (Object)this.depositInfoService.queryDepositInfo(customerId));
        } else {
            modelAndView = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(modelAndView);
    }

    @RequestMapping(value={"/mypredepositsrecharge"})
    public ModelAndView myPredepositsRecharge(HttpServletRequest request) {
        ModelAndView modelAndView = null;
        modelAndView = LoginUtil.checkLoginStatus(request) ? new ModelAndView("member/mypredepositsrecharge").addObject("payments", (Object)this.payService.selectMobilePay()) : new ModelAndView("redirect:/loginm.html");
        return this.seoService.getCurrSeo(modelAndView);
    }

    @RequestMapping(value={"/wxrecharge"})
    @ResponseBody
    public Map<String, Object> wxReharge(HttpServletRequest request, HttpServletResponse response, BigDecimal orderPrice) {
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            String userId = request.getParameter("userId");
            String openid = (String)request.getSession().getAttribute("openid");
            RequestHandlerUtil reqHandler = new RequestHandlerUtil(request, response);
            String spbillCreateIp = request.getRemoteAddr();
            return this.depositInfoService.getBrandWCPayRequest(reqHandler, openid, userId, spbillCreateIp, customerId, orderPrice, "0");
        }
        return null;
    }

    @RequestMapping(value={"/wxrechargepaysuc"})
    public void wxpaySuc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        try {
            Document document = DocumentHelper.parseText((String)sb.toString());
            Element root = document.getRootElement();
            String appId = "";
            String outTradeNo = "";
            String resultCode = "";
            String mId = "";
            String returnMsg = "";
            List elements = root.elements();
            for (Element element : elements) {
                if ("appid".equals(element.getName())) {
                    appId = element.getText();
                    continue;
                }
                if ("bank_type".equals(element.getName())) {
                    element.getText();
                    continue;
                }
                if ("mch_id".equals(element.getName())) {
                    mId = element.getText();
                    continue;
                }
                if ("result_code".equals(element.getName())) {
                    resultCode = element.getText();
                    continue;
                }
                if (OUT_TRADE_NO.equals(element.getName())) {
                    outTradeNo = element.getText();
                    continue;
                }
                if (!"FAIL".equals(resultCode) || !"return_msg".equals(element.getName())) continue;
                returnMsg = element.getText();
            }
            boolean result = this.depositInfoService.weixinRechargeNotify(outTradeNo, appId, resultCode, mId);
            if (result) {
                this.sendSucess(response, SUCCESS);
            } else {
                this.sendSucess(response, returnMsg);
            }
        }
        catch (DocumentException e1) {
            LOGGER.error("\u5fae\u4fe1\u652f\u4ed8\u9519\u8bef\uff1a" + (Object)((Object)e1));
            this.sendSucess(response, "FAIL");
        }
    }

    public void sendSucess(HttpServletResponse response, String msg) throws IOException {
        PrintWriter out = response.getWriter();
        out.println(msg);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/checkDepositPay"})
    @ResponseBody
    public JSONObject checkDepositPay(HttpServletRequest request, BigDecimal orderPrice, String type) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        return (JSONObject)this.depositInfoService.checkDepositPay(customerId, orderPrice, type);
    }

    @RequestMapping(value={"/tonextpassword"})
    public ModelAndView toNextPassword(HttpServletRequest request, String code) {
        ModelAndView modelAndView = null;
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            String payCode = (String)request.getSession().getAttribute("payCode");
            int result = this.depositInfoService.validatePayCode(payCode, code);
            modelAndView = result == 1 ? new ModelAndView("member/nextpaypassword") : new ModelAndView("member/modifypaypassword").addObject("custInfo", (Object)this.customerService.selectByPrimaryKey(customerId)).addObject("error_msg", (Object)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
        } else {
            modelAndView = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(modelAndView);
    }

    @RequestMapping(value={"/zhifubaopecharge"})
    public ModelAndView zhifubaoRecharge(HttpServletRequest request, BigDecimal rechargePrice) {
        ModelAndView modelAndView = new ModelAndView();
        if (LoginUtil.checkLoginStatus(request) && rechargePrice.compareTo(new BigDecimal(1000000)) <= 0) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            modelAndView.addObject("sHtmlText", (Object)this.depositInfoService.zhifubaoRecharge(rechargePrice, customerId));
            modelAndView.setViewName("order/netbank");
        } else {
            modelAndView = new ModelAndView("redirect:/loginm.html");
        }
        return this.seoService.getCurrSeo(modelAndView);
    }

    @RequestMapping(value={"/synrechargesucccess"})
    public ModelAndView synRechargeSucccess(HttpServletRequest request) {
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            StringBuilder valueStr = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    valueStr.append(values[i]);
                    continue;
                }
                valueStr.append(values[i]);
                valueStr.append(",");
            }
            params.put(name, valueStr.toString());
        }
        String orderCode = null;
        try {
            orderCode = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u4ea4\u6613\u53f7\u9519\u8bef\uff1a" + e);
        }
        boolean verifyResult = AlipayNotify.verify(params);
        if (verifyResult) {
            this.depositInfoService.zhifubaoRechargeNotify(orderCode);
        }
        ModelAndView mav = new ModelAndView("order/recharg_success");
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/asynrechargesucccess"})
    public void asynrechargesucccess(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            StringBuilder valueStr = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    valueStr.append(values[i]);
                    continue;
                }
                valueStr.append(values[i]);
                valueStr.append(",");
            }
            params.put(name, valueStr.toString());
        }
        String outTradeNo = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
        String tradeStatus = new String(request.getParameter("trade_status").getBytes(ISO_8859_1), UTF_8);
        if (AlipayNotify.verify(params)) {
            if ("TRADE_FINISHED".equals(tradeStatus)) {
                this.depositInfoService.zhifubaoRechargeNotify(outTradeNo);
            } else if ("TRADE_SUCCESS".equals(tradeStatus)) {
                this.depositInfoService.zhifubaoRechargeNotify(outTradeNo);
                this.sendSucess(response, SUCCESS);
            }
        } else {
            System.out.println("fail");
        }
    }
}

