/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.order.util;

import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderOtherPay;
import com.qianjiang.order.bean.OrderOtherPaySchedule;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderOtherPayScheduleService;
import com.qianjiang.order.service.OrderOtherPayService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.other.bean.ClientResponseHandler;
import com.qianjiang.wap.other.bean.MD5Util;
import com.qianjiang.wap.other.bean.RequestHandler;
import com.qianjiang.wap.other.bean.TenpayHttpClient;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="RefundmentUtil")
public class RefundmentUtil {
    public static final MyLogger LOGGER = new MyLogger(RefundmentUtil.class);
    @Resource(name="OrderOtherPayService")
    private OrderOtherPayService orderOtherPayService;
    @Resource(name="OrderOtherPayScheduleService")
    private OrderOtherPayScheduleService orderOtherPayScheduleService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="OrderLogService")
    private OrderLogService orderLogService;

    public void service() {
        List schedules = this.orderOtherPayScheduleService.queryOrderOtherPayRefund();
        for (OrderOtherPaySchedule orderOtherPaySchedule : schedules) {
            List orderOtherPays = this.orderOtherPayService.queryOrderPayRefund(orderOtherPaySchedule.getOrderCode());
            if (orderOtherPays == null || orderOtherPays.isEmpty()) {
                Order order = this.orderService.getPayOrderByCode(orderOtherPaySchedule.getOrderCode());
                if (!"0".equals(order.getOrderStatus())) continue;
                this.orderService.updateSetCargoStatusByOrderId(order.getOrderId(), "4");
                continue;
            }
            for (OrderOtherPay orderOtherPay : orderOtherPays) {
                try {
                    this.refundment(orderOtherPay.getOrderPayCode(), orderOtherPay.getOrderPayPrice().toString().replace(".", ""), orderOtherPay.getOrderCode());
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    public void refundment(String orderCode, String orderPrice, String code) throws Exception {
        Order order = this.orderService.getPayOrderByCode(code);
        String partner = "1220343401";
        String key = "9b65423e573b0baa90e882e7158270ce";
        RequestHandler reqHandler = new RequestHandler(null, null);
        TenpayHttpClient httpClient = new TenpayHttpClient();
        ClientResponseHandler resHandler = new ClientResponseHandler();
        reqHandler.init();
        reqHandler.setKey(key);
        reqHandler.setGateUrl("https://mch.tenpay.com/refundapi/gateway/refund.xml");
        reqHandler.setParameter("service_version", "1.1");
        reqHandler.setParameter("partner", partner);
        reqHandler.setParameter("out_trade_no", orderCode);
        reqHandler.setParameter("out_refund_no", orderCode);
        reqHandler.setParameter("total_fee", orderPrice);
        reqHandler.setParameter("refund_fee", orderPrice);
        reqHandler.setParameter("op_user_id", "1220343401001");
        reqHandler.setParameter("op_user_passwd", MD5Util.MD5Encode("oacat520", "GBK"));
        reqHandler.setParameter("recv_user_id", "");
        reqHandler.setParameter("reccv_user_name", "");
        httpClient.setTimeOut(5);
        httpClient.setCaInfo(new File(RefundmentUtil.class.getClassLoader().getResource("").getPath() + "/com/qianjiang/m/order/util/cacert.pem"));
        httpClient.setCertInfo(new File(RefundmentUtil.class.getClassLoader().getResource("").getPath() + "/com/qianjiang/m/order/util/1220343401_20140804205129.pfx"), "1220343401");
        httpClient.setMethod("POST");
        String requestUrl = reqHandler.getRequestURL();
        httpClient.setReqContent(requestUrl);
        String rescontent = "null";
        if (httpClient.call()) {
            rescontent = httpClient.getResContent();
            resHandler.setContent(rescontent);
            resHandler.setKey(key);
            String retcode = resHandler.getParameter("retcode");
            if (resHandler.isTenpaySign() && "0".equals(retcode)) {
                String refundStatus = resHandler.getParameter("refund_status");
                String outRefundNo = resHandler.getParameter("out_refund_no");
                if ("4".equals(refundStatus) || "10".equals(refundStatus)) {
                    OrderOtherPay otherPay = this.orderOtherPayService.selectOthertByOrderPayCode(outRefundNo);
                    otherPay.setOrderPayStatus("3");
                    this.orderOtherPayService.updateOtherPay(otherPay);
                    this.orderLogService.insertSelective("\u7528\u6237\uff1a" + otherPay.getOrderPayName() + "\u7684\u9000\u6b3e\u5df2\u5b8c\u6210", order.getOrderId(), "\u7528\u6237\u9000\u6b3e", "5");
                } else if ("8".equals(refundStatus) || "9".equals(refundStatus) || "11".equals(refundStatus)) {
                    OrderOtherPay otherPay = this.orderOtherPayService.selectOthertByOrderPayCode(outRefundNo);
                    if (otherPay.getOrderPayName() == null) {
                        otherPay.setOrderPayName("\u8bf7\u53eb\u6211\u597d\u5fc3\u4eba");
                    }
                    if ("4".equals(otherPay.getOrderPayStatus())) {
                        otherPay.setOrderPayStatus("4");
                        this.orderOtherPayService.updateOtherPay(otherPay);
                        this.orderLogService.insertSelective("\u7528\u6237\uff1a" + otherPay.getOrderPayName() + "\u7684\u9000\u6b3e\u6b63\u5728\u5904\u7406\u4e2d\u3002", order.getOrderId(), "\u7528\u6237\u9000\u6b3e", "5");
                    }
                }
            } else {
                this.orderLogService.insertSelective("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u6216\u4e1a\u52a1\u9519\u8bef", order.getOrderId(), "\u7528\u6237\u9000\u6b3e", "5");
                this.orderLogService.insertSelective("http res:" + httpClient.getResponseCode() + "," + httpClient.getErrInfo(), order.getOrderId(), "\u7528\u6237\u9000\u6b3e", "5");
            }
        } else {
            this.orderLogService.insertSelective("\u540e\u53f0\u8c03\u7528\u901a\u4fe1\u5931\u8d25", order.getOrderId(), "\u7528\u6237\u9000\u6b3e", "5");
            this.orderLogService.insertSelective("http res:" + httpClient.getResponseCode() + "," + httpClient.getErrInfo(), order.getOrderId(), "\u7528\u6237\u9000\u6b3e", "5");
        }
    }
}

