/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.weixin.controller;

import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.wap.weixin.util.WeiXinUtil;
import com.qianjiang.weixin.service.WXActivityService;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WeiXinGroupController {
    private static final String REDIRECT_ACTIVITY_HTML = "redirect:/activity.html";
    private AuthService authService;
    private WXActivityService wxActivityService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"wxUserActivity"})
    protected ModelAndView wxUserActivity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String code = request.getParameter("code");
        if (code == null) {
            return new ModelAndView(REDIRECT_ACTIVITY_HTML);
        }
        Auth auth = this.authService.findAuthByAuthType("8");
        if (auth != null) {
            String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + auth.getAuthClientId() + "&secret=" + auth.getAuthClientSecret() + "&code=" + code + "&grant_type=authorization_code";
            GetMethod getTokenMethod = new GetMethod(url);
            HttpClient clientToken = new HttpClient();
            getTokenMethod.getParams().setContentCharset("utf-8");
            String res = "";
            Map<String, String> resultMap = null;
            try {
                clientToken.executeMethod((HttpMethod)getTokenMethod);
                res = getTokenMethod.getResponseBodyAsString();
                resultMap = WeiXinUtil.getWeiToken(res);
                if (resultMap == null) {
                    try {
                        throw new NullPointerException();
                    }
                    catch (Exception e) {
                        OperaLogUtil.addOperaException((String)"Getting token failed!", (Exception)e, (HttpServletRequest)request);
                        return new ModelAndView(REDIRECT_ACTIVITY_HTML);
                    }
                }
                try {
                    if (this.wxActivityService.checkOpenIdExist(resultMap.get("openid"))) return new ModelAndView(REDIRECT_ACTIVITY_HTML);
                    this.wxActivityService.addWxUserIdToGroup(resultMap.get("openid"));
                    return new ModelAndView(REDIRECT_ACTIVITY_HTML);
                }
                catch (Exception e) {
                    OperaLogUtil.addOperaException((String)"add wxuser to group failed!", (Exception)e, (HttpServletRequest)request);
                    return new ModelAndView(REDIRECT_ACTIVITY_HTML);
                }
            }
            catch (Exception e) {
                OperaLogUtil.addOperaException((String)"Sending getwxtoken request failed!", (Exception)e, (HttpServletRequest)request);
                return new ModelAndView(REDIRECT_ACTIVITY_HTML);
            }
        } else {
            try {
                throw new NullPointerException();
            }
            catch (Exception e) {
                OperaLogUtil.addOperaException((String)"Getting WEIXIN set failed!", (Exception)e, (HttpServletRequest)request);
                return new ModelAndView(REDIRECT_ACTIVITY_HTML);
            }
        }
    }

    @RequestMapping(value={"/activity"})
    public ModelAndView toActivity() {
        return new ModelAndView("customer/activity");
    }

    public WXActivityService getWxActivityService() {
        return this.wxActivityService;
    }

    @Resource(name="wXActivityServicec")
    public void setWxActivityService(WXActivityService wxActivityService) {
        this.wxActivityService = wxActivityService;
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    @Resource(name="authService")
    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }
}

