/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.customer.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.freight.bean.SysLogisticsCompany;
import com.qianjiang.freight.service.SysLogisticsCompanyService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.util.KuaiDiUtil;
import com.qianjiang.wap.util.LoginUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CustomerLogisticsControllerM {
    private static final MyLogger LOGGER = new MyLogger(CustomerLogisticsControllerM.class);
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="SysLogisticsCompanyService")
    private SysLogisticsCompanyService sysLogisticsCompanyService;

    @RequestMapping(value={"/queryOrderLogisticsInfo"})
    public ModelAndView queryOrderLogisticsInfo(HttpServletRequest request, HttpServletResponse response, Long orderId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if (orderId != null) {
                    SysLogisticsCompany sysLogisticsCompany = this.sysLogisticsCompanyService.selectLogisticsCompanyInfoByOrderId(orderId);
                    if (sysLogisticsCompany != null) {
                        String kuaidi100Code = sysLogisticsCompany.getKuaidi100Code();
                        String expressNo = sysLogisticsCompany.getExpressNo();
                        String param = "{\"com\":\"" + kuaidi100Code + "\",\"num\":\"" + expressNo + "\"}";
                        List<Map<Object, Object>> logisticsInfo = KuaiDiUtil.getKuaiDiInfo4Firm(param);
                        if (logisticsInfo != null && !logisticsInfo.isEmpty()) {
                            mav.addObject("logisticsInfo", logisticsInfo);
                            mav.setViewName("customer/logistics_detail");
                            return this.seoService.getCurrSeo(mav);
                        }
                        mav.addObject("logisticsInfo", logisticsInfo);
                        mav.setViewName("customer/logistics_detail");
                        return this.seoService.getCurrSeo(mav);
                    }
                } else {
                    LOGGER.error("\u4f20\u9012\u7684\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7528\u6237id\u548c\u8ba2\u5355id\u67e5\u8be2\u7269\u6d41\u8be6\u60c5\u5931\u8d25");
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/queryExchangeOrderLogisticsInfo"})
    public ModelAndView queryExchangeOrderLogisticsInfo(HttpServletRequest request, HttpServletResponse response, Long backOrderId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                if (backOrderId != null) {
                    SysLogisticsCompany sysLogisticsCompany = this.sysLogisticsCompanyService.selectExchangeLogisticsInfoByOrderId(backOrderId);
                    if (sysLogisticsCompany != null) {
                        String kuaidi100Code = sysLogisticsCompany.getKuaidi100Code();
                        String expressNo = sysLogisticsCompany.getExpressNo();
                        String param = "{\"com\":\"" + kuaidi100Code + "\",\"num\":\"" + expressNo + "\"}";
                        List<Map<Object, Object>> logisticsInfo = KuaiDiUtil.getKuaiDiInfo4Firm(param);
                        if (logisticsInfo != null && !logisticsInfo.isEmpty()) {
                            mav.addObject("logisticsInfo", logisticsInfo);
                            mav.setViewName("customer/exchange_logistics_detail");
                            return this.seoService.getCurrSeo(mav);
                        }
                        mav.addObject("logisticsInfo", logisticsInfo);
                        mav.setViewName("customer/exchange_logistics_detail");
                        return this.seoService.getCurrSeo(mav);
                    }
                } else {
                    LOGGER.error("\u4f20\u9012\u7684\u9000\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else {
                mav = new ModelAndView("redirect:/loginm.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u9000\u5355id\u67e5\u8be2\u7269\u6d41\u8be6\u60c5\u5931\u8d25");
        }
        return this.seoService.getCurrSeo(mav);
    }
}

