/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.store.controller;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.mobile.service.MobCateBarService;
import com.qianjiang.store.service.StoreListService;
import com.qianjiang.system.mobile.bean.MobSiteBasic;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class StoreListStreetController {
    private static final String STATUS = "status";
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="storeListService")
    private StoreListService storeListService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="MobCateBarService")
    private MobCateBarService mobCateBarService;

    @RequestMapping(value={"/storeliststreet"})
    public ModelAndView storeliststreet(PageBean pb, HttpServletRequest request, Long cateId) {
        pb.setPageSize(20);
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        HashMap<String, Object> map = new HashMap<String, Object>();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        MobSiteBasic msb = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
        map.put("cateGory", this.storeListService.selectgoodscatebyone());
        map.put("channelAdvers", this.mobCateBarService.selectStoreListImage("1"));
        map.put("pb", this.storeListService.selectStoreList(pb, cateId, customerId));
        map.put("mobSiteBasic", msb);
        map.put("cateId", cateId);
        map.put("cateId", cateId);
        ModelAndView mav = new ModelAndView("store/store_street_new");
        mav.addObject("map", map);
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/ajaxStorelistStreet"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> ajaxStorelistStreet(PageBean pb, HttpServletRequest request, Long cateId) {
        pb.setPageSize(20);
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.storeListService.selectStoreList(pb, cateId, customerId));
        return map;
    }

    @RequestMapping(value={"/addcollectionsellerStore"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> addcollectionsellerStore(HttpServletRequest request, Long storeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            map.put(STATUS, 2);
            return map;
        }
        if (null != storeId && null != customerId && this.storeListService.selectController(storeId, customerId) > 0) {
            this.storeListService.deleteController(storeId, customerId);
            map.put(STATUS, 0);
            return map;
        }
        map.put(STATUS, this.storeListService.addCollectionSeller(customerId, storeId));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/storenewproduct"})
    public ModelAndView storenewproduct(Long storeId, PageBean pb) {
        pb.setPageSize(10);
        HashMap<String, PageBean> map = new HashMap<String, PageBean>();
        try {
            map.put("pb", this.storeListService.setStoreNewProcudtList(pb, storeId));
            ModelAndView mav = new ModelAndView("store/store_new_product");
            mav.addObject("map", map);
            ModelAndView modelAndView = this.seoService.getCurrSeo(mav);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }
}

