/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.weixin.bean;

import com.qianjiang.wap.other.bean.MD5Util;
import com.qianjiang.wap.other.bean.TenpayUtil;
import com.qianjiang.wap.weixin.util.Sha1Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseHandler {
    private static final String appkey = null;
    private static final String APPSIGNATURE = "AppSignature";
    private String key;
    private SortedMap parameters;
    private String debugInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String uriEncoding;
    private String k;

    public ResponseHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.key = "";
        this.parameters = new TreeMap();
        this.debugInfo = "";
        this.uriEncoding = "";
        Map m = this.request.getParameterMap();
        for (String ks : m.keySet()) {
            String v = ((String[])m.get(ks))[0];
            this.setParameter(ks, v);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getParameter(String parameter) {
        String s = (String)this.parameters.get(parameter);
        return null == s ? "" : s;
    }

    public void setParameter(String parameter, String parameterValue) {
        String v = "";
        if (null != parameterValue) {
            v = parameterValue.trim();
        }
        this.parameters.put(parameter, v);
    }

    public SortedMap getAllParameters() {
        return this.parameters;
    }

    public boolean isValidSign() {
        StringBuilder sb = new StringBuilder();
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String ks = (String)entry.getKey();
            String v = (String)entry.getValue();
            if ("sign".equals(ks) || null == v || "".equals(v)) continue;
            sb.append(ks + "=" + v + "&");
        }
        sb.append("key=9b65423e573b0baa90e882e7158270ce");
        String enc = TenpayUtil.getCharacterEncoding(this.request, this.response);
        String sign = MD5Util.MD5Encode(sb.toString(), enc).toLowerCase();
        String validSign = this.getParameter("sign").toLowerCase();
        this.setDebugInfo(sb.toString() + " => sign:" + sign + " ValidSign:" + validSign);
        return validSign.equals(sign);
    }

    public boolean isWXsign() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> signMap = new HashMap<String, String>();
        Set es = this.parameters.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String ks = (String)entry.getKey();
            String v = (String)entry.getValue();
            if ("SignMethod".equals(ks) || APPSIGNATURE.equals(ks)) continue;
            sb.append(ks + "=" + v + "&");
        }
        signMap.put("appkey", appkey);
        while (it.hasNext()) {
            String v = this.k;
            if (sb.length() == 0) {
                sb.append(this.k + "=" + v);
                continue;
            }
            sb.append("&" + this.k + "=" + v);
        }
        String sign = Sha1Util.getSha1(sb.toString()).toString().toLowerCase();
        this.setDebugInfo(sb.toString() + " => SHA1 sign:" + sign);
        return APPSIGNATURE.equals(sign);
    }

    public boolean isWXsignfeedback() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> signMap = new HashMap<String, String>();
        Set es = this.parameters.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String ks = (String)entry.getKey();
            String v = (String)entry.getValue();
            if ("SignMethod".equals(ks) || APPSIGNATURE.equals(ks)) continue;
            sb.append(ks + "=" + v + "&");
        }
        signMap.put("appkey", appkey);
        while (it.hasNext()) {
            String v = this.k;
            if (sb.length() == 0) {
                sb.append(this.k + "=" + v);
                continue;
            }
            sb.append("&" + this.k + "=" + v);
        }
        String sign = Sha1Util.getSha1(sb.toString()).toString().toLowerCase();
        this.setDebugInfo(sb.toString() + " => SHA1 sign:" + sign);
        return "App    Signature".equals(sign);
    }

    public void sendToCFT(String msg) throws IOException {
        String strHtml = msg;
        PrintWriter out = this.getHttpServletResponse().getWriter();
        out.println(strHtml);
        out.flush();
        out.close();
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public void setUriEncoding(String uriEncoding) throws UnsupportedEncodingException {
        if (!"".equals(uriEncoding.trim())) {
            this.uriEncoding = uriEncoding;
            String enc = TenpayUtil.getCharacterEncoding(this.request, this.response);
            for (String ks : this.parameters.keySet()) {
                String v = this.getParameter(ks);
                v = new String(v.getBytes(uriEncoding.trim()), enc);
                this.setParameter(ks, v);
            }
        }
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    protected void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    protected HttpServletResponse getHttpServletResponse() {
        return this.response;
    }
}

