/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.adaptation.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.domian.ApAdaptationDomainBean;
import com.yqbsoft.laser.html.facade.bm.repository.AdaptationRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ap/adaptation"})
public class AdaptationCon
extends SpringmvcController {
    private static String CODE = "ap.adaptation.con";
    @Autowired
    private AdaptationRepository adaptationRepository;

    protected String getContext() {
        return "adaptation";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(ApAdaptationDomainBean apAdaptationDomainBean) {
        if (null == apAdaptationDomainBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.adaptationRepository.saveAdaptation(apAdaptationDomainBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String adaptationId, ModelMap modelMap) {
        modelMap.put((Object)"apAdaptationReBean", (Object)this.getAdaptation(adaptationId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, ApAdaptationDomainBean apAdaptationDomainBean) {
        if (null == apAdaptationDomainBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.adaptationRepository.updateAdaptation(apAdaptationDomainBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String adaptationId) {
        if (StringUtils.isBlank((String)adaptationId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.adaptationRepository.deleteAdaptation(Integer.valueOf(Integer.parseInt(adaptationId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String adaptationId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)adaptationId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.adaptationRepository.updateAdaptationState(adaptationId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String adaptationId, ModelMap modelMap) {
        modelMap.put((Object)"apAdaptationReBean", (Object)this.getAdaptation(adaptationId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAdaptation(String adaptationId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)adaptationId)) {
            this.logger.error(CODE + ".view", (Object)"adaptationId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.adaptationRepository.getAdaptation(adaptationId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.adaptationRepository.queryAdaptationPage(param);
    }
}

