<#include '/layout/listHead.ftl' />
<table id="adaptationList"></table>
<div id="adaptationList_window" class="easyui-window" closed="true">
</div>
<div id="adaptationList_tb" style="padding:5px;height:auto">
	<div style="margin-bottom:5px">
		<a href="#" class="easyui-linkbutton" id="btnadd" iconCls="icon-add" plain="true" onclick="javascript:adaptationList_add('');" >新增</a>
		<a href="#" class="easyui-linkbutton" id="btnedit" iconCls="icon-edit" plain="true" onclick="javascript:adaptationList_edit('');">修改</a>
		<a href="#" class="easyui-linkbutton" id="btnremove" iconCls="icon-no" plain="true" onclick="javascript:adaptationList_remove('');">删除</a>
		<a href="#" class="easyui-linkbutton" id="btndisables" iconCls="icon-remove" plain="true" onclick="javascript:adaptationList_disables('');">停用</a>
		<a href="#" class="easyui-linkbutton" id="btnenable" iconCls="icon-ok" plain="true" onclick="javascript:adaptationList_enable('');">启用</a>
		<a href="#" class="easyui-linkbutton" id="btnmore" iconCls="icon-more" plain="true" onclick="javascript:adaptationList_more('');">查看</a>
	</div>
	<form name="adaptationList_searchform" method="post" action="" id ="adaptationList_searchform">
	<div>
		日期 : <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="startDate" style="width:100px">
		To: <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="endDate"  style="width:100px">
		名称: <input class="easyui-textbox" name="adaptationName"  style="width:100px">
		<a href="#" class="easyui-linkbutton" iconCls="icon-search" onclick="javascript:adaptationList_reload('');">查询</a>
	</div>
	</form>
</div>
<script type="text/javascript">
var _datagrid='adaptationList';
var _windowid='adaptationList_window';

function adaptationList_disables(dataObject){
	$('#btndisables').linkbutton('disable');
	if(!dataObject){
		dataObject = adaptationList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btndisables').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要停用？",function(data){
		if(data){
			var data=new Object();
			data.adaptationId=dataObject.adaptationId;
			data.dataState=0;
			data.oldDataState=1;
			common_ajax('stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btndisables').linkbutton('enable');
		}else{
			$('#btndisables').linkbutton('enable');
			return;
		}
	});
}

function adaptationList_enable(dataObject){
	$('#btnenable').linkbutton('disable');
	if(!dataObject){
		dataObject = adaptationList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnenable').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要启用？",function(data){
		if(data){
			var data=new Object();
			data.adaptationId=dataObject.adaptationId;
			data.dataState=1;
			data.oldDataState=0;
			common_ajax('stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnenable').linkbutton('enable');
		}else{
			$('#btnenable').linkbutton('enable');
			return;
		}
	});
}

function adaptationList_add(dataObject){
	common_window({
		id:_windowid,
		title:'新增',
		href:_sysAppContextPath+'/web/ap/adaptation/add'
	});
}
function adaptationList_getselected(){
	return $('#'+_datagrid).datagrid('getSelected');
}
function adaptationList_edit(dataObject){
	$('#btnedit').linkbutton('disable');
	if(!dataObject){
		dataObject = adaptationList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnedit').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'修改',
		iconCls:'icon-edit',
		href:_sysAppContextPath+'/web/ap/adaptation/edit?adaptationId='+dataObject.adaptationId
	});
	$('#btnedit').linkbutton('enable');
}
function adaptationList_more(dataObject){
	$('#btnmore').linkbutton('disable');
	if(!dataObject){
		dataObject = adaptationList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnmore').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'查看',
		iconCls:'icon-more',
		href:_sysAppContextPath+'/web/ap/adaptation/view?adaptationId='+dataObject.adaptationId
	});
	$('#btnmore').linkbutton('enable');
}
function adaptationList_remove(dataObject){
	$('#btnremove').linkbutton('disable');
	if(!dataObject){
		dataObject = adaptationList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnremove').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要删除？",function(data){
		if(data){
			var data=new Object();
			data.adaptationId=dataObject.adaptationId;
			common_ajax('delSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnremove').linkbutton('enable');
		}else{
			$('#btnremove').linkbutton('enable');
			return;
		}
	});
}
function adaptationList_search(dataObject){
	return common_formtojson('adaptationList_searchform');
}
function adaptationList_reload(dataObject){
	$('#'+_datagrid).datagrid('options').queryParams = adaptationList_search(dataObject);  
	$('#'+_datagrid).datagrid('reload');  
}

common_datagrid({
	id:_datagrid,
	url:'listQuery.json',
	btnaddFun:function(dataObject){
		adaptationList_add(dataObject);
	},btneditFun:function(dataObject){
		adaptationList_edit(dataObject);
	},btnremoveFun:function(dataObject){
		adaptationList_remove(dataObject);
	},btnmoreFun:function(dataObject){
		adaptationList_more(dataObject);
	},btnsearchFun:function(dataObject){
		adaptationList_search(dataObject);
	},
	divtoolbar:'#adaptationList_tb',
	columns:[[
            {field:'adaptationId',title:'ID',width:20},
            {field:'adaptationName',title:'名称',width:80},
            {field:'adaptationCode',title:'号码',width:40},
            {field:'adaptationRemark',title:'说明',width:80},
            {field:'dataState',title:'状态',width:80},
            {field:'gmtCreate',title:'创建日期',width:80},
            {field:'adaptationClob',title:'代码',width:250}
        ]]
})
</script>
<#include '/layout/listFoot.ftl' />
