/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.aftersale.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/entryContract/"})
public class EntryContractCon
extends SpringmvcController {
    private static String CODE = "devest.entryContract.con";
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;

    protected String getContext() {
        return "aftersale";
    }

    @RequestMapping(value={"entryContractlist"})
    public String loanservicelist(HttpServletRequest request, ModelMap modelMap, String projectCode, String inputState) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
            }
        }
        if (!StringUtils.isEmpty((String)inputState)) {
            param.put("inputState", Integer.parseInt(inputState));
        } else {
            param.put("inputState", 0);
        }
        param.put("tenantCode", user.getTenantCode());
        param.put("dataState", 1);
        SupQueryResult supPayments = this.paymentDetailsRepository.queryPaymentDetailsAndreserveUnit(param);
        List payments = supPayments.getList();
        for (Map map2 : payments) {
            String cacheStr = SupDisUtil.getMap((String)"EcoreDd-list", (String)("PaymentDetails-paymentDetailsType-" + map2.get("paymentDetailsType")));
            if (StringUtils.isEmpty((String)cacheStr)) {
                cacheStr = "";
            }
            map2.put("paymentDetailsTypeDesc", cacheStr);
        }
        modelMap.addAttribute("paramMap", (Object)param);
        modelMap.addAttribute("paymentDetails", (Object)payments);
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supPayments.getPageTools(), request));
        return this.getFtlTempPath(request) + "entryContractlist";
    }

    private void wrapper(List<SfDd> sfdds, List<Map<String, Object>> payments, String key, Set<String> userCodes) {
        String descKey = key + "Desc";
        String userCodeKey = "userCode";
        HashMap<String, String> ddMap = new HashMap<String, String>();
        for (SfDd sfDd : sfdds) {
            ddMap.put(sfDd.getDdCode(), sfDd.getDdValue());
        }
        for (Map map : payments) {
            map.put(descKey, ddMap.get(map.get(key)));
            if (!ListUtil.isEmpty(userCodes)) continue;
            userCodes.add(String.valueOf(map.get(userCodeKey)));
        }
    }

    public List<SfDd> queryDdList(String ddTable, String ddColumn) {
        List ddLists = this.ddRepository.queryDdList(ddTable, ddColumn);
        return ddLists;
    }

    @RequestMapping(value={"updateEntryContract.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean updateEntryContract(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null) {
            return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u6570\u636e");
        }
        if (param.get("contractNo") != null) {
            if (!this.updateContractNo(param, user, 2)) {
                return new HtmlJsonReBean("error", "\u5408\u540c\u7f16\u53f7\u4fee\u6539\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
            return new HtmlJsonReBean((Object)true);
        }
        return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u5408\u540c\u7f16\u53f7");
    }

    private boolean updateContractNo(Map<String, Object> param, UserSession user, Integer acceptMaterialState) {
        EstReserveUnitBean estReserveUnitBean = new EstReserveUnitBean();
        String contractNo = (String)param.get("contractNo");
        estReserveUnitBean.setSigningDate(DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        estReserveUnitBean.setContractNo(contractNo);
        estReserveUnitBean.setTenantCode(user.getTenantCode());
        estReserveUnitBean.setReserveUnitCode((String)param.get("reserveUnitCode"));
        boolean flag = this.reserveUnitRepository.updateReserveUnit(estReserveUnitBean);
        return flag;
    }
}

