/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.member.controller;

import com.yqbsoft.laser.html.common.service.HtmlIBaseService;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.bean.EstReport;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.IntentionRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReportRepository;
import com.yqbsoft.laser.html.facade.est.repository.TeamRepository;
import com.yqbsoft.laser.html.facade.mm.bean.MmMberextend;
import com.yqbsoft.laser.html.facade.mm.bean.VisitingReBean;
import com.yqbsoft.laser.html.facade.mm.repository.MmMberextendRepository;
import com.yqbsoft.laser.html.facade.mm.repository.VisitingRepository;
import com.yqbsoft.laser.html.facade.um.bean.UserBean;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/web/devest/mm/visiting"})
public class VisitingCon
extends SpringmvcController {
    @Autowired
    private TeamRepository teamRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Autowired
    private VisitingRepository visitingRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private IntentionRepository intentionRepository;
    @Autowired
    private MmMberextendRepository mmMberextendRepository;
    @Autowired
    private UserRepository userRepository;

    public VisitingCon() {
    }

    public VisitingCon(HtmlIBaseService htmlIBaseService) {
        this.htmlIBaseService = htmlIBaseService;
    }

    protected String getContext() {
        return "visiting";
    }

    @RequestMapping(value={"list"})
    public String listQuery(HttpServletRequest request, String startDate, String endDate, String memberPhone, String projectCode, ModelMap modelMap) {
        SupQueryResult supQueryResult;
        List results;
        UserSession userSession = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", userSession.getTenantCode());
        List projects = this.ptProjectRepository.getProjectByRole(userSession, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode) && ListUtil.isNotEmpty((Collection)projects)) {
                projectCode = (String)((Map)projects.get(0)).get("projectCode");
            }
        }
        if (StringUtils.isNotBlank((String)projectCode)) {
            param.put("opCode", projectCode);
        }
        if (ListUtil.isNotEmpty((Collection)(results = (supQueryResult = this.visitingRepository.getVisitingReBeanSupQueryResult(param, null, null, false)).getList()))) {
            HashSet<String> memberCodes = new HashSet<String>();
            HashSet<String> userCodes = new HashSet<String>();
            ArrayList<Map<String, Object>> visitings = new ArrayList<Map<String, Object>>();
            for (VisitingReBean visitingReBean : results) {
                HashMap visiting = new HashMap();
                try {
                    BeanUtils.copyAllPropertysNotNull(visiting, (Object)visitingReBean);
                    visitings.add(visiting);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                memberCodes.add(visitingReBean.getMemberCode());
                if (!StringUtils.isEmpty((String)visitingReBean.getOpRelative())) {
                    userCodes.add(visitingReBean.getOpRelative());
                    continue;
                }
                if (StringUtils.isEmpty((String)visitingReBean.getOpBillno())) continue;
                userCodes.add(visitingReBean.getOpBillno());
            }
            if (ListUtil.isNotEmpty(memberCodes)) {
                param.put("memberCodes", memberCodes);
                param.put("projectCode", projectCode);
                this.wrapperMbextendIntLevelInfo(param, visitings, memberCodes, projectCode);
                param.put("dataState", 1);
                this.wrapperReportInfo(param, visitings, memberCodes, projectCode);
            }
            if (ListUtil.isNotEmpty(userCodes)) {
                this.wrapperUsersInfo(param, visitings, userCodes);
            }
            modelMap.addAttribute("visitings", visitings);
        }
        modelMap.addAttribute("paramMap", (Object)param);
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return this.getFtlTempPath(request) + "visitinglist";
    }

    public void wrapperUsersInfo(Map<String, Object> param, List<Map<String, Object>> visitings, Set<String> userCodes) {
        List<UserBean> list = this.queryUserList(param, userCodes);
        HashMap<String, String> tkMap = new HashMap<String, String>();
        HashMap<String, String> zyMap = new HashMap<String, String>();
        for (UserBean userBean : list) {
            if ("0001001".equals(userBean.getRoleCode())) {
                tkMap.put(userBean.getUserCode(), userBean.getUserRelname());
                continue;
            }
            if (!"0001003".equals(userBean.getRoleCode())) continue;
            zyMap.put(userBean.getUserCode(), userBean.getUserRelname());
        }
        for (Map map : visitings) {
            map.put("tkUserName", tkMap.get(map.get("opRelative")));
            map.put("zyUserName", zyMap.get(map.get("opBillno")));
        }
    }

    public void wrapperReportInfo(Map<String, Object> param, List<Map<String, Object>> visitings, Set<String> memberCodes, String projectCode) {
        List<EstReport> reports = this.queryReportByMemberCodes(param, memberCodes, projectCode);
        HashMap<String, String> channelMap = new HashMap<String, String>();
        for (EstReport estReport : reports) {
            channelMap.put(estReport.getMemberCode(), SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstReport-cognitiveChannel-" + estReport.getCognitiveChannel())));
        }
        for (Map map : visitings) {
            map.put("channel", channelMap.get(map.get("memberCode")));
        }
    }

    public List<EstReport> queryReportByMemberCodes(Map<String, Object> param, Set<String> memberCodes, String projectCode) {
        SupQueryResult supQueryResult = this.reportRepository.queryReportPage(param);
        if (supQueryResult != null) {
            List list = supQueryResult.getList();
            return list;
        }
        return null;
    }

    public List<UserBean> queryUserList(Map<String, Object> param, Set<String> userCodes) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("userCodes", userCodes);
        Object obj = this.userRepository.queryUserList(map);
        if (obj != null) {
            List list = (List)obj;
            return list;
        }
        return null;
    }

    public void wrapperMbextendIntLevelInfo(Map<String, Object> param, List<Map<String, Object>> visitings, Set<String> memberCodes, String projectCode) {
        HashMap<String, String> intentionLevelMap = new HashMap<String, String>();
        List<MmMberextend> intentions = this.queryIntentionByMemberCodes(param, memberCodes, projectCode);
        for (MmMberextend mmMberextend : intentions) {
            intentionLevelMap.put(mmMberextend.getMerberCode(), mmMberextend.getMbextendIntLevel());
        }
        for (Map map : visitings) {
            map.put("mbextendIntLevel", intentionLevelMap.get(map.get("memberCode")));
        }
    }

    public List<MmMberextend> queryIntentionByMemberCodes(Map<String, Object> param, Set<String> memberCodes, String projectCode) {
        param.put("fuzzy", false);
        SupQueryResult supQueryResult = this.mmMberextendRepository.queryMberextendPage(param);
        if (supQueryResult != null) {
            List list = supQueryResult.getList();
            return list;
        }
        return null;
    }
}

