/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.project.domain.PtProjectStDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pt/projectSt"})
public class ProjectStCon
extends SpringmvcController {
    private static String CODE = "pt.projectSt.con";
    @Autowired
    private PtProjectRepository projectRepository;

    protected String getContext() {
        return "projectSt";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtProjectStDomain projectStBean) {
        if (null == projectStBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.saveProjectSt(projectStBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String stId, ModelMap modelMap) {
        modelMap.put((Object)"projectStReBean", (Object)this.getProjectSt(stId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtProjectStDomain projectStBean) {
        if (null == projectStBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateProjectSt(projectStBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String stId) {
        if (StringUtils.isBlank((String)stId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.deleteProjectSt(Integer.valueOf(Integer.parseInt(stId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String stId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)stId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateProjectStState(stId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String stId, ModelMap modelMap) {
        modelMap.put((Object)"projectStReBean", (Object)this.getProjectSt(stId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getProjectSt(String stId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)stId)) {
            this.logger.error(CODE + ".getProjectSt", (Object)"stId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.projectRepository.getProjectSt(Integer.valueOf(Integer.parseInt(stId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.projectRepository.queryProjectStPage(param);
    }
}

