/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.statistical.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.bean.EstReport;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReportRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/web/devest/statistical"})
public class StatisticalCon
extends SpringmvcController {
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private PtHouseRepository ptHouseRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private ReportRepository reportRepository;

    protected String getContext() {
        return "statistical";
    }

    @RequestMapping(value={"unsell/query"})
    public String unsellQuery(HttpServletRequest request, String projectCode, String type, String startDate, String endDate, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
                param.put("statistaclType", 1);
            }
        }
        param.put("unsell", true);
        List unlist = this.ptHouseRepository.queryUnSellStatistical(param);
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("startDate", "");
            param.put("endDate", "");
        }
        param.put("presell", true);
        List preList = this.ptHouseRepository.queryPreSellStatistical(param);
        param.remove("presell");
        if (ListUtil.isNotEmpty((Collection)preList)) {
            block0: for (Map pre : preList) {
                for (Map un : unlist) {
                    if (!pre.get("otherCode").equals(un.get("otherCode"))) continue;
                    pre.put("unsellHouseCount", un.get("unsellHouseCount"));
                    pre.put("unsellArea", un.get("unsellArea"));
                    pre.put("unsellSumPrice", un.get("unsellSumPrice"));
                    pre.put("averagePrice", un.get("averagePrice"));
                    pre.put("unsellPrecent", un.get("unsellPrecent"));
                    continue block0;
                }
            }
        }
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        modelMap.put((Object)"unSellList", (Object)preList);
        modelMap.put((Object)"paramMap", (Object)param);
        return this.getFtlTempPath(request) + "unsellQuery";
    }

    @RequestMapping(value={"selled/query"})
    public String selledQuery(HttpServletRequest request, String projectCode, String type, String startDate, String endDate, String[] dimension, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
                param.put("statistaclType", 1);
            }
        }
        param.put("presell", true);
        List preList = this.ptHouseRepository.queryPreSellStatistical(param);
        param.remove("presell");
        HashSet<String> otherCodes = new HashSet<String>();
        for (Map other : preList) {
            otherCodes.add((String)other.get("otherCode"));
        }
        if (StringUtils.isEmpty((String)projectCode)) {
            if (dimension == null) {
                dimension = new String[]{"1", "2"};
            }
        } else if (dimension == null) {
            dimension = new String[]{};
        }
        if (ListUtil.isNotEmpty(otherCodes) && dimension != null) {
            for (String dime : dimension) {
                if (Integer.valueOf(dime) == 1) {
                    this.queryUnSellStatistical(preList, param, startDate, endDate);
                }
                if (Integer.valueOf(dime) == 2) {
                    this.queryStatisticalSellTransRg(preList, otherCodes, user.getTenantCode(), param.get("statistaclType"), startDate, endDate);
                    this.queryStatisticalSellTransCj(preList, otherCodes, user.getTenantCode(), param.get("statistaclType"), startDate, endDate);
                }
                if (Integer.valueOf(dime) != 3) continue;
                this.queryStatisticalSellPayment(preList, otherCodes, user.getTenantCode(), param.get("statistaclType"), startDate, endDate);
            }
        }
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        param.put("dimension", dimension);
        modelMap.put((Object)"selledList", (Object)preList);
        modelMap.put((Object)"paramMap", (Object)param);
        return this.getFtlTempPath(request) + "selledQuery";
    }

    private List<Map<String, Object>> queryStatisticalSellTransRc(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("flowLinkType", "1");
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            block0: for (Map<String, Object> map : selleds) {
                for (Map tran : list) {
                    if (!map.get("otherCode").equals(tran.get("otherCode"))) continue;
                    map.put("rcHouseCount", tran.get("rcHouseCount"));
                    map.put("rcSellArea", tran.get("rcSellArea"));
                    map.put("rcSumPrice", tran.get("rcSumPrice"));
                    map.put("rcAveragePrice", tran.get("rcAveragePrice"));
                    continue block0;
                }
            }
        }
        return list;
    }

    private List<Map<String, Object>> queryStatisticalSellTransRg(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("flowLinkType", "2");
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            block0: for (Map<String, Object> map : selleds) {
                for (Map tran : list) {
                    if (!map.get("otherCode").equals(tran.get("otherCode"))) continue;
                    map.put("rgHouseCount", tran.get("rgHouseCount"));
                    map.put("rgSellArea", tran.get("rgSellArea"));
                    map.put("rgSumPrice", tran.get("rgSumPrice"));
                    map.put("rgAveragePrice", tran.get("rgAveragePrice"));
                    continue block0;
                }
            }
        }
        return list;
    }

    private List<Map<String, Object>> queryStatisticalSellTransCj(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("queryContractNo", true);
        param.put("flowLinkType", "3");
        param.put("otherCodes", otherCodes);
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            block0: for (Map<String, Object> map : selleds) {
                for (Map tran : list) {
                    if (!map.get("otherCode").equals(tran.get("otherCode"))) continue;
                    map.put("cjSellArea", tran.get("cjSellArea"));
                    map.put("cjHouseCount", tran.get("cjHouseCount"));
                    map.put("cjSumPrice", tran.get("cjSumPrice"));
                    map.put("cjAveragePrice", tran.get("cjAveragePrice"));
                    continue block0;
                }
            }
        }
        return list;
    }

    private List<Map<String, Object>> queryStatisticalSellPayment(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellPayment(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            block0: for (Map<String, Object> map : selleds) {
                for (Map pay : list) {
                    if (!map.get("otherCode").equals(pay.get("otherCode"))) continue;
                    map.put("qkHouseCount", pay.get("qkHouseCount"));
                    map.put("qkSellArea", pay.get("qkSellArea"));
                    map.put("qkSumPrice", pay.get("qkSumPrice"));
                    map.put("qkAveragePrice", pay.get("qkAveragePrice"));
                    map.put("ajHouseCount", pay.get("ajHouseCount"));
                    map.put("ajSellArea", pay.get("ajSellArea"));
                    map.put("ajSumPrice", pay.get("ajSumPrice"));
                    map.put("ajAveragePrice", pay.get("ajAveragePrice"));
                    continue block0;
                }
            }
        }
        return list;
    }

    private List<Map<String, Object>> queryUnSellStatistical(List<Map<String, Object>> preSells, Map<String, Object> param, String startDate, String endDate) {
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        } else {
            param.remove("endDate");
            param.remove("startDate");
        }
        param.put("unsell", true);
        List unsells = this.ptHouseRepository.queryUnSellStatistical(param);
        if (ListUtil.isNotEmpty((Collection)unsells)) {
            block0: for (Map<String, Object> map : preSells) {
                for (Map unsell : unsells) {
                    if (!map.get("otherCode").equals(unsell.get("otherCode"))) continue;
                    map.put("unsellHouseCount", unsell.get("unsellHouseCount"));
                    map.put("unsellArea", unsell.get("unsellArea"));
                    map.put("unsellSumPrice", unsell.get("unsellSumPrice"));
                    map.put("unSellAveragePrice", unsell.get("unSellAveragePrice"));
                    map.put("unsellPrecent", unsell.get("unsellPrecent"));
                    continue block0;
                }
            }
        }
        return preSells;
    }

    @RequestMapping(value={"selled/details"})
    public String selledDetails(HttpServletRequest request, String startDate, String endDate, String memberPhone, String projectCode, ModelMap modelMap) {
        SupQueryResult supResult;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        param.put("order", true);
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
            }
        }
        if ((supResult = this.reserveUnitRepository.queryStatisticalSellDetails(param)) != null) {
            List list = supResult.getList();
            if (ListUtil.isNotEmpty((Collection)list)) {
                HashSet<String> memberCodes = new HashSet<String>();
                for (Map member : list) {
                    memberCodes.add((String)member.get("memberCode"));
                }
                HashMap<String, Serializable> paramReport = new HashMap<String, Serializable>();
                paramReport.put("memberCodes", memberCodes);
                paramReport.put("dataState", Integer.valueOf(1));
                List reports = this.reportRepository.getReportList(paramReport);
                HashMap<String, String> zyMap = new HashMap<String, String>();
                HashMap<String, String> tkMap = new HashMap<String, String>();
                for (EstReport report : reports) {
                    if ("0001001".equals(report.getRoleCode())) {
                        tkMap.put(report.getMemberCode(), report.getReportUname());
                        continue;
                    }
                    if (!"0001003".equals(report.getRoleCode())) continue;
                    zyMap.put(report.getMemberCode(), report.getReportUname());
                }
                for (Map member : list) {
                    member.put("zyUserName", tkMap.get(member.get("memberCode")));
                    member.put("tkUserName", tkMap.get(member.get("memberCode")));
                }
            }
            modelMap.put((Object)"sellDetails", (Object)list);
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supResult.getPageTools(), request));
        }
        modelMap.put((Object)"paramMap", (Object)param);
        return this.getFtlTempPath(request) + "selledDetails";
    }

    @RequestMapping(value={"sell/all"})
    public String sellAll(HttpServletRequest request, String startDate, String endDate, String memberPhone, String projectCode, ModelMap modelMap) {
        return "";
    }

    public static void main(String[] args) {
        DecimalFormat format = new DecimalFormat();
        format.applyPattern("#.00");
        System.out.println(format.format(1122222.2751));
    }
}

