/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.transaction.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitMemberBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.bean.SfDdReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.repository.DdCacheRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitMemberRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/print-preview"})
public class PrintPreviewCon
extends SpringmvcController {
    @Autowired
    ReserveUnitRepository reserveUnitRepository;
    @Autowired
    ReserveUnitMemberRepository reserveUnitMemberRepository;
    @Autowired
    DdCacheRepository ddCacheRepository;

    @ResponseBody
    @RequestMapping(value={"contract/form"}, produces={"application/xml;charset=utf-8"})
    public String getContractForm(HttpServletRequest request, String reserveUnitCode) throws IOException {
        if (StringUtils.isBlank((String)reserveUnitCode)) {
            return "";
        }
        String tempTxt = "";
        String filePath = "/META-INF/templet/contract_form.html";
        URL fileURL = PrintPreviewCon.class.getResource(filePath);
        if (fileURL != null) {
            InputStream inputStream = PrintPreviewCon.class.getResourceAsStream(filePath);
            tempTxt = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            Map<String, Object> resultMap = this.getReserveUnit(request, reserveUnitCode);
            tempTxt = this.forSetKeyValueByString(tempTxt, resultMap);
        }
        return tempTxt;
    }

    private String forSetKeyValueByString(String context, Map<String, Object> resultMap) {
        if (resultMap == null || resultMap.size() <= 0) {
            return "";
        }
        try {
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                System.out.println("key= " + entry.getKey() + " and value= " + entry.getValue());
                context = context.replaceFirst("#" + entry.getKey() + "#", String.valueOf(entry.getValue()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        context = context.replaceAll("\\#(.*?)\\#", "");
        return context;
    }

    private Map<String, Object> getReserveUnit(HttpServletRequest request, String reserveUnitCode) {
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String discountTypeTag;
            List reserveUnitMembers;
            EstReserveUnitReBean reserveUnit = this.reserveUnitRepository.getReserveUnitByCode(reserveUnitCode, userSession.getTenantCode());
            if (reserveUnit != null) {
                if (reserveUnit.getDeposit() != null) {
                    resultMap.put("deposit", reserveUnit.getDeposit());
                    resultMap.put("depositUppercase", PrintPreviewCon.digitUppercase(String.valueOf(reserveUnit.getDeposit())));
                }
                if (reserveUnit.getClinchDealUnitPrice() != null) {
                    resultMap.put("clinchDealUnitPrice", reserveUnit.getClinchDealUnitPrice());
                }
                if (reserveUnit.getTotalTransactionPrice() != null) {
                    int i;
                    resultMap.put("totalTransactionPrice", reserveUnit.getTotalTransactionPrice());
                    String ttPriceStr = PrintPreviewCon.digitUppercase(String.valueOf(reserveUnit.getTotalTransactionPrice()));
                    Object priceStrArray = ttPriceStr.toCharArray();
                    int j = 0;
                    for (i = 0; i <= 6; ++i) {
                        Object c = priceStrArray[i];
                        if (c != 19975 && c != 20191 && c != 20336 && c != 25342) {
                            resultMap.put("ttPrice" + j, Character.valueOf((char)priceStrArray[i]));
                            ++j;
                            continue;
                        }
                        if (c != 25342) continue;
                        resultMap.put("ttPrice" + j, "\u96f6");
                        ++j;
                    }
                    for (i = 0; i <= 6; ++i) {
                        if (resultMap.containsKey("ttPrice" + i)) continue;
                        resultMap.put("ttPrice" + i, "\u96f6");
                    }
                }
                if (StringUtils.isNotBlank((String)reserveUnit.getContractArea())) {
                    resultMap.put("contractArea", reserveUnit.getContractArea());
                }
            }
            if (ListUtil.isNotEmpty((Collection)(reserveUnitMembers = this.reserveUnitMemberRepository.getReserveUnitMemberList(reserveUnit.getReserveUnitCode())))) {
                for (EstReserveUnitMemberBean reserveUnitMember : reserveUnitMembers) {
                    if (!reserveUnitMember.getMembership().equals(0)) continue;
                    resultMap.put("memberName", reserveUnitMember.getMemberName());
                    resultMap.put("memberAddr", reserveUnitMember.getMemberAddr());
                    resultMap.put("memberPhone", reserveUnitMember.getMemberPhone());
                    resultMap.put("identityCardNumber", reserveUnitMember.getIdentityCardNumber());
                }
            }
            reserveUnit.setPaymentDetails(reserveUnit.getEstPaymentDetails());
            if (StringUtils.isNotBlank((String)reserveUnit.getHouseCode())) {
                HouseReBean houseReBean = this.reserveUnitRepository.getHouse(reserveUnit.getHouseCode(), null, reserveUnit.getTenantCode());
                if (houseReBean != null) {
                    if (houseReBean.getPrivateArea() != null) {
                        resultMap.put("privateArea", houseReBean.getPrivateArea());
                    }
                    if (houseReBean.getPublicArea() != null) {
                        resultMap.put("publicArea", houseReBean.getPublicArea());
                    }
                }
                String houseTag = this.getHouseTag(reserveUnit);
                resultMap.put("houseTag", houseTag);
            }
            if (StringUtils.isNotBlank((String)reserveUnit.getDiscountTypeCode()) && (discountTypeTag = this.getDiscountTypeTag(reserveUnit.getDiscountTypeCode())) != null) {
                reserveUnit.setDiscountTypeTag(discountTypeTag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultMap;
    }

    private String getHouseTag(EstReserveUnitReBean reserveUnitReBean) {
        String houseTag = "";
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getBuildingNumber())) {
            houseTag = houseTag + reserveUnitReBean.getBuildingNumber();
        }
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getUnitNumber())) {
            houseTag = houseTag + reserveUnitReBean.getUnitNumber();
        }
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getRoomNumber())) {
            houseTag = houseTag + reserveUnitReBean.getRoomNumber();
        }
        return houseTag;
    }

    private String getDiscountTypeTag(String discountTypeCode) {
        List ddReBeanList = this.ddCacheRepository.queryDdList("EstReserveUnit", "discountTypeCode", "", "up");
        if (ddReBeanList == null || ddReBeanList.size() <= 0) {
            return null;
        }
        for (SfDdReBean sfDdReBean : ddReBeanList) {
            if (sfDdReBean == null || !sfDdReBean.getDdCode().equals(discountTypeCode)) continue;
            return sfDdReBean.getDdValue();
        }
        return null;
    }

    public static String digitUppercase(String num) throws Exception {
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[] unit1 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
        String[] unit2 = new String[]{"\u5143", "\u4e07", "\u4ebf", "\u4e07\u4ebf"};
        BigDecimal bigDecimal = new BigDecimal(num);
        bigDecimal = bigDecimal.multiply(new BigDecimal(100));
        String strVal = String.valueOf(bigDecimal.toBigInteger());
        String head = strVal.substring(0, strVal.length() - 2);
        String end = strVal.substring(strVal.length() - 2);
        String endMoney = "";
        String headMoney = "";
        if ("00".equals(end)) {
            endMoney = "";
        } else {
            if (!end.substring(0, 1).equals("0")) {
                endMoney = endMoney + digit[Integer.valueOf(end.substring(0, 1))] + "\u89d2";
            } else if (end.substring(0, 1).equals("0") && !end.substring(1, 2).equals("0")) {
                endMoney = endMoney + "\u96f6";
            }
            if (!end.substring(1, 2).equals("0")) {
                endMoney = endMoney + digit[Integer.valueOf(end.substring(1, 2))] + "\u5206";
            }
        }
        char[] chars = head.toCharArray();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        boolean zeroKeepFlag = false;
        int vidxtemp = 0;
        for (int i = 0; i < chars.length; ++i) {
            int idx = (chars.length - 1 - i) % 4;
            int vidx = (chars.length - 1 - i) / 4;
            String s = digit[Integer.valueOf(String.valueOf(chars[i]))];
            if (!"\u96f6".equals(s)) {
                headMoney = headMoney + s + unit1[idx] + unit2[vidx];
                zeroKeepFlag = false;
            } else if (i == chars.length - 1 || map.get("zero" + vidx) != null) {
                headMoney = headMoney + "";
            } else {
                headMoney = headMoney + s;
                zeroKeepFlag = true;
                map.put("zero" + vidx, true);
            }
            if (vidxtemp != vidx || i == chars.length - 1) {
                headMoney = headMoney.replaceAll(unit2[vidx], "");
                headMoney = headMoney + unit2[vidx];
            }
            if (!zeroKeepFlag || (chars.length - 1 - i) % 4 != 0) continue;
            headMoney = headMoney.replaceAll("\u96f6", "");
        }
        return headMoney + endMoney;
    }

    protected String getContext() {
        return null;
    }
}

