<#include '/layout/Head.ftl' />
				<div class="page_content">
					<#if house?exists>
						<div class="list_form">
							<div class="small_field">
								<div class="row">
									<div class="col-md-12">
										<label>房号：</label>
										<input type="text" class="inline_200" readonly name="houseName" value="${house.houseName}"/>
										<input type="hidden" class="inline_200" name="houseCode" value="${house.houseCode}"/>
									</div>
								</div>
							</div>
							<div class="small_field">
								<div class="row">
									<div class="col-md-8">
										<label>户型：</label>
										<input type="text" class="inline_200" readonly name="houseStyle" value="<#if house.houseStyle?exists>${house.houseStyle}</#if>"/>
									</div>
								</div>
							</div>
							<div class="small_field">
								<div class="row">
									<div class="col-md-8">
										<label>面积：</label>
										<input type="text" class="inline_200" readonly name="totalArea" value="<#if house.totalArea?exists>${house.totalArea}</#if>"/>(㎡)
									</div>
								</div>
							</div>
							<div class="small_field">
								<div class="row">
									<div class="col-md-8">
										<label>表价：</label>
										<input type="text" class="inline_200" name="averagePrice"  value="<#if house.averagePrice?exists>${house.averagePrice}</#if>"/>(元)
									</div>
								</div>
							</div>
							<div class="small_field">
								<div class="row">
									<div class="col-md-8">
									<label>底价：</label>
										<input type="text" class="inline_200" name="minPrice"  value="<#if house.minPrice?exists>${house.minPrice}</#if>"/>(元)
									</div>
								</div>
							</div>
							<input type="hidden" name="tenantCode" id="tenantCode" value="${house.tenantCode!!}"/>
							<input type="hidden" name="oldDataState" value="${house.dataState}"/>
							<div class="small_field">
								<div class="row">
										<div style="float:left;margin-left:15px;margin-top:8px;">
										<label>状态：&nbsp;</label>
										</div>
										<div class="col-sm-8 control-label">
										<select name="dataState"s style="width:59%" onchange="changeHint(this)">
										<#if (house.memo == '1')>
										<!--有订单-->
											<#if (house.dataState == 1)>
												<option value="1">认筹</option>
											<#elseif (house.dataState == 2)>
												<option value="2">认购</option>
											<#elseif (house.dataState == 3)>
												<option value="3">已售</option>
											<#else>
												<option value="0" <#if (house.dataState == 0)> selected</#if>>可售</option>
												<option value="4" <#if (house.dataState == 4)> selected</#if>>保留</option>
												<option value="1">认筹</option>
												<option value="2">认购</option>
												<option value="3">已售</option>
											</#if>
										<#else>
												<!--无订单-->
												<option value="0" <#if (house.dataState == 0)> selected</#if>>可售</option>
												<option value="4" <#if (house.dataState == 4)> selected</#if>>保留</option>
												<option value="1" <#if (house.dataState == 1)> selected</#if>>认筹</option>
												<option value="2" <#if (house.dataState == 2)> selected</#if>>认购</option>
												<option value="3" <#if (house.dataState == 3)> selected</#if>>已售</option>
										</#if>
										</select>
										</div>
										
								</div>
							</div>
							<p class="align-center">
								<button type="button" class="button bg_blue" onclick="submitUpdate(this);">保存</button>&nbsp;&nbsp;
								<!--<button type="button" class="button bg_blue">重置</button>-->
							</p>
						</div>
						</#if>
					</div>
					
					
<script>
			function changeHint(obj){
				//alert('您所选的状态为：'+(obj.options[obj.selectedIndex].text));
			}
			/*提交修改*/
			function submitUpdate(obj){
				obj.disabled=true;
				var houseCode=$("input[name='houseCode']").val();
				var houseName=$("input[name='houseName']").val();
				var houseStyle=$("input[name='houseStyle']").val();
				var totalArea=$("input[name='totalArea']").val();
				var averagePrice=$("input[name='averagePrice']").val();
				var dataState=$("select[name='dataState']").val();
				var oldDataState=$("input[name='oldDataState']").val();
				var tenantCode=$("input[name='tenantCode']").val();
				var minPrice=$("input[name='minPrice']").val();
				
				if((!checkNull(averagePrice,'表价'))||(!checkNum(averagePrice,'表价'))){
					return false;
				}
				if((!checkNull(minPrice,'底价'))||(!checkNum(minPrice,'底价'))){
					return false;
				}
				var jsonData = {"houseCode":houseCode,"houseName":houseName, "houseStyle":houseStyle,"totalArea":totalArea,"averagePrice":averagePrice,"dataState":dataState,"oldDataState":oldDataState,"tenantCode":tenantCode,"minPrice":minPrice};
				$.ajax({
					type: "POST",
		            contentType: "application/json; charset=utf-8",
		            dataType: "json",
		            url: "${sysAppContextPath}/web/pt/house/dev/updateHouse.json",
		          	data: JSON.stringify(jsonData),
		            success: function (data) {
		            	if(data.success == true && data.sysRecode == 'success'){
		            		parent.location.reload(); 
		            		parent.layer.close(parent.layer.getFrameIndex(window.name));
		            	}else {
		                	alert(data.msg);
		                	return false;
		            	}
		             },
		             error: function (data) {
		                  alert(data.msg)
		                  return false;
		             }
		         });
			}
			
			/*非空校验*/
			function checkNull(obj,msg){
				if(obj == null||obj == ''){
       				alert("请输入："+msg);
       				return false;
       			}
       			return true;
			}
			
			/*3位小数校验*/
			function checkNum(obj,msg){
       			var reg = new RegExp("^[0-9]+(.[0-9]{1,3})?$");
				if(!reg.test(obj)){
   			 		alert(msg+":请输入非零数,最多保留3位小数!");
   				 	return false;
    			}
    			return true;
  			}
</script>