/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.achieve.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstCustomerCapitalReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReport;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitMemberBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.domain.EstCommissionDomain;
import com.yqbsoft.laser.html.facade.est.domain.EstCommissionReDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.CustomerCapitalRepository;
import com.yqbsoft.laser.html.facade.est.repository.EstCommissionRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReportRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitMemberRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.mm.bean.MmMerber;
import com.yqbsoft.laser.html.facade.mm.repository.MmMemberRepository;
import com.yqbsoft.laser.html.facade.um.bean.UserBean;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.handler.config.SubordinateCodeHandler;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.transaction.bean.TradeCustomers;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/achieve/"})
public class AchieveCon
extends SpringmvcController {
    private static String CODE = "devest.achieve.con";
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private CustomerCapitalRepository customerCapitalRepository;
    @Resource
    private PtHouseRepository ptHouseRepository;
    @Resource
    private ReportRepository reportRepository;
    @Resource
    private ReserveUnitMemberRepository reserveUnitMemberRepository;
    @Resource
    private MmMemberRepository mmMemberRepository;
    @Resource
    private SubordinateCodeHandler subordinateCodeHandler;
    @Resource
    private EstCommissionRepository estCommissionRepository;

    protected String getContext() {
        return "achieve";
    }

    @RequestMapping(value={"list"})
    public String loanservicelist(HttpServletRequest request, ModelMap modelMap, String projectCode, String inputState, String findType) {
        return this.loanservicelist2(request, modelMap, projectCode, inputState, findType);
    }

    public String loanservicelist2(HttpServletRequest request, ModelMap modelMap, String projectCode, String inputState, String findType) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        String userCode = user.getUserCode();
        String tenantCode = user.getTenantCode();
        this.findHandler(modelMap, findType, userCode, tenantCode, param);
        this.getFirstProjectCode(request, param);
        param.put("reserveDataState", 1);
        param.put("capitalType", 5);
        param.put("membership", 0);
        if (!param.containsKey("dataExamState")) {
            param.put("dataExamState", 0);
        }
        param.put("dataExamStateAble", true);
        param.put("order", true);
        SupQueryResult customerCapitalOrRes = this.customerCapitalRepository.queryCustomerCapitalOrRes(param);
        if (customerCapitalOrRes != null && ListUtil.isNotEmpty((Collection)customerCapitalOrRes.getList())) {
            List list = customerCapitalOrRes.getList();
            HashSet<String> zyUserCodes = new HashSet<String>();
            for (HashMap<String, Object> map : list) {
                if (!map.containsKey("zyUserCode")) continue;
                String zyUserCode = String.valueOf(map.get("zyUserCode"));
                zyUserCodes.add(zyUserCode);
            }
            if (ListUtil.isNotEmpty(zyUserCodes)) {
                HashMap<String, Object> map;
                map = new HashMap<String, Object>();
                map.put("userCodes", zyUserCodes);
                List users = (List)this.userRepository.queryUserList(map);
                map.clear();
                for (UserBean userTemp : users) {
                    map.put(userTemp.getUserCode(), userTemp.getUserRelname());
                }
                if (MapUtil.isNotEmpty(map)) {
                    for (Map mapTemp : list) {
                        mapTemp.put("zyUserName", map.get(mapTemp.get("zyUserCode")));
                    }
                }
            }
            modelMap.put((Object)"tradeCustomerList", (Object)list);
            modelMap.addAttribute("pageTools", (Object)this.buildPage(customerCapitalOrRes.getPageTools(), request));
        }
        modelMap.put((Object)"paramMap", (Object)param);
        modelMap.put((Object)"projects", this.queryProjects(request));
        modelMap.put((Object)"projectCode", param.get("projectCode"));
        return String.valueOf(this.getFtlTempPath(request)) + "achieve_exam";
    }

    private void findHandler(ModelMap modelMap, String findType, String userCode, String tenantCode, Map<String, Object> param) {
        if (StringUtils.isNotBlank((String)findType)) {
            this.subordinateCodeHandler.wrapperSubordinateUserCode(userCode, tenantCode, findType, param);
            if (modelMap != null) {
                modelMap.put((Object)"findType", (Object)findType);
            }
        }
    }

    private void queryReserveUnitByPhone(Map<String, Object> parmMap, String projectCode, String tenantCode) {
        String phoneNo = (String)parmMap.get("likeVal");
        if (StringUtils.isBlank((String)phoneNo)) {
            return;
        }
        MmMerber mmMerber = this.mmMemberRepository.getMerberByAllPhone(phoneNo, tenantCode);
        if (mmMerber == null) {
            return;
        }
        String memberCode = mmMerber.getMerberCode();
        SupQueryResult reserveUnitMemberSupQueryResult = this.reserveUnitMemberRepository.getReserveUnitMemberByCode(memberCode, 2, projectCode, tenantCode);
        if (reserveUnitMemberSupQueryResult == null || reserveUnitMemberSupQueryResult.getRows() == null || reserveUnitMemberSupQueryResult.getRows().size() <= 0) {
            return;
        }
        ArrayList<String> reserveUnitCodes = new ArrayList<String>();
        for (EstReserveUnitMemberBean reserveUnitMember : reserveUnitMemberSupQueryResult.getRows()) {
            reserveUnitCodes.add(reserveUnitMember.getReserveUnitCode());
        }
        if (reserveUnitCodes != null && reserveUnitCodes.size() > 0) {
            parmMap.put("reserveUnitCodes", reserveUnitCodes);
        }
    }

    public List<Map<String, String>> queryProjects(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        List list = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        return list;
    }

    public void getFirstProjectCode(HttpServletRequest request, Map<String, Object> parmMap) {
        UserSession user = this.getUserSession(request);
        String projectCode = (String)parmMap.get("projectCode");
        if (StringUtils.isNotBlank((String)projectCode)) {
            return;
        }
        List list = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (list != null && list.size() > 0) {
            for (Map map : list) {
                Iterator iterator = map.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                parmMap.put("projectCode", entry.getValue());
                return;
            }
        }
    }

    public SupQueryResult<TradeCustomers> ssignmentaReserveUnitTradingClient(SupQueryResult<EstReserveUnitReBean> supQueryResult) {
        if (supQueryResult == null || supQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        ArrayList<TradeCustomers> tradeCustomerss = new ArrayList<TradeCustomers>();
        for (EstReserveUnitReBean reserveUnitReBean : supQueryResult.getRows()) {
            TradeCustomers tradeCustomers = new TradeCustomers();
            if (reserveUnitReBean.getDataExamState() != null) {
                tradeCustomers.setDataExamState(reserveUnitReBean.getDataExamState());
            }
            tradeCustomers.setReserveUnitCode(reserveUnitReBean.getReserveUnitCode());
            tradeCustomers.setReserveUnit((EstReserveUnitBean)reserveUnitReBean);
            if (reserveUnitReBean.getEstReserveUnitMember() != null) {
                tradeCustomers.setMemberName(reserveUnitReBean.getEstReserveUnitMember().getMemberName());
                tradeCustomers.setMemberPhone(reserveUnitReBean.getMemberPhone());
            }
            if (reserveUnitReBean.getEstFlowLink() != null) {
                tradeCustomers.setFlowLinkType(reserveUnitReBean.getEstFlowLinkLast().getFlowLinkType());
                tradeCustomers.setAuditDate(reserveUnitReBean.getEstFlowLink().getAuditDate());
                tradeCustomers.setOperationType(reserveUnitReBean.getEstFlowLink().getOperationType());
            }
            if (reserveUnitReBean.getEstFlowLinkLast() != null) {
                tradeCustomers.setFlowLinkTypeLast(reserveUnitReBean.getEstFlowLinkLast().getFlowLinkType());
                tradeCustomers.setFlowLinkType(reserveUnitReBean.getEstFlowLinkLast().getFlowLinkType());
                tradeCustomers.setApprovalStatus(reserveUnitReBean.getEstFlowLinkLast().getApprovalStatus());
                tradeCustomers.setFlowLinkCode(reserveUnitReBean.getEstFlowLinkLast().getFlowLinkCode());
                tradeCustomers.setOperationType(reserveUnitReBean.getEstFlowLinkLast().getOperationType());
            }
            tradeCustomers.setHouseTag(this.getHouseTag(reserveUnitReBean));
            tradeCustomers.setReserveUnitType(reserveUnitReBean.getReserveUnitType());
            tradeCustomerss.add(tradeCustomers);
            tradeCustomers.setFlowLinkTotal(reserveUnitReBean.getFlowLinkTotal());
            tradeCustomers.setGmtCreate(reserveUnitReBean.getGmtCreate());
            tradeCustomers.setGmtModified(reserveUnitReBean.getGmtModified());
            tradeCustomers.setDataState(reserveUnitReBean.getDataState());
            tradeCustomers.setProjectCode(reserveUnitReBean.getProjectCode());
            tradeCustomers.setRemark(reserveUnitReBean.getRemark());
            EstReport estReport = this.reportRepository.getReportByCode("reportCode", (Object)reserveUnitReBean.getReportCode(), reserveUnitReBean.getProjectCode(), null);
            if (estReport == null) continue;
            tradeCustomers.setUserName(estReport.getReportUname());
        }
        SupQueryResult tradeCustomersSupQueryResult = new SupQueryResult();
        tradeCustomersSupQueryResult.setRows(tradeCustomerss);
        tradeCustomersSupQueryResult.setList(tradeCustomerss);
        tradeCustomersSupQueryResult.setPageTools(supQueryResult.getPageTools());
        tradeCustomersSupQueryResult.setTotal(supQueryResult.getTotal());
        return tradeCustomersSupQueryResult;
    }

    private String getHouseTag(EstReserveUnitReBean reserveUnitReBean) {
        String houseTag = "";
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getBuildingNumber())) {
            houseTag = String.valueOf(houseTag) + reserveUnitReBean.getBuildingNumber();
        }
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getUnitNumber())) {
            houseTag = String.valueOf(houseTag) + reserveUnitReBean.getUnitNumber();
        }
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getRoomNumber())) {
            houseTag = String.valueOf(houseTag) + reserveUnitReBean.getRoomNumber();
        }
        return houseTag;
    }

    private void wrapper(List<SfDd> sfdds, List<Map<String, Object>> payments, String key, Set<String> userCodes) {
        String descKey = String.valueOf(key) + "Desc";
        String userCodeKey = "userCode";
        HashMap<String, String> ddMap = new HashMap<String, String>();
        for (SfDd sfDd : sfdds) {
            ddMap.put(sfDd.getDdCode(), sfDd.getDdValue());
        }
        for (Map map : payments) {
            map.put(descKey, ddMap.get(map.get(key)));
            if (!ListUtil.isEmpty(userCodes)) continue;
            userCodes.add(String.valueOf(map.get(userCodeKey)));
        }
    }

    public List<SfDd> queryDdList(String ddTable, String ddColumn) {
        List ddLists = this.ddRepository.queryDdList(ddTable, ddColumn);
        return ddLists;
    }

    @RequestMapping(value={"examCommit.json"})
    @ResponseBody
    public HtmlJsonReBean examCommit(HttpServletRequest request, String reserveUnitCode, String dataExamRemark, Integer dataExamState) {
        if (StringUtils.isBlank((String)dataExamRemark)) {
            return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u610f\u89c1");
        }
        UserSession user = this.getUserSession(request);
        String tenantCode = user.getTenantCode();
        EstReserveUnitReBean reserveUnit = this.reserveUnitRepository.getReserveUnitByCode(reserveUnitCode, tenantCode);
        if (reserveUnit != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("reserveUnitCode", reserveUnitCode);
            map.put("capitalType", 5);
            map.put("dataExamRemark", dataExamRemark);
            map.put("dataExamState", dataExamState);
            Boolean success = this.customerCapitalRepository.updateTransforCommission(map);
            if (success.booleanValue()) {
                String jjrTenantCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-devbroker-jjrTenantCode");
                if (StringUtils.isEmpty((String)jjrTenantCode)) {
                    jjrTenantCode = "10000002";
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("reserveUnitCode", reserveUnitCode);
                param.put("tenantCode", jjrTenantCode);
                param.put("capitalType", 5);
                String brokerUserCode = "";
                SupQueryResult customerCapitalResult = this.customerCapitalRepository.queryCustomerCapitalPage(param);
                if (customerCapitalResult != null && ListUtil.isNotEmpty((Collection)customerCapitalResult.getList())) {
                    List list = customerCapitalResult.getList();
                    brokerUserCode = ((EstCustomerCapitalReBean)list.get(0)).getUserCode();
                    EstCommissionReDomain commission = this.estCommissionRepository.getCommissionByCode(null, "10000002", brokerUserCode);
                    if (commission != null) {
                        BigDecimal commissionAmount = commission.getCommissionAmount();
                        commissionAmount = commissionAmount.add(((EstCustomerCapitalReBean)list.get(0)).getShouldReceivables());
                        commission.setCommissionAmount(commissionAmount);
                        return this.estCommissionRepository.updateCommission((EstCommissionDomain)commission);
                    }
                    if (StringUtils.isNotBlank((String)brokerUserCode)) {
                        EstCommissionDomain estCommissionDomain = new EstCommissionDomain();
                        estCommissionDomain.setCommissionAmount(((EstCustomerCapitalReBean)list.get(0)).getShouldReceivables());
                        estCommissionDomain.setTenantCode(jjrTenantCode);
                        estCommissionDomain.setUserCode(brokerUserCode);
                        return this.estCommissionRepository.saveCommission(estCommissionDomain);
                    }
                } else {
                    this.logger.error(String.valueOf(CODE) + ".examCommit", (Object)"\u672a\u83b7\u53d6\u5230\u8d44\u91d1\u8bb0\u5f55");
                }
            } else {
                this.logger.error(String.valueOf(CODE) + ".examCommit", (Object)"\u4f63\u91d1\u4fee\u6539\u5931\u8d25");
            }
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5ba1\u6838\u5931\u8d25");
        }
        return new HtmlJsonReBean("error", "\u8be5\u7b14\u8ba2\u5355\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
    }
}

