/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.aftersale.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/aftersale/"})
public class AftersaleCon
extends SpringmvcController {
    private static final String LOANWAY_KEY = "loanWay";
    private static final String PAYMENTDETAILS_KEY = "PaymentDetails";
    private static final String ACCEPTHANDLESTATE_KEY = "acceptHandleState";
    private static final String ACCEPTMATERIALSTATE_KEY = "acceptMaterialState";
    private static final String CACHEKEY = "PaymentDetails-loanWay-";
    private static final String CACHEENTITY = "EcoreDd-list";
    private static String CODE = "devest.aftersale.con";
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private PtBuildingRepository ptBuildingRepository;

    protected String getContext() {
        return "aftersale";
    }

    @RequestMapping(value={"loanservicelist"})
    public String loanservicelist(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        if (param.get(LOANWAY_KEY) == null) {
            param.put(LOANWAY_KEY, "2");
        }
        HashMap paramMap = new HashMap();
        paramMap.put(LOANWAY_KEY, param.get(LOANWAY_KEY));
        String cacheStr = SupDisUtil.getMap((String)CACHEENTITY, (String)(CACHEKEY + param.get(LOANWAY_KEY)));
        param.put(LOANWAY_KEY, cacheStr);
        param.put("tenantCode", user.getTenantCode());
        param.put("dataState", 1);
        param.put("membership", 0);
        SupQueryResult supPayments = this.paymentDetailsRepository.queryPaymentDetailsAndreserveUnit(param);
        HashSet<String> userCodes = new HashSet<String>();
        List<SfDd> acceptHandleState = this.queryDdList(PAYMENTDETAILS_KEY, ACCEPTHANDLESTATE_KEY);
        List<SfDd> acceptMaterialState = this.queryDdList(PAYMENTDETAILS_KEY, ACCEPTMATERIALSTATE_KEY);
        List shangDynastyBanks = this.ddRepository.getDisList("PaymentDetails-shangDynastyBank");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 0);
        map.put("tenantCode", user.getTenantCode());
        SupQueryResult queryBuildingResult = this.ptBuildingRepository.queryBuildingPage2(map, true, false);
        if (queryBuildingResult != null && ListUtil.isNotEmpty((Collection)queryBuildingResult.getList())) {
            List list = queryBuildingResult.getList();
            modelMap.addAttribute("buildings", (Object)list);
        }
        if (supPayments != null && ListUtil.isNotEmpty((Collection)supPayments.getList())) {
            List payments = supPayments.getList();
            for (Map entry : payments) {
                String shangDynastyBank = SupDisUtil.getMap((String)CACHEENTITY, (String)("PaymentDetails-shangDynastyBank-" + entry.get("shangDynastyBankCode")));
                if (!StringUtils.isNotBlank((String)shangDynastyBank)) continue;
                entry.put("shangDynastyBank", shangDynastyBank);
            }
            this.wrapper(acceptHandleState, payments, ACCEPTHANDLESTATE_KEY, userCodes);
            this.wrapper(acceptMaterialState, payments, ACCEPTMATERIALSTATE_KEY, userCodes);
            this.userRepository.assemblyUserRelname(userCodes, payments);
            modelMap.addAttribute("paymentDetails", (Object)payments);
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supPayments.getPageTools(), request));
        }
        paramMap.put("acceptHandleStateList", acceptHandleState);
        paramMap.put("acceptMaterialStateList", acceptMaterialState);
        paramMap.put("shangDynastyBankList", shangDynastyBanks);
        paramMap.put("handleStateSelect", param.get(ACCEPTHANDLESTATE_KEY));
        paramMap.put("materialStateSelect", param.get(ACCEPTMATERIALSTATE_KEY));
        paramMap.put("bankSelect", param.get("shangDynastyBankCode"));
        paramMap.put("memberPhone", param.get("memberPhone"));
        paramMap.put("buildingCode", param.get("buildingCode"));
        modelMap.addAttribute("paramMap", paramMap);
        return String.valueOf(this.getFtlTempPath(request)) + "loanservicelist";
    }

    private void wrapper(List<SfDd> sfdds, List<Map<String, Object>> payments, String key, Set<String> userCodes) {
        String descKey = String.valueOf(key) + "Desc";
        String userCodeKey = "userCode";
        HashMap<String, String> ddMap = new HashMap<String, String>();
        for (SfDd sfDd : sfdds) {
            ddMap.put(sfDd.getDdCode(), sfDd.getDdValue());
        }
        for (Map map : payments) {
            map.put(descKey, ddMap.get(map.get(key)));
            if (!ListUtil.isEmpty(userCodes)) continue;
            userCodes.add(String.valueOf(map.get(userCodeKey)));
        }
    }

    public List<SfDd> queryDdList(String ddTable, String ddColumn) {
        List ddLists = this.ddRepository.queryDdList(ddTable, ddColumn);
        return ddLists;
    }

    @RequestMapping(value={"updateloanservice.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean updateloanservice(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null) {
            return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u6570\u636e");
        }
        param.put("acceptUserCode", user.getUserCode());
        param.put("acceptUserName", user.getUserRelname());
        param.put("tenantCode", user.getTenantCode());
        param.put("dataState", 0);
        Boolean success = this.paymentDetailsRepository.updatePaymentDetailsAcceptHandle(param);
        if (success.booleanValue()) {
            return new HtmlJsonReBean((Object)success);
        }
        return new HtmlJsonReBean("error", "\u6536\u6750\u4fe1\u606f\u4fee\u6539\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
    }

    @RequestMapping(value={"updateAcceptService.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean updateAcceptService(HttpServletRequest request, String shangDynastyBankCode) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null) {
            return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u6570\u636e");
        }
        if (StringUtils.isNotBlank((String)shangDynastyBankCode)) {
            String shangDynastyBank = SupDisUtil.getMap((String)CACHEENTITY, (String)("PaymentDetails-shangDynastyBank-" + shangDynastyBankCode));
            param.put("shangDynastyBank", shangDynastyBank);
        }
        param.put("acceptUserCode", user.getUserCode());
        param.put("acceptUserName", user.getUserRelname());
        param.put("tenantCode", user.getTenantCode());
        param.put("dataState", 0);
        Boolean success = this.paymentDetailsRepository.updatePaymentDetailsAcceptHandle(param);
        if (success.booleanValue()) {
            return new HtmlJsonReBean((Object)success);
        }
        return new HtmlJsonReBean("error", "\u53d7\u7406\u529e\u8d37\u4fe1\u606f\u4fee\u6539\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
    }

    private boolean updateContractNo(Map<String, Object> param, UserSession user, Integer acceptMaterialState) {
        EstReserveUnitBean estReserveUnitBean = new EstReserveUnitBean();
        String contractNo = (String)param.get("contractNo");
        if (acceptMaterialState != 1) {
            estReserveUnitBean.setSigningDate(DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        estReserveUnitBean.setContractNo(contractNo);
        estReserveUnitBean.setTenantCode(user.getTenantCode());
        estReserveUnitBean.setReserveUnitCode((String)param.get("reserveUnitCode"));
        boolean flag = this.reserveUnitRepository.updateReserveUnit(estReserveUnitBean);
        return flag;
    }
}

