/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.aftersale.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstCustomerCapitalReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.CustomerCapitalRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/entryContract/"})
public class EntryContractCon
extends SpringmvcController {
    private static String CODE = "devest.entryContract.con";
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private CustomerCapitalRepository customerCapitalRepository;
    @Resource
    private PtHouseRepository ptHouseRepository;

    protected String getContext() {
        return "aftersale";
    }

    @RequestMapping(value={"entryContractlist"})
    public String loanservicelist(HttpServletRequest request, ModelMap modelMap, String projectCode, String inputState) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
            }
        }
        if (!StringUtils.isEmpty((String)inputState)) {
            param.put("inputState", Integer.parseInt(inputState));
        } else {
            param.put("inputState", 0);
        }
        String tenantCode = user.getTenantCode();
        param.put("tenantCode", tenantCode);
        param.put("dataState", 1);
        param.put("membership", 0);
        SupQueryResult supPayments = this.paymentDetailsRepository.queryPaymentDetailsAndreserveUnit(param);
        List payments = supPayments.getList();
        ArrayList<String> houseCodes = new ArrayList<String>();
        for (Map map2 : payments) {
            houseCodes.add(String.valueOf(map2.get("houseCode")));
            String cacheStr = SupDisUtil.getMap((String)"EcoreDd-list", (String)("PaymentDetails-paymentDetailsType-" + map2.get("paymentDetailsType")));
            if (StringUtils.isEmpty((String)cacheStr)) {
                cacheStr = "";
            }
            map2.put("paymentDetailsTypeDesc", cacheStr);
        }
        if (ListUtil.isNotEmpty(houseCodes)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("houseCodes", houseCodes);
            map.put("tenantCode", tenantCode);
            SupQueryResult houseResult = this.ptHouseRepository.queryHousePageSup(map, false, false);
            HashMap<String, Date> houseHandoverDateMap = new HashMap<String, Date>();
            if (houseResult != null && ListUtil.isNotEmpty((Collection)houseResult.getList())) {
                List list = houseResult.getList();
                for (HouseReBean house : list) {
                    houseHandoverDateMap.put(house.getHouseCode(), house.getHouseHandoverDate());
                }
            }
            if (MapUtil.isNotEmpty(houseHandoverDateMap)) {
                for (Map temp : payments) {
                    if (houseHandoverDateMap.get(String.valueOf(temp.get("houseCode"))) != null) {
                        temp.put("houseHandoverDate", DateUtil.getDateString((Date)((Date)houseHandoverDateMap.get(String.valueOf(temp.get("houseCode")))), (String)"yyyy-MM-dd"));
                    }
                    temp.put("signingDate", DateUtil.getDateString((String)String.valueOf(temp.get("signingDate")), (String)"yyyy-MM-dd"));
                }
            }
        }
        modelMap.addAttribute("paramMap", (Object)param);
        modelMap.addAttribute("paymentDetails", (Object)payments);
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supPayments.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "entryContractlist";
    }

    private void wrapper(List<SfDd> sfdds, List<Map<String, Object>> payments, String key, Set<String> userCodes) {
        String descKey = String.valueOf(key) + "Desc";
        String userCodeKey = "userCode";
        HashMap<String, String> ddMap = new HashMap<String, String>();
        for (SfDd sfDd : sfdds) {
            ddMap.put(sfDd.getDdCode(), sfDd.getDdValue());
        }
        for (Map map : payments) {
            map.put(descKey, ddMap.get(map.get(key)));
            if (!ListUtil.isEmpty(userCodes)) continue;
            userCodes.add(String.valueOf(map.get(userCodeKey)));
        }
    }

    public List<SfDd> queryDdList(String ddTable, String ddColumn) {
        List ddLists = this.ddRepository.queryDdList(ddTable, ddColumn);
        return ddLists;
    }

    @RequestMapping(value={"updateEntryContract.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean updateEntryContract(HttpServletRequest request) {
        Integer channel;
        UserSession user = this.getUserSession(request);
        String tenantCode = user.getTenantCode();
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null || param.get("contractNo") == null || param.get("reserveUnitCode") == null || param.get("houseHandoverDate") == null) {
            return new HtmlJsonReBean("error", "\u8bf7\u8f93\u5165\u6570\u636e");
        }
        String reserveUnitCode = String.valueOf(param.get("reserveUnitCode"));
        if (!this.updateContractNo(param, user, 2)) {
            return new HtmlJsonReBean("error", "\u5408\u540c\u7f16\u53f7\u4fee\u6539\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        EstReserveUnitReBean reserveUnit = this.reserveUnitRepository.getReserveUnitByCode(reserveUnitCode, user.getTenantCode());
        String houseCode = reserveUnit.getHouseCode();
        this.updateHouseHandoverDate(houseCode, param.get("houseHandoverDate"), tenantCode);
        if (reserveUnit != null && (channel = reserveUnit.getChannel()) != null) {
            channel.intValue();
        }
        return new HtmlJsonReBean((Object)true);
    }

    private boolean updateContractNo(Map<String, Object> param, UserSession user, Integer acceptMaterialState) {
        EstReserveUnitBean estReserveUnitBean = new EstReserveUnitBean();
        String contractNo = (String)param.get("contractNo");
        String signingDate = (String)param.get("signingDate");
        if (StringUtils.isBlank((String)signingDate)) {
            signingDate = DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        estReserveUnitBean.setSigningDate(signingDate);
        estReserveUnitBean.setContractNo(contractNo);
        estReserveUnitBean.setTenantCode(user.getTenantCode());
        estReserveUnitBean.setReserveUnitCode((String)param.get("reserveUnitCode"));
        boolean flag = this.reserveUnitRepository.updateReserveUnit(estReserveUnitBean);
        return flag;
    }

    private boolean updateHouseHandoverDate(String houseCode, Object houseHandoverDate, String tenantCode) {
        return this.ptHouseRepository.updateHouseHandoverDate(houseCode, houseHandoverDate, tenantCode);
    }

    private boolean updateCommissionState(String reserveUnitCode) {
        List capitals;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitCode", reserveUnitCode);
        map.put("reserveUnitType", 9);
        map.put("dataState", 0);
        SupQueryResult capitalResult = this.customerCapitalRepository.queryCustomerCapitalPage(map);
        if (capitalResult != null && ListUtil.isNotEmpty((Collection)capitalResult.getList()) && (capitals = capitalResult.getList()) != null && capitals.size() == 1) {
            EstCustomerCapitalReBean capital = (EstCustomerCapitalReBean)capitals.get(0);
            Boolean success = this.customerCapitalRepository.updateCustomerCapitalState(capital.getCustomerCapitalId(), Integer.valueOf(1), Integer.valueOf(0));
            if (success.booleanValue()) {
                this.logger.info(String.valueOf(CODE) + "updateCommissionState", (Object)("\u5408\u540c\u5f55\u5165\u64cd\u4f5c\uff0c\u4f63\u91d1\u72b6\u6001\u4fee\u6539\u6210\u529f\uff0c\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a" + capital.getReserveUnitCode()));
                return true;
            }
            this.logger.error(String.valueOf(CODE) + "updateCommissionState", (Object)("\u5408\u540c\u5f55\u5165\u64cd\u4f5c\uff0c\u4f63\u91d1\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a" + capital.getReserveUnitCode()));
            return false;
        }
        this.logger.error(String.valueOf(CODE) + "updateCommissionState", (Object)("\u5408\u540c\u5f55\u5165\u64cd\u4f5c\uff0c\u4f63\u91d1\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff0c\u672a\u627e\u5230\u8be5\u7b14\u8ba2\u5355\uff0c\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a" + reserveUnitCode));
        return false;
    }
}

