/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.basic.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.domian.ImsgImsgReDomainBean;
import com.yqbsoft.laser.html.facade.bm.repository.ImsgRspository;
import com.yqbsoft.laser.html.facade.bm.repository.PushImsgHandler;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/web/est/basic"})
public class EstateBasicCon
extends SpringmvcController {
    @Autowired
    private ImsgRspository imsgRspository;
    @Resource
    private PushImsgHandler pushImsgHandler;

    protected String getContext() {
        return "basic";
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
    }

    @RequestMapping(value={"dev/sys/list"}, method={RequestMethod.GET})
    public String list(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        Map map = HtmlUtil.buildPage((HttpServletRequest)request);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.imsgRspository.queryImsgPage(map);
        modelMap.addAttribute("imsglist", (Object)supQueryResult.getList());
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"dev/sys/sendmessage_get"}, method={RequestMethod.GET})
    public String redirectSendMessage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        return String.valueOf(this.getFtlTempPath(request)) + "sendMsg";
    }

    @RequestMapping(value={"dev/sys/sendmessage_post"}, method={RequestMethod.POST})
    public String sendMessage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, ImsgImsgReDomainBean imsgImsgBean) {
        UserSession user = this.getUserSession(request);
        String imsgType = imsgImsgBean.getImsgType();
        if (StringUtils.isNotBlank((String)imsgType) && "1".equals(imsgType)) {
            imsgImsgBean.setImsgSuserCode("sys");
            imsgImsgBean.setImsgSuserName("sys");
            imsgImsgBean.setImsgAuserCode(user.getTenantCode());
            imsgImsgBean.setImsgAuserName(user.getTenantCode());
        }
        imsgImsgBean.setTenantCode(user.getTenantCode());
        imsgImsgBean.setImsgCheckFlag("1");
        String imsgCode = this.imsgRspository.saveImsgReturn(imsgImsgBean);
        if (StringUtils.isNotBlank((String)imsgCode)) {
            HashMap<String, String> contentMap = new HashMap<String, String>();
            contentMap.put("content", imsgImsgBean.getImsgContent());
            contentMap.put("url", "/web/ex/imsg/pushmsg/sysMsgByMsgCode");
            contentMap.put("code", imsgCode);
            this.pushMessage(imsgImsgBean.getImsgSuserCode(), imsgImsgBean.getImsgSuserName(), imsgImsgBean.getImsgAuserCode(), imsgImsgBean.getImsgAuserName(), user.getTenantCode(), "11", DateUtils.getDateStr((String)"yyyy-MM-dd HH:mm:ss"), "\u7cfb\u7edf\u901a\u77e5", contentMap, "0", "0");
        }
        return String.valueOf(this.getFtlTempPath(request)) + "sendMsg";
    }

    public void pushMessage(String suserCode, String suserName, String auserCode, String auserName, String tenantCode, String businessObject, String pushSendDate, String subject, Map<String, String> contentMap, String pushmsgJpushType, String mnslistSource) {
        this.pushImsgHandler.pushTeam(suserCode, suserName, auserCode, auserName, tenantCode, businessObject, pushSendDate, subject, contentMap, pushmsgJpushType, mnslistSource);
    }
}

