/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.capital.controller;

import com.yqbsoft.laser.api.LaserRequest;
import com.yqbsoft.laser.api.request.SaveParticipantFromByRefundRequest;
import com.yqbsoft.laser.api.request.SavePyamentToPteFormRequest;
import com.yqbsoft.laser.api.request.SendOpenMerberFormRequest;
import com.yqbsoft.laser.api.response.SaveParticipantFromByRefundResponse;
import com.yqbsoft.laser.api.response.SavePyamentToPteFormResponse;
import com.yqbsoft.laser.api.response.SendOpenMerberFormResponse;
import com.yqbsoft.laser.html.capital.bean.OpenMerber;
import com.yqbsoft.laser.html.constants.EstateConstants;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.datadictionary.bean.DdFalgSettingReBean;
import com.yqbsoft.laser.html.facade.bm.datadictionary.repository.DdFalgSettingRepository;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstCustomerCapitalReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReceivablesRecordBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReceivablesRecordReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitMemberBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.bean.PaymentDetailsReBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.CustomerCapitalRepository;
import com.yqbsoft.laser.html.facade.est.repository.EstReceivablesRecordRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitMemberRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.handler.config.CapitalArrivalHandler;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/web/devest/capital/"})
public class CapitalCon
extends SpringmvcController {
    private static String CODE = "devest.capital.con";
    private static final String RESERVEUNITCODEKEY = "reserveUnitCode";
    private static final String CACHEKEY = "EstReserveUnit-paymentMethod-";
    private static final String CACHEENTITY = "EcoreDd-list";
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private CustomerCapitalRepository customerCapitalRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private EstReceivablesRecordRepository estReceivablesRecordRepository;
    @Resource
    private CapitalArrivalHandler capitalArrivalHandler;
    @Resource
    private DdFalgSettingRepository ddFalgSettingRepository;
    @Resource
    private ReserveUnitMemberRepository reserveUnitMemberRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private PtBuildingRepository ptBuildingRepository;
    private Object UUIDLock = new Object();

    protected String getContext() {
        return "capital";
    }

    private Set<String> appendFlowLinkTypeParam(Map<String, Object> param) {
        HashSet<String> flowLinkTypes = new HashSet<String>();
        param.put("approvalStatus", 2);
        if (param.get("handleType") == null) {
            if (param.get("customerCapitalCode") == null) {
                flowLinkTypes.add("1");
                flowLinkTypes.add("2");
                flowLinkTypes.add("3");
            }
        } else if ("1".equals(param.get("handleType"))) {
            flowLinkTypes.add("1");
            flowLinkTypes.add("2");
            flowLinkTypes.add("3");
        } else if ("2".equals(param.get("handleType"))) {
            flowLinkTypes.add("4");
            flowLinkTypes.add("5");
            flowLinkTypes.add("6");
        }
        return flowLinkTypes;
    }

    @RequestMapping(value={"customercapitallist/{reserveUnitType}"})
    public String customercapitallist(HttpServletRequest request, @PathVariable(value="reserveUnitType") String reserveUnitType, String projectCode, ModelMap modelMap) {
        List projects;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        Set<String> flowLinkTypes = this.appendFlowLinkTypeParam(param);
        if (ListUtil.isNotEmpty(flowLinkTypes)) {
            param.put("flowLinkTypes", flowLinkTypes);
        }
        if (ListUtil.isNotEmpty((Collection)(projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false)))) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                projectCode = String.valueOf(((Map)projects.get(0)).get("projectCode"));
                param.put("projectCode", projectCode);
            }
        }
        if ("3".equals(reserveUnitType) || "4".equals(reserveUnitType)) {
            param.put("capitalType", reserveUnitType);
            param.put("needPaymentDetails", true);
        } else {
            if ("1".equals(reserveUnitType)) {
                param.put("capitalType", reserveUnitType);
            } else if ("2".equals(reserveUnitType)) {
                param.put("capitalType", reserveUnitType);
            }
            if (param.containsKey("paymentDetailsType")) {
                param.remove("paymentDetailsType");
            }
        }
        param.put("notReserveDataState", -1);
        param.put("order", true);
        param.put("membership", 0);
        if (param.containsKey("reserveUnitType")) {
            param.remove("reserveUnitType");
        }
        SupQueryResult sup = this.customerCapitalRepository.queryCustomerCapitalOrRes(param);
        param.put("reserveUnitType", reserveUnitType);
        List capitals = sup.getList();
        HashSet<String> set = new HashSet<String>();
        HashSet<String> customerCapitalCodes = new HashSet<String>();
        if (ListUtil.isNotEmpty((Collection)capitals)) {
            for (HashMap<String, Object> map : capitals) {
                set.add(String.valueOf(map.get(RESERVEUNITCODEKEY)));
                customerCapitalCodes.add(String.valueOf(map.get("customerCapitalCode")));
            }
            if (ListUtil.isNotEmpty(set)) {
                HashMap<String, Object> map;
                map = new HashMap<String, Object>();
                map.put("reserveUnitCodes", set);
                SupQueryResult supPays = this.paymentDetailsRepository.queryPaymentDetailsPage(map);
                List list = supPays.getList();
                map.clear();
                for (PaymentDetailsReBean pdb : list) {
                    map.put(pdb.getReserveUnitCode(), pdb.getPaymentDetailsType());
                }
                map.put("customerCapitalCodes", customerCapitalCodes);
                this.wrapperWaitPaymentParam(map);
                Map waitMap = this.estReceivablesRecordRepository.countWaitPaymentRecord(map);
                boolean waitMapFlag = false;
                if (MapUtil.isNotEmpty((Map)waitMap)) {
                    waitMapFlag = !waitMapFlag;
                }
                for (Map map2 : capitals) {
                    String cacheStr = SupDisUtil.getMap((String)CACHEENTITY, (String)("PaymentDetails-paymentDetailsType-" + map.get(map2.get(RESERVEUNITCODEKEY))));
                    if (StringUtils.isEmpty((String)cacheStr)) {
                        cacheStr = "";
                    }
                    map2.put("paymentDetailsTypeDesc", cacheStr);
                    if (!waitMapFlag) continue;
                    map2.put("waitPaymentCount", waitMap.get(map2.get("customerCapitalCode")));
                }
            }
            modelMap.addAttribute("paymentDetails", (Object)capitals);
            modelMap.addAttribute("pageTools", (Object)this.buildPage(sup.getPageTools(), request));
        }
        List receivablesMethods = this.ddRepository.getDisList("EstCustomerCapital-receivablesMethod");
        modelMap.addAttribute("receivablesMethods", (Object)receivablesMethods);
        if (param.get("handleType") == null || "".equals(param.get("handleType"))) {
            param.put("handleType", "1");
        }
        param.put("paymentDetailsTypeSelect", this.ddRepository.getDisList("PaymentDetails-paymentDetailsType"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCode", projectCode);
        map.put("dataState", 0);
        map.put("tenantCode", user.getTenantCode());
        SupQueryResult queryBuildingResult = this.ptBuildingRepository.queryBuildingPage2(map, true, false);
        if (queryBuildingResult != null && ListUtil.isNotEmpty((Collection)queryBuildingResult.getList())) {
            List list = queryBuildingResult.getList();
            modelMap.addAttribute("buildings", (Object)list);
        }
        boolean capitalModel = this.hasCapitalSimpleModel();
        modelMap.addAttribute("capitalModel", (Object)capitalModel);
        modelMap.addAttribute("paramMap", (Object)param);
        return String.valueOf(this.getFtlTempPath(request)) + "customercapitallist";
    }

    private void wrapperWaitPaymentParam(Map<String, Object> map) {
        map.put("dataState", 0);
        map.put("receivablesType", "1");
        map.put("ptradeSeqnoIsnotnull", true);
    }

    @RequestMapping(value={"commitWaitArrival"})
    public String queryWaitCapitalPayment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String receivablesRecordCode, String tenantCode) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (!this.hasCapitalSimpleModel()) {
            boolean failure = false;
            StringBuffer absUrl = new StringBuffer();
            if (MapUtil.isNotEmpty((Map)param)) {
                String symbol_1 = "?";
                String symbol_2 = "&";
                for (Map.Entry item : param.entrySet()) {
                    if (absUrl.length() == 0) {
                        absUrl.append(symbol_1);
                    } else {
                        absUrl.append(symbol_2);
                    }
                    absUrl.append(String.valueOf((String)item.getKey()) + "=" + item.getValue().toString());
                }
                if (absUrl.length() == 0) {
                    failure = !failure;
                }
            } else {
                boolean bl = failure = !failure;
            }
            if (failure) {
                return null;
            }
            String cashierUrl = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", String.valueOf(this.getTenantCode()) + "-pay-cashier_PAYMENTLINE");
            cashierUrl = String.valueOf(cashierUrl) + absUrl.toString();
            return this.waitLinePay(request, modelMap, cashierUrl, receivablesRecordCode, tenantCode);
        }
        this.simpleNotify("PAYMENTLINE", receivablesRecordCode, tenantCode);
        try {
            response.sendRedirect(String.valueOf(this.getRequestservice(request)) + request.getContextPath() + "/web/devest/capital/customercapitallist/1");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(value={"capitalcalllist"})
    public String capitalcalllist(HttpServletRequest request, ModelMap modelMap, String projectCode) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("beyondDay", 0);
        param.put("tenantCode", user.getTenantCode());
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
            }
        }
        param.put("dataState", 0);
        SupQueryResult sup = this.customerCapitalRepository.queryCustomerCapitalOrRes(param);
        List capitals = sup.getList();
        if (ListUtil.isNotEmpty((Collection)capitals)) {
            List<SfDd> acceptHandleState = this.queryDdList("CustomerCapital", "hasArrival");
            Set<String> reserveUnitCodes = this.wrapper(acceptHandleState, capitals, "hasArrival");
            if (ListUtil.isNotEmpty(reserveUnitCodes)) {
                List pays;
                HashMap<String, Set<String>> mapReserveUnitCode = new HashMap<String, Set<String>>();
                mapReserveUnitCode.put("reserveUnitCodes", reserveUnitCodes);
                SupQueryResult supPay = this.paymentDetailsRepository.queryPaymentDetailsPage(mapReserveUnitCode);
                if (supPay != null && ListUtil.isNotEmpty((Collection)(pays = supPay.getList()))) {
                    HashMap<String, String> strMap = new HashMap<String, String>();
                    for (PaymentDetailsReBean payment : pays) {
                        strMap.put(payment.getReserveUnitCode(), payment.getLoanWay());
                    }
                    for (Map map : capitals) {
                        map.put("loanWay", strMap.get(map.get(RESERVEUNITCODEKEY)));
                    }
                }
            }
            modelMap.addAttribute("paymentDetails", (Object)capitals);
            modelMap.addAttribute("pageTools", (Object)this.buildPage(sup.getPageTools(), request));
        }
        modelMap.addAttribute("paramMap", (Object)param);
        return String.valueOf(this.getFtlTempPath(request)) + "capitalcalllist";
    }

    private EstReceivablesRecordReBean saveReceivablesRecordReWrapper(UserSession user, EstReceivablesRecordReBean estReceivablesRecordReBean, BigDecimal alreadyReceivables) {
        estReceivablesRecordReBean.setUserCode(user.getUserCode());
        estReceivablesRecordReBean.setUserName(user.getUserRelname());
        estReceivablesRecordReBean.setTenantCode(user.getTenantCode());
        estReceivablesRecordReBean.setPreviousOperationAmount(alreadyReceivables);
        EstReceivablesRecordReBean record = this.estReceivablesRecordRepository.saveReceivablesRecordRe(estReceivablesRecordReBean);
        return record;
    }

    private boolean hasCapitalSimpleModel() {
        String capitalModel = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", "00000000-capital-capitalModel");
        this.logger.info(String.valueOf(CODE) + "hasCapitalSimpleModel\u5230\u8d26\u9000\u6b3e\u4f7f\u7528\u6a21\u5f0f", (Object)capitalModel);
        return !"yqb".equals(capitalModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"capitalHandleArrivalRefund"}, method={RequestMethod.POST})
    public String capitalHandleArrival(HttpServletRequest request, HttpServletResponse response, String page, String rows, String projectCode, String buildingCode, String handleType, EstReceivablesRecordReBean estReceivablesRecordReBean, RedirectAttributes attr, ModelMap modelMap) {
        EstCustomerCapitalReBean customerCapital;
        block15: {
            if (StringUtils.isNotBlank((String)page)) {
                page = page.replaceAll(",", "");
            }
            if (StringUtils.isNotBlank((String)rows)) {
                rows = rows.replaceAll(",", "");
            }
            UserSession user = this.getUserSession(request);
            String tenantCode = user.getTenantCode();
            customerCapital = this.getCustomerCapitalByCode(user.getTenantCode(), estReceivablesRecordReBean);
            if (customerCapital != null) {
                Integer receivablesType;
                EstReceivablesRecordReBean record = this.saveReceivablesRecordReWrapper(user, estReceivablesRecordReBean, customerCapital.getAlreadyReceivables());
                String receivablesRecordCode = record.getReceivablesRecordCode();
                attr.addAttribute("receivablesRecordCode", (Object)record.getReceivablesRecordCode());
                String orderSuccessReturnUrl = String.valueOf(this.getRequestservice(request)) + request.getContextPath() + "/web/devest/capital/capitalArrivalRefundReturn";
                String type = estReceivablesRecordReBean.getReceivablesType();
                if (StringUtils.isNotBlank((String)type) && (receivablesType = Integer.valueOf(Integer.parseInt(type))) == 1) {
                    try {
                        String reserveUnitCode = customerCapital.getReserveUnitCode();
                        EstReserveUnitMemberBean unitMember = this.reserveUnitMemberRepository.getReserveUnitMainMemberName(reserveUnitCode, Integer.valueOf(0));
                        boolean success = false;
                        if (!this.hasCapitalSimpleModel()) {
                            success = this.capitalArrival((EstReceivablesRecordBean)record, orderSuccessReturnUrl, unitMember);
                        } else {
                            record.setPtradeSeqno(this.createUUIDString());
                            success = true;
                            record.setCashierUrl("-");
                        }
                        if (success) {
                            String ptradeSeqno = record.getPtradeSeqno();
                            EstReceivablesRecordReBean estReceivablesRecord = new EstReceivablesRecordReBean();
                            estReceivablesRecord.setReceivablesRecordCode(receivablesRecordCode);
                            this.updateReceivablesRecord(estReceivablesRecord, 0, ptradeSeqno);
                            if (!StringUtils.isNotBlank((String)record.getCashierUrl()) || !"-".equals(record.getCashierUrl())) return this.waitLinePay(request, modelMap, record.getCashierUrl(), receivablesRecordCode, tenantCode);
                            boolean notifyFlag = this.simpleNotify("PAYMENTLINE", receivablesRecordCode, tenantCode);
                            if (notifyFlag) {
                                this.logger.info("\u5230\u8d26\u4ea4\u6613\u7b80\u5355\u56de\u8c03\u6210\u529f");
                            } else {
                                this.logger.info("\u5230\u8d26\u4ea4\u6613\u7b80\u5355\u56de\u8c03\u5931\u8d25");
                            }
                        } else {
                            this.logger.error(String.valueOf(CODE) + ".capitalHandleArrivalRefund", (Object)("\u8d44\u91d1\u5230\u8d26\u64cd\u4f5c\uff0c\u9884\u4ed8\u5355\u751f\u6210\u5931\u8d25\uff0c\u8d44\u91d1\u6d41\u6c34\u53f7\uff1a" + receivablesRecordCode));
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("receivablesRecordCode", receivablesRecordCode);
                            boolean delSuccess = this.estReceivablesRecordRepository.delReceivablesRecordByCode(param);
                            if (delSuccess) {
                                this.logger.error(String.valueOf(CODE) + ".capitalHandleArrivalRefund", (Object)("\u8d44\u91d1\u8bb0\u5f55\u6d41\u6c34\u5df2\u56de\u6eda\u5220\u9664\uff0c\u5ba2\u6237\u8d44\u91d1\u7f16\u53f7\u4e3a\uff1a" + record.getCustomerCapitalCode()));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(String.valueOf(CODE) + ".capitalHandleArrivalRefund", (Object)("\u8d44\u91d1\u5230\u8d26\u64cd\u4f5c\uff0c\u9884\u9632\u5355\u751f\u6210\u5931\u8d25\uff0c\u8d44\u91d1\u6d41\u6c34\u53f7\uff1a" + receivablesRecordCode));
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("receivablesRecordCode", receivablesRecordCode);
                        boolean delSuccess = this.estReceivablesRecordRepository.delReceivablesRecordByCode(param);
                        if (!delSuccess) break block15;
                        this.logger.error(String.valueOf(CODE) + ".capitalHandleArrivalRefund", (Object)("\u8d44\u91d1\u8bb0\u5f55\u6d41\u6c34\u5df2\u56de\u6eda\u5220\u9664\uff0c\u5ba2\u6237\u8d44\u91d1\u7f16\u53f7\u4e3a\uff1a" + record.getCustomerCapitalCode()));
                    }
                }
            }
        }
        try {
            response.sendRedirect(String.valueOf(this.getRequestservice(request)) + request.getContextPath() + "/web/devest/capital/customercapitallist/" + customerCapital.getCapitalType() + "?page=" + page + "&rows=" + rows + "&projectCode=" + projectCode + "&buildingCode=" + buildingCode + "&handleType=" + handleType);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean simpleNotify(String ptradpdeCode, String receivablesRecordCode, String tenantCode) {
        boolean flag = this.returnNotifyWrapper(receivablesRecordCode, ptradpdeCode, tenantCode);
        return flag;
    }

    private String waitLinePay(HttpServletRequest request, ModelMap modelMap, String cashierUrl, String receivablesRecordCode, String tenantCode) {
        modelMap.addAttribute("cashierUrl", (Object)cashierUrl);
        modelMap.addAttribute("code", (Object)receivablesRecordCode);
        modelMap.addAttribute("tenantCode", (Object)tenantCode);
        return String.valueOf(this.getFtlTempPath(request)) + "orderSuccessInWaitLinePay";
    }

    @RequestMapping(value={"payCompleteConfirm/{code}/{tenantCode}/{type}"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean payCompleteConfirm(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="code") String code, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="type") Integer type) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)code)) {
            EstReceivablesRecordReBean estReceivablesRecord = this.getReceivablesRecordByCode(tenantCode, code, "");
            String payFlagDesc = "\u64cd\u4f5c\u5931\u8d25";
            String receivablesTypeDesc = SupDisUtil.getMap((String)CACHEENTITY, (String)("ReceivablesRecord-receivablesType-" + estReceivablesRecord.getReceivablesType()));
            payFlagDesc = estReceivablesRecord.getDataState() == 1 ? String.valueOf(receivablesTypeDesc) + "\u64cd\u4f5c\u6210\u529f" : String.valueOf(receivablesTypeDesc) + payFlagDesc;
            EstCustomerCapitalReBean customerCapital = this.getCustomerCapitalByCode(tenantCode, estReceivablesRecord);
            String reserveUnitType = customerCapital.getReserveUnitType();
            Integer flowLinkType = Integer.parseInt(customerCapital.getFlowLinkType());
            String handleType = "2";
            if (flowLinkType == 1 || flowLinkType == 2 || flowLinkType == 3) {
                handleType = "1";
            }
            map.put("url", "/web/devest/capital/customercapitallist/" + reserveUnitType + "?receivablesRecordCode=" + code + "&tenantCode=" + tenantCode + "&handleType=" + handleType + "&projectCode=" + customerCapital.getOtherCode());
            map.put("payFlagDesc", payFlagDesc);
            return new HtmlJsonReBean(map);
        }
        return new HtmlJsonReBean("error", "\u672a\u67e5\u5230\u8be5\u8ba2\u5355");
    }

    @RequestMapping(value={"capitalArrivalRefundReturn"})
    public String capitalHandleRefundReturn(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        try {
            Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
            if (param == null || param.get("businessOrderno") == null) {
                throw new Exception("\u8ba2\u5355\u5f02\u5e38");
            }
            String receivablesRecordCode = (String)param.get("businessOrderno");
            boolean flag = true;
            if (flag = this.refundWait(receivablesRecordCode, flag)) {
                modelMap.put((Object)"successDesc", (Object)"\u64cd\u4f5c\u6210\u529f");
                modelMap.put((Object)"success", (Object)true);
            } else {
                modelMap.put((Object)"successDesc", (Object)"\u8ba2\u5355\u6b63\u5728\u6392\u961f\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b");
                modelMap.put((Object)"success", (Object)false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(this.getFtlTempPath(request)) + "redirectClose";
    }

    public boolean refundWait(String receivablesRecordCode, boolean flag) {
        String catchState = SupDisUtil.get((String)receivablesRecordCode);
        if (StringUtils.isNotBlank((String)catchState) && 1 == Integer.parseInt(catchState)) {
            return true;
        }
        if (flag) {
            flag = false;
            try {
                Thread.sleep(3000L);
                return this.refundWait(receivablesRecordCode, flag);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @RequestMapping(value={"capitalArrivalRefundNotify"})
    @ResponseBody
    public String capitalArrivalRefundNotify(HttpServletRequest request, HttpServletResponse response) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        boolean flag = false;
        if (param.get("ptradpdeCode") != null && param.get("businessOrderno") != null && param.get("tenantCode") != null) {
            String ptradpdeCode = String.valueOf(param.get("ptradpdeCode"));
            String businessOrderno = String.valueOf(param.get("businessOrderno"));
            String tenantCode = String.valueOf(param.get("tenantCode"));
            flag = this.returnNotifyWrapper(businessOrderno, ptradpdeCode, tenantCode);
        }
        if (flag) {
            return "success";
        }
        return "faliure";
    }

    private boolean returnNotifyWrapper(String receivablesRecordCode, String ptradpdeCode, String tenantCode) {
        Boolean success = false;
        String successDesc = "\u64cd\u4f5c\u6210\u529f";
        Integer dataState = 0;
        boolean backNotify = false;
        EstReceivablesRecordReBean record = this.getReceivablesRecordByCode(tenantCode, receivablesRecordCode, "");
        if ("PAYMENTBACK".equals(ptradpdeCode) && record == null) {
            record = this.getReceivablesRecordByCode(tenantCode, "", receivablesRecordCode);
            backNotify = true;
        }
        if (record == null) {
            this.logger.info(String.valueOf(CODE) + ".returnNotifyWrapper", (Object)"\u672a\u67e5\u5230\u8be5\u7b14\u8ba2\u5355\uff0c\u5df2\u66f4\u65b0\u8fc7\u64cd\u4f5c\uff0c\u65e0\u9700\u518d\u6b21\u5904\u7406");
            return false;
        }
        if (record.getDataState() == 0 || record.getDataState() == 2) {
            dataState = 1;
            success = this.updateReceivablesRecord(record, dataState, null);
            try {
                if (success.booleanValue()) {
                    EstCustomerCapitalReBean customerCapital = this.getCustomerCapitalByCode(tenantCode, record);
                    customerCapital.setAlreadyReceivables(customerCapital.getAlreadyReceivables().add(record.getReceivablesAmount()));
                    customerCapital.setReceivablesRecordNum(Integer.valueOf(customerCapital.getReceivablesRecordNum() + 1));
                    success = this.customerCapitalRepository.updateCustomerCapital(customerCapital);
                    if (!success.booleanValue()) {
                        successDesc = "\u5ba2\u6237\u8d44\u91d1\u6570\u636e\u56de\u5199\u5931\u8d25";
                        dataState = 2;
                        success = this.updateReceivablesRecord(record, dataState, "");
                        if (success.booleanValue()) {
                            successDesc = String.valueOf(successDesc) + ",\u5df2\u6210\u529f\u56de\u6eda\u72b6\u6001\uff0c\u9700\u518d\u6b21\u8fdb\u884c\u8865\u5e10";
                        }
                    } else if (backNotify) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("customerCapitalCode", customerCapital.getCustomerCapitalCode());
                        map.put("receivablesType", "1");
                        map.put("dataState", "2");
                        map.put("tenantCode", tenantCode);
                        List list = this.estReceivablesRecordRepository.queryEstReceivablesRecordList(map);
                        if (ListUtil.isNotEmpty((Collection)list)) {
                            this.updateReceivablesRecord((EstReceivablesRecordReBean)list.get(0), 3, "");
                        }
                    } else if (customerCapital.getCapitalType() == 4) {
                        String reserveUnitCode = customerCapital.getReserveUnitCode();
                        EstReserveUnitReBean reserveUnitBean = this.reserveUnitRepository.getReserveUnitByCode(reserveUnitCode, tenantCode);
                        reserveUnitBean.setDataExamState(Integer.valueOf(0));
                        this.reserveUnitRepository.updateReserveUnit((EstReserveUnitBean)reserveUnitBean);
                    }
                    SupDisUtil.set((String)receivablesRecordCode, (String)dataState.toString());
                } else {
                    successDesc = "\u8d44\u91d1\u6d41\u6c34\u8bb0\u5f55\u56de\u5199\u5931\u8d25";
                }
            }
            catch (Exception e) {
                success = this.updateReceivablesRecord(record, 0, null);
            }
            this.logger.info(String.valueOf(CODE) + ".returnNotifyWrapper", (Object)successDesc);
            return success;
        }
        this.logger.info(String.valueOf(CODE) + ".returnNotifyWrapper", (Object)(String.valueOf(successDesc) + "\uff0c\u5df2\u66f4\u65b0\u8fc7\u64cd\u4f5c\uff0c\u65e0\u9700\u518d\u6b21\u5904\u7406"));
        return true;
    }

    @RequestMapping(value={"capitalHandleRefundSubmit.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean capitalHandleRefundAllSubmit(HttpServletRequest request, BigDecimal amountCount, String customerCapitalCode, String receivablesRecordCode, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)receivablesRecordCode)) {
            param.put("receivablesRecordCode", receivablesRecordCode);
        }
        param.put("customerCapitalCode", customerCapitalCode);
        param.put("ptradeSeqnoIsNotNull", true);
        param.put("dataState", 1);
        param.put("receivablesType", "1");
        List list = this.estReceivablesRecordRepository.queryEstReceivablesRecordList(param);
        if (ListUtil.isEmpty((Collection)list)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u5230\u8be5\u7b14\u5230\u8d26\u8bb0\u5f55\uff0c\u6216\u8be5\u7b14\u8ba2\u5355\u5df2\u53d1\u8d77\u9000\u6b3e");
        }
        if (amountCount == null && StringUtils.isEmpty((String)customerCapitalCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u63a5\u6536\u5230\u9700\u9000\u6b3e\u4fe1\u606f\uff0c\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        BigDecimal tempAmountCount = new BigDecimal(0);
        for (EstReceivablesRecordReBean estRecord : list) {
            tempAmountCount = tempAmountCount.add(estRecord.getReceivablesAmount());
        }
        if (amountCount.subtract(tempAmountCount).compareTo(BigDecimal.ZERO) != 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f93\u5165\u9000\u6b3e\u91d1\u989d\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff0c\u5e94\u9000\uff1a" + tempAmountCount + "\u5b9e\u9000" + amountCount);
        }
        return this.capitalHandleRefundWrapper(list, param, customerCapitalCode, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    private HtmlJsonReBean capitalHandleRefundWrapper(List<EstReceivablesRecordReBean> list, Map<String, Object> param, String customerCapitalCode, UserSession user) {
        BigDecimal succAmount = new BigDecimal(0);
        BigDecimal faliureAmount = new BigDecimal(0);
        int succCount = 0;
        int faliureCount = 0;
        for (EstReceivablesRecordReBean record : list) {
            EstReceivablesRecordReBean reBean = new EstReceivablesRecordReBean();
            reBean.setReceivablesType("2");
            reBean.setDataState(Integer.valueOf(-1));
            reBean.setCustomerCapitalCode(customerCapitalCode);
            reBean.setReceivablesAmount(record.getReceivablesAmount());
            reBean.setReceivablesComment("\u9000\u6b3e");
            EstReceivablesRecordReBean saveReturnBean = this.saveReceivablesRecordReWrapper(user, reBean, BigDecimal.ZERO);
            boolean flag = false;
            String newReceivablesRecordCode = saveReturnBean.getReceivablesRecordCode();
            try {
                if (!this.hasCapitalSimpleModel()) {
                    flag = this.capitalRefund((EstReceivablesRecordBean)record, newReceivablesRecordCode);
                } else {
                    flag = true;
                    record.setPtradeBackCode(this.createUUIDString());
                }
                if (flag) {
                    this.updateReceivablesRecord(saveReturnBean, 0, record.getPtradeBackCode());
                    this.updateReceivablesRecord(record, 2, "");
                    succAmount = succAmount.add(record.getReceivablesAmount());
                    ++succCount;
                    if (!this.hasCapitalSimpleModel()) continue;
                    this.simpleNotify("PAYMENTBACK", record.getPtradeBackCode(), record.getTenantCode());
                    continue;
                }
                this.logger.error(String.valueOf(CODE) + ".capitalHandleRefundSubmit.json", (Object)("\u9000\u6b3e\u64cd\u4f5c\uff0c\u9000\u6b3e\u8ba2\u5355\u53d1\u8d77\u5931\u8d25\uff0c\u539f\u5230\u8d26\u8d44\u91d1\u6d41\u6c34\u53f7\uff1a" + record.getReceivablesRecordCode() + ",\u9000\u6b3e\u8d44\u91d1\u6d41\u6c34\u53f7\u4e3a\uff1a" + saveReturnBean.getReceivablesRecordCode()));
                param.clear();
                param.put("receivablesRecordCode", saveReturnBean.getReceivablesRecordCode());
                boolean delSuccess = this.estReceivablesRecordRepository.delReceivablesRecordByCode(param);
                if (delSuccess) {
                    this.logger.error(String.valueOf(CODE) + ".capitalHandleRefundSubmit.json", (Object)("\u9000\u6b3e\u64cd\u4f5c\uff1a\u8d44\u91d1\u8bb0\u5f55\u6d41\u6c34\u5df2\u56de\u6eda\u5220\u9664\uff0c\u5ba2\u6237\u8d44\u91d1\u7f16\u53f7\u4e3a\uff1a" + customerCapitalCode));
                }
                faliureAmount = faliureAmount.add(record.getReceivablesAmount());
                ++faliureCount;
            }
            catch (Exception e) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u5931\u8d25");
            }
        }
        StringBuffer succ = new StringBuffer();
        succ.append("\u9000\u6b3e\u6210\u529f\u8d44\u91d1\u8bb0\u5f55\u7b14\u6570\uff1a");
        succ.append(succCount);
        if (succCount > 0) {
            succ.append("\uff0c\u6210\u529f\u8d44\u91d1\u8bb0\u5f55\u603b\u91d1\u989d\uff1a");
            succ.append(succAmount);
            succ.append("\uff0c\u5ba2\u6237\u8d44\u91d1\u7f16\u53f7\u4e3a\uff1a");
            succ.append(customerCapitalCode);
            this.logger.info(succ.toString());
        }
        StringBuffer faliure = new StringBuffer();
        faliure.append("\u9000\u6b3e\u5931\u8d25\u8d44\u91d1\u8bb0\u5f55\u7b14\u6570\uff1a");
        faliure.append(faliureCount);
        if (faliureCount > 0) {
            faliure.append("\uff0c\u5931\u8d25\u8d44\u91d1\u8bb0\u5f55\u603b\u91d1\u989d\uff1a");
            faliure.append(faliureAmount);
            faliure.append("\uff0c\u5ba2\u6237\u8d44\u91d1\u7f16\u53f7\u4e3a\uff1a");
            faliure.append(customerCapitalCode);
            this.logger.error(faliure.toString());
        }
        return new HtmlJsonReBean((Object)(String.valueOf(succ.toString()) + "\n" + faliure.toString()));
    }

    @RequestMapping(value={"capitalRefundReturn"})
    public String capitalRefundReturn(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        System.out.println(param.toString());
        return "";
    }

    @RequestMapping(value={"capitalRefundNotify"})
    @ResponseBody
    public String capitalRefundNotify(HttpServletRequest request, HttpServletResponse response) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null && param.get("ptradpdeCode") != null && param.get("businessOrderno") != null && param.get("tenantCode") != null) {
            String ptradpdeCode = String.valueOf(param.get("ptradpdeCode"));
            String businessOrderno = String.valueOf(param.get("businessOrderno"));
            String tenantCode = String.valueOf(param.get("tenantCode"));
            this.returnNotifyWrapper(businessOrderno, ptradpdeCode, tenantCode);
            return "success";
        }
        return "faliure";
    }

    @RequestMapping(value={"queryReceivablesRecord"})
    public String queryReceivablesRecord(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        if (param.get("receivablesType") != null && !"".equals(param.get("receivablesType"))) {
            modelMap.put((Object)"receivablesType", (Object)Integer.valueOf((String)param.get("receivablesType")));
        }
        if (param.get("model") != null && !"".equals(param.get("model"))) {
            Integer model = Integer.valueOf((String)param.get("model"));
            if (model != 2) {
                param.put("dataState", 1);
            }
            param.put("ptradeSeqnoIsnotnull", true);
            modelMap.put((Object)"model", (Object)model);
        }
        if (param.get("customerCapitalCode") == null || "".equals(param.get("customerCapitalCode"))) {
            param.put("customerCapitalCode", "-");
        }
        param.put("order", true);
        param.put("tenantCode", user.getTenantCode());
        modelMap.addAttribute("customerCapitalCode", param.get("customerCapitalCode"));
        this.queryEstReceivablesRecordWrapper(request, param, modelMap);
        return String.valueOf(this.getFtlTempPath(request)) + "receivablesRecord";
    }

    private void queryEstReceivablesRecordWrapper(HttpServletRequest request, Map<String, Object> param, ModelMap modelMap) {
        SupQueryResult sup = this.estReceivablesRecordRepository.queryEstReceivablesRecord(param);
        List list = sup.getList();
        int refundCount = 0;
        BigDecimal amountCount = new BigDecimal(0);
        if (ListUtil.isNotEmpty((Collection)list)) {
            HashMap<String, String> ddMap = new HashMap<String, String>();
            List<SfDd> sfdds = this.queryDdList("ReceivablesRecord", "receivablesType");
            for (SfDd dd : sfdds) {
                ddMap.put(dd.getDdCode(), dd.getDdValue());
            }
            for (EstReceivablesRecordReBean obj : list) {
                if (Integer.parseInt(obj.getReceivablesType()) == 1 && obj.getDataState() == 1) {
                    ++refundCount;
                    amountCount = amountCount.add(obj.getReceivablesAmount());
                }
                if (EstateConstants.ReceivablesEnum.ARRIVAL_ING.getReceivablesType().equals(obj.getReceivablesType())) {
                    if (EstateConstants.ReceivablesEnum.ARRIVAL_ING.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5230\u8d26\u4e2d");
                    } else if (EstateConstants.ReceivablesEnum.ARRIVAL_ED.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5df2\u5230\u8d26");
                    } else if (EstateConstants.ReceivablesEnum.ARRIVAL_EXE_BACK.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5df2\u53d1\u8d77\u9000\u6b3e");
                    } else if (EstateConstants.ReceivablesEnum.ARRIVAL_BACK_SUCC.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u9000\u6b3e\u6210\u529f");
                    }
                } else if (EstateConstants.ReceivablesEnum.REFUND_ING.getReceivablesType().equals(obj.getReceivablesType())) {
                    if (EstateConstants.ReceivablesEnum.REFUND_ING.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u9000\u6b3e\u4e2d");
                    } else if (EstateConstants.ReceivablesEnum.REFUND_ED.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5df2\u9000\u6b3e");
                    } else if (EstateConstants.ReceivablesEnum.REFUND_UN.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u672a\u6210\u529f\u53d1\u8d77\u9000\u6b3e");
                    }
                }
                String receivablesMethod = SupDisUtil.getMap((String)CACHEENTITY, (String)("EstCustomerCapital-receivablesMethod-" + obj.getReceivablesMethod()));
                if (StringUtils.isNotBlank((String)receivablesMethod)) {
                    obj.setReceivablesMethod(receivablesMethod);
                }
                obj.setReceivablesType((String)ddMap.get(obj.getReceivablesType()));
            }
        }
        modelMap.addAttribute("listCount", (Object)refundCount);
        modelMap.addAttribute("amountCount", (Object)amountCount);
        modelMap.addAttribute("receivablesRecords", (Object)list);
        modelMap.addAttribute("pageTools", (Object)this.buildPage(sup.getPageTools(), request));
    }

    @RequestMapping(value={"refundDetails"})
    public String refundDetails(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        if (param == null) {
            return "";
        }
        param.put("order", true);
        param.put("tenantCode", user.getTenantCode());
        this.queryEstReceivablesRecordWrapper(request, param, modelMap);
        return String.valueOf(this.getFtlTempPath(request)) + "refundDetailsSubmit";
    }

    private boolean updateReceivablesRecord(EstReceivablesRecordReBean estReceivablesRecord, Integer dataState, String ptradeSeqno) {
        estReceivablesRecord = this.getReceivablesRecordByCode(null, estReceivablesRecord.getReceivablesRecordCode(), "");
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            estReceivablesRecord.setPtradeSeqno(ptradeSeqno);
            param.put("ptradeSeqno", ptradeSeqno);
        }
        param.put("dataState", dataState);
        param.put("receivablesRecordCode", estReceivablesRecord.getReceivablesRecordCode());
        param.put("tenantCode", estReceivablesRecord.getTenantCode());
        return this.estReceivablesRecordRepository.updateReceivablesRecordMap(param);
    }

    private EstCustomerCapitalReBean getCustomerCapitalByCode(String tenantCode, EstReceivablesRecordReBean estReceivablesRecordReBean) {
        HashMap<String, String> param = new HashMap<String, String>();
        String customerCapitalCode = estReceivablesRecordReBean.getCustomerCapitalCode();
        param.put("customerCapitalCode", customerCapitalCode);
        param.put("tenantCode", tenantCode);
        EstCustomerCapitalReBean customerCapital = this.customerCapitalRepository.getCustomerCapitalByCode(param);
        return customerCapital;
    }

    @RequestMapping(value={"capitalArrivalValidate.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean capitalArrivalValidate(HttpServletRequest request, BigDecimal receivablesAmount, String customerCapitalCode, String receivablesType) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null) {
            return new HtmlJsonReBean("error", "\u8f93\u5165\u8d44\u91d1\u6709\u8bef");
        }
        param.put("tenantCode", user.getTenantCode());
        param.put("dataState", 0);
        param.put("receivablesType", receivablesType);
        param.put("receivablesAmount", receivablesAmount);
        EstCustomerCapitalReBean customer = this.customerCapitalRepository.getCustomerCapitalByCode(param);
        if (customer != null) {
            if (param.get("receivablesType") != null && "1".equals(param.get("receivablesType"))) {
                if (customer.getShouldReceivables().subtract(customer.getAlreadyReceivables()).compareTo(receivablesAmount) < 0) {
                    return new HtmlJsonReBean("error", "\u4fee\u6539\u8d85\u989d,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
                }
            } else if (customer.getShouldReceivables().subtract(customer.getAlreadyReceivables()).compareTo(receivablesAmount) < 0) {
                return new HtmlJsonReBean("error", "\u8d44\u91d1\u8d85\u989d,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
        } else {
            return new HtmlJsonReBean("error", "\u672a\u627e\u5230\u8be5\u8d44\u91d1\u8bb0\u5f55\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        return new HtmlJsonReBean((Object)"");
    }

    private EstReceivablesRecordReBean getReceivablesRecordByCode(String tenantCode, String receivablesRecordCode, String ptradeSeqno) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)tenantCode)) {
            param.put("tenantCode", tenantCode);
        }
        EstReceivablesRecordReBean estReceivablesRecord = null;
        if (StringUtils.isNotBlank((String)receivablesRecordCode)) {
            param.put("receivablesRecordCode", receivablesRecordCode);
            estReceivablesRecord = this.estReceivablesRecordRepository.getReceivablesRecordByCode(param);
        } else if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            param.put("ptradeSeqno", ptradeSeqno);
            List lists = this.estReceivablesRecordRepository.queryEstReceivablesRecordList(param);
            if (ListUtil.isNotEmpty((Collection)lists)) {
                estReceivablesRecord = (EstReceivablesRecordReBean)lists.get(0);
            }
        }
        return estReceivablesRecord;
    }

    private Set<String> wrapper(List<SfDd> sfdds, List<Map<String, Object>> payments, String key) {
        HashSet<String> reserveUnitCodes = new HashSet<String>();
        String reserveUnitCodeKey = RESERVEUNITCODEKEY;
        String descKey = String.valueOf(key) + "Desc";
        HashMap<String, String> ddMap = new HashMap<String, String>();
        for (SfDd sfDd : sfdds) {
            ddMap.put(sfDd.getDdCode(), sfDd.getDdValue());
        }
        for (Map map : payments) {
            map.put(descKey, ddMap.get(map.get(key).toString()));
            reserveUnitCodes.add(String.valueOf(map.get(reserveUnitCodeKey)));
        }
        return reserveUnitCodes;
    }

    public List<SfDd> queryDdList(String ddTable, String ddColumn) {
        List ddLists = this.ddRepository.queryDdList(ddTable, ddColumn);
        return ddLists;
    }

    private boolean capitalArrival(EstReceivablesRecordBean record, String returnUrl, EstReserveUnitMemberBean unitMember) {
        String memberName = unitMember.getMemberName();
        StringBuffer sb = new StringBuffer("");
        String receivablesType = SupDisUtil.getMap((String)CACHEENTITY, (String)("ReceivablesRecord-receivablesType-" + record.getReceivablesType()));
        String merberCode = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", String.valueOf(record.getTenantCode()) + "-openMerber-merberCode");
        if (StringUtils.isEmpty((String)merberCode)) {
            this.logger.error("CapitalCon.capitalArrival \u5408\u4f5c\u65b9ID\u4e3a\u7a7a");
            return false;
        }
        sb.append(record.getUserName());
        sb.append(receivablesType);
        sb.append(",\u5ba2\u6237\uff1a");
        sb.append(memberName);
        SavePyamentToPteFormRequest rr = new SavePyamentToPteFormRequest();
        rr.setOrderAmount(record.getReceivablesAmount().toString());
        rr.setPtradeType("03");
        rr.setPartnerCode(merberCode);
        rr.setBusinessOrderno(record.getReceivablesRecordCode());
        rr.setPaymentMemo(sb.toString());
        rr.setPaymentReturnurl(returnUrl);
        rr.setOpuserCode(record.getUserCode());
        rr.setPtradpdeCode("PAYMENTLINE");
        rr.setTenantCode(record.getTenantCode());
        rr.setMerchantCode(merberCode);
        rr.setFchannelPmodeCode("WEB");
        rr.setOpuserName(record.getUserName());
        SavePyamentToPteFormResponse rs = (SavePyamentToPteFormResponse)this.capitalArrivalHandler.execRequest((LaserRequest<?>)rr, null);
        if (rs == null || !rs.getSuccess().booleanValue()) {
            return false;
        }
        record.setCashierUrl(rs.getUrl());
        record.setPtradeSeqno(rs.getPtradeSeqno());
        return true;
    }

    private boolean capitalRefund(EstReceivablesRecordBean record, String newReceivablesRecordCode) {
        SaveParticipantFromByRefundResponse rs;
        block4: {
            StringBuffer sb = new StringBuffer("\u4e91\u9500\u7ba1\u5bb6\u7528\u6237\u64cd\u4f5c\uff1a");
            String receivablesType = SupDisUtil.getMap((String)CACHEENTITY, (String)("ReceivablesRecord-receivablesType-" + record.getReceivablesType()));
            String merberCode = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", String.valueOf(record.getTenantCode()) + "-openMerber-merberCode");
            if (StringUtils.isEmpty((String)merberCode)) {
                this.logger.error("CapitalCon.capitalArrival \u5408\u4f5c\u65b9ID\u4e3a\u7a7a");
                return false;
            }
            sb.append(record.getUserName());
            sb.append(receivablesType);
            SaveParticipantFromByRefundRequest rr = new SaveParticipantFromByRefundRequest();
            rr.setBusinessOrderno(record.getReceivablesRecordCode());
            rr.setRefundOrderno(newReceivablesRecordCode);
            rr.setPartnerCode(merberCode);
            rr.setPtradpdeCode("PAYMENTBACK");
            rr.setPtradeSeqno(record.getPtradeSeqno());
            rr.setTenantCode(record.getTenantCode());
            rr.setOrderAmount(String.valueOf(record.getReceivablesAmount()));
            try {
                rs = (SaveParticipantFromByRefundResponse)this.capitalArrivalHandler.execRequest((LaserRequest<?>)rr, null);
                if (rs != null && rs.getSuccess().booleanValue()) break block4;
                return false;
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u9000\u6b3e\u5355\u5931\u8d25,\u539f\u8ba2\u5355\u53f7\uff1a" + record.getReceivablesRecordCode() + "\uff0c\u5546\u6237\u53f7:" + merberCode, (Throwable)e);
                return false;
            }
        }
        record.setPtradeBackCode(rs.getPtradeBackCode());
        return true;
    }

    @RequestMapping(value={"saveMerchant.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean queryMerchant(HttpServletRequest request, OpenMerber openMerber) {
        UserSession user = this.getUserSession(request);
        String tenantCode = user.getTenantCode();
        String merberCode = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", String.valueOf(tenantCode) + "-openMerber-merberCode");
        if (StringUtils.isNotBlank((String)merberCode)) {
            return new HtmlJsonReBean("error", "\u8be5\u5e73\u53f0\u5546\u6237\u5df2\u5b58\u5728\uff0c\u5546\u6237\u53f7\u4e3a\uff1a" + merberCode);
        }
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null || openMerber == null) {
            return new HtmlJsonReBean("error", "\u8f93\u5165\u53c2\u6570\u6709\u8bef");
        }
        SendOpenMerberFormRequest rr = new SendOpenMerberFormRequest();
        rr.setTenantCode(tenantCode);
        rr.setUserName(user.getUserName());
        rr.setMerberExcode(UUID.randomUUID().toString().replace("-", ""));
        rr.setMerberType(openMerber.getMerberType());
        rr.setPaypw(openMerber.getPaypw());
        rr.setMerberCompname(openMerber.getMerberCompname());
        rr.setMerberArea(openMerber.getMerberArea());
        rr.setMerberTel(openMerber.getMerberTel());
        rr.setMerberPhone(openMerber.getMerberPhone());
        rr.setMerberEmail(openMerber.getMerberEmail());
        rr.setMerberCon(openMerber.getMerberCon());
        SendOpenMerberFormResponse rs = (SendOpenMerberFormResponse)this.capitalArrivalHandler.execRequest((LaserRequest<?>)rr, null);
        if (rs == null || !rs.getSuccess().booleanValue()) {
            return new HtmlJsonReBean("error", "\u5f00\u6237\u5931\u8d25");
        }
        this.saveFalgSetting(rs.getMerberCode(), tenantCode);
        return new HtmlJsonReBean((Object)("\u5f00\u6237\u6210\u529f,\u5546\u6237\u53f7\u4e3a\uff1a" + rs.getMerberCode()));
    }

    private void saveFalgSetting(String merberCode, String tenantCode) {
        DdFalgSettingReBean reBean = new DdFalgSettingReBean();
        reBean.setFlagSettingInfo(merberCode);
        reBean.setFlagSettingCode("merberCode");
        reBean.setFlagSettingScope(ServletMain.getAppName());
        reBean.setFlagSettingType("openMerber");
        reBean.setTenantCode(tenantCode);
        reBean.setMemo("\u5546\u6237\u4ee3\u7801");
        this.ddFalgSettingRepository.saveFalgSetting(reBean);
    }
}

