/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.capital.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.datadictionary.repository.DdFalgSettingRepository;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstFlowLinkBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReceivablesRecordReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitMemberBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.bean.PaymentDetailsReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.project.domain.PtHouseReDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.CustomerCapitalRepository;
import com.yqbsoft.laser.html.facade.est.repository.EstReceivablesRecordRepository;
import com.yqbsoft.laser.html.facade.est.repository.FlowLinkRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitMemberRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.pt.bean.UnitBean;
import com.yqbsoft.laser.html.facade.um.domain.UmUserReDomainBean;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.handler.config.BuildingHouseListHandler;
import com.yqbsoft.laser.html.handler.config.CapitalArrivalHandler;
import com.yqbsoft.laser.html.project.bean.FloorBean;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/capitalhouse/"})
public class CapitalHouseCon
extends SpringmvcController {
    @Resource
    private PtBuildingRepository ptBuildingRepository;
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private CustomerCapitalRepository customerCapitalRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private FlowLinkRepository flowLinkRepository;
    @Resource
    private EstReceivablesRecordRepository estReceivablesRecordRepository;
    @Resource
    private CapitalArrivalHandler capitalArrivalHandler;
    @Resource
    private DdFalgSettingRepository ddFalgSettingRepository;
    @Resource
    private ReserveUnitMemberRepository reserveUnitMemberRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private PtHouseRepository ptHouseRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private BuildingHouseListHandler buildingHouseListHandler;

    protected String getContext() {
        return "capitalHouse";
    }

    @RequestMapping(value={"house_list"})
    public String customercapitallistV2(HttpServletRequest request, String projectCode, ModelMap modelMap, String projectSelect) {
        UserSession user = this.getUserSession(request);
        this.buildingHouseListHandler.sellControllerListLogic(request, modelMap, projectSelect, user);
        modelMap.addAttribute("bigTitle", (Object)"\u8d22\u52a1\u7ba1\u7406");
        modelMap.addAttribute("smallTitle", (Object)"\u623f\u6237\u5217\u8868");
        ConcurrentHashMap<String, Boolean> findMap = new ConcurrentHashMap<String, Boolean>();
        findMap.put("titleHouse", true);
        findMap.put("titleHouseMoney", true);
        modelMap.addAttribute("findMap", findMap);
        modelMap.addAttribute("queryUrl", (Object)"/web/devest/capitalhouse/house_list");
        return "house_list";
    }

    public String customercapitallist(HttpServletRequest request, String projectCode, ModelMap modelMap, String projectSelect) {
        List houses;
        List buildings;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        if (param != null) {
            if (param.get("projectSelect") != null) {
                param.put("projectCode", param.get("projectSelect"));
            }
            if (param.get("buildingSelect") != null) {
                param.put("buildingCode", param.get("buildingSelect"));
            }
        }
        Map<String, Object> supsBuilding = this.queryBuildingProcess(param);
        String defaultBuildingCode = "";
        String defaultBuildingName = "";
        Integer buildingType = 1;
        String defaultProjectCode = "";
        if (supsBuilding != null && ListUtil.isNotEmpty((Collection)(buildings = (List)supsBuilding.get("list")))) {
            defaultBuildingCode = ((Map)buildings.get(0)).get("buildingCode");
            defaultBuildingName = (String)((Map)buildings.get(0)).get("buildingName");
            buildingType = (Integer)((Map)buildings.get(0)).get("buildingType");
            defaultProjectCode = (String)((Map)buildings.get(0)).get("projectCode");
        }
        if (StringUtils.isNotBlank((String)defaultBuildingName)) {
            param.put("buildingCode", defaultBuildingCode);
        }
        param.put("orderStr", " unit_name*1 ,floor_name*1,house_name*1");
        SupQueryResult sups = this.ptHouseRepository.queryHousePage2(param, true, false);
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (sups != null && ListUtil.isNotEmpty((Collection)(houses = sups.getList()))) {
            ArrayList<UnitBean> units = new ArrayList<UnitBean>();
            for (HouseReBean houseMap : houses) {
                boolean exists = false;
                UnitBean unit = new UnitBean();
                for (UnitBean unitMap : units) {
                    if (!unitMap.getUnitCode().equals(houseMap.getUnitCode())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                unit.setUnitCode(houseMap.getUnitCode());
                unit.setUnitName(houseMap.getUnitName());
                units.add(unit);
            }
            retMap.put("units", units);
            ArrayList<FloorBean> floors = new ArrayList<FloorBean>();
            for (HouseReBean houseMap : houses) {
                FloorBean floor = new FloorBean();
                boolean floorExists = false;
                for (FloorBean floorMap : floors) {
                    if (!houseMap.getFloorName().equals(floorMap.getFloorName())) continue;
                    floorExists = true;
                    break;
                }
                if (floorExists) continue;
                floor.setFloorCode(houseMap.getFloorCode());
                floor.setFloorName(houseMap.getFloorName());
                floors.add(floor);
            }
            String unitCodeMark = "";
            int unitColspanCount = 4;
            for (FloorBean floor : floors) {
                int unitColspan = 0;
                ArrayList<HouseReBean> housess = new ArrayList<HouseReBean>();
                for (HouseReBean houseMap_housess : houses) {
                    if (!unitCodeMark.equals(houseMap_housess.getUnitCode())) {
                        if (StringUtils.isNotBlank((String)unitCodeMark) && unitColspanCount > unitColspan && unitColspan > 0) {
                            int i = 0;
                            while (i < unitColspanCount - unitColspan) {
                                this.assemblingHouse(housess, "", "", -1, 0);
                                ++unitColspan;
                                ++i;
                            }
                        }
                        unitCodeMark = houseMap_housess.getUnitCode();
                    }
                    if (!floor.getFloorName().equals(houseMap_housess.getFloorName())) continue;
                    boolean houseExists = false;
                    for (HouseReBean h : housess) {
                        if (!h.getHouseCode().equals(houseMap_housess.getHouseCode())) continue;
                        houseExists = true;
                        break;
                    }
                    if (houseExists) break;
                    this.assemblingHouse(housess, houseMap_housess.getHouseCode(), houseMap_housess.getHouseName(), houseMap_housess.getDataState(), houseMap_housess.getManageUpdateNum());
                    ++unitColspan;
                }
                if (buildingType == 2 && unitColspan > unitColspanCount) {
                    unitColspanCount = unitColspan;
                }
                floor.setHousess(housess);
            }
            for (FloorBean floor : floors) {
                List<HouseReBean> housess = floor.getHousess();
                int h = 0;
                int j = housess.size();
                if (j % unitColspanCount > 0) {
                    h = unitColspanCount - j % unitColspanCount;
                }
                int i = 0;
                while (i < h) {
                    this.assemblingHouse(housess, "", "", -1, 0);
                    ++i;
                }
            }
            retMap.put("floors", floors);
            retMap.put("unitColspan", unitColspanCount);
            if (StringUtils.isEmpty((String)projectSelect)) {
                projectSelect = defaultProjectCode;
            }
            retMap.put("projectSelect", projectSelect);
            retMap.put("projectSelect", param.get("projectCode"));
            retMap.put("buildingSelect", param.get("buildingSelect"));
            retMap.put("sellDataState", param.get("sellDataState"));
            modelMap.put((Object)"retMap", retMap);
        }
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"capitalHouseDetails"})
    public String houseDetails(HttpServletRequest request, String houseCode, String projectCode, Integer dataState, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        String tenantCode = user.getTenantCode();
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        param.put("order", true);
        param.put("tenantCode", user.getTenantCode());
        PtHouseReDomain house = this.ptHouseRepository.getHouseByCode(houseCode, tenantCode);
        if (house != null) {
            house.setDataStateDesc(SupDisUtil.getMap((String)"EcoreDd-list", (String)("PtHouse-dataState-" + house.getDataState())));
            house.setHouseTypeDesc(SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstIntention-intentionOpType-" + house.getHouseType())));
            modelMap.put((Object)"house", (Object)house);
        }
        PaymentDetailsReBean paymentDetails = new PaymentDetailsReBean();
        String reserveUnitCode = "";
        EstReserveUnitReBean reserveUnit = this.reserveUnitRepository.getReserveUnitByHouseCode(houseCode, projectCode, tenantCode);
        if (reserveUnit != null) {
            this.reserveUnitMemberRepository.getReserveUnitMember((Object)reserveUnit);
            reserveUnit.setReserveUnitTypeDesc(SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstFlowLink-flowLinkType-" + house.getDataState())));
            reserveUnit.setUserCode(this.userRepository.getUserByCode(reserveUnit.getUserCode()).getUserRelname());
            modelMap.put((Object)"transaction", (Object)reserveUnit);
            reserveUnitCode = reserveUnit.getReserveUnitCode();
            if (dataState == 2 || dataState == 3) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("reserveUnitCode", reserveUnitCode);
                map.put("tenantCode", tenantCode);
                map.put("dataState", 0);
                paymentDetails = this.paymentDetailsRepository.getPaymentDetailsByReserveUnitCode(map);
                if (paymentDetails != null) {
                    paymentDetails.setPaymentDetailsTypeDesc(SupDisUtil.getMap((String)"EcoreDd-list", (String)("PaymentDetails-paymentDetailsType-" + paymentDetails.getPaymentDetailsType())));
                    String shangDynastyBank = SupDisUtil.getMap((String)"EcoreDd-list", (String)("PaymentDetails-shangDynastyBank-" + paymentDetails.getShangDynastyBankCode()));
                    if (StringUtils.isNotBlank((String)shangDynastyBank)) {
                        paymentDetails.setShangDynastyBankCode(shangDynastyBank);
                    }
                }
                if (StringUtils.isNotBlank((String)reserveUnitCode)) {
                    map.put("reserveUnitCode", reserveUnitCode);
                    map.put("membership", 0);
                    SupQueryResult capitalResult = this.customerCapitalRepository.queryCustomerCapitalOrRes(map);
                    if (capitalResult != null && ListUtil.isNotEmpty((Collection)capitalResult.getList())) {
                        List list = capitalResult.getList();
                        HashSet<String> customerCapitalCodes = new HashSet<String>();
                        HashMap<String, String> capitalMap = new HashMap<String, String>();
                        for (Map temp : list) {
                            String capitalTypeDesc;
                            String reserveUnitTypeDesc = SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstFlowLink-flowLinkType-" + temp.get("reserveUnitType")));
                            if (StringUtils.isNotBlank((String)reserveUnitTypeDesc)) {
                                temp.put("reserveUnitTypeDesc", reserveUnitTypeDesc);
                            }
                            if (StringUtils.isNotBlank((String)(capitalTypeDesc = SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstCustomerCapital-capitalType-" + temp.get("capitalType")))))) {
                                temp.put("capitalTypeDesc", capitalTypeDesc);
                            }
                            Object shouldReceivables = temp.get("shouldReceivables");
                            Object alreadyReceivables = temp.get("alreadyReceivables");
                            if (alreadyReceivables != null) {
                                BigDecimal shouldReceivablesb = new BigDecimal(String.valueOf(shouldReceivables));
                                BigDecimal alreadyReceivablesb = new BigDecimal(String.valueOf(alreadyReceivables));
                                BigDecimal unReceivables = shouldReceivablesb.subtract(alreadyReceivablesb);
                                temp.put("unReceivables", unReceivables);
                            }
                            String customerCapitalCode = String.valueOf(temp.get("customerCapitalCode"));
                            customerCapitalCodes.add(customerCapitalCode);
                            capitalMap.put(customerCapitalCode, capitalTypeDesc);
                        }
                        modelMap.put((Object)"capitals", (Object)list);
                        if (ListUtil.isNotEmpty(customerCapitalCodes)) {
                            map.clear();
                            map.put("customerCapitalCodes", customerCapitalCodes);
                            SupQueryResult queryEstReceivablesRecord = this.estReceivablesRecordRepository.queryEstReceivablesRecord(map);
                            if (queryEstReceivablesRecord != null && ListUtil.isNotEmpty((Collection)queryEstReceivablesRecord.getList())) {
                                List receivablesRecordList = queryEstReceivablesRecord.getList();
                                for (EstReceivablesRecordReBean record : receivablesRecordList) {
                                    if (capitalMap.get(record.getCustomerCapitalCode()) == null) continue;
                                    record.setMemo((String)capitalMap.get(record.getCustomerCapitalCode()));
                                }
                                modelMap.put((Object)"receivablesRecords", (Object)receivablesRecordList);
                                modelMap.addAttribute("pageTools", (Object)this.buildPage(queryEstReceivablesRecord.getPageTools(), request));
                            }
                        }
                    }
                }
            }
        }
        modelMap.put((Object)"paymentDetails", (Object)paymentDetails);
        modelMap.put((Object)"paramMap", (Object)param);
        return String.valueOf(this.getFtlTempPath(request)) + "transaction_content";
    }

    private Map<String, Object> queryBuildingProcess(Map<String, Object> param) {
        Map sups = (Map)this.ptBuildingRepository.queryBuildingPage(param, false, false);
        return sups;
    }

    @RequestMapping(value={"getReserveChangeInfo.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean getReserveChangeInfo(HttpServletRequest request, HttpServletResponse response, String houseCode, String tenantCode) {
        if (StringUtils.isBlankLoop((String[])new String[]{houseCode, tenantCode})) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u67e5\u8be2\u6761\u4ef6");
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String projectCode = null;
        List newReserveUnits = this.reserveUnitRepository.queryReserveUnitByHouseCode(houseCode, projectCode, tenantCode, Integer.valueOf(1));
        List oldReserveUnits = this.reserveUnitRepository.queryReserveUnitByHouseCode(houseCode, projectCode, tenantCode, Integer.valueOf(-1));
        if (ListUtil.isEmpty((Collection)oldReserveUnits)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u53d8\u66f4\u8bb0\u5f55");
        }
        EstReserveUnitReBean newEstReserveUnit = (EstReserveUnitReBean)newReserveUnits.get(0);
        EstReserveUnitBean newEstReserveUnit1 = new EstReserveUnitBean();
        EstReserveUnitReBean oldEstReserveUnit = (EstReserveUnitReBean)oldReserveUnits.get(0);
        EstReserveUnitBean oldEstReserveUnit1 = new EstReserveUnitBean();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)newEstReserveUnit1, (Object)newEstReserveUnit);
            BeanUtils.copyAllPropertysNotNull((Object)oldEstReserveUnit1, (Object)oldEstReserveUnit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, String> contrastObj = CapitalHouseCon.contrastObj(newEstReserveUnit1, oldEstReserveUnit1);
        String zygw = newEstReserveUnit.getUserCode();
        UmUserReDomainBean user = this.userRepository.getUserByCode(zygw);
        zygw = user.getUserRelname();
        String newReserveUnitCode = newEstReserveUnit.getReserveUnitCode();
        String oldReserveUnitCode = oldEstReserveUnit.getReserveUnitCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitCode", newReserveUnitCode);
        map.put("tenantCode", tenantCode);
        map.put("operationType", 9);
        List flowLinkList = this.flowLinkRepository.getFlowLinkList(map, true);
        for (EstFlowLinkBean estFlowLink : flowLinkList) {
            String flowLinkTypeDesc = SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstFlowLink-approvalStatus-" + estFlowLink.getApprovalStatus()));
            if (StringUtils.isBlank((String)flowLinkTypeDesc)) {
                flowLinkTypeDesc = "";
            }
            estFlowLink.setFlowLinkTypeDesc(flowLinkTypeDesc);
        }
        retMap.put("flowLinksObje", flowLinkList);
        List newReserveUnitMemberList = this.reserveUnitMemberRepository.getReserveUnitMemberList(newReserveUnitCode);
        List oldReserveUnitMemberList = this.reserveUnitMemberRepository.getReserveUnitMemberList(oldReserveUnitCode);
        String content = "";
        if (newReserveUnitMemberList.size() != oldReserveUnitMemberList.size()) {
            content = "\u5ba2\u6237\u4fe1\u606f\u53d8\u66f4";
        } else {
            EstReserveUnitMemberBean oldEstReserveUnitMember = null;
            for (EstReserveUnitMemberBean estReserveUnitMemberBean : oldReserveUnitMemberList) {
                if (!estReserveUnitMemberBean.getMembership().equals(0)) continue;
                oldEstReserveUnitMember = estReserveUnitMemberBean;
            }
            EstReserveUnitMemberBean newEstReserveUnitMember = null;
            for (EstReserveUnitMemberBean estReserveUnitMemberBean : newReserveUnitMemberList) {
                if (!estReserveUnitMemberBean.getMembership().equals(0)) continue;
                newEstReserveUnitMember = estReserveUnitMemberBean;
            }
            if (oldEstReserveUnitMember != null && newEstReserveUnitMember != null) {
                Map<String, String> contrastObj2 = CapitalHouseCon.contrastObj(newEstReserveUnitMember, oldEstReserveUnitMember);
                contrastObj.putAll(contrastObj2);
            }
        }
        HashMap<String, String> payMap = new HashMap<String, String>();
        payMap.put("reserveUnitCode", newReserveUnitCode);
        payMap.put("tenantCode", tenantCode);
        PaymentDetailsReBean newPaymentDetails = this.paymentDetailsRepository.getPaymentDetailsByReserveUnitCode(payMap);
        payMap.put("reserveUnitCode", oldReserveUnitCode);
        PaymentDetailsReBean oldPaymentDetails = this.paymentDetailsRepository.getPaymentDetailsByReserveUnitCode(payMap);
        if (newPaymentDetails != null && oldPaymentDetails != null) {
            Map<String, String> contrastObj3 = CapitalHouseCon.contrastObj(newPaymentDetails, oldPaymentDetails);
            contrastObj.putAll(contrastObj3);
        }
        List dds = this.ddRepository.queryDdList("CapitalUpdateProperty", null);
        HashMap<String, String> temp = new HashMap<String, String>();
        if (ListUtil.isNotEmpty((Collection)dds)) {
            for (SfDd sfDd : dds) {
                String property = contrastObj.get(sfDd.getDdColumn());
                if (!StringUtils.isNotBlank((String)property)) continue;
                content = String.valueOf(content) + sfDd.getDdValue() + " ";
            }
            temp.put("content", content);
            temp.put("userName", zygw);
        }
        retMap.put("changeObj", temp);
        return new HtmlJsonReBean(retMap);
    }

    public static void main(String[] args) {
        EstReserveUnitBean newEstReserveUnit = new EstReserveUnitBean();
        newEstReserveUnit.setBookingDate("2221");
        EstReserveUnitBean oldEstReserveUnit = new EstReserveUnitBean();
        oldEstReserveUnit.setBookingDate("222");
        Map<String, String> contrastObj = CapitalHouseCon.contrastObj(newEstReserveUnit, oldEstReserveUnit);
        System.out.println(contrastObj.toString());
    }

    public static Map<String, String> contrastObj(Object newObject, Object oldObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Field[] fields;
            Class<?> clazz = newObject.getClass();
            Field[] fieldArray = fields = oldObject.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!"serialVersionUID".equals(field.getName())) {
                    System.out.println(field.getName());
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                    Method getMethod = pd.getReadMethod();
                    Object o1 = getMethod.invoke(newObject, new Object[0]);
                    Object o2 = getMethod.invoke(oldObject, new Object[0]);
                    if (o1 != null && o2 != null && !o1.toString().equals(o2.toString())) {
                        map.put(field.getName(), field.getName());
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void assemblingHouse(List<HouseReBean> housess, String houseCode, String houseName, Integer dataState, Integer manageUpdateNum) {
        HouseReBean house = new HouseReBean();
        house.setHouseCode(houseCode);
        house.setHouseName(houseName);
        house.setDataState(dataState);
        house.setManageUpdateNum(manageUpdateNum);
        housess.add(house);
    }
}

