/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.devmain.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.constants.EstateConstants;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.bean.EstReport;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReportRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.mm.repository.VisitingRepository;
import com.yqbsoft.laser.html.facade.um.bean.UserBean;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/web/devest/home"})
public class DevHomeCon
extends SpringmvcController {
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private ReserveUnitRepository reserveUnitRepository;
    @Autowired
    private VisitingRepository visitingRepository;

    @RequestMapping(value={"page"})
    public String screeningQueryList(HttpServletRequest request, ModelMap modelMap) {
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        this.switchProject(request, modelMap, param);
        String projectCode = String.valueOf(param.get("projectCode"));
        param.put("projectCode", projectCode);
        param.put("cycleType", "week");
        param.put("tcType", "report");
        param.put("tenantCode", userSession.getTenantCode());
        Map<String, Map<String, Object>> reportTrendChartResult = this.queryTrendChartByDayx(param);
        this.trendChartFormatData(reportTrendChartResult, "report", modelMap);
        Map<String, Map<String, Object>> visitingTrendChartResult = this.queryTrendChartByDayx(param);
        this.trendChartFormatData(visitingTrendChartResult, "visiting", modelMap);
        Map<String, Map<String, Object>> sbuyTrendChartResult = this.queryTrendChartByDayx(param);
        this.trendChartFormatData(sbuyTrendChartResult, "sbuy", modelMap);
        Map<String, Map<String, Object>> tradeTrendChartResult = this.queryTrendChartByDayx(param);
        this.trendChartFormatData(visitingTrendChartResult, "trade", modelMap);
        this.funnelChartData(projectCode, userSession.getTenantCode(), modelMap);
        modelMap.addAttribute("paramMap", (Object)param);
        SupQueryResult<EstReport> supQueryResult = this.queryRealTimeRptPage(userSession, projectCode);
        modelMap.addAttribute("reportList", (Object)supQueryResult.getList());
        SupQueryResult<Map<String, Object>> membersSalesStatistics = this.performanceRanking(userSession, projectCode);
        modelMap.addAttribute("mmSalesList", (Object)membersSalesStatistics.getList());
        return String.valueOf(this.getFtlTempPath(request)) + "home";
    }

    public SupQueryResult<Map<String, Object>> performanceRanking(UserSession userSession, String projectCode) {
        PostParamMap pmap = new PostParamMap("est.estate.membersSalesStatistics");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("projectCode", projectCode);
        param.put("approvalStatus", 2);
        param.put("tenantCode", userSession.getTenantCode());
        param.put("page", 0);
        param.put("rows", 5);
        pmap.putParamToJson("map", param);
        SupQueryResult membersSalesStatistics = this.htmlIBaseService.sendReSupObject(pmap, HashMap.class);
        this.setUserNameMmVisiting(membersSalesStatistics.getRows());
        return membersSalesStatistics;
    }

    private void setUserNameMmVisiting(List<Map<String, Object>> mapList) {
        if (mapList == null) {
            return;
        }
        ArrayList<String> userCodes = new ArrayList<String>();
        for (Map<String, Object> map : mapList) {
            userCodes.add((String)map.get("userCode"));
        }
        PostParamMap pmap = new PostParamMap("um.user.queryUserList");
        HashMap<String, ArrayList<String>> parmMap = new HashMap<String, ArrayList<String>>();
        parmMap.put("userCodes", userCodes);
        pmap.putParamToJson("map", parmMap);
        List users = (List)this.htmlIBaseService.senReList(pmap, UserBean.class);
        if (users == null) {
            return;
        }
        for (Map<String, Object> map : mapList) {
            for (UserBean userBean : users) {
                if (!map.get("userCode").equals(userBean.getUserCode())) continue;
                String userRelname = userBean.getUserRelname();
                if (userRelname.length() > 2) {
                    userRelname = userRelname.substring(0, 2);
                }
                map.put("userName", userRelname);
            }
        }
    }

    private SupQueryResult<EstReport> queryRealTimeRptPage(UserSession user, String projectCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("rptDateSort", 0);
        paramMap.put("page", 0);
        paramMap.put("rows", 8);
        paramMap.put("projectCode", projectCode);
        paramMap.put("tenantCode", user.getTenantCode());
        SupQueryResult supQueryResult = this.reportRepository.queryReportScreeningPage(paramMap);
        return supQueryResult;
    }

    private void funnelChartData(String projectCode, String tenantCode, ModelMap modelMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Calendar curr = Calendar.getInstance();
        curr.add(5, -1);
        String startDate = DateUtils.parseDate((Date)curr.getTime());
        paramMap.put("startDate", startDate);
        paramMap.put("endDate", DateUtils.parseDate((Date)new Date()));
        Integer reportCount = this.reportRepository.getReportCount(paramMap, projectCode, tenantCode);
        paramMap.put("dataState", 1);
        Integer reportCountP = this.reportRepository.getReportCount(paramMap, projectCode, tenantCode);
        paramMap.remove("dataState");
        paramMap.put("groupBy", true);
        Integer visitingCount = this.visitingRepository.getVisitingCount(paramMap, projectCode, tenantCode);
        paramMap.put("reserveUnitTypeGt", EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType());
        Integer reserveUnitCount = this.reserveUnitRepository.getReserveUnitCount(paramMap, projectCode, tenantCode);
        int countTotal = reportCount + reportCountP + visitingCount + reserveUnitCount;
        int reportPercent = 0;
        int reportPPercent = 0;
        int visitingPercent = 0;
        int reserveUnitPercent = 0;
        if (countTotal != 0) {
            if (reportCount != 0) {
                reportPercent = reportCount / countTotal * 100;
            }
            if (reportCountP != 0) {
                reportPPercent = reportCountP / countTotal * 100;
            }
            if (visitingCount != 0) {
                visitingPercent = visitingCount / countTotal * 100;
            }
            if (reserveUnitCount != 0) {
                reserveUnitPercent = reserveUnitCount / countTotal * 100;
            }
        }
        modelMap.addAttribute("reportPercent", (Object)reportPercent);
        modelMap.addAttribute("reportPPercent", (Object)reportPPercent);
        modelMap.addAttribute("visitingPercent", (Object)visitingPercent);
        modelMap.addAttribute("reserveUnitPercent", (Object)reserveUnitPercent);
    }

    private void trendChartFormatData(Map<String, Map<String, Object>> trendChartResult, String dataName, ModelMap modelMap) {
        if (MapUtil.isEmpty(trendChartResult)) {
            return;
        }
        ArrayList<String> dateWeekArray = new ArrayList<String>();
        ArrayList<String> dateMonthArray = new ArrayList<String>();
        ArrayList<Integer> dataWeekArray = new ArrayList<Integer>();
        ArrayList<Integer> dataMonthArray = new ArrayList<Integer>();
        for (Map.Entry<String, Map<String, Object>> tcMap : trendChartResult.entrySet()) {
            if ("week".equals(tcMap.getKey())) {
                for (Map.Entry<String, Object> dataMap : tcMap.getValue().entrySet()) {
                    dateWeekArray.add(dataMap.getKey());
                    dataWeekArray.add(Integer.valueOf(String.valueOf(dataMap.getValue())));
                }
                continue;
            }
            if (!"month".equals(tcMap.getKey())) continue;
            for (Map.Entry<String, Object> dataMap : tcMap.getValue().entrySet()) {
                dateMonthArray.add(dataMap.getKey());
                dataMonthArray.add(Integer.valueOf(String.valueOf(dataMap.getValue())));
            }
        }
        String dateWeekArrayJson = JsonUtil.buildNormalBinder().toJson((Object)dateWeekArray.toArray(new String[dateWeekArray.size()]));
        modelMap.addAttribute(String.valueOf(dataName) + "DateWeekArray", (Object)dateWeekArrayJson);
        String dataWeekArrayJson = JsonUtil.buildNormalBinder().toJson((Object)dataWeekArray.toArray(new Integer[dataWeekArray.size()]));
        modelMap.addAttribute(String.valueOf(dataName) + "DataWeekArray", (Object)dataWeekArrayJson);
        String dateMonthArrayJson = JsonUtil.buildNormalBinder().toJson((Object)dateMonthArray.toArray(new String[dateMonthArray.size()]));
        modelMap.addAttribute(String.valueOf(dataName) + "DateMonthArray", (Object)dateMonthArrayJson);
        String dataMonthArrayJson = JsonUtil.buildNormalBinder().toJson((Object)dataMonthArray.toArray(new Integer[dataMonthArray.size()]));
        modelMap.addAttribute(String.valueOf(dataName) + "DataMonthArray", (Object)dataMonthArrayJson);
    }

    public Map<String, Map<String, Object>> queryTrendChartByDayx(Map<String, Object> param) {
        PostParamMap pmap = new PostParamMap("est.estate.queryTrendChartByDayx");
        pmap.putParamToJson("map", param);
        Map trendChartResult = (Map)this.htmlIBaseService.senBySupRq(pmap, new HashMap());
        return trendChartResult;
    }

    public List<Map<String, String>> queryProjects(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        List list = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        return list;
    }

    private void switchProject(HttpServletRequest request, ModelMap modelMap, Map<String, Object> param) {
        this.getFirstProjectCode(request, param);
        modelMap.put((Object)"projects", this.queryProjects(request));
        modelMap.put((Object)"projectCode", param.get("projectCode"));
    }

    public void getFirstProjectCode(HttpServletRequest request, Map<String, Object> parmMap) {
        UserSession user = this.getUserSession(request);
        String projectCode = (String)parmMap.get("projectCode");
        if (StringUtils.isNotBlank((String)projectCode)) {
            return;
        }
        List list = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (list != null && list.size() > 0) {
            for (Map map : list) {
                Iterator iterator = map.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                parmMap.put("projectCode", entry.getValue());
                return;
            }
        }
    }

    protected String getContext() {
        return "devmain";
    }
}

