/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.handler.config;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.ModelMap;

@Component
public class BuildingHouseListHandler {
    @Autowired
    private PtBuildingRepository ptBuildingRepository;
    @Autowired
    private PtHouseRepository ptHouseRepository;
    @Autowired
    private DdRepository ddRepository;

    /*
     * WARNING - void declaration
     */
    public void sellControllerListLogic(HttpServletRequest request, ModelMap modelMap, String projectSelect, UserSession user) {
        List houses;
        List buildings;
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        if (param != null) {
            if (param.get("projectSelect") != null) {
                param.put("projectCode", param.get("projectSelect"));
            }
            if (param.get("buildingSelect") != null) {
                param.put("buildingCode", param.get("buildingSelect"));
            }
            if (param.get("unitSelect") != null) {
                param.put("unitCode", param.get("unitSelect"));
            }
        }
        Map<String, Object> supsBuilding = this.queryBuildingProcess(param);
        String defaultBuildingCode = "";
        String defaultBuildingName = "";
        Integer buildingType = 1;
        String defaultProjectCode = "";
        if (supsBuilding != null && ListUtil.isNotEmpty((Collection)(buildings = (List)supsBuilding.get("list")))) {
            defaultBuildingCode = ((Map)buildings.get(0)).get("buildingCode");
            defaultBuildingName = (String)((Map)buildings.get(0)).get("buildingName");
            buildingType = (Integer)((Map)buildings.get(0)).get("buildingType");
            defaultProjectCode = (String)((Map)buildings.get(0)).get("projectCode");
        }
        if (StringUtils.isNotBlank((String)defaultBuildingName)) {
            param.put("buildingCode", defaultBuildingCode);
        }
        param.put("orderStr", " unit_name*1 ,floor_name*1,house_name*1");
        List<HouseReBean> houseList = this.queryHouseResult(param);
        Map sups = (Map)this.ptHouseRepository.queryHousePage(param, true, false);
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (sups != null && ListUtil.isNotEmpty((Collection)(houses = (List)sups.get("list")))) {
            ArrayList units = new ArrayList();
            for (Map houseMap : houses) {
                boolean exists = false;
                HashMap unit = new HashMap();
                for (Map map : units) {
                    if (!map.get("unitCode").equals(houseMap.get("unitCode"))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                unit.put("unitCode", houseMap.get("unitCode"));
                unit.put("unitName", houseMap.get("unitName"));
                units.add(unit);
            }
            retMap.put("units", units);
            ArrayList<Map<String, ArrayList<Map<String, Object>>>> floors = new ArrayList<Map<String, ArrayList<Map<String, Object>>>>();
            for (Map houseMap : houses) {
                boolean bl;
                Map<String, ArrayList<Map<String, Object>>> floor = new HashMap();
                boolean bl2 = false;
                for (Map map : floors) {
                    if (!houseMap.get("floorName").equals(map.get("floorName"))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                floor.put("floorCode", (ArrayList<Map<String, Object>>)houseMap.get("floorCode"));
                floor.put("floorName", (ArrayList<Map<String, Object>>)houseMap.get("floorName"));
                floors.add(floor);
            }
            String unitCodeMark = "";
            int unitColspanCount = 4;
            for (Map<String, ArrayList<Map<String, Object>>> floor : floors) {
                void var21_34;
                boolean bl = false;
                ArrayList<Map<String, Object>> housess = new ArrayList<Map<String, Object>>();
                for (Map houseMap_housess : houses) {
                    if (!unitCodeMark.equals(houseMap_housess.get("unitCode"))) {
                        if (StringUtils.isNotBlank((String)unitCodeMark) && unitColspanCount > var21_34 && var21_34 > 0) {
                            int i = 0;
                            while (i < unitColspanCount - var21_34) {
                                this.assemblingHouse(housess, "", "", "-1", "0");
                                ++var21_34;
                                ++i;
                            }
                        }
                        unitCodeMark = (String)houseMap_housess.get("unitCode");
                    }
                    if (!floor.get("floorName").equals(houseMap_housess.get("floorName"))) continue;
                    boolean houseExists = false;
                    for (Map map : housess) {
                        if (!map.get("houseCode").equals(houseMap_housess.get("houseCode"))) continue;
                        houseExists = true;
                        break;
                    }
                    if (houseExists) break;
                    this.assemblingHouse(housess, houseMap_housess.get("houseCode"), houseMap_housess.get("houseName"), houseMap_housess.get("dataState"), houseMap_housess.get("manageUpdateNum"));
                    ++var21_34;
                }
                if (buildingType == 2 && var21_34 > unitColspanCount) {
                    unitColspanCount = var21_34;
                }
                floor.put("housess", housess);
            }
            for (Map<String, ArrayList<Map<String, Object>>> floor : floors) {
                List list = (List)floor.get("housess");
                int h = 0;
                int j = list.size();
                if (j % unitColspanCount > 0) {
                    h = unitColspanCount - j % unitColspanCount;
                }
                int i = 0;
                while (i < h) {
                    this.assemblingHouse(list, "", "", "-1", "0");
                    ++i;
                }
            }
            retMap.put("floors", floors);
            retMap.put("unitColspan", unitColspanCount);
            if (StringUtils.isEmpty((String)projectSelect)) {
                projectSelect = defaultProjectCode;
            }
            retMap.put("projectSelect", projectSelect);
            retMap.put("buildingSelect", param.get("buildingSelect"));
            retMap.put("unitSelect", param.get("unitSelect"));
            retMap.put("sellDataState", param.get("sellDataState"));
            modelMap.put((Object)"retMap", retMap);
        }
        if (ListUtil.isNotEmpty(houseList)) {
            Collections.sort(houseList, new Comparator<HouseReBean>(){

                @Override
                public int compare(HouseReBean o1, HouseReBean o2) {
                    String houseName2;
                    String houseName;
                    block4: {
                        try {
                            houseName = o1.getHouseName();
                            houseName2 = o2.getHouseName();
                            if (houseName.length() >= houseName2.length()) break block4;
                            return -1;
                        }
                        catch (Exception e) {
                            return 1;
                        }
                    }
                    if (houseName.length() == houseName2.length()) {
                        return houseName.compareTo(houseName2);
                    }
                    return 1;
                }
            });
            ArrayList houseLists = new ArrayList();
            ArrayList<HouseReBean> houseListTemp = new ArrayList<HouseReBean>();
            int i = 1;
            int size = houseList.size();
            int z = size / 10;
            for (HouseReBean house : houseList) {
                houseListTemp.add(house);
                if (i % 10 == 0) {
                    houseLists.add(houseListTemp);
                    houseListTemp = new ArrayList();
                }
                if (z <= 0 || ++i != size) continue;
                houseLists.add(houseListTemp);
            }
            modelMap.put((Object)"houseLists", houseLists);
            modelMap.put((Object)"houseCount", (Object)size);
        }
        List commissionTypes = this.ddRepository.getDisList("PtProjectRelation-commissionType");
        modelMap.put((Object)"commissionTypes", (Object)commissionTypes);
    }

    private Map<String, Object> queryBuildingProcess(Map<String, Object> param) {
        Map sups = (Map)this.ptBuildingRepository.queryBuildingPage(param, false, false);
        return sups;
    }

    private List<HouseReBean> queryHouseResult(Map<String, Object> param) {
        SupQueryResult queryHouseResult = this.ptHouseRepository.queryHousePage2(param, true, false);
        if (queryHouseResult != null && ListUtil.isNotEmpty((Collection)queryHouseResult.getList())) {
            List houseList = queryHouseResult.getList();
            return houseList;
        }
        return null;
    }

    private void assemblingHouse(List<Map<String, Object>> housess, Object houseCode, Object houseName, Object dataState, Object manageUpdateNum) {
        HashMap<String, Object> house = new HashMap<String, Object>();
        house.put("houseCode", houseCode);
        house.put("houseName", houseName);
        house.put("dataState", Integer.valueOf(String.valueOf(dataState)));
        house.put("manageUpdateNum", Integer.valueOf(String.valueOf(manageUpdateNum)));
        housess.add(house);
    }
}

