/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.file.bean.DownloadFileDomainBean;
import com.yqbsoft.laser.html.facade.bm.file.repository.DownloadFileRepository;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.project.bean.BuildingReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.ProjectBean;
import com.yqbsoft.laser.html.facade.est.project.bean.ProjectReBean;
import com.yqbsoft.laser.html.facade.est.project.domain.PtBuildingDomain;
import com.yqbsoft.laser.html.facade.est.project.domain.PtProjectCpDomain;
import com.yqbsoft.laser.html.facade.est.project.domain.PtProjectTmDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.TeamRepository;
import com.yqbsoft.laser.html.facade.pt.bean.UnitReBean;
import com.yqbsoft.laser.html.facade.pt.repository.ElevatorRepository;
import com.yqbsoft.laser.html.facade.pt.repository.PtUnitRepository;
import com.yqbsoft.laser.html.facade.um.domain.UmCompanyReDomain;
import com.yqbsoft.laser.html.facade.um.repository.CompanyRepository;
import com.yqbsoft.laser.html.handler.config.BuildingHouseListHandler;
import com.yqbsoft.laser.html.project.bean.BuildingBatchBean;
import com.yqbsoft.laser.html.project.bean.BuildingImpBean;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ExcelReaderUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/pt/building"})
public class BuildingCon
extends SpringmvcController {
    private static String CODE = "pt.building.con";
    @Autowired
    private PtBuildingRepository ptBuildingRepository;
    @Autowired
    private PtHouseRepository ptHouseRepository;
    @Resource
    private DownloadFileRepository downloadFileRepository;
    @Resource
    private TeamRepository teamRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private PtUnitRepository ptUnitRepository;
    @Resource
    private ElevatorRepository elevatorRepository;
    @Resource
    private CompanyRepository companyRepository;
    @Resource
    private BuildingHouseListHandler buildingHouseListHandler;

    protected String getContext() {
        return "building";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtBuildingDomain buildingBean) {
        if (buildingBean == null) {
            this.logger.error(String.valueOf(CODE) + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.saveBuilding(buildingBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String buildingId, ModelMap modelMap) {
        modelMap.put((Object)"buildingReBean", (Object)this.getBuilding(buildingId));
        return String.valueOf(this.getFtlTempPath(request)) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtBuildingDomain buildingBean) {
        if (buildingBean == null) {
            this.logger.error(String.valueOf(CODE) + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.updateBuilding(buildingBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String buildingId) {
        if (StringUtils.isBlank((String)buildingId)) {
            this.logger.error(String.valueOf(CODE) + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.deleteBuilding(Integer.valueOf(Integer.parseInt(buildingId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String buildingId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)buildingId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(String.valueOf(CODE) + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.updateBuildingState(buildingId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String buildingId, ModelMap modelMap) {
        modelMap.put((Object)"buildingReBean", (Object)this.getBuilding(buildingId));
        return String.valueOf(this.getFtlTempPath(request)) + "view";
    }

    private String getBuilding(String buildingId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)buildingId)) {
            this.logger.error(String.valueOf(CODE) + ".getBuilding", (Object)"buildingId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.ptProjectRepository.getBuilding(Integer.valueOf(Integer.parseInt(buildingId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ptProjectRepository.queryBuildingPage(param);
    }

    @RequestMapping(value={"dev/sellControl/imp"})
    public String impAdd(HttpServletRequest request, ModelMap map) {
        UserSession userSession = this.getUserSession(request);
        List projects = this.ptProjectRepository.getProjectByRole(userSession, Integer.valueOf(0), true);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            map.addAttribute("projects", (Object)projects);
        }
        return String.valueOf(this.getFtlTempPath(request)) + "imp";
    }

    @RequestMapping(value={"dev/sellControl/download/modelfile"})
    public String download(String type, String fileCode, HttpServletResponse response, HttpServletRequest request) {
        if (type != null) {
            "sellControl".equals(type);
        }
        if (StringUtils.isBlank((String)fileCode)) {
            request.setAttribute("ex", (Object)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new SupperSysException("download", "\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        ServletOutputStream out2 = null;
        DownloadFileDomainBean downloadFile = this.downloadFileRepository.getDownloadFileByCode(fileCode);
        byte[] fileContent = downloadFile.getFilecontent();
        if (fileContent != null && fileContent.length > 0) {
            String fileName = downloadFile.getFileName() == null ? String.valueOf(downloadFile.getFileCode()) + "." + downloadFile.getFileCtype() : downloadFile.getFileName();
            response.setHeader("content-disposition", "attachment;filename=" + fileName + "." + downloadFile.getFileCtype());
            try {
                out2 = response.getOutputStream();
                out2.write(fileContent);
                out2.flush();
            }
            catch (IOException e) {
                request.setAttribute("ex", (Object)e.getMessage());
                throw new SupperSysException("download", e.getMessage());
            }
        } else {
            request.setAttribute("ex", (Object)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new SupperSysException("download", "\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        return null;
    }

    private String[] getTeamCode(String userCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", userCode);
        String[] teamInfo = this.teamRepository.getTeamInfo(param);
        return teamInfo;
    }

    private String[] getProjectInfo(UserSession userSession, String teamCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", userSession.getUserCode());
        param.put("tenantCode", userSession.getTenantCode());
        param.put("dataState", "0");
        param.put("teamCode", teamCode);
        String[] projectInfo = this.ptProjectRepository.getProjectInfoByUserCode(param);
        return projectInfo;
    }

    @RequestMapping(value={"dev/sellControl/imp/initializeBuilding"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean initializeBuilding(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file, String projectCode, String handleType) {
        HashMap<String, String> projectMap = new HashMap<String, String>();
        projectMap.put("projectCode", projectCode);
        ProjectReBean pb = this.ptProjectRepository.getProjectByCode(projectMap);
        String tenantCode = pb.getTenantCode();
        if (StringUtils.isEmpty((String)tenantCode)) {
            tenantCode = this.getTenantCode(request);
        }
        if (StringUtils.isEmpty((String)handleType)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u9009\u62e9\u5bfc\u5165\u7c7b\u578b");
        }
        Integer impType = Integer.parseInt(handleType);
        if (file != null) {
            Map columnMap = this.ddRepository.getExcelColumnMatch("ExcelSellControl-impProperty");
            if (MapUtil.isEmpty((Map)columnMap)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u540e\u53f0\u5bf9\u5e94\u7684\u5c5e\u6027,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            List list = null;
            try {
                String buildingNames = ExcelReaderUtils.getSheetsNameByStream((InputStream)file.getInputStream());
                list = ExcelReaderUtils.parseExcelByStream((InputStream)file.getInputStream(), (Object)new BuildingBatchBean(), (Map)columnMap);
                this.logger.info("\u89e3\u6790excel\u7684sheet\u4e2a\u6570\uff1a" + list.size());
                if (ListUtil.isEmpty((Collection)list)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u8bfb\u53d6\u5230\u6570\u636e");
                }
                this.readyInfo(list, projectCode, buildingNames, tenantCode, impType);
                this.logger.info("\u9500\u63a7\u6279\u91cf\u5bfc\u5165\u6210\u529f");
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
        }
        return new HtmlJsonReBean();
    }

    public Map<String, Object> readyInfo(List<List<BuildingBatchBean>> lists, String projectCode, String buildingNames, String tenantCode, Integer impType) throws Exception {
        int i = 0;
        String[] buildingNamess = buildingNames.split("\\|");
        for (List<BuildingBatchBean> list : lists) {
            for (BuildingBatchBean buildingBatchBean : list) {
                buildingBatchBean.setImpType(impType);
                buildingBatchBean.setBuildingName(buildingNamess[i]);
                buildingBatchBean.setProjectCode(projectCode);
                buildingBatchBean.setTenantCode(tenantCode);
            }
            PostParamMap pmap = new PostParamMap("pt.project.insertInitBatchBuilding");
            pmap.putParamToJson("list", list);
            this.htmlIBaseService.senBySupRq(pmap, new ArrayList());
            this.logger.info("\u89e3\u6790\u7b2c" + ++i + "\u4e2asheet\uff0c\u9500\u63a7\u6279\u91cf\u5bfc\u5165\u6210\u529f" + list.size() + "\u6761");
        }
        return null;
    }

    public Map<String, Object> readyInfoBak(List<List<BuildingImpBean>> lists, String projectCode, String buildingNames, String tenantCode, Integer impType) throws Exception {
        if (buildingNames != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (List<BuildingImpBean> list : lists) {
                int j = 0;
                ArrayList<BuildingBatchBean> buildings = new ArrayList<BuildingBatchBean>();
                for (BuildingImpBean buildingImpBean : list) {
                    ++j;
                    BuildingBatchBean impBatchBean = new BuildingBatchBean();
                    impBatchBean.setUnitName(buildingImpBean.getUnitName());
                    impBatchBean.setHouseType(buildingImpBean.getHouseType());
                    impBatchBean.setBuildingName(buildingNames);
                    impBatchBean.setFloorName(buildingImpBean.getFloorName());
                    impBatchBean.setHouseName(buildingImpBean.getHouseName());
                    impBatchBean.setImpType(impType);
                    try {
                        impBatchBean.setPrivateArea(this.toBigDecimal(buildingImpBean.getPrivateArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u79c1\u6709\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setPublicCoefficient(this.toBigDecimal(buildingImpBean.getPublicCoefficient()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u516c\u644a\u7cfb\u6570"));
                    }
                    try {
                        impBatchBean.setPublicArea(this.toBigDecimal(buildingImpBean.getPublicArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u516c\u644a\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setBalconyArea(this.toBigDecimal(buildingImpBean.getBalconyArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u9633\u53f0\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setTotalArea(this.toBigDecimal(buildingImpBean.getTotalArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u5efa\u7b51\u603b\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setAveragePrice(this.toBigDecimal(buildingImpBean.getAveragePrice()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u5355\u4ef7"));
                    }
                    try {
                        impBatchBean.setTotalPrice(this.toBigDecimal(buildingImpBean.getTotalPrice()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u603b\u4ef7"));
                    }
                    int minPrice = 0;
                    if (buildingImpBean.getMinPrice() != null) {
                        minPrice = Integer.valueOf(buildingImpBean.getMinPrice());
                    }
                    impBatchBean.setMinPrice(minPrice);
                    impBatchBean.setFunctionalAreas(buildingImpBean.getFunctionalAreas());
                    impBatchBean.setProjectCode(projectCode);
                    impBatchBean.setTenantCode(tenantCode);
                    impBatchBean.setComment(buildingImpBean.getComment());
                    buildings.add(impBatchBean);
                }
                PostParamMap pmap = new PostParamMap("pt.project.insertInitBatchBuilding");
                pmap.putParamToJson("list", buildings);
                this.htmlIBaseService.senBySupRq(pmap, new ArrayList());
                this.logger.info("\u89e3\u6790\u7b2c" + ++i + "\u4e2asheet\uff0c\u9500\u63a7\u6279\u91cf\u5bfc\u5165\u6210\u529f" + list.size() + "\u6761");
            }
        } else {
            throw new Exception("\u672a\u6309\u7167\u6307\u5b9a\u683c\u5f0f\u5bfc\u5165\uff0c\u8bf7\u68c0\u67e5sheet\u540d\u79f0");
        }
        return null;
    }

    private String getExceptionStr(StringBuffer sb, int i, int j, String exceStr) {
        if (sb != null && sb.length() > 0) {
            sb.delete(0, sb.length() - 1);
        }
        sb.append("\u9519\u8bef\uff0c\u5728\u7b2c");
        sb.append(i + 1);
        sb.append("\u4e2asheet\uff0c\u7b2c");
        sb.append(j);
        sb.append("\u884c");
        sb.append(exceStr);
        sb.append("\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
        return sb.toString();
    }

    private BigDecimal toBigDecimal(String str) throws Exception {
        if (StringUtils.isNotBlank((String)str)) {
            try {
                return new BigDecimal(str);
            }
            catch (Exception e) {
                throw new Exception("\u8bf7\u68c0\u67e5\u5404\u6570\u5b57\u6b63\u786e");
            }
        }
        return new BigDecimal(0);
    }

    @RequestMapping(value={"dev/sellControl/list"})
    public String devSellControlList(HttpServletRequest request, ModelMap modelMap, String projectSelect) {
        UserSession user = this.getUserSession(request);
        this.buildingHouseListHandler.sellControllerListLogic(request, modelMap, projectSelect, user);
        modelMap.addAttribute("bigTitle", (Object)"\u9500\u63a7\u7ba1\u7406");
        modelMap.addAttribute("smallTitle", (Object)"\u9500\u63a7\u5217\u8868");
        ConcurrentHashMap<String, Boolean> findMap = new ConcurrentHashMap<String, Boolean>();
        findMap.put("titleHouse", true);
        modelMap.addAttribute("findMap", findMap);
        modelMap.addAttribute("queryUrl", (Object)"/web/pt/building/dev/sellControl/list");
        return "house_list";
    }

    private List<HouseReBean> queryHouseResult(Map<String, Object> param) {
        SupQueryResult queryHouseResult = this.ptHouseRepository.queryHousePage2(param, true, false);
        if (queryHouseResult != null && ListUtil.isNotEmpty((Collection)queryHouseResult.getList())) {
            List houseList = queryHouseResult.getList();
            return houseList;
        }
        return null;
    }

    private void assemblingHouse(List<Map<String, Object>> housess, Object houseCode, Object houseName, Object dataState, Object manageUpdateNum) {
        HashMap<String, Object> house = new HashMap<String, Object>();
        house.put("houseCode", houseCode);
        house.put("houseName", houseName);
        house.put("dataState", Integer.valueOf(String.valueOf(dataState)));
        house.put("manageUpdateNum", Integer.valueOf(String.valueOf(manageUpdateNum)));
        housess.add(house);
    }

    @RequestMapping(value={"dev/sellControl/setting"})
    public String devSellControlSetting(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"dev/sellControl/examlist"})
    public String devSellControlExamList(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"dev/queryPtBuilding.json"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean queryPtBuilding(HttpServletRequest request) {
        List buildings;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        Map<String, Object> sups = this.queryBuildingProcess(param);
        if (sups != null && ListUtil.isNotEmpty((Collection)(buildings = (List)sups.get("list")))) {
            return new HtmlJsonReBean((Object)buildings);
        }
        return new HtmlJsonReBean(new ArrayList());
    }

    @RequestMapping(value={"dev/queryPtUnit.json"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean queryPtUnit(HttpServletRequest request) {
        List units;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        SupQueryResult<UnitReBean> queryUnitProcess = this.queryUnitProcess(param);
        if (queryUnitProcess != null && ListUtil.isNotEmpty((Collection)queryUnitProcess.getList()) && ListUtil.isNotEmpty((Collection)(units = queryUnitProcess.getList()))) {
            return new HtmlJsonReBean((Object)units);
        }
        return new HtmlJsonReBean(new ArrayList());
    }

    private Map<String, Object> queryBuildingProcess(Map<String, Object> param) {
        Map sups = (Map)this.ptBuildingRepository.queryBuildingPage(param, false, false);
        return sups;
    }

    private SupQueryResult<UnitReBean> queryUnitProcess(Map<String, Object> param) {
        SupQueryResult queryUnitResult = this.ptUnitRepository.queryUnitPage(param, false, false);
        return queryUnitResult;
    }

    @RequestMapping(value={"dev/elevatorpt/imp"})
    public String impElevatorpt(HttpServletRequest request, ModelMap map, String projectCode) {
        UserSession userSession = this.getUserSession(request);
        List projects = this.ptProjectRepository.getProjectByRole(userSession, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            map.addAttribute("projects", (Object)projects);
        }
        if (StringUtils.isNotBlank((String)projectCode)) {
            map.addAttribute("projectCode", (Object)projectCode);
        }
        return String.valueOf(this.getFtlTempPath(request)) + "imp";
    }

    @RequestMapping(value={"dev/elevatorpt/addProjectPage"})
    public String addProjectPage(HttpServletRequest request, ModelMap map) {
        map.addAttribute("bigTitle", (Object)"\u697c\u76d8\u7ba1\u7406");
        map.addAttribute("secondTitle", (Object)"\u697c\u76d8\u65b0\u589e");
        return String.valueOf(this.getFtlTempPath(request)) + "addProject";
    }

    @RequestMapping(value={"dev/elevatorpt/addProject.json"})
    @ResponseBody
    public HtmlJsonReBean addProject(HttpServletRequest request, @RequestBody ProjectBean projectBean) {
        if (projectBean == null || StringUtils.isEmpty((String)projectBean.getProjectName())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u4f20\u5165\u6570\u636e");
        }
        UserSession user = this.getUserSession(request);
        String tenantCode = user.getTenantCode();
        String userCode = user.getUserCode();
        projectBean.setTenantCode(tenantCode);
        String teamCode = this.teamRepository.getTeamCode(userCode);
        if (StringUtils.isBlank((String)teamCode)) {
            String projectCode = this.ptProjectRepository.saveProjectRet(projectBean);
            return new HtmlJsonReBean((Object)projectCode);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", user.getUserCode());
        param.put("tenantCode", tenantCode);
        String[] teamInfo = this.teamRepository.getTeamInfo(param);
        String companyCode = teamInfo[2];
        param.clear();
        param.put("companyCode", companyCode);
        UmCompanyReDomain company = this.companyRepository.getCompanyByCode(param);
        String projectCode = this.ptProjectRepository.saveProjectRet(projectBean);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(String.valueOf(CODE) + "dev/elevatorpt/addProject.json", (Object)"\u4fdd\u5b58\u9879\u76ee\u5931\u8d25\uff0c\u4fdd\u5b58\u81f3project");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u6dfb\u52a0\u5931\u8d25");
        }
        PtProjectCpDomain projectCpDomain = new PtProjectCpDomain();
        projectCpDomain.setProjectCode(projectCode);
        projectCpDomain.setProjectName(projectBean.getProjectName());
        projectCpDomain.setTenantCode(projectBean.getTenantCode());
        projectCpDomain.setCompanyCode(companyCode);
        projectCpDomain.setCompanyName(company.getCompanyName());
        String cpCode = this.ptProjectRepository.saveProjectCpRet(projectCpDomain);
        if (StringUtils.isBlank((String)cpCode)) {
            this.logger.error(String.valueOf(CODE) + "dev/elevatorpt/addProject.json", (Object)"\u4fdd\u5b58\u9879\u76ee\u5931\u8d25\uff0c\u4fdd\u5b58\u81f3projectcp");
            this.ptProjectRepository.deleteProjectByCode(projectCode, tenantCode);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u6dfb\u52a0\u5931\u8d25");
        }
        PtProjectTmDomain ptProjectTmDomain = new PtProjectTmDomain();
        ptProjectTmDomain.setProjectCode(projectCode);
        ptProjectTmDomain.setProjectName(projectBean.getProjectName());
        ptProjectTmDomain.setTenantCode(projectBean.getTenantCode());
        ptProjectTmDomain.setTeamCode(teamCode);
        ptProjectTmDomain.setTeamName(teamInfo[1]);
        String tmCode = this.ptProjectRepository.saveProjectTmRet(ptProjectTmDomain);
        if (StringUtils.isNotBlank((String)tmCode)) {
            return new HtmlJsonReBean();
        }
        this.logger.error(String.valueOf(CODE) + "dev/elevatorpt/addProject.json", (Object)"\u4fdd\u5b58\u9879\u76ee\u5931\u8d25\uff0c\u4fdd\u5b58\u81f3projectTm");
        this.ptProjectRepository.deleteProjectByCode(projectCode, tenantCode);
        this.ptProjectRepository.deleteProjectCpByCode(cpCode, tenantCode);
        this.ptProjectRepository.delProjectTmByCode(tmCode, tenantCode);
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"dev/elevatorpt/imp/init"})
    @ResponseBody
    public HtmlJsonReBean initElevatorpt(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file, String projectCode, String handleType) {
        HashMap<String, String> projectMap = new HashMap<String, String>();
        projectMap.put("projectCode", projectCode);
        ProjectReBean pb = this.ptProjectRepository.getProjectByCode(projectMap);
        String tenantCode = pb.getTenantCode();
        if (StringUtils.isEmpty((String)tenantCode)) {
            tenantCode = this.getTenantCode(request);
        }
        if (StringUtils.isEmpty((String)handleType)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u9009\u62e9\u5bfc\u5165\u7c7b\u578b");
        }
        Integer impType = Integer.parseInt(handleType);
        if (file != null) {
            Map columnMap = this.ddRepository.getExcelColumnMatch("ExcelElevatorUnit-impProperty");
            if (MapUtil.isEmpty((Map)columnMap)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u540e\u53f0\u5bf9\u5e94\u7684\u5c5e\u6027,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            List list = null;
            try {
                list = ExcelReaderUtils.parseExcelByStream((InputStream)file.getInputStream(), (Object)new BuildingBatchBean(), (Map)columnMap);
                this.logger.info("\u89e3\u6790excel\u7684sheet\u4e2a\u6570\uff1a" + list.size());
                if (ListUtil.isEmpty((Collection)list)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u8bfb\u53d6\u5230\u6570\u636e");
                }
                this.readyInfoUnitBatch(list, projectCode, tenantCode, impType);
                this.logger.info("\u697c\u76d8\u6279\u91cf\u5bfc\u5165\u6210\u529f");
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
        }
        return new HtmlJsonReBean((Object)true);
    }

    public Map<String, Object> readyInfoUnitBatch(List<List<BuildingBatchBean>> lists, String projectCode, String tenantCode, Integer impType) throws Exception {
        int i = 0;
        for (List<BuildingBatchBean> list : lists) {
            for (BuildingBatchBean buildingBatchBean : list) {
                buildingBatchBean.setImpType(impType);
                buildingBatchBean.setProjectCode(projectCode);
                buildingBatchBean.setTenantCode(tenantCode);
            }
            PostParamMap pmap = new PostParamMap("pt.project.insertInitBatchBuilding");
            pmap.putParamToJson("list", list);
            this.htmlIBaseService.senBySupRq(pmap, new ArrayList());
            this.logger.info("\u89e3\u6790\u7b2c" + ++i + "\u4e2asheet\uff0c\u697c\u76d8\u6279\u91cf\u5bfc\u5165\u6210\u529f" + list.size() + "\u6761");
        }
        return null;
    }

    @RequestMapping(value={"dev/elevatorpt/list"})
    public String devElevatorptList(HttpServletRequest request, ModelMap modelMap, String projectCode, String buildingCode) {
        UserSession user = this.getUserSession(request);
        Map pageParam = HtmlUtil.buildPage((HttpServletRequest)request);
        pageParam.put("tenantCode", user.getTenantCode());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", user.getTenantCode());
        SupQueryResult results = this.ptProjectRepository.queryProjectPage(map);
        if (results != null) {
            modelMap.put((Object)"projects", (Object)results.getList());
            if (StringUtils.isEmpty((String)projectCode)) {
                projectCode = ((ProjectReBean)results.getList().get(0)).getProjectCode();
                pageParam.put("projectCode", projectCode);
            }
            if (!StringUtils.isEmpty((String)projectCode)) {
                map.put("projectCode", projectCode);
                SupQueryResult buildings = this.ptBuildingRepository.queryBuildingPage2(map, true, false);
                if (buildings != null && ListUtil.isNotEmpty((Collection)buildings.getList())) {
                    if (StringUtils.isEmpty((String)buildingCode)) {
                        buildingCode = ((BuildingReBean)buildings.getList().get(0)).getBuildingCode();
                        pageParam.put("buildingCode", buildingCode);
                    }
                    modelMap.put((Object)"buildings", (Object)buildings.getList());
                    SupQueryResult result = this.ptUnitRepository.queryUnitPage(pageParam, true, false);
                    if (result != null) {
                        List units = result.getList();
                        HashSet<String> unitCodes = new HashSet<String>();
                        for (UnitReBean unitReBean : units) {
                            unitCodes.add(unitReBean.getUnitCode());
                        }
                        map.clear();
                        map.put("unitCodes", unitCodes);
                        map.put("tenantCode", user.getTenantCode());
                        map.put("dataState", 0);
                        List unitElevators = this.elevatorRepository.getUnitElevatorCount(map);
                        map.clear();
                        if (ListUtil.isNotEmpty((Collection)unitElevators)) {
                            HashMap<String, Integer> unitMap = new HashMap<String, Integer>();
                            for (Map temp : unitElevators) {
                                if (temp.get("elevatorCount") == null) continue;
                                unitMap.put((String)temp.get("unitCode"), Integer.parseInt(String.valueOf(temp.get("elevatorCount"))));
                            }
                            for (Map temp : units) {
                                temp.setElevatorCount((Integer)unitMap.get(temp.getUnitCode()));
                            }
                        }
                        if (ListUtil.isNotEmpty((Collection)units)) {
                            Collections.sort(units, new Comparator<UnitReBean>(){

                                @Override
                                public int compare(UnitReBean o1, UnitReBean o2) {
                                    String unitName2;
                                    String unitName1;
                                    block4: {
                                        try {
                                            unitName1 = o1.getUnitName().substring(0, o1.getUnitName().length() - 2);
                                            unitName2 = o2.getUnitName().substring(0, o2.getUnitName().length() - 2);
                                            if (Integer.parseInt(unitName1) <= Integer.parseInt(unitName2)) break block4;
                                            return 1;
                                        }
                                        catch (Exception e) {
                                            return 1;
                                        }
                                    }
                                    if (Integer.parseInt(unitName1) == Integer.parseInt(unitName2)) {
                                        return 0;
                                    }
                                    return -1;
                                }
                            });
                        }
                        modelMap.addAttribute("units", (Object)units);
                        modelMap.addAttribute("pageTools", (Object)this.buildPage(result.getPageTools(), request));
                    }
                }
            }
        }
        modelMap.addAttribute("projectCode", (Object)projectCode);
        modelMap.addAttribute("buildingCode", (Object)buildingCode);
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }
}

