/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.project.domain.PtFloorDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pt/floor"})
public class FloorCon
extends SpringmvcController {
    private static String CODE = "pt.floor.con";
    @Autowired
    private PtProjectRepository projectRepository;

    protected String getContext() {
        return "floor";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtFloorDomain floorBean) {
        if (floorBean == null) {
            this.logger.error(String.valueOf(CODE) + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.saveFloor(floorBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String floorId, ModelMap modelMap) {
        modelMap.put((Object)"floorReBean", (Object)this.getFloor(floorId));
        return String.valueOf(this.getFtlTempPath(request)) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtFloorDomain floorBean) {
        if (floorBean == null) {
            this.logger.error(String.valueOf(CODE) + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateFloor(floorBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String floorId) {
        if (StringUtils.isBlank((String)floorId)) {
            this.logger.error(String.valueOf(CODE) + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.deleteFloor(Integer.valueOf(Integer.parseInt(floorId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String floorId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)floorId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(String.valueOf(CODE) + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateFloorState(floorId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String floorId, ModelMap modelMap) {
        modelMap.put((Object)"floorReBean", (Object)this.getFloor(floorId));
        return String.valueOf(this.getFtlTempPath(request)) + "view";
    }

    private String getFloor(String floorId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)floorId)) {
            this.logger.error(String.valueOf(CODE) + ".getFloor", (Object)"floorId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.projectRepository.getFloor(Integer.valueOf(Integer.parseInt(floorId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.projectRepository.queryFloorPage(param);
    }
}

