/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.constants.EstateConstants;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstFlowLinkReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReceivablesRecordReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.bean.PaymentDetailsReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.project.domain.PtHouseDomain;
import com.yqbsoft.laser.html.facade.est.project.domain.PtHouseReDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.repository.CustomerCapitalRepository;
import com.yqbsoft.laser.html.facade.est.repository.EstReceivablesRecordRepository;
import com.yqbsoft.laser.html.facade.est.repository.FlowLinkRepository;
import com.yqbsoft.laser.html.facade.est.repository.PaymentDetailsRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pt/house"})
public class HouseCon
extends SpringmvcController {
    private static String CODE = "pt.house.con";
    @Autowired
    private PtHouseRepository ptHouseRepository;
    @Autowired
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private CustomerCapitalRepository customerCapitalRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private PaymentDetailsRepository paymentDetailsRepository;
    @Resource
    private EstReceivablesRecordRepository estReceivablesRecordRepository;
    @Resource
    private FlowLinkRepository flowLinkRepository;

    protected String getContext() {
        return "house";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtHouseDomain houseBean) {
        if (houseBean == null) {
            this.logger.error(String.valueOf(CODE) + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptHouseRepository.saveHouse(houseBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String houseId, ModelMap modelMap) {
        modelMap.put((Object)"houseReBean", (Object)this.getHouse(houseId));
        return String.valueOf(this.getFtlTempPath(request)) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtHouseDomain houseBean) {
        if (houseBean == null) {
            this.logger.error(String.valueOf(CODE) + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptHouseRepository.updateHouse(houseBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String houseId) {
        if (StringUtils.isBlank((String)houseId)) {
            this.logger.error(String.valueOf(CODE) + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptHouseRepository.deleteHouse(Integer.valueOf(Integer.parseInt(houseId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String houseId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)houseId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(String.valueOf(CODE) + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptHouseRepository.updateHouseState(houseId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String houseId, ModelMap modelMap) {
        modelMap.put((Object)"houseReBean", (Object)this.getHouse(houseId));
        return String.valueOf(this.getFtlTempPath(request)) + "view";
    }

    private String getHouse(String houseId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)houseId)) {
            this.logger.error(String.valueOf(CODE) + ".getHouse", (Object)"houseId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.ptHouseRepository.getHouse(Integer.valueOf(Integer.parseInt(houseId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ptHouseRepository.queryHousePage(param, true, true);
    }

    @RequestMapping(value={"dev/getHouseDetail/byHouseName"})
    public String getHouseDetail(HttpServletRequest request, ModelMap modelMap) {
        List houses;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        SupQueryResult sups = this.ptHouseRepository.queryHousePageSup(param, true, false);
        if (sups != null && ListUtil.isNotEmpty((Collection)(houses = sups.getList()))) {
            HouseReBean house = (HouseReBean)houses.get(0);
            boolean hasExistsOrder = this.hasExistsOrder(house.getHouseCode(), "", house.getTenantCode());
            if (hasExistsOrder) {
                house.setMemo("1");
            } else {
                house.setMemo("0");
            }
            modelMap.put((Object)"house", (Object)house);
            boolean permiss = false;
            if (user.getRoleCode().equals("0001099")) {
                permiss = !permiss;
            }
            Object[] pos = new Object[]{param.get("POS_X"), param.get("POS_Y")};
            modelMap.put((Object)"pos", (Object)pos);
            modelMap.put((Object)"permiss", (Object)permiss);
            List commissionTypes = this.ddRepository.getDisList("PtProjectRelation-commissionType");
            modelMap.put((Object)"commissionTypes", (Object)commissionTypes);
        }
        return String.valueOf(this.getFtlTempPath(request)) + param.get("redirectPage");
    }

    @RequestMapping(value={"dev/getHouseDetail/byHouseName_V2.json"})
    @ResponseBody
    public HtmlJsonReBean getHouseDetailV2(HttpServletRequest request, String houseCode, String tenantCode) {
        List orderByHouses;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        PtHouseReDomain house = this.ptHouseRepository.getHouseByCode(houseCode, tenantCode);
        boolean hasExistsOrder = this.hasExistsOrder(house.getHouseCode(), "", house.getTenantCode());
        house.setHasExistsOrder(Boolean.valueOf(hasExistsOrder));
        if (hasExistsOrder && ListUtil.isNotEmpty((Collection)(orderByHouses = this.reserveUnitRepository.queryOrderByHouseCode(param)))) {
            EstReserveUnitReBean effectiveOrder = null;
            for (EstReserveUnitReBean estReserveUnit : orderByHouses) {
                if (estReserveUnit.getDataState() != 1) continue;
                effectiveOrder = estReserveUnit;
                break;
            }
            if (effectiveOrder != null) {
                SupQueryResult customerCapitalOrResult;
                String reserveUnitTypeDesc = EstateConstants.flowLinkTypeMap.get(effectiveOrder.getReserveUnitType());
                if (StringUtils.isNotBlank((String)reserveUnitTypeDesc)) {
                    effectiveOrder.setReserveUnitTypeDesc(reserveUnitTypeDesc);
                }
                String zyCode = effectiveOrder.getUserCode();
                effectiveOrder.setUserName(this.userRepository.getUserByCode(zyCode, tenantCode).getUserRelname());
                param.put("effectiveOrderInfo", effectiveOrder);
                String reserveUnitCode = effectiveOrder.getReserveUnitCode();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("reserveUnitCode", reserveUnitCode);
                map.put("tenantCode", tenantCode);
                PaymentDetailsReBean paymentDetails = this.paymentDetailsRepository.getPaymentDetailsByReserveUnitCode(param);
                if (paymentDetails != null) {
                    String paymentDetailsType = SupDisUtil.getMap((String)"EcoreDd-list", (String)("PaymentDetails-paymentDetailsType-" + paymentDetails.getPaymentDetailsType()));
                    if (paymentDetailsType != null) {
                        paymentDetails.setPaymentDetailsTypeDesc(paymentDetailsType);
                    }
                    effectiveOrder.setPaymentDetails(paymentDetails);
                }
                map.clear();
                map.put("reserveUnitCode", reserveUnitCode);
                map.put("tenantCode", tenantCode);
                SupQueryResult queryFlowLinkResult = this.flowLinkRepository.queryFlowLinkPage(map, true);
                if (queryFlowLinkResult != null && ListUtil.isNotEmpty((Collection)queryFlowLinkResult.getList())) {
                    List flowLinkList = queryFlowLinkResult.getList();
                    for (EstFlowLinkReBean estFlowLink : flowLinkList) {
                        estFlowLink.setFlowLinkTypeDesc(EstateConstants.flowLinkTypeMap.get(estFlowLink.getFlowLinkType()));
                        estFlowLink.setApprovalStatusDesc(EstateConstants.approvalStatusMap.get(estFlowLink.getApprovalStatus()));
                        estFlowLink.setOperationTypeDesc(EstateConstants.OPERATION_TYPE_MAP.get(estFlowLink.getOperationType()));
                    }
                    param.put("flowLinkList", flowLinkList);
                }
                if ((customerCapitalOrResult = this.customerCapitalRepository.queryCustomerCapitalOrRes(map)) != null && ListUtil.isNotEmpty((Collection)customerCapitalOrResult.getList())) {
                    List customerCapitalList = customerCapitalOrResult.getList();
                    HashSet<String> customerCapitalCodes = new HashSet<String>();
                    ConcurrentHashMap capitalTypeMap = new ConcurrentHashMap();
                    for (Map temp : customerCapitalList) {
                        String capitalTypeStr;
                        String capitalTypeDesc;
                        Object capitalType = temp.get("capitalType");
                        if (capitalType != null && (capitalTypeDesc = SupDisUtil.getMap((String)"EcoreDd-list", (String)("EstCustomerCapital-capitalType-" + (capitalTypeStr = String.valueOf(capitalType))))) != null) {
                            temp.put("capitalTypeDesc", capitalTypeDesc);
                        }
                        if (!temp.containsKey("customerCapitalCode")) continue;
                        String customerCapitalCode = String.valueOf(temp.get("customerCapitalCode"));
                        customerCapitalCodes.add(customerCapitalCode);
                        capitalTypeMap.put(customerCapitalCode, temp.get("capitalTypeDesc"));
                    }
                    param.put("orderHandleList", customerCapitalList);
                    if (ListUtil.isNotEmpty(customerCapitalCodes)) {
                        map.clear();
                        map.put("customerCapitalCodes", customerCapitalCodes);
                        List receivablesRecordList = this.estReceivablesRecordRepository.queryEstReceivablesRecordList(map);
                        if (ListUtil.isNotEmpty((Collection)receivablesRecordList)) {
                            for (EstReceivablesRecordReBean temp : receivablesRecordList) {
                                String receivablesTypeDesc;
                                String receivablesType;
                                Object object = capitalTypeMap.get(temp.getCustomerCapitalCode());
                                if (object != null) {
                                    temp.setCapitalTypeDesc(String.valueOf(object));
                                }
                                if (!StringUtils.isNotBlank((String)(receivablesType = temp.getReceivablesType())) || !StringUtils.isNotBlank((String)(receivablesTypeDesc = SupDisUtil.getMap((String)"EcoreDd-list", (String)("ReceivablesRecord-receivablesType-" + receivablesType))))) continue;
                                temp.setReceivablesTypeDesc(receivablesTypeDesc);
                            }
                            param.put("receivablesRecords", receivablesRecordList);
                        }
                    }
                }
            }
        }
        this.assemblyBuildingArea(house);
        param.put("houseInfo", house);
        boolean permiss = false;
        if (user.getRoleCode().equals("0001099")) {
            permiss = !permiss;
        }
        param.put("permiss", permiss);
        return new HtmlJsonReBean((Object)param);
    }

    private void assemblyBuildingArea(PtHouseReDomain house) {
        BigDecimal buildingArea = BigDecimal.ZERO;
        BigDecimal totalArea = house.getTotalArea();
        BigDecimal publicArea = house.getPublicArea();
        BigDecimal balconyArea = house.getBalconyArea();
        BigDecimal privateArea = house.getPrivateArea();
        if (totalArea != null && totalArea.compareTo(BigDecimal.ZERO) > 0) {
            buildingArea = totalArea;
            if (publicArea != null) {
                buildingArea = buildingArea.subtract(publicArea);
            }
            if (balconyArea != null) {
                buildingArea = buildingArea.subtract(balconyArea);
            }
            if (privateArea != null) {
                buildingArea = buildingArea.subtract(privateArea);
            }
        }
        if (buildingArea.compareTo(BigDecimal.valueOf(1L)) < 0) {
            buildingArea = BigDecimal.ZERO;
        }
        house.setBuildingArea(buildingArea);
    }

    @RequestMapping(value={"dev/updateHouse.json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean updateHouse(HttpServletRequest request, @RequestBody HouseReBean houseReBean) {
        String tenantCode;
        if (houseReBean == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u53c2\u6570,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        String houseCode = houseReBean.getHouseCode();
        boolean hasExistsOrder = this.hasExistsOrder(houseCode, "", tenantCode = houseReBean.getTenantCode());
        if (hasExistsOrder) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u623f\u6237\u5df2\u7ecf\u5904\u4e8e\u4ea4\u6613\u4e2d\u4e0d\u80fd\u53d8\u66f4\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("dataState", houseReBean.getDataState());
        map.put("houseCode", houseReBean.getHouseCode());
        map.put("averagePrice", houseReBean.getAveragePrice());
        map.put("minPrice", houseReBean.getMinPrice());
        map.put("totalArea", houseReBean.getTotalArea());
        map.put("commission", houseReBean.getCommission());
        map.put("commissionType", houseReBean.getCommissionType());
        map.put("manageUpdateNum", "1");
        map.put("oldDataState", houseReBean.getOldDataState());
        PostParamMap pmap = new PostParamMap("pt.project.updateHouseByCode");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public boolean hasExistsOrder(String houseCode, String projectCode, String tenantCode) {
        EstReserveUnitReBean eru = this.reserveUnitRepository.getReserveUnitByHouseCode(houseCode, "", tenantCode);
        return eru != null;
    }
}

