/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.project.domain.PtUnitDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pt/unit"})
public class UnitCon
extends SpringmvcController {
    private static String CODE = "pt.unit.con";
    @Autowired
    private PtProjectRepository projectRepository;

    protected String getContext() {
        return "unit";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtUnitDomain unitBean) {
        if (unitBean == null) {
            this.logger.error(String.valueOf(CODE) + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.saveUnit(unitBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String unitId, ModelMap modelMap) {
        modelMap.put((Object)"unitReBean", (Object)this.getUnit(unitId));
        return String.valueOf(this.getFtlTempPath(request)) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtUnitDomain unitBean) {
        if (unitBean == null) {
            this.logger.error(String.valueOf(CODE) + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateUnit(unitBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String unitId) {
        if (StringUtils.isBlank((String)unitId)) {
            this.logger.error(String.valueOf(CODE) + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.deleteUnit(Integer.valueOf(Integer.parseInt(unitId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String unitId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)unitId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(String.valueOf(CODE) + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateUnitState(unitId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String unitId, ModelMap modelMap) {
        modelMap.put((Object)"unitReBean", (Object)this.getUnit(unitId));
        return String.valueOf(this.getFtlTempPath(request)) + "view";
    }

    private String getUnit(String unitId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)unitId)) {
            this.logger.error(String.valueOf(CODE) + ".getUnit", (Object)"unitId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.projectRepository.getUnit(Integer.valueOf(Integer.parseInt(unitId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        PostParamMap pmap = new PostParamMap("pt.project.queryUnitPage");
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        pmap.putParamToJson("map", (Object)param);
        return this.htmlIBaseService.senBySupRq(pmap, (Object)new SupQueryResult());
    }
}

