/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.property.controller;

import com.yqbsoft.laser.html.constants.EstateConstants;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.SfDd;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstPropertyMgmt;
import com.yqbsoft.laser.html.facade.est.bean.EstReceivablesRecordBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReceivablesRecordReBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitMemberBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.bean.SfDdBean;
import com.yqbsoft.laser.html.facade.est.bean.SfDdReBean;
import com.yqbsoft.laser.html.facade.est.domain.EstPropertyMgmtDomain;
import com.yqbsoft.laser.html.facade.est.domain.EstPropertyMgmtReDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.DdCacheRepository;
import com.yqbsoft.laser.html.facade.est.repository.EstPropertyMgmtRepository;
import com.yqbsoft.laser.html.facade.est.repository.EstReceivablesRecordRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitMemberRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.property.bean.PropertyMgmtVo;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/property-mgmt"})
public class PropertyMgmtCon
extends SpringmvcController {
    @Autowired
    private PtProjectRepository ptProjectRepository;
    @Autowired
    private DdCacheRepository ddCacheRepository;
    @Autowired
    private EstPropertyMgmtRepository estPropertyMgmtRepository;
    @Autowired
    private ReserveUnitMemberRepository reserveUnitMemberRepository;
    @Autowired
    private ReserveUnitRepository reserveUnitRepository;
    @Autowired
    private EstReceivablesRecordRepository estReceivablesRecordRepository;
    @Resource
    private DdRepository ddRepository;

    @RequestMapping(value={"deliveryPenalty/list"})
    public String deliveryPenaltyList(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", EstateConstants.PROPERTY_MGMT_TYPE_1);
        this.switchProject(request, modelMap, param);
        SupQueryResult<PropertyMgmtVo> supQueryResult = this.ssignmentaPropertyMgmtVo((SupQueryResult<EstPropertyMgmt>)this.estPropertyMgmtRepository.listQuery(param, null));
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"queryResultList", (Object)supQueryResult.getRows());
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        }
        return String.valueOf(this.getFtlTempPath(request)) + "deliveryPenaltyList";
    }

    @RequestMapping(value={"batch/initBuilding.json"})
    @ResponseBody
    public void deliveryPenaltyList(HttpServletRequest request, String buildingCode) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        UserSession user = this.getUserSession(request);
        param.put("buildingCode", buildingCode);
        param.put("tenantCode", user.getTenantCode());
        this.estPropertyMgmtRepository.batchInitBuildingPropertyMgmt(param);
    }

    @RequestMapping(value={"deliveryPenalty/detail"})
    public String deliveryPenaltyDetail(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("buildingCode", "5d168fd1292e4890b2ad67ef664cbd5e");
        parmMap.put("tenantCode", user.getTenantCode());
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", EstateConstants.PROPERTY_MGMT_TYPE_1);
        SupQueryResult<PropertyMgmtVo> supQueryResult = this.ssignmentaPropertyMgmtVo((SupQueryResult<EstPropertyMgmt>)this.estPropertyMgmtRepository.listQuery(param, null));
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"propertyMgmt", supQueryResult.getRows().get(0));
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        }
        this.switchProject(request, modelMap, param);
        return String.valueOf(this.getFtlTempPath(request)) + "deliveryPenaltyDetail";
    }

    private void switchProject(HttpServletRequest request, ModelMap modelMap, Map<String, Object> param) {
        this.getFirstProjectCode(request, param);
        modelMap.put((Object)"projects", this.queryProjects(request));
        modelMap.put((Object)"projectCode", param.get("projectCode"));
        this.getFirstHouseTypeCode(request, param);
        modelMap.put((Object)"houseTypes", this.queryHouseTypes());
        modelMap.put((Object)"houseType", param.get("houseType"));
        if (param.get("yearData") == null) {
            modelMap.put((Object)"yearData", (Object)Calendar.getInstance().get(1));
        } else {
            modelMap.put((Object)"yearData", param.get("yearData"));
        }
    }

    private void getFirstHouseTypeCode(HttpServletRequest request, Map<String, Object> parmMap) {
        String houseType = (String)parmMap.get("houseType");
        if (StringUtils.isNotBlank((String)houseType)) {
            return;
        }
        List<SfDdReBean> ddReBeans = this.queryHouseTypes();
        if (ListUtil.isNotEmpty(ddReBeans)) {
            parmMap.put("houseType", ddReBeans.get(0).getDdValue());
        }
    }

    public SupQueryResult<PropertyMgmtVo> ssignmentaPropertyMgmtVo(SupQueryResult<EstPropertyMgmt> supQueryResult) {
        if (supQueryResult == null || supQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        ArrayList<PropertyMgmtVo> propertyMgmtVoArrayList = new ArrayList<PropertyMgmtVo>();
        for (EstPropertyMgmt estPropertyMgmt : supQueryResult.getRows()) {
            PropertyMgmtVo propertyMgmtVo = new PropertyMgmtVo();
            try {
                BeanUtils.copyAllPropertys((Object)((Object)propertyMgmtVo), (Object)estPropertyMgmt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            propertyMgmtVo.setReserveUnitCode(estPropertyMgmt.getReserveUnitCode());
            EstReserveUnitMemberBean estReserveUnitMemberBean = this.reserveUnitMemberRepository.getReserveUnitMainMemberName(estPropertyMgmt.getReserveUnitCode(), Integer.valueOf(0));
            if (estReserveUnitMemberBean != null) {
                propertyMgmtVo.setMemberName(estReserveUnitMemberBean.getMemberName());
                propertyMgmtVo.setMemberPhone(estReserveUnitMemberBean.getMemberPhone());
                propertyMgmtVo.setIdentityCardNumber(estReserveUnitMemberBean.getIdentityCardNumber());
            }
            propertyMgmtVo.setHouseTag(this.getHouseTag(estPropertyMgmt));
            EstReserveUnitReBean estReserveUnitBean = this.reserveUnitRepository.getReserveUnitByCode(estPropertyMgmt.getReserveUnitCode(), estPropertyMgmt.getTenantCode());
            if (estReserveUnitBean != null) {
                propertyMgmtVo.setContractArea(estReserveUnitBean.getContractArea());
                propertyMgmtVo.setTotalTransactionPrice(estReserveUnitBean.getTotalTransactionPrice());
                propertyMgmtVo.setSigningDate(estReserveUnitBean.getSigningDate());
            }
            propertyMgmtVoArrayList.add(propertyMgmtVo);
        }
        SupQueryResult propertyMgmtVoSupQueryResult = new SupQueryResult();
        propertyMgmtVoSupQueryResult.setRows(propertyMgmtVoArrayList);
        propertyMgmtVoSupQueryResult.setList(propertyMgmtVoArrayList);
        propertyMgmtVoSupQueryResult.setPageTools(supQueryResult.getPageTools());
        propertyMgmtVoSupQueryResult.setTotal(supQueryResult.getTotal());
        return propertyMgmtVoSupQueryResult;
    }

    private String getHouseTag(EstPropertyMgmt estPropertyMgmt) {
        String houseTag = "";
        if (StringUtils.isNotBlank((String)estPropertyMgmt.getBuildingNumber())) {
            houseTag = String.valueOf(houseTag) + estPropertyMgmt.getBuildingNumber();
        }
        if (StringUtils.isNotBlank((String)estPropertyMgmt.getUnitNumber())) {
            houseTag = String.valueOf(houseTag) + estPropertyMgmt.getUnitNumber();
        }
        if (StringUtils.isNotBlank((String)estPropertyMgmt.getRoomNumber())) {
            houseTag = String.valueOf(houseTag) + estPropertyMgmt.getRoomNumber();
        }
        return houseTag;
    }

    @RequestMapping(value={"propertyCost/list"})
    public String propertyCostList(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", EstateConstants.PROPERTY_MGMT_TYPE_2);
        this.switchProject(request, modelMap, param);
        SupQueryResult<PropertyMgmtVo> supQueryResult = this.ssignmentaPropertyMgmtVo((SupQueryResult<EstPropertyMgmt>)this.estPropertyMgmtRepository.listQuery(param, null));
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"queryResultList", (Object)supQueryResult.getRows());
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        }
        return String.valueOf(this.getFtlTempPath(request)) + "propertyCostList";
    }

    @RequestMapping(value={"update.json"})
    @ResponseBody
    public Object updatePropertyMgmt(HttpServletRequest request, @RequestBody EstPropertyMgmt propertyMgmt, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", propertyMgmt.getPropertyMgmtType());
        param.put("propertyMgmtId", propertyMgmt.getPropertyMgmtId());
        param.put("propertyMgmtCode", propertyMgmt.getPropertyMgmtCode());
        SupQueryResult supQueryResult = this.estPropertyMgmtRepository.listQuery(param, null);
        EstPropertyMgmt estPropertyMgmt = null;
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            estPropertyMgmt = (EstPropertyMgmt)supQueryResult.getRows().get(0);
        }
        if (estPropertyMgmt != null) {
            EstPropertyMgmtReDomain estPropertyMgmtReDomain = new EstPropertyMgmtReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)estPropertyMgmtReDomain, (Object)estPropertyMgmt);
                estPropertyMgmtReDomain.setRemark(propertyMgmt.getRemark());
                estPropertyMgmtReDomain.setCostStatus(propertyMgmt.getCostStatus());
                HtmlJsonReBean htmlJsonReBean = this.estPropertyMgmtRepository.updatePropertyMgmt((EstPropertyMgmtDomain)estPropertyMgmtReDomain);
                return htmlJsonReBean;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new HtmlJsonReBean("-1", "\u4fee\u6539\u5931\u8d25");
    }

    @RequestMapping(value={"propertyCost/detail"})
    public String propertyCostDetail(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", EstateConstants.PROPERTY_MGMT_TYPE_2);
        SupQueryResult<PropertyMgmtVo> supQueryResult = this.ssignmentaPropertyMgmtVo((SupQueryResult<EstPropertyMgmt>)this.estPropertyMgmtRepository.listQuery(param, null));
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"propertyMgmt", supQueryResult.getRows().get(0));
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        }
        this.switchProject(request, modelMap, param);
        return String.valueOf(this.getFtlTempPath(request)) + "propertyCostDetail";
    }

    @RequestMapping(value={"decorationDeposit/list"})
    public String decorationDepositList(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", EstateConstants.PROPERTY_MGMT_TYPE_3);
        this.switchProject(request, modelMap, param);
        SupQueryResult<PropertyMgmtVo> supQueryResult = this.ssignmentaPropertyMgmtVo((SupQueryResult<EstPropertyMgmt>)this.estPropertyMgmtRepository.listQuery(param, null));
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            this.setReceivablesRecord(supQueryResult, modelMap, Integer.valueOf((String)param.get("houseType")));
            modelMap.put((Object)"queryResultList", (Object)supQueryResult.getRows());
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        }
        modelMap.put((Object)"handleCostTypes", this.queryHandleCostTypes(Integer.valueOf((String)param.get("houseType"))));
        return String.valueOf(this.getFtlTempPath(request)) + "decorationDepositList";
    }

    @RequestMapping(value={"queryReceivablesRecord"})
    public String queryReceivablesRecord(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        if (param.get("model") != null && !"".equals(param.get("model"))) {
            Integer model = Integer.valueOf((String)param.get("model"));
            if (model != 2) {
                param.put("dataState", 1);
            }
            param.put("ptradeSeqnoIsnotnull", true);
            modelMap.put((Object)"model", (Object)model);
        }
        if (param.get("customerCapitalCode") == null || "".equals(param.get("customerCapitalCode"))) {
            param.put("customerCapitalCode", "-");
        }
        param.put("order", true);
        param.put("tenantCode", user.getTenantCode());
        modelMap.addAttribute("customerCapitalCode", param.get("customerCapitalCode"));
        this.queryEstReceivablesRecordWrapper(request, param, modelMap);
        return String.valueOf(this.getFtlTempPath(request)) + "receivablesRecord";
    }

    private void setReceivablesRecord(SupQueryResult<PropertyMgmtVo> supQueryResult, ModelMap modelMap, Integer type) {
        if (supQueryResult == null || supQueryResult.getRows() == null) {
            return;
        }
        for (PropertyMgmtVo propertyMgmtVo : supQueryResult.getRows()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("customerCapitalCode", propertyMgmtVo.getPropertyMgmtCode());
            paramMap.put("businessType", 2);
            SupQueryResult recordReBeanSupQueryResult = this.estReceivablesRecordRepository.queryEstReceivablesRecord(paramMap);
            propertyMgmtVo.setCostCount(recordReBeanSupQueryResult.getPageTools().getRecordCount());
            List<SfDdReBean> ddReBeanList = this.queryHandleCostTypes(type);
            ArrayList<Map<String, Object>> infoMaps = new ArrayList<Map<String, Object>>();
            for (SfDdReBean sfDdReBean : ddReBeanList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("keyName", sfDdReBean.getDdValue());
                map.put("receivablesAmount", 0);
                if (ListUtil.isNotEmpty((Collection)recordReBeanSupQueryResult.getRows())) {
                    for (EstReceivablesRecordReBean receivablesRecord : recordReBeanSupQueryResult.getRows()) {
                        if (!receivablesRecord.getReceivablesType().equals("1") || !sfDdReBean.getDdCode().equals(String.valueOf(receivablesRecord.getOpBilltype()))) continue;
                        map.put("receivablesAmount", receivablesRecord.getReceivablesAmount());
                        map.put("paymentDate", receivablesRecord.getGmtCreate());
                        if (sfDdReBean.getDdValue().equals("decorationDeposit")) {
                            propertyMgmtVo.setDecorationDeposit(receivablesRecord.getReceivablesAmount());
                            propertyMgmtVo.setDecorationDepositPaymentDate(receivablesRecord.getGmtCreate());
                        }
                        if (sfDdReBean.getDdValue().equals("decorationDepositCom")) {
                            propertyMgmtVo.setDecorationDepositCom(receivablesRecord.getReceivablesAmount());
                        }
                        if (sfDdReBean.getDdValue().equals("junkFeeAmount")) {
                            propertyMgmtVo.setJunkFeeAmount(receivablesRecord.getReceivablesAmount());
                        }
                        if (sfDdReBean.getDdValue().equals("documentDeposit")) {
                            propertyMgmtVo.setDocumentDeposit(receivablesRecord.getReceivablesAmount());
                            propertyMgmtVo.setDocumentDepositPaymentDate(receivablesRecord.getGmtCreate());
                        }
                        if (!sfDdReBean.getDdValue().equals("additionalFeeAmount")) continue;
                        propertyMgmtVo.setAdditionalFeeAmount(receivablesRecord.getReceivablesAmount());
                    }
                    infoMaps.add(map);
                }
                propertyMgmtVo.setInfoMaps(infoMaps);
            }
        }
    }

    @RequestMapping(value={"decorationDeposit/detail"})
    public String decorationDepositDetail(HttpServletRequest request, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        param.put("propertyMgmtType", EstateConstants.PROPERTY_MGMT_TYPE_3);
        SupQueryResult<PropertyMgmtVo> supQueryResult = this.ssignmentaPropertyMgmtVo((SupQueryResult<EstPropertyMgmt>)this.estPropertyMgmtRepository.listQuery(param, null));
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            this.setReceivablesRecord(supQueryResult, modelMap, Integer.valueOf((String)param.get("houseType")));
            modelMap.put((Object)"propertyMgmt", supQueryResult.getRows().get(0));
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        }
        this.switchProject(request, modelMap, param);
        return String.valueOf(this.getFtlTempPath(request)) + "decorationDepositDetail";
    }

    @RequestMapping(value={"receivables/record/save.json"})
    @ResponseBody
    public Object receivablesRecord(HttpServletRequest request, @RequestBody EstReceivablesRecordBean receivablesRecordBean) {
        UserSession userSession = this.getUserSession(request);
        EstReceivablesRecordReBean estReceivablesRecordReBean = this.getReceivablesRecord(receivablesRecordBean, userSession, 1);
        EstReceivablesRecordReBean receivablesRecordReBean = this.getReceivablesRecord(receivablesRecordBean, userSession, 2);
        if (estReceivablesRecordReBean != null && estReceivablesRecordReBean.getReceivablesType().equals(receivablesRecordBean.getReceivablesType())) {
            return new HtmlJsonReBean("error", "\u4e0d\u80fd\u91cd\u590d\u4ea4\u6b3e");
        }
        if (receivablesRecordReBean != null && receivablesRecordReBean.getReceivablesType().equals(receivablesRecordBean.getReceivablesType())) {
            return new HtmlJsonReBean("error", "\u4e0d\u80fd\u91cd\u590d\u9000\u6b3e");
        }
        if (estReceivablesRecordReBean == null && receivablesRecordBean.getReceivablesType().equals("2")) {
            return new HtmlJsonReBean("error", "\u4e0d\u5b58\u5728\u6b64\u7b14\u8ba2\u5355");
        }
        EstReceivablesRecordReBean estReceivablesRecordBean = new EstReceivablesRecordReBean();
        try {
            BeanUtils.copyAllPropertys((Object)estReceivablesRecordBean, (Object)receivablesRecordBean);
            if (estReceivablesRecordBean.getReceivablesType().equals("2")) {
                if (estReceivablesRecordReBean.getReceivablesAmount().compareTo(receivablesRecordBean.getReceivablesAmount()) != 0) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f93\u5165\u9000\u6b3e\u91d1\u989d\u6709\u8bef\uff0c\u5e94\u9000\uff1a" + estReceivablesRecordReBean.getReceivablesAmount());
                }
                estReceivablesRecordBean.setReceivablesAmount(estReceivablesRecordReBean.getReceivablesAmount());
            }
            estReceivablesRecordBean.setBusinessType(Integer.valueOf(2));
            estReceivablesRecordBean.setUserCode(userSession.getUserCode());
            estReceivablesRecordBean.setUserName(userSession.getUserRelname());
            estReceivablesRecordBean.setDataState(EstateConstants.ReceivablesEnum.ARRIVAL_ED.getDataState());
            estReceivablesRecordBean.setTenantCode(userSession.getTenantCode());
            this.estReceivablesRecordRepository.saveReceivablesRecordRe(estReceivablesRecordBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new HtmlJsonReBean();
    }

    private EstReceivablesRecordReBean getReceivablesRecord(EstReceivablesRecordBean receivablesRecordBean, UserSession userSession, Integer receivablesType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerCapitalCode", receivablesRecordBean.getCustomerCapitalCode());
        paramMap.put("receivablesType", receivablesType);
        paramMap.put("businessType", 2);
        paramMap.put("opBilltype", receivablesRecordBean.getOpBilltype());
        paramMap.put("tenantCode", userSession.getTenantCode());
        List estReceivablesRecordBeans = this.estReceivablesRecordRepository.queryEstReceivablesRecordList(paramMap);
        if (ListUtil.isNotEmpty((Collection)estReceivablesRecordBeans)) {
            return (EstReceivablesRecordReBean)estReceivablesRecordBeans.get(0);
        }
        return null;
    }

    private void queryEstReceivablesRecordWrapper(HttpServletRequest request, Map<String, Object> param, ModelMap modelMap) {
        SupQueryResult sup = this.estReceivablesRecordRepository.queryEstReceivablesRecord(param);
        List list = sup.getList();
        int refundCount = 0;
        BigDecimal amountCount = new BigDecimal(0);
        if (ListUtil.isNotEmpty((Collection)list)) {
            HashMap<String, String> ddMap = new HashMap<String, String>();
            List<SfDd> sfdds = this.queryDdList("ReceivablesRecord", "receivablesType");
            for (SfDd dd : sfdds) {
                ddMap.put(dd.getDdCode(), dd.getDdValue());
            }
            for (EstReceivablesRecordReBean obj : list) {
                if (Integer.parseInt(obj.getReceivablesType()) == 1 && obj.getDataState() == 1) {
                    ++refundCount;
                    amountCount = amountCount.add(obj.getReceivablesAmount());
                }
                if (EstateConstants.ReceivablesEnum.ARRIVAL_ING.getReceivablesType().equals(obj.getReceivablesType())) {
                    if (EstateConstants.ReceivablesEnum.ARRIVAL_ING.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5230\u8d26\u4e2d");
                    } else if (EstateConstants.ReceivablesEnum.ARRIVAL_ED.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5df2\u5230\u8d26");
                    } else if (EstateConstants.ReceivablesEnum.ARRIVAL_EXE_BACK.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5df2\u53d1\u8d77\u9000\u6b3e");
                    } else if (EstateConstants.ReceivablesEnum.ARRIVAL_BACK_SUCC.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u9000\u6b3e\u6210\u529f");
                    }
                } else if (EstateConstants.ReceivablesEnum.REFUND_ING.getReceivablesType().equals(obj.getReceivablesType())) {
                    if (EstateConstants.ReceivablesEnum.REFUND_ING.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u9000\u6b3e\u4e2d");
                    } else if (EstateConstants.ReceivablesEnum.REFUND_ED.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u5df2\u9000\u6b3e");
                    } else if (EstateConstants.ReceivablesEnum.REFUND_UN.getDataState().equals(obj.getDataState())) {
                        obj.setMemo("\u672a\u6210\u529f\u53d1\u8d77\u9000\u6b3e");
                    }
                }
                obj.setReceivablesType((String)ddMap.get(obj.getReceivablesType()));
            }
        }
        modelMap.addAttribute("listCount", (Object)refundCount);
        modelMap.addAttribute("amountCount", (Object)amountCount);
        modelMap.addAttribute("receivablesRecords", (Object)list);
        modelMap.addAttribute("pageTools", (Object)this.buildPage(sup.getPageTools(), request));
    }

    public List<SfDd> queryDdList(String ddTable, String ddColumn) {
        List ddLists = this.ddRepository.queryDdList(ddTable, ddColumn);
        return ddLists;
    }

    public void getFirstProjectCode(HttpServletRequest request, Map<String, Object> parmMap) {
        UserSession user = this.getUserSession(request);
        String projectCode = (String)parmMap.get("projectCode");
        if (StringUtils.isNotBlank((String)projectCode)) {
            return;
        }
        List list = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (list != null && list.size() > 0) {
            for (Map map : list) {
                Iterator iterator = map.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                parmMap.put("projectCode", entry.getValue());
                return;
            }
        }
    }

    public List<Map<String, String>> queryProjects(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        List list = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        return list;
    }

    List<SfDdReBean> queryHouseTypes() {
        List sfDdBeans = this.ddCacheRepository.queryDdList("PtHouse", "houseType", null, null);
        return sfDdBeans;
    }

    List<SfDdReBean> queryHandleCostTypes(Integer type) {
        List sfDdBeans = this.ddCacheRepository.queryDdList("ReceivablesRecord", "opBilltype", null, null);
        if (ListUtil.isNotEmpty((Collection)sfDdBeans)) {
            Iterator i = sfDdBeans.iterator();
            if (type != null) {
                while (i.hasNext()) {
                    SfDdBean sfd = (SfDdBean)i.next();
                    if (sfd.getDdOrder() == type) continue;
                    i.remove();
                }
            }
        }
        return sfDdBeans;
    }

    protected String getContext() {
        return null;
    }
}

