/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.statistical.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.project.bean.BuildingReBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.CustomerCapitalRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReportRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.pt.bean.OtherBean;
import com.yqbsoft.laser.html.facade.pt.bean.UnitReBean;
import com.yqbsoft.laser.html.facade.pt.repository.PtUnitRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.statistical.bean.FstatisticalAllBean;
import com.yqbsoft.laser.html.statistical.bean.LoanBean;
import com.yqbsoft.laser.html.statistical.bean.SelledFinanceBean;
import com.yqbsoft.laser.html.statistical.bean.UnSellFinancesBean;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/finance/statistical"})
public class FinanceStatisticalCon
extends SpringmvcController {
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private PtHouseRepository ptHouseRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private ReportRepository reportRepository;
    @Resource
    private PtBuildingRepository ptBuildingRepository;
    @Resource
    private PtUnitRepository ptUnitRepository;
    @Resource
    private DdRepository ddRepository;
    @Resource
    private CustomerCapitalRepository customerCapitalRepository;

    protected String getContext() {
        return "fstatistical";
    }

    @RequestMapping(value={"allsell"})
    public String allsell(HttpServletRequest request, String projectCode, ModelMap modelMap, Integer statistaclType, String endDates) {
        this.allsellWrapper(request, projectCode, modelMap, statistaclType, endDates);
        return String.valueOf(this.getFtlTempPath(request)) + "allsell";
    }

    @RequestMapping(value={"export_allsell"})
    public String allsell(HttpServletRequest request, HttpServletResponse response, String projectCode, ModelMap modelMap, Integer statistaclType, String endDates) {
        this.allsellWrapper(request, projectCode, modelMap, statistaclType, endDates);
        try {
            String allsellName = SupDisUtil.getMap((String)"EcoreDd-list", (String)"ExpExcelFileName-export_allsell-1");
            if (StringUtils.isEmpty((String)allsellName)) {
                allsellName = "\u4e91\u9500\u7ba1\u5bb6-\u8d22\u52a1\u62a5\u8868-\u603b\u9500.xls";
            }
            modelMap.put((Object)"title", (Object)"\u603b\u9500\u8868");
            response.setHeader("Content-Type", "application/vnd.ms-execl");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(allsellName.getBytes(), "ISO-8859-1"));
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.valueOf(this.getFtlTempPath(request)) + "allsellExp";
    }

    private void allsellWrapper(HttpServletRequest request, String projectCode, ModelMap modelMap, Integer statistaclType, String endDates) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        String tenantCode = user.getTenantCode();
        param.put("tenantCode", tenantCode);
        Object buildingCode = null;
        if (statistaclType == null) {
            statistaclType = 1;
        }
        if (statistaclType == 1) {
            param.remove("buildingCode");
        } else {
            buildingCode = param.get("buildingCode");
        }
        this.getProject(modelMap, user, param, projectCode);
        List preList = this.ptHouseRepository.queryPreSellStatistical(param);
        if (ListUtil.isNotEmpty((Collection)preList)) {
            HashSet<String> otherCodes = new HashSet<String>();
            for (Map other : preList) {
                String otherCode = (String)other.get("otherCode");
                otherCodes.add(otherCode);
            }
            Map<String, Object> rgMap = this.queryStatisticalSellTransRg(otherCodes, tenantCode, statistaclType, buildingCode, endDates, null);
            Map<String, Object> cjMap = this.queryStatisticalSellTransCj(otherCodes, tenantCode, statistaclType, buildingCode, endDates, null);
            Map<String, Object> moneyMap = this.getFstatisticalAll(param, tenantCode);
            this.wrapperAllSell(preList, moneyMap, rgMap, cjMap);
            modelMap.addAttribute("fstatisticalAll", (Object)preList);
        }
        modelMap.put((Object)"title", (Object)"\u603b\u9500\u8868");
        modelMap.put((Object)"actions", (Object)"allsell");
        modelMap.put((Object)"paramMap", (Object)param);
    }

    @RequestMapping(value={"yrgwqy"})
    public String sellAll(HttpServletRequest request, String projectCode, ModelMap modelMap, Integer statistaclType, String endDates) {
        this.yrgwqyWrapper(request, projectCode, modelMap, statistaclType, endDates);
        return String.valueOf(this.getFtlTempPath(request)) + "allsell";
    }

    @RequestMapping(value={"export_yrgwqy"})
    public String export_yrgwqy(HttpServletRequest request, HttpServletResponse response, String projectCode, ModelMap modelMap, Integer statistaclType, String endDates) {
        modelMap.put((Object)"title", (Object)"\u5df2\u8ba4\u8d2d\u672a\u7b7e\u7ea6");
        this.yrgwqyWrapper(request, projectCode, modelMap, statistaclType, endDates);
        try {
            String yrgwqyName = SupDisUtil.getMap((String)"EcoreDd-list", (String)"ExpExcelFileName-export_allsell-1");
            if (StringUtils.isEmpty((String)yrgwqyName)) {
                yrgwqyName = "\u4e91\u9500\u7ba1\u5bb6-\u8d22\u52a1\u62a5\u8868-\u5df2\u8ba4\u8d2d\u672a\u7b7e\u7ea6\u5bfc\u51fa.xls";
            }
            response.setHeader("Content-Type", "application/vnd.ms-execl");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(yrgwqyName.getBytes(), "ISO-8859-1"));
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.valueOf(this.getFtlTempPath(request)) + "allsellExp";
    }

    private void yrgwqyWrapper(HttpServletRequest request, String projectCode, ModelMap modelMap, Integer statistaclType, String endDates) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        String tenantCode = user.getTenantCode();
        param.put("tenantCode", tenantCode);
        Object buildingCode = null;
        if (statistaclType == null) {
            statistaclType = 1;
        }
        if (statistaclType == 1) {
            param.remove("buildingCode");
        } else {
            buildingCode = param.get("buildingCode");
        }
        this.getProject(modelMap, user, param, projectCode);
        Boolean yrgwqy = true;
        param.put("yrgwqy", true);
        List preList = this.ptHouseRepository.queryPreSellStatistical(param);
        if (ListUtil.isNotEmpty((Collection)preList)) {
            HashSet<String> otherCodes = new HashSet<String>();
            for (Map other : preList) {
                String otherCode = (String)other.get("otherCode");
                otherCodes.add(otherCode);
            }
            Map<String, Object> rgMap = this.queryStatisticalSellTransRg(otherCodes, tenantCode, statistaclType, buildingCode, endDates, yrgwqy);
            Map<String, Object> cjMap = this.queryStatisticalSellTransCj(otherCodes, tenantCode, statistaclType, buildingCode, endDates, yrgwqy);
            Map<String, Object> moneyMap = this.getFstatisticalAll(param, tenantCode);
            this.wrapperAllSell(preList, moneyMap, rgMap, cjMap);
            modelMap.addAttribute("fstatisticalAll", (Object)preList);
        }
        modelMap.put((Object)"title", (Object)"\u5df2\u8ba4\u8d2d\u672a\u7b7e\u7ea6");
        modelMap.put((Object)"actions", (Object)"yrgwqy");
        modelMap.put((Object)"paramMap", (Object)param);
    }

    private void wrapperAllSell(List<Map<String, Object>> preList, Map<String, Object> moneyMap, Map<String, Object> rgMap, Map<String, Object> cjMap) {
        for (Map<String, Object> other : preList) {
            Map all;
            Map cj;
            Map rg;
            BigDecimal totalPrice = BigDecimal.ZERO;
            Integer sellCount = 0;
            if (MapUtil.isNotEmpty(rgMap) && (rg = (Map)rgMap.get(other.get("otherCode"))) != null) {
                Object rgHouseCount;
                Object rgSumPrice = rg.get("rgSumPrice");
                if (rgSumPrice != null) {
                    BigDecimal rjPrice = new BigDecimal(String.valueOf(rgSumPrice));
                    totalPrice = totalPrice.add(rjPrice);
                }
                if ((rgHouseCount = rg.get("rgHouseCount")) != null) {
                    sellCount = sellCount + Integer.valueOf(String.valueOf(rgHouseCount));
                }
            }
            if (MapUtil.isNotEmpty(cjMap) && (cj = (Map)cjMap.get(other.get("otherCode"))) != null) {
                Object cjHouseCount;
                Object cjSumPrice = cj.get("cjSumPrice");
                if (cjSumPrice != null) {
                    BigDecimal cjPrice = new BigDecimal(String.valueOf(cjSumPrice));
                    totalPrice = totalPrice.add(cjPrice);
                }
                if ((cjHouseCount = cj.get("cjHouseCount")) != null) {
                    sellCount = sellCount + Integer.valueOf(String.valueOf(cjHouseCount));
                }
            }
            if (moneyMap != null && (all = (Map)moneyMap.get(other.get("otherCode"))) != null) {
                BigDecimal subtract;
                other.put("otherName", all.get("otherName"));
                Object alreadyReceivables = all.get("alreadyReceivables");
                BigDecimal already = BigDecimal.ZERO;
                BigDecimal total = BigDecimal.ZERO;
                if (totalPrice != null) {
                    total = new BigDecimal(String.valueOf(totalPrice));
                }
                if (alreadyReceivables != null) {
                    already = new BigDecimal(String.valueOf(alreadyReceivables));
                }
                if ((subtract = total.subtract(already)).compareTo(BigDecimal.ZERO) < 1) {
                    subtract = BigDecimal.ZERO;
                }
                other.put("alreadyReceivables", all.get("alreadyReceivables"));
                other.put("shouldReceivables", subtract);
            }
            other.put("totalPrice", totalPrice);
            other.put("sellCount", sellCount);
        }
    }

    private Map<String, Object> queryStatisticalSellTransRg(Set<String> otherCodes, String tenantCode, Object statistaclType, Object buildingCode, String endDate, Boolean yrgwqy) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("flowLinkType", "2");
        param.put("tenantCode", tenantCode);
        param.put("endDate", endDate);
        param.put("yrgwqy", yrgwqy);
        param.put("statistaclType", statistaclType);
        if (buildingCode != null) {
            param.put("buildingCode", buildingCode);
        }
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        param.clear();
        for (Map map : list) {
            String otherCode = String.valueOf(map.get("otherCode"));
            param.put(otherCode, map);
        }
        return param;
    }

    private Map<String, Object> queryStatisticalSellTransCj(Set<String> otherCodes, String tenantCode, Object statistaclType, Object buildingCode, String endDate, Boolean yrgwqy) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("flowLinkType", "3");
        param.put("otherCodes", otherCodes);
        param.put("tenantCode", tenantCode);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        if (yrgwqy != null) {
            param.put("yrgwqy", yrgwqy);
        }
        if (buildingCode != null) {
            param.put("buildingCode", buildingCode);
        }
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        param.clear();
        if (ListUtil.isNotEmpty((Collection)list)) {
            for (Map tran : list) {
                String otherCode = String.valueOf(tran.get("otherCode"));
                param.put(otherCode, tran);
            }
        }
        return param;
    }

    private void queryBuilding(Map<String, Object> param, ModelMap modelMap) {
        SupQueryResult buildingResult = this.ptBuildingRepository.queryBuildingPage2(param, true, false);
        if (buildingResult != null && ListUtil.isNotEmpty((Collection)buildingResult.getList())) {
            List buildings = buildingResult.getList();
            modelMap.put((Object)"buildings", (Object)buildings);
        }
    }

    @RequestMapping(value={"queryBuildingByProject.json"})
    @ResponseBody
    public HtmlJsonReBean queryBuilding(HttpServletRequest request, String projectCode) {
        if (StringUtils.isEmpty((String)projectCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u9009\u62e9\u9879\u76ee");
        }
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        SupQueryResult buildingResult = this.ptBuildingRepository.queryBuildingPage2(param, true, false);
        if (buildingResult != null && ListUtil.isNotEmpty((Collection)buildingResult.getList())) {
            List buildings = buildingResult.getList();
            return new HtmlJsonReBean((Object)buildings);
        }
        return new HtmlJsonReBean();
    }

    private void getProject(ModelMap modelMap, UserSession user, Map<String, Object> param, String projectCode) {
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
                param.put("statistaclType", 1);
            } else {
                param.put("projectCode", projectCode);
            }
        }
    }

    private Map<String, Object> getFstatisticalAll(Map<String, Object> param, String tenantCode) {
        ArrayList<String> reserveUnitTypes = new ArrayList<String>();
        reserveUnitTypes.add("1");
        reserveUnitTypes.add("2");
        reserveUnitTypes.add("3");
        param.put("reserveUnitTypes", reserveUnitTypes);
        ArrayList<String> flowLinkTypes = new ArrayList<String>();
        flowLinkTypes.add("1");
        flowLinkTypes.add("2");
        flowLinkTypes.add("3");
        param.put("flowLinkTypes", flowLinkTypes);
        param.put("dataState", 1);
        if (!StringUtils.isEmpty((String)tenantCode)) {
            param.put("tenantCode", tenantCode);
        }
        List fstatisticalAll = this.reserveUnitRepository.queryFstatisticalAll(param);
        HashMap<String, Object> moneyMap = new HashMap<String, Object>();
        if (ListUtil.isNotEmpty((Collection)fstatisticalAll)) {
            for (Map all : fstatisticalAll) {
                String otherCode = (String)all.get("otherCode");
                moneyMap.put(otherCode, all);
            }
        }
        return moneyMap;
    }

    private List<Map<String, Object>> getFstatisticalAll2(Map<String, Object> param, String tenantCode) {
        List fstatisticalAll;
        ArrayList<String> reserveUnitTypes = new ArrayList<String>();
        reserveUnitTypes.add("1");
        reserveUnitTypes.add("2");
        reserveUnitTypes.add("3");
        param.put("reserveUnitTypes", reserveUnitTypes);
        ArrayList<String> flowLinkTypes = new ArrayList<String>();
        flowLinkTypes.add("1");
        flowLinkTypes.add("2");
        flowLinkTypes.add("3");
        param.put("flowLinkTypes", flowLinkTypes);
        param.put("dataState", 1);
        if (!StringUtils.isEmpty((String)tenantCode)) {
            param.put("tenantCode", tenantCode);
        }
        if (ListUtil.isNotEmpty((Collection)(fstatisticalAll = this.reserveUnitRepository.queryFstatisticalAll(param)))) {
            return fstatisticalAll;
        }
        return new ArrayList<Map<String, Object>>();
    }

    private List<OtherBean> getOthers(Object projectCode, String tenantCode, Object buildingCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("projectCode", projectCode);
        param.put("tenantCode", tenantCode);
        List result = null;
        if (buildingCode != null) {
            param.put("buildingCode", buildingCode);
            result = this.ptUnitRepository.queryUnitByBuildingProject(param);
        } else {
            result = this.ptUnitRepository.queryBuildingByProjectCode(param);
        }
        if (ListUtil.isNotEmpty((Collection)result)) {
            return result;
        }
        return null;
    }

    @RequestMapping(value={"list"})
    public String selledQuery(HttpServletRequest request, String projectCode, Integer statistaclType, String endDate, ModelMap modelMap) {
        this.selledQueryWrapper(request, projectCode, statistaclType, endDate, modelMap);
        return String.valueOf(this.getFtlTempPath(request)) + "selledQuery";
    }

    @RequestMapping(value={"export_list"})
    public String export_list(HttpServletRequest request, HttpServletResponse response, String projectCode, Integer statistaclType, String endDate, ModelMap modelMap) {
        this.selledQueryWrapper(request, projectCode, statistaclType, endDate, modelMap);
        try {
            String listName = SupDisUtil.getMap((String)"EcoreDd-list", (String)"ExpExcelFileName-export_selledlist-1");
            if (StringUtils.isEmpty((String)listName)) {
                listName = "\u4e91\u9500\u7ba1\u5bb6-\u8d22\u52a1\u62a5\u8868-\u9500\u552e\u660e\u7ec6.xls";
            }
            response.setHeader("Content-Type", "application/vnd.ms-execl");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(listName.getBytes(), "ISO-8859-1"));
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.valueOf(this.getFtlTempPath(request)) + "selledQueryExp";
    }

    /*
     * WARNING - void declaration
     */
    private void selledQueryWrapper(HttpServletRequest request, String projectCode, Integer statistaclType, String endDate, ModelMap modelMap) {
        void var19_29;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (statistaclType == null) {
            statistaclType = 1;
        }
        if (statistaclType == 1 && param.containsKey("buildingCode")) {
            param.remove("buildingCode");
        }
        String tenantCode = user.getTenantCode();
        this.getProject(modelMap, user, param, projectCode);
        param.put("tenantCode", tenantCode);
        ArrayList retMaps = new ArrayList();
        HashMap<String, BigDecimal> selledAveragePrice = new HashMap<String, BigDecimal>();
        Map<String, SelledFinanceBean> selledMap = this.querySelledFinances(tenantCode, param.get("statistaclType"), param.get("buildingCode"), endDate, false);
        HashMap<String, BigDecimal> allSellPrice = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> totalCount = new HashMap<String, Integer>();
        HashMap<String, BigDecimal> totalArea = new HashMap<String, BigDecimal>();
        BigDecimal sellPercent = BigDecimal.ZERO;
        Map<String, UnSellFinancesBean> unSellMap = this.queryUnSellFinances(param, selledAveragePrice);
        for (Map.Entry<String, UnSellFinancesBean> unSell : unSellMap.entrySet()) {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            UnSellFinancesBean unSellBean = unSell.getValue();
            String string = unSell.getKey();
            SelledFinanceBean selledFinanceBean = selledMap.get(string);
            if (selledFinanceBean != null) {
                BigDecimal unTotalArea1 = BigDecimal.ZERO;
                if (unSell.getValue().getUnTotalArea() != null) {
                    unTotalArea1 = unSell.getValue().getUnTotalArea();
                }
                BigDecimal multiply = unTotalArea1.multiply(selledFinanceBean.getSelledAveragePrice());
                unSell.getValue().setUnsellPrice(multiply);
                BigDecimal selledPrice = selledFinanceBean.getSellTotalPrice();
                BigDecimal allsp = selledPrice.add(multiply);
                allSellPrice.put(string, selledPrice.add(multiply));
                if (allsp.compareTo(BigDecimal.ZERO) != 0) {
                    sellPercent = selledPrice.divide(allsp, 4, RoundingMode.HALF_UP);
                }
                selledFinanceBean.setSelledPercent(sellPercent.multiply(new BigDecimal(100)));
                Integer unTotalHouse = unSellBean.getUnTotalHouse();
                Integer sellTotalHouse = selledFinanceBean.getSellTotalHouse();
                totalCount.put(string, unTotalHouse + sellTotalHouse);
                BigDecimal unTotalArea = unSellBean.getUnTotalArea();
                BigDecimal sellArea = selledFinanceBean.getSellTotalArea();
                sellArea = sellArea.add(unTotalArea);
                totalArea.put(string, sellArea);
                try {
                    BeanUtils.copyAllPropertys(hashMap2, (Object)selledFinanceBean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                allSellPrice.put(string, BigDecimal.ZERO);
                totalCount.put(string, unSellBean.getUnTotalHouse());
                totalArea.put(string, unSellBean.getUnTotalArea());
            }
            try {
                BeanUtils.copyAllPropertys(hashMap, (Object)unSellBean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hashMap.putAll(hashMap2);
            retMaps.add(hashMap);
        }
        Map<String, FstatisticalAllBean> allMap = this.queryFstatisticalAll(param);
        for (Map.Entry<String, FstatisticalAllBean> entry : allMap.entrySet()) {
            String string = entry.getKey();
            entry.getValue().setTotalPrice((BigDecimal)allSellPrice.get(string));
            entry.getValue().setTotalCount((Integer)totalCount.get(string));
            entry.getValue().setTotalArea((BigDecimal)totalArea.get(string));
            HashMap totalmap = new HashMap();
            try {
                BeanUtils.copyAllPropertys(totalmap, (Object)entry.getValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (Map map : retMaps) {
                if (!entry.getValue().getOtherCode().equals(map.get("otherCode"))) continue;
                map.putAll(totalmap);
            }
        }
        Map<String, LoanBean> map = this.queryLoanBeans(param);
        for (Map.Entry<String, LoanBean> entry : map.entrySet()) {
            HashMap loanmap = new HashMap();
            LoanBean loanBean = entry.getValue();
            if (loanBean == null) continue;
            try {
                BeanUtils.copyAllPropertys(loanmap, (Object)loanBean);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (Map map2 : retMaps) {
                if (!loanBean.getOtherCode().equals(map2.get("otherCode"))) continue;
                map2.putAll(loanmap);
            }
        }
        Object var19_26 = null;
        param.remove("dataState");
        if (statistaclType == null || statistaclType == 1) {
            Map<String, Object> map3 = this.getBuildingName(param);
        } else if (statistaclType == 2) {
            Map<String, Object> map4 = this.getUnitName(param);
        }
        if (MapUtil.isNotEmpty((Map)var19_29)) {
            for (Map map5 : retMaps) {
                String string = String.valueOf(map5.get("otherCode"));
                map5.put("otherName", var19_29.get(string));
            }
        }
        modelMap.put((Object)"results", retMaps);
        modelMap.put((Object)"paramMap", (Object)param);
    }

    private Map<String, Object> getBuildingName(Map<String, Object> param) {
        HashMap<String, Object> otherMap = new HashMap<String, Object>();
        SupQueryResult buildingResult = this.ptBuildingRepository.queryBuildingPage2(param, false, false);
        if (buildingResult != null && ListUtil.isNotEmpty((Collection)buildingResult.getList())) {
            List list = buildingResult.getList();
            for (BuildingReBean building : list) {
                otherMap.put(building.getBuildingCode(), building.getBuildingName());
            }
        }
        return otherMap;
    }

    private Map<String, Object> getUnitName(Map<String, Object> param) {
        HashMap<String, Object> otherMap = new HashMap<String, Object>();
        SupQueryResult unitResult = this.ptUnitRepository.queryUnitPage(param, false, false);
        if (unitResult != null && ListUtil.isNotEmpty((Collection)unitResult.getList())) {
            List list = unitResult.getList();
            for (UnitReBean unit : list) {
                otherMap.put(unit.getUnitCode(), unit.getUnitName());
            }
        }
        return otherMap;
    }

    private Map<String, SelledFinanceBean> querySelledFinances(String tenantCode, Object statistaclType, Object buildingCode, String endDate, Boolean yrgwqy) {
        Map<String, Object> rgMaps = this.queryStatisticalSellTransRg(null, tenantCode, statistaclType, buildingCode, endDate, yrgwqy);
        Map<String, Object> cjMaps = this.queryStatisticalSellTransCj(null, tenantCode, statistaclType, buildingCode, endDate, yrgwqy);
        HashMap<String, SelledFinanceBean> retMap = new HashMap<String, SelledFinanceBean>();
        for (Map.Entry<String, Object> entry : rgMaps.entrySet()) {
            Object rgSumPrice;
            Object rgAveragePrice;
            Object rgSellArea;
            SelledFinanceBean tempBean = new SelledFinanceBean();
            BigDecimal selledAveragePrice = BigDecimal.ZERO;
            BigDecimal sellTotalArea = BigDecimal.ZERO;
            Integer sellTotalHouse = 0;
            BigDecimal sellTotalPrice = BigDecimal.ZERO;
            Map rgMap = (Map)entry.getValue();
            Object rgHouseCount = rgMap.get("rgHouseCount");
            if (rgHouseCount != null) {
                sellTotalHouse = sellTotalHouse + Integer.valueOf(String.valueOf(rgHouseCount));
            }
            if ((rgSellArea = rgMap.get("rgSellArea")) != null) {
                sellTotalArea = sellTotalArea.add(new BigDecimal(String.valueOf(rgSellArea)));
            }
            if ((rgAveragePrice = rgMap.get("rgAveragePrice")) != null) {
                selledAveragePrice = selledAveragePrice.add(new BigDecimal(String.valueOf(rgAveragePrice)));
            }
            if ((rgSumPrice = rgMap.get("rgSumPrice")) != null) {
                sellTotalPrice = sellTotalPrice.add(new BigDecimal(String.valueOf(rgSumPrice)));
            }
            tempBean.setSelledAveragePrice(selledAveragePrice);
            tempBean.setSellTotalArea(sellTotalArea);
            tempBean.setSellTotalHouse(sellTotalHouse);
            tempBean.setSellTotalPrice(sellTotalPrice);
            tempBean.setOtherCode(entry.getKey());
            retMap.put(entry.getKey(), tempBean);
        }
        boolean rgnull = false;
        if (MapUtil.isEmpty(retMap)) {
            rgnull = true;
        }
        for (Map.Entry<String, Object> entry2 : cjMaps.entrySet()) {
            String otherCode;
            SelledFinanceBean selledFinanceBean;
            Object cjSumPrice;
            Object cjAveragePrice;
            Object cjSellArea;
            SelledFinanceBean tempBean = new SelledFinanceBean();
            BigDecimal selledAveragePrice = BigDecimal.ZERO;
            BigDecimal sellTotalArea = BigDecimal.ZERO;
            Integer sellTotalHouse = 0;
            BigDecimal sellTotalPrice = BigDecimal.ZERO;
            Map cjMap = (Map)entry2.getValue();
            Object cjHouseCount = cjMap.get("cjHouseCount");
            if (cjHouseCount != null) {
                sellTotalHouse = sellTotalHouse + Integer.valueOf(String.valueOf(cjHouseCount));
            }
            if ((cjSellArea = cjMap.get("cjSellArea")) != null) {
                sellTotalArea = sellTotalArea.add(new BigDecimal(String.valueOf(cjSellArea)));
            }
            if ((cjAveragePrice = cjMap.get("cjAveragePrice")) != null) {
                selledAveragePrice = selledAveragePrice.add(new BigDecimal(String.valueOf(cjAveragePrice)));
            }
            if ((cjSumPrice = cjMap.get("cjSumPrice")) != null) {
                sellTotalPrice = sellTotalPrice.add(new BigDecimal(String.valueOf(cjSumPrice)));
            }
            if (!rgnull && (selledFinanceBean = (SelledFinanceBean)retMap.get(otherCode = entry2.getKey())) != null) {
                BigDecimal rgAveragePrice = selledFinanceBean.getSelledAveragePrice();
                selledAveragePrice = rgAveragePrice.add(selledAveragePrice);
                selledAveragePrice = selledAveragePrice.divide(new BigDecimal(2), 4, RoundingMode.HALF_UP);
                BigDecimal rgSellTotalArea = selledFinanceBean.getSellTotalArea();
                sellTotalArea = rgSellTotalArea.add(sellTotalArea);
                Integer rgSellTotalHouse = selledFinanceBean.getSellTotalHouse();
                sellTotalHouse = sellTotalHouse + rgSellTotalHouse;
                BigDecimal rgSellTotalPrice = selledFinanceBean.getSellTotalPrice();
                sellTotalPrice = rgSellTotalPrice.add(sellTotalPrice);
            }
            tempBean.setSelledAveragePrice(selledAveragePrice);
            tempBean.setSellTotalArea(sellTotalArea);
            tempBean.setSellTotalHouse(sellTotalHouse);
            tempBean.setSellTotalPrice(sellTotalPrice);
            tempBean.setOtherCode(entry2.getKey());
            retMap.put(entry2.getKey(), tempBean);
        }
        return retMap;
    }

    private Map<String, UnSellFinancesBean> queryUnSellFinances(Map<String, Object> param, Map<String, BigDecimal> selledAveragePrice) {
        List unSellFinances = this.ptHouseRepository.queryStatisUnSellFinance(param);
        HashMap<String, UnSellFinancesBean> unSellMap = new HashMap<String, UnSellFinancesBean>();
        for (Map mapTemp : unSellFinances) {
            UnSellFinancesBean unSellFinance = new UnSellFinancesBean();
            try {
                BeanUtils.copyAllPropertys((Object)unSellFinance, (Object)mapTemp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BigDecimal unTotalArea = unSellFinance.getUnTotalArea();
            if (MapUtil.isNotEmpty(selledAveragePrice)) {
                BigDecimal averagePrice = selledAveragePrice.get(unSellFinance.getOtherCode());
                if (averagePrice == null) {
                    averagePrice = BigDecimal.ZERO;
                }
                unSellFinance.setUnsellPrice(unTotalArea.multiply(averagePrice));
            }
            unSellMap.put(unSellFinance.getOtherCode(), unSellFinance);
        }
        return unSellMap;
    }

    private Map<String, FstatisticalAllBean> queryFstatisticalAll(Map<String, Object> param) {
        List<Map<String, Object>> fstatisticalAll = this.getFstatisticalAll2(param, null);
        ArrayList<FstatisticalAllBean> fstatisticalAllBeans = new ArrayList<FstatisticalAllBean>();
        HashMap<String, FstatisticalAllBean> allMap = new HashMap<String, FstatisticalAllBean>();
        for (Map<String, Object> fstatistical : fstatisticalAll) {
            FstatisticalAllBean fstatisticalAllBean = new FstatisticalAllBean();
            try {
                BeanUtils.copyAllPropertys((Object)fstatisticalAllBean, fstatistical);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fstatisticalAllBeans.add(fstatisticalAllBean);
        }
        if (ListUtil.isNotEmpty(fstatisticalAllBeans)) {
            for (FstatisticalAllBean fstatisticalAllBean : fstatisticalAllBeans) {
                allMap.put(fstatisticalAllBean.getOtherCode(), fstatisticalAllBean);
            }
        }
        return allMap;
    }

    private Map<String, LoanBean> queryLoanBeans(Map<String, Object> param) {
        List totalLoanAmounts = this.reserveUnitRepository.queryTotalLoanAmount(param);
        ArrayList<LoanBean> loanBeans = new ArrayList<LoanBean>();
        HashMap<String, LoanBean> loanMap = new HashMap<String, LoanBean>();
        if (ListUtil.isNotEmpty((Collection)totalLoanAmounts)) {
            for (Map loanMap2 : totalLoanAmounts) {
                LoanBean loanBean = new LoanBean();
                try {
                    BeanUtils.copyAllPropertys((Object)loanBean, (Object)loanMap2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                loanBeans.add(loanBean);
            }
            if (ListUtil.isNotEmpty(loanBeans)) {
                for (LoanBean loanBean : loanBeans) {
                    loanMap.put(loanBean.getOtherCode(), loanBean);
                }
            }
        }
        return loanMap;
    }

    @RequestMapping(value={"backcount"})
    public String backcount(HttpServletRequest request, String endDate, Integer statistaclType, String projectCode, ModelMap modelMap) {
        this.backcountWrapper(request, endDate, statistaclType, projectCode, modelMap);
        return String.valueOf(this.getFtlTempPath(request)) + "backMoneycount";
    }

    @RequestMapping(value={"export_backcount"})
    public String export_backcount(HttpServletRequest request, HttpServletResponse response, String endDate, Integer statistaclType, String projectCode, ModelMap modelMap) {
        this.backcountWrapper(request, endDate, statistaclType, projectCode, modelMap);
        try {
            String backcountName = SupDisUtil.getMap((String)"EcoreDd-list", (String)"ExpExcelFileName-export_backcount-1");
            if (StringUtils.isEmpty((String)backcountName)) {
                backcountName = "\u4e91\u9500\u7ba1\u5bb6-\u8d22\u52a1\u62a5\u8868-\u56de\u6b3e\u7edf\u8ba1.xls";
            }
            response.setHeader("Content-Type", "application/vnd.ms-execl");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(backcountName.getBytes(), "ISO-8859-1"));
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.valueOf(this.getFtlTempPath(request)) + "backMoneycountExp";
    }

    /*
     * WARNING - void declaration
     */
    public void backcountWrapper(HttpServletRequest request, String endDate, Integer statistaclType, String projectCode, ModelMap modelMap) {
        void var12_17;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPageMap((HttpServletRequest)request);
        if (statistaclType == null) {
            statistaclType = 1;
            param.put("statistaclType", 1);
        }
        param.put("tenantCode", user.getTenantCode());
        param.put("order", true);
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
            }
        }
        Map<String, FstatisticalAllBean> fstatisticalAll = this.queryFstatisticalAll(param);
        ArrayList retMaps = new ArrayList();
        if (MapUtil.isNotEmpty(fstatisticalAll)) {
            for (Map.Entry<String, FstatisticalAllBean> entryTemp : fstatisticalAll.entrySet()) {
                HashMap hashMap = new HashMap();
                FstatisticalAllBean bean = entryTemp.getValue();
                try {
                    BeanUtils.copyAllPropertys(hashMap, (Object)bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                retMaps.add(hashMap);
            }
        }
        param.put("acceptHandleStateGt", "11");
        Map<String, LoanBean> loans = this.queryLoanBeans(param);
        if (MapUtil.isNotEmpty(loans)) {
            for (Map.Entry<String, LoanBean> entry : loans.entrySet()) {
                HashMap loanmap = new HashMap();
                LoanBean loan = entry.getValue();
                try {
                    BeanUtils.copyAllPropertys(loanmap, (Object)loan);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!ListUtil.isNotEmpty(retMaps)) continue;
                for (Map map : retMaps) {
                    if (!loan.getOtherCode().equals(map.get("otherCode"))) continue;
                    map.putAll(loanmap);
                }
            }
        }
        Object var12_14 = null;
        if (statistaclType == 1) {
            Map<String, Object> map = this.getBuildingName(param);
        } else if (statistaclType == 2) {
            Map<String, Object> map = this.getUnitName(param);
        }
        if (MapUtil.isNotEmpty((Map)var12_17)) {
            for (Map map : retMaps) {
                String otherCode = String.valueOf(map.get("otherCode"));
                map.put("otherName", var12_17.get(otherCode));
            }
        }
        modelMap.put((Object)"results", retMaps);
        modelMap.put((Object)"paramMap", (Object)param);
    }
}

