/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.statistical.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.bean.EstReport;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReportRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/web/devest/statistical"})
public class StatisticalCon
extends SpringmvcController {
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private PtHouseRepository ptHouseRepository;
    @Resource
    private ReserveUnitRepository reserveUnitRepository;
    @Resource
    private ReportRepository reportRepository;
    @Resource
    private DdRepository ddRepository;

    protected String getContext() {
        return "statistical";
    }

    @RequestMapping(value={"unsell/query"})
    public String unsellQuery(HttpServletRequest request, String projectCode, String type, String startDate, String endDate, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
                param.put("statistaclType", 1);
            }
        }
        param.put("unsell", true);
        List unlist = this.ptHouseRepository.queryUnSellStatistical(param);
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("startDate", "");
            param.put("endDate", "");
        }
        param.put("presell", true);
        List preList = this.ptHouseRepository.queryPreSellStatistical(param);
        param.remove("presell");
        if (ListUtil.isNotEmpty((Collection)preList)) {
            block0: for (Map pre : preList) {
                for (Map un : unlist) {
                    if (!pre.get("otherCode").equals(un.get("otherCode"))) continue;
                    pre.put("unsellHouseCount", un.get("unsellHouseCount"));
                    pre.put("unsellArea", un.get("unsellArea"));
                    pre.put("unsellSumPrice", un.get("unsellSumPrice"));
                    pre.put("averagePrice", un.get("averagePrice"));
                    pre.put("unsellPrecent", un.get("unsellPrecent"));
                    continue block0;
                }
            }
        }
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        modelMap.put((Object)"unSellList", (Object)preList);
        modelMap.put((Object)"paramMap", (Object)param);
        return String.valueOf(this.getFtlTempPath(request)) + "unsellQuery";
    }

    @RequestMapping(value={"selled/query"})
    public String selledQuery(HttpServletRequest request, String projectCode, String type, String startDate, String endDate, String[] dimension, ModelMap modelMap) {
        this.selled_wrapper(request, projectCode, type, startDate, endDate, dimension, modelMap);
        return String.valueOf(this.getFtlTempPath(request)) + "selledQuery";
    }

    @RequestMapping(value={"selled/export"})
    public String export(HttpServletRequest request, HttpServletResponse response, String projectCode, String type, String startDate, String endDate, String[] dimension, ModelMap modelMap) {
        if (StringUtils.isEmpty((String)projectCode)) {
            if (dimension == null) {
                dimension = new String[]{"1", "2"};
            }
        } else if (dimension == null) {
            dimension = new String[]{};
        }
        this.selled_wrapper(request, projectCode, type, startDate, endDate, dimension, modelMap);
        String[] stringArray = dimension;
        int n = dimension.length;
        int n2 = 0;
        while (n2 < n) {
            String dime = stringArray[n2];
            if (Integer.valueOf(dime) == 1) {
                modelMap.put((Object)"unsell_display", (Object)"display:table-cell");
                modelMap.put((Object)"title_colspan", (Object)"10");
            } else if (Integer.valueOf(dime) == 2) {
                modelMap.put((Object)"trans_display", (Object)"display:table-cell");
                modelMap.put((Object)"title_colspan", (Object)"18");
            } else if (Integer.valueOf(dime) == 3) {
                modelMap.put((Object)"pay_display", (Object)"display:table-cell");
                modelMap.put((Object)"title_colspan", (Object)"26");
            }
            ++n2;
        }
        try {
            String selledName = SupDisUtil.getMap((String)"EcoreDd-list", (String)"ExpExcelFileName-export_selled-1");
            if (StringUtils.isEmpty((String)selledName)) {
                selledName = "\u4e91\u9500\u7ba1\u5bb6-\u8d22\u52a1\u62a5\u8868-\u9500\u552e\u660e\u7ec6.xls";
            }
            response.setHeader("Content-Type", "application/vnd.ms-execl");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(selledName.getBytes(), "ISO-8859-1"));
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.valueOf(this.getFtlTempPath(request)) + "selledQueryExp";
    }

    private List<Map<String, Object>> selled_wrapper(HttpServletRequest request, String projectCode, String type, String startDate, String endDate, String[] dimension, ModelMap modelMap) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
                param.put("statistaclType", 1);
            }
        }
        param.put("presell", true);
        List preList = this.ptHouseRepository.queryPreSellStatistical(param);
        param.remove("presell");
        HashSet<String> otherCodes = new HashSet<String>();
        for (Map other : preList) {
            otherCodes.add((String)other.get("otherCode"));
        }
        if (StringUtils.isEmpty((String)projectCode)) {
            if (dimension == null) {
                dimension = new String[]{"1", "2"};
            }
        } else if (dimension == null) {
            dimension = new String[]{};
        }
        Map<Object, Object> rgMap = new HashMap();
        Map<Object, Object> cjMap = new HashMap();
        if (ListUtil.isNotEmpty(otherCodes) && dimension != null) {
            String[] stringArray = dimension;
            int n = dimension.length;
            int n2 = 0;
            while (n2 < n) {
                String dime = stringArray[n2];
                if (Integer.valueOf(dime) == 1) {
                    this.queryUnSellStatistical(preList, param, startDate, endDate);
                }
                if (Integer.valueOf(dime) == 2) {
                    rgMap = this.queryStatisticalSellTransRg(preList, otherCodes, user.getTenantCode(), param.get("statistaclType"), startDate, endDate);
                    cjMap = this.queryStatisticalSellTransCj(preList, otherCodes, user.getTenantCode(), param.get("statistaclType"), startDate, endDate, false);
                }
                if (Integer.valueOf(dime) == 3) {
                    this.queryStatisticalSellPayment(preList, otherCodes, user.getTenantCode(), param.get("statistaclType"), startDate, endDate);
                }
                ++n2;
            }
        }
        for (Map other : preList) {
            Object cjOtherCode;
            Object rgOtherCode;
            Integer i = 0;
            BigDecimal rgAveragePrice = BigDecimal.ZERO;
            if (rgMap != null && (rgOtherCode = rgMap.get(other.get("otherCode"))) != null && (rgAveragePrice = new BigDecimal(String.valueOf(rgMap.get(other.get("otherCode"))))).compareTo(BigDecimal.ZERO) > 0) {
                i = i + 1;
            }
            BigDecimal cjAveragePrice = BigDecimal.ZERO;
            if (cjMap != null && (cjOtherCode = cjMap.get(other.get("otherCode"))) != null && (cjAveragePrice = new BigDecimal(String.valueOf(cjMap.get(other.get("otherCode"))))).compareTo(BigDecimal.ZERO) > 0) {
                i = i + 1;
            }
            BigDecimal add = rgAveragePrice.add(cjAveragePrice);
            BigDecimal divide = BigDecimal.ZERO;
            if (i > 0) {
                divide = add.divide(new BigDecimal(i), 4, 4);
            }
            other.put("preAveragePrice", divide);
            BigDecimal bd = BigDecimal.ZERO;
            Object unSellArea = other.get("unsellArea");
            BigDecimal unSellPercent = BigDecimal.ZERO;
            other.put("unSellPercent", unSellPercent);
            if (unSellArea != null) {
                bd = new BigDecimal(String.valueOf(unSellArea));
                unSellPercent = bd = bd.multiply(divide);
            }
            other.put("unsellSumPrice", bd);
            bd = BigDecimal.ZERO;
            Object preSellArea = other.get("preSellArea");
            if (preSellArea != null) {
                bd = new BigDecimal(String.valueOf(preSellArea));
                bd = bd.multiply(divide);
                if (unSellPercent.compareTo(BigDecimal.ZERO) > 0) {
                    unSellPercent = unSellPercent.divide(bd, 4, 4).multiply(new BigDecimal(100));
                    other.put("unSellPercent", unSellPercent);
                }
            }
            other.put("preSumPrice", bd);
        }
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        param.put("dimension", dimension);
        modelMap.put((Object)"selledList", (Object)preList);
        modelMap.put((Object)"paramMap", (Object)param);
        return preList;
    }

    private List<Map<String, Object>> queryStatisticalSellTransRc(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("flowLinkType", "1");
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            block0: for (Map<String, Object> map : selleds) {
                for (Map tran : list) {
                    if (!map.get("otherCode").equals(tran.get("otherCode"))) continue;
                    map.put("rcHouseCount", tran.get("rcHouseCount"));
                    map.put("rcSellArea", tran.get("rcSellArea"));
                    map.put("rcSumPrice", tran.get("rcSumPrice"));
                    map.put("rcAveragePrice", tran.get("rcAveragePrice"));
                    continue block0;
                }
            }
        }
        return list;
    }

    private Map<String, Object> queryStatisticalSellTransRg(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("flowLinkType", "2");
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            HashMap<String, Object> rgMap = new HashMap<String, Object>();
            block0: for (Map<String, Object> map : selleds) {
                for (Map tran : list) {
                    if (!map.get("otherCode").equals(tran.get("otherCode"))) continue;
                    map.put("rgHouseCount", tran.get("rgHouseCount"));
                    map.put("rgSellArea", tran.get("rgSellArea"));
                    map.put("rgSumPrice", tran.get("rgSumPrice"));
                    map.put("rgAveragePrice", tran.get("rgAveragePrice"));
                    rgMap.put(String.valueOf(map.get("otherCode")), tran.get("rgAveragePrice"));
                    continue block0;
                }
            }
            return rgMap;
        }
        return null;
    }

    private Map<String, Object> queryStatisticalSellTransCj(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate, Boolean queryContractNo) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("queryContractNo", queryContractNo);
        param.put("flowLinkType", "3");
        param.put("otherCodes", otherCodes);
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellTrans(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            HashMap<String, Object> cjMap = new HashMap<String, Object>();
            block0: for (Map<String, Object> map : selleds) {
                for (Map tran : list) {
                    if (!map.get("otherCode").equals(tran.get("otherCode"))) continue;
                    if (queryContractNo.booleanValue()) {
                        map.put("cjSellArea", tran.get("cjSellArea"));
                        map.put("cjHouseCount", tran.get("cjHouseCount"));
                        map.put("cjSumPrice", tran.get("cjSumPrice"));
                        map.put("cjAveragePrice", tran.get("cjAveragePrice"));
                    }
                    cjMap.put(String.valueOf(map.get("otherCode")), tran.get("cjAveragePrice"));
                    continue block0;
                }
            }
            return cjMap;
        }
        return null;
    }

    private List<Map<String, Object>> queryStatisticalSellPayment(List<Map<String, Object>> selleds, Set<String> otherCodes, String tenantCode, Object statistaclType, String startDate, String endDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("otherCodes", otherCodes);
        param.put("tenantCode", tenantCode);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("statistaclType", statistaclType);
        List list = this.reserveUnitRepository.queryStatisticalSellPayment(param);
        if (ListUtil.isNotEmpty((Collection)list)) {
            block0: for (Map<String, Object> map : selleds) {
                for (Map pay : list) {
                    if (!map.get("otherCode").equals(pay.get("otherCode"))) continue;
                    map.put("qkHouseCount", pay.get("qkHouseCount"));
                    map.put("qkSellArea", pay.get("qkSellArea"));
                    map.put("qkSumPrice", pay.get("qkSumPrice"));
                    map.put("qkAveragePrice", pay.get("qkAveragePrice"));
                    map.put("ajHouseCount", pay.get("ajHouseCount"));
                    map.put("ajSellArea", pay.get("ajSellArea"));
                    map.put("ajSumPrice", pay.get("ajSumPrice"));
                    map.put("ajAveragePrice", pay.get("ajAveragePrice"));
                    continue block0;
                }
            }
        }
        return list;
    }

    private List<Map<String, Object>> queryUnSellStatistical(List<Map<String, Object>> preSells, Map<String, Object> param, String startDate, String endDate) {
        if (StringUtils.isNotBlank((String)startDate) && StringUtils.isNotBlank((String)startDate)) {
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        } else {
            param.remove("endDate");
            param.remove("startDate");
        }
        param.put("unsell", true);
        List unsells = this.ptHouseRepository.queryUnSellStatistical(param);
        if (ListUtil.isNotEmpty((Collection)unsells)) {
            block0: for (Map<String, Object> map : preSells) {
                for (Map unsell : unsells) {
                    if (!map.get("otherCode").equals(unsell.get("otherCode"))) continue;
                    Integer unsellHouseCount = 0;
                    if (unsell.get("unsellHouseCount") != null) {
                        unsellHouseCount = Integer.valueOf(String.valueOf(unsell.get("unsellHouseCount")));
                    }
                    Integer rcHouseCount = 0;
                    if (unsell.get("rcHouseCount") != null) {
                        rcHouseCount = Integer.valueOf(String.valueOf(unsell.get("rcHouseCount")));
                    }
                    map.put("unsellHouseCount", unsellHouseCount + rcHouseCount);
                    BigDecimal unsellArea = BigDecimal.ZERO;
                    if (unsell.get("unsellArea") != null) {
                        unsellArea = new BigDecimal(String.valueOf(unsell.get("unsellArea")));
                    }
                    BigDecimal rcArea = BigDecimal.ZERO;
                    if (unsell.get("rcArea") != null) {
                        rcArea = new BigDecimal(String.valueOf(unsell.get("rcArea")));
                    }
                    map.put("unsellArea", unsellArea.add(rcArea));
                    BigDecimal unsellSumPrice = BigDecimal.ZERO;
                    if (unsell.get("unsellSumPrice") != null) {
                        unsellSumPrice = new BigDecimal(String.valueOf(unsell.get("unsellSumPrice")));
                    }
                    BigDecimal rcsumPrice = BigDecimal.ZERO;
                    if (unsell.get("rcsumPrice") != null) {
                        rcsumPrice = new BigDecimal(String.valueOf(unsell.get("rcsumPrice")));
                    }
                    map.put("unsellSumPrice", unsellSumPrice.add(rcsumPrice));
                    BigDecimal unSellAveragePrice = BigDecimal.ZERO;
                    if (unsell.get("unSellAveragePrice") != null) {
                        unSellAveragePrice = new BigDecimal(String.valueOf(unsell.get("unSellAveragePrice")));
                    }
                    map.put("unSellAveragePrice", unSellAveragePrice);
                    map.put("unsellPrecent", unsell.get("unsellPrecent"));
                    continue block0;
                }
            }
        }
        return preSells;
    }

    @RequestMapping(value={"selled/details"})
    public String selledDetails(HttpServletRequest request, String startDate, String endDate, String memberPhone, String projectCode, ModelMap modelMap) {
        SupQueryResult supResult;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", user.getTenantCode());
        param.put("order", true);
        List projects = this.ptProjectRepository.getProjectByRole(user, Integer.valueOf(0), false);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            modelMap.addAttribute("projects", (Object)projects);
            if (StringUtils.isEmpty((String)projectCode)) {
                param.put("projectCode", String.valueOf(((Map)projects.get(0)).get("projectCode")));
            }
        }
        if ((supResult = this.reserveUnitRepository.queryStatisticalSellDetails(param)) != null) {
            List list = supResult.getList();
            if (ListUtil.isNotEmpty((Collection)list)) {
                HashSet<String> memberCodes = new HashSet<String>();
                for (Map member : list) {
                    memberCodes.add((String)member.get("memberCode"));
                }
                HashMap<String, Serializable> paramReport = new HashMap<String, Serializable>();
                paramReport.put("memberCodes", memberCodes);
                paramReport.put("dataState", Integer.valueOf(1));
                List reports = this.reportRepository.getReportList(paramReport);
                HashMap<String, String> zyMap = new HashMap<String, String>();
                HashMap<String, String> tkMap = new HashMap<String, String>();
                for (EstReport report : reports) {
                    if ("0001001".equals(report.getRoleCode())) {
                        tkMap.put(report.getMemberCode(), report.getReportUname());
                        continue;
                    }
                    if (!"0001003".equals(report.getRoleCode())) continue;
                    zyMap.put(report.getMemberCode(), report.getReportUname());
                }
                for (Map member : list) {
                    member.put("zyUserName", zyMap.get(member.get("memberCode")));
                    member.put("tkUserName", tkMap.get(member.get("memberCode")));
                }
            }
            modelMap.put((Object)"sellDetails", (Object)list);
            modelMap.addAttribute("pageTools", (Object)this.buildPage(supResult.getPageTools(), request));
        }
        modelMap.put((Object)"paramMap", (Object)param);
        return String.valueOf(this.getFtlTempPath(request)) + "selledDetails";
    }

    @RequestMapping(value={"sell/all"})
    public String sellAll(HttpServletRequest request, String startDate, String endDate, String memberPhone, String projectCode, ModelMap modelMap) {
        return "";
    }
}

